

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeSecurityForSmartFolders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ------------------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------------------*/
--	Description :give visibility, change security permissions for creator of existing smart folders
/* ----------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeSecurityForSmartFolders <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeSecurityForSmartFolders')
	drop procedure sec_upgradeSecurityForSmartFolders
IF EXISTS (select * from GxQscripts where name='sec_upgradeSecurityForSmartFolders')
	delete from GxQscripts where name = 'sec_upgradeSecurityForSmartFolders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForSmartFolders')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForSmartFolders'
GO
print '... Creating Procedure: sec_upgradeSecurityForSmartFolders'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_upgradeSecurityForSmartFolders
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
BEGIN TRY
	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTrackINg WHERE SqlScriptGUID = '3679CB6C-2F34-4395-9184-8B4A8CD16A94')    -- GUID NOT present
	BEGIN
		-- add EV_VISIBILITY Permission
DECLARE @adminuserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)
		INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, permissionId, entityType1, entityId1, authorId, isCreator)
SELECT SF.ownerId, 1, 31, 127, SF.id , @adminuserId, 1
		FROM APP_SmartFolder SF
		WHERE NOT EXISTS(
				SELECT 1 FROM UMSecurityAssociations UMSA
WHERE UMSA.entityType1 = 127 AND UMSA.entityId1 = SF.id AND UMSA.permissionId = 31 AND UMSA.isCreator = 1)
		-- add CAT_USER_MANAGMENT_ASSOC_ON_ENTITY Permission
		INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, permissionId, entityType1, entityId1, authorId, isCreator)
SELECT SF.ownerId, 1, 107, 127, SF.id , @adminuserId, 1
		FROM APP_SmartFolder SF
		WHERE NOT EXISTS(
				SELECT 1 FROM UMSecurityAssociations UMSA
WHERE UMSA.entityType1 = 127 AND UMSA.entityId1 = SF.id AND UMSA.permissionId = 107 AND UMSA.isCreator = 1)
		INSERT GXUniqueSQLScriptExecTracking(SqlScriptGUID,Name,Description,CreatedTime,CreatedRelId,ExpireTime,ExpireRelId)
VALUES('3679CB6C-2F34-4395-9184-8B4A8CD16A94','UpgradeSecurityForSmartFolder','Upgrade Security For Smart Folder',dbo.GetUnixTime(GETUTCDATE()),16,0,16 + 2)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeSecurityForSmartFolders')
	delete from GxQscripts where name = 'sec_upgradeSecurityForSmartFolders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForSmartFolders')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForSmartFolders'
GO

insert into GXDBVersions values(2, 'sec_upgradeSecurityForSmartFolders',  '00000000000000000000', 'sec_upgradeSecurityForSmartFolders', '00000000000000000000')
GO

