

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeSecurityForRole.sp] ---------- 

--give visibility, change security permissions for creator of existing table filter
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_upgradeSecurityForRole')
BEGIN
	print '>>> Drop Stored Procedure: sec_upgradeSecurityForRole <<<'
	drop procedure sec_upgradeSecurityForRole
END
IF EXISTS (select * from GxQscripts where name='sec_upgradeSecurityForRole')
	delete from GxQscripts where name = 'sec_upgradeSecurityForRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForRole')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForRole'
GO
print '... Creating Procedure: sec_upgradeSecurityForRole'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_upgradeSecurityForRole
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
BEGIN TRY
	IF NOT EXISTS (SELECT 1 FROM GXUniqueSQLScriptExecTrackINg WHERE SqlScriptGUID = '92880492-0969-405C-A7A5-81D92EB84313')    -- GUID NOT present
	BEGIN
		--user which have change security settings at commcell,  give all three permission for now.
		DECLARE @permissionIdTbl TABLE ( pId INT)
		INSERT INTO @permissionIdTbl
SELECT 241
		UNION
SELECT 242
		UNION
SELECT 243
		INSERT INTO UMSecurityAssociations (userOrGroupId,isUser,permissionId,entityType1,entityId1,authorId)
		SELECT TBL.userORGRoupId,Tbl.isUSer,pId,1,2,-1 FROM @permissionIdTbl CROSS JOIN
		(SELECT DISTINCT userOrGroupId,isUSer FROM UMSEcurityAssociations  where entityType1=1 and entityId1=2
and roleId in (SELECT roleId from UMRolesWithPermissionsExpanded where permissionId=107)
		UNION
		SELECT DISTINCT userOrGroupId,isUSer FROM UMSEcurityAssociations where entityType1=1 and entityId1=2
and  permissionId=107) as TBL
		LEFT JOIN
		UMSEcurityAssociations SA ON TBL.userORGroupId=SA.userORGroupId and TBL.isUser=SA.isUSer
								 AND pid=SA.permissionId
								 AND SA.entityType1=1
								 AND SA.entityId1=2
								 AND SA.entityType2=0
		WHERE SA.userOrGRoupId IS NULL
		--Lets give creator also Edit and Delete permission on respective role.should we create creator role here?
DELETE FROM @permissionIdTbl where pId=241
		INSERT INTO @permissionIdTbl
VALUES(107)
		INSERT INTO UMSecurityAssociations (userOrGroupId,isUser,permissionId,entityType1,entityId1,authorId,isCreator)
		SELECT DISTINCT insertSA.userORGroupId,insertSA.isUSer,pid,insertSA.entityType1,insertSA.entityId1,insertSA.authorId,1
		FROM UMSecurityAssociations insertSA CROSS JOIN @permissionIdTbl
		LEFT JOIN
		UMSEcurityAssociations SA ON insertSA.userORGroupId=SA.userORGroupId and insertSA.isUser=SA.isUSer
								 AND pid=SA.permissionId
								 AND insertSA.entityType1=SA.entityType1
								 AND insertSA.entityId1=SA.entityId1
								 and insertSA.isCreator=SA.isCreator
								 AND SA.entityType2=0
		WHERE SA.userOrGRoupId IS NULL and insertSA.entityType1=120 and insertSA.isCreator=1
		IF  EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'bEnableSecurityOnRoles' AND cast([value] as nvarchar(32)) = N'true')
		BEGIN
			--implies security is  enabled
			UPDATE UMRoles
			SET isPrivate=1
			WHERE
(flags & 256 = 0)
AND (flags & 512 = 0)
		END
		INSERT GXUniqueSQLScriptExecTracking(SqlScriptGUID,Name,Description,CreatedTime,CreatedRelId,ExpireTime,ExpireRelId)
VALUES('92880492-0969-405C-A7A5-81D92EB84313','UpgradeSecurityForTableFilter','Upgrade Security For Table Filter',dbo.GetUnixTime(GETUTCDATE()),16,0,16 + 2)
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode = ERROR_NUMBER()
    SET @errorString = ERROR_MESSAGE()
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeSecurityForRole')
	delete from GxQscripts where name = 'sec_upgradeSecurityForRole'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForRole')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForRole'
GO

insert into GXDBVersions values(2, 'sec_upgradeSecurityForRole',  '00000000000000000000', 'sec_upgradeSecurityForRole', '00000000000000000000')
GO

