

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeSecurityForAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--      Script for alert security upgrade
--      This script assigns permissions to the
--      creators of alerts and the users having 'Alert Management'
--		capability at commcell level before upgrade
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeSecurityForAlerts <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeSecurityForAlerts')
	drop procedure sec_upgradeSecurityForAlerts
IF EXISTS (select * from GxQscripts where name='sec_upgradeSecurityForAlerts')
	delete from GxQscripts where name = 'sec_upgradeSecurityForAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForAlerts')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForAlerts'
GO
print '... Creating Procedure: sec_upgradeSecurityForAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_upgradeSecurityForAlerts
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
--execute the script only if this is the first time the category is getting inserted into the DB
--for the subsequent runs, this should not be run
IF EXISTS (SELECT 1 FROM UMCategories WHERE id = 117 AND (flags & CAST(0x1000 AS INT) <> 0))
BEGIN
	--Table to store alerts and its creators
	DECLARE @alertCreatorsIdTable TABLE
	(
		alertId INT,
		creatorUserId INT
	)
	--Get list of alerts and its creators
	INSERT INTO @alertCreatorsIdTable
		SELECT id, notifOwner
		FROM NTnotificationRule
WHERE notifOwner <> 1			--If the owner of alert is admin user himself, then no need to assign the permissions explicitly
	--Table to store users and user groups having 'Alert Management' capability at commcell level before upgrade.
	DECLARE @alertManagementUserOrGroupIdTable TABLE
	(
		userOrGroupId INT,
		isUser INT
	)
	--Table to store security for commcell
	DECLARE @commcellSecurityTable TABLE
	(
		userId INT,
		userGroupId INT,
        externalGroupId INT,
        roleId INT,
        permissionId INT
	)
	--Get security for commcell entity
	DECLARE @securityXML XML
EXEC sec_getSecurityForEntity 1, @securityXML OUTPUT, 1, 2
	--Store securityXML in table
	INSERT INTO @commcellSecurityTable (userId, userGroupId, externalGroupId, roleId, permissionId)
        SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@userGroupId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@groupId)[1]', 'INT'), 0),
               ISNULL(R.value('(@roleId)[1]', 'INT'), 0),
               0
        FROM @securityXML.nodes('associations/userOrGroup') AS Input(UG)
        CROSS APPLY
        Input.UG.nodes('../properties/role') AS Role(R)
    INSERT INTO @commcellSecurityTable (userId, userGroupId, externalGroupId, roleId, permissionId)
        SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@userGroupId)[1]', 'INT'), 0),
               ISNULL(UG.value('(@groupId)[1]', 'INT'), 0),
               0,
               ISNULL(P.value('(@permissionId)[1]', 'INT'), 0)
        FROM @securityXML.nodes('associations/userOrGroup') AS Input(UG)
        CROSS APPLY
        Input.UG.nodes('../properties/categoryPermission/categoriesPermissionList') AS Permissions(P)
	--Get list of users and user groups having 'Alert Management' capability on commcell
	INSERT INTO @alertManagementUserOrGroupIdTable
        SELECT CASE WHEN Security.userId <> 0 THEN Security.userId
                    WHEN Security.userGroupId <> 0 THEN Security.usergroupId
                    ELSE Security.externalGroupId
               END,
               CASE WHEN Security.userId <> 0 THEN 1
					ELSE 0
			   END
        FROM @commcellSecurityTable Security LEFT JOIN UMRolesWithPermissionsExpanded RolePerm
			ON Security.roleId = RolePerm.roleId
WHERE (Security.permissionId = 18 OR RolePerm.permissionId = 18)
AND Security.userId <> 1 AND Security.userGroupId <> 1        ----If the user is admin user or userGroup is admin group (master group), then no need to assign the permissions explicitly
	--Already created 'Alert Owner' role with all permissions in 'Alert' category except 'Create Alert'
	--This role also has'Change Security Settings' permission
	--This role is for creators of the alert.
	--Will also be given to the users and user groups having 'Alert Management' capability at commcell level before upgrade.
	DECLARE @alertOwnerRoleId INT = 0
SET @alertOwnerRoleId = ISNULL((SELECT id FROM UMRoles WHERE name = 'Alert Owner' AND (flags & 1 | 2 <> 0)), 0)			--USE_MACRO
	--Assign 'Alert Owner' role to the creators of the older alerts on their alerts
	--And to the users and user groups having 'Alert Management' capability at commcell level before upgrade on all alerts
	IF @alertOwnerRoleId <> 0
	BEGIN
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
SELECT DISTINCT @alertOwnerRoleId, 0, creatorUserId, 1, 64, alertId, 1, 1		--USE_MACRO
			FROM @alertCreatorsIdTable
WHERE alertId NOT IN (SELECT entityId1 FROM UMSecurityAssociations WHERE entityType1 = 64 AND isCreator = 1)
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId, includeAll)
SELECT DISTINCT @alertOwnerRoleId, 0, userOrGroupId, isUser, 64, 0, 0, 1, 1		--USE_MACRO
			FROM @alertManagementUserOrGroupIdTable
WHERE (isUser = 1 AND userOrGroupId NOT IN (SELECT userOrGroupId FROM UMSecurityAssociations WHERE isUser = 1 AND roleId = @alertOwnerRoleId AND entityType1 = 64 AND entityID1 = 0 AND includeAll = 1))
OR (isUser = 0 AND userOrGroupId NOT IN (SELECT userOrGroupId FROM UMSecurityAssociations WHERE isUser = 0 AND roleId = @alertOwnerRoleId AND entityType1 = 64 AND entityID1 = 0 AND includeAll = 1))
	END
	--Create the role 'Alert Creator' with 'Create Alert' permission for users to be able to create alert.
	--This role will be assigned to the creators of the older alerts and users & user groups having 'Alert Management' capability at commcell level before upgrade.
	--This role is needed only at the time of upgrade.
    DECLARE @alertCreatorRoleId INT = 0
IF NOT EXISTS (SELECT 1 FROM UMRoles WHERE name LIKE 'Alert Creator')           --USE_MACRO
    BEGIN
        INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
SELECT 2, 'Alert Creator', 'Role for Create Alert permission', 0, 0, 0, 1, dbo.getunixtime(getutcdate()), 0, NEWID(), ''        --USE_MACRO
SET @alertCreatorRoleId = (SELECT id FROM UMRoles WHERE name LIKE 'Alert Creator')
        INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
SELECT @alertCreatorRoleId, 122, categoryId, id, 0, 0          --USE_MACRO
FROM UMPermissions WHERE id = 151
        EXEC sec_expandRoleWithPermissions @alertCreatorRoleId, @errorCode OUTPUT, @errorString OUTPUT
    END
SET @alertCreatorRoleId = ISNULL((SELECT id FROM UMRoles WHERE name LIKE 'Alert Creator'), 0)         --USE_MACRO
    --Assign 'Alert Creator' role to the creators of the older alerts on commcell
	--Also to the users and user groups having 'Alert Management' capability at commcell level before upgrade on commcell
	IF @alertCreatorRoleId <> 0
	BEGIN
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
SELECT DISTINCT @alertCreatorRoleId, 0, creatorUserId, 1, 1, 2, 0, 1		--USE_MACRO
			FROM @alertCreatorsIdTable
WHERE creatorUserId NOT IN (SELECT userOrGroupId FROM UMSecurityAssociations WHERE isUser = 1 AND roleId = @alertCreatorRoleId AND entityType1 = 1 AND entityID1 = 2)
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
SELECT DISTINCT @alertCreatorRoleId, 0, userOrGroupId, isUser, 1, 2, 0, 1		--USE_MACRO
			FROM @alertManagementUserOrGroupIdTable
WHERE (isUser = 1 AND userOrGroupId NOT IN (SELECT userOrGroupId FROM UMSecurityAssociations WHERE isUser = 1 AND roleId = @alertCreatorRoleId AND entityType1 = 1 AND entityID1 = 2))
OR (isUser = 0 AND userOrGroupId NOT IN (SELECT userOrGroupId FROM UMSecurityAssociations WHERE isUser = 0 AND roleId = @alertCreatorRoleId AND entityType1 = 1 AND entityID1 = 2))
	END
	--Unset the flag in UMCategories so that the next time upgrade is run, this script does not execute
	UPDATE UMCategories
SET flags = flags & (~ CAST(0x1000 AS INT))
WHERE id = 117
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeSecurityForAlerts')
	delete from GxQscripts where name = 'sec_upgradeSecurityForAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityForAlerts')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityForAlerts'
GO

insert into GXDBVersions values(2, 'sec_upgradeSecurityForAlerts',  '00000000000000000000', 'sec_upgradeSecurityForAlerts', '00000000000000000000')
GO

