

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeSecurityDataCube.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		Script for schedule policy permissions upgrade
--		This script assigns all permissions under "schedule policy" category to the
--		creators of schedule policies
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_upgradeSecurityDataCube')
BEGIN
	print '>>> Drop Stored Procedure: sec_upgradeSecurityDataCube <<<'
	drop procedure sec_upgradeSecurityDataCube
END
IF EXISTS (select * from GxQscripts where name='sec_upgradeSecurityDataCube')
	delete from GxQscripts where name = 'sec_upgradeSecurityDataCube'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityDataCube')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityDataCube'
GO
print '... Creating Procedure: sec_upgradeSecurityDataCube'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_upgradeSecurityDataCube
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
--Handle permission for existing data source
--Provide permissions - View / Edit /Delete/User Mgmt for data source owners
--should be executed only once
DECLARE @isDCublePermissionHandled integer = ISNULL((SELECT CAST (value AS INT) FROM GXGlobalParam WHERE name = 'isDCublePermissionHandled' AND modified = 0),0)
IF (@isDCublePermissionHandled = 0)
BEGIN
	DECLARE @newAnalyticsRoleTbl TABLE ( newPermId INt)
	INSERT INTO @newAnalyticsRoleTbl
VALUES (201), (202), (203), (107)
	INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
SELECT newPermId, OwnerUserID, 1, 132, DataSourceId, 1, OwnerUserID
	FROM SEDataSource
	CROSS JOIN @newAnalyticsRoleTbl
	WHERE  newPermId  NOT IN (SELECT permissionId
															FROM UMSecurityAssociations
															WHERE userOrGroupId = OwnerUserID
																	AND isuser = 1
																	AND permissionId in (newPermId)
AND entityType1 = 132 AND entityId1 = DataSourceId
																	AND entityType2 = 0 AND entityId2 = 0
																	AND entityType3 = 0 AND entityId3 = 0
																	AND entityType4 = 0 AND entityId4 = 0
																	AND entityType5 = 0 AND entityId5 = 0
																	AND isCreator = 1)
	IF NOT EXISTS (SELECT * FROM GXGlobalParam WHERE name = 'isDCublePermissionHandled' AND modified = 0)
		INSERT INTO GXGlobalParam
		VALUES ('isDCublePermissionHandled', '1', dbo.GetUnixTime(GETUTCDATE()) , 0)
	ELSE
		UPDATE GXGlobalParam
		SET VALUE  = '1'
		WHERE NAME  = 'isDCublePermissionHandled' AND modified = 0
	SET @isDCublePermissionHandled = 1
END
IF (@isDCublePermissionHandled = 1) OR (@isDCublePermissionHandled = 2)
BEGIN
		UPDATE UMSecurityAssociations
SET permissionId = 201
WHERE entityType1 IN ( 132 , 133, 157) and permissionId = 31
		UPDATE UMSecurityAssociations
SET permissionId = 202
WHERE entityType1 IN ( 132 , 133, 157) and permissionId = 34
		UPDATE UMSecurityAssociations
SET permissionId = 203
WHERE entityType1 IN ( 132 , 133, 157) and permissionId = 35
		-- For Handlers
		-- only VIEW permission exists then update to EXECUTE
		-- DELETE / EDIT permission exists -- insert new row with EXECUTE permission
		--get user / user groups with EDIT / DELETE permission on SEA_SEARCH_HANDLER_ENTITY
		DECLARE @userLists TABLE (userOrGroupId INT, isUser INT, isEditPermissionSet INT, entityId INT)
		INSERT INTO @userLists  (userOrGroupId,isUser, isEditPermissionSet, entityId)
		SELECT DISTINCT userOrGroupId , isUser,  1, entityId1
		FROM UMSecurityAssociations
WHERE  entityType1 =157 AND permissionId IN (202, 203)
		--get user / user groups with VIEW permission on SEA_SEARCH_HANDLER_ENTITY and does NOT have EDIT & DELETE permissions
		INSERT INTO @userLists  (userOrGroupId,isUser, isEditPermissionSet, entityId)
		SELECT DISTINCT userOrGroupId , isUser,  0, entityId1
		FROM UMSecurityAssociations
WHERE  entityType1 =157 AND permissionId = 201
		AND userOrGroupId NOT IN (SELECT userOrGroupId FROM @userLists WHERE entityId = entityId1)
		--in case execute permission already exists for the user on those entity
        DELETE temp
		FROM  @userLists temp inner join UMSecurityAssociations as S
ON temp.userOrGroupId = S.userOrGroupId AND temp.isUser = s.isUser AND temp.entityId = s.entityId1 AND S.entityType1 = 204
		-- only VIEW permission exists then update to EXECUTE
		IF EXISTS (SELECT 1 FROM @userLists WHERE isEditPermissionSet = 0)
			UPDATE UMSecurityAssociations
SET permissionId = 204
			FROM @userLists U
WHERE entityType1 IN ( 157) and permissionId = 201
			AND UMSecurityAssociations.userOrGroupId = U.userOrGroupId AND U.isEditPermissionSet = 0 AND UMSecurityAssociations.entityId1 = U.entityId
		-- DELETE / EDIT permission exists -- insert new row with EXECUTE permission
		IF EXISTS (SELECT 1 FROM @userLists WHERE isEditPermissionSet = 1)
			INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
SELECT 204, U.userOrGroupId, U.isUser, 157, U.entityId, 1, U.userOrGroupId
			FROM @userLists U
			WHERE U.isEditPermissionSet = 1
				AND NOT EXISTS (SELECT permissionId
												FROM UMSecurityAssociations
												WHERE userOrGroupId = U.userOrGroupId
													AND isuser = U.isUser
AND permissionId = 204
AND entityType1 = 157 AND entityId1 = U.entityId
													AND entityType2 = 0 AND entityId2 = 0
													AND entityType3 = 0 AND entityId3 = 0
													AND entityType4 = 0 AND entityId4 = 0
													AND entityType5 = 0 AND entityId5 = 0
													AND isCreator = 1)
		UPDATE GXGlobalParam
		SET VALUE  = '3'
		WHERE NAME  = 'isDCublePermissionHandled' AND modified = 0
		SET @isDCublePermissionHandled = 3
END
IF( @isDCublePermissionHandled = 3)
BEGIN
	--for searchview which doesnt have entry in UMSecurityAssociation table, create owner entry
	--
	DECLARE @newSearchViewTbl TABLE ( searchviewId INT, OwnerUserId INT);
	INSERT INTO @newSearchViewTbl
	SELECT SearchViewId, OwnerUserID FROM SESearchView WHERE Status = 0
		EXCEPT
SELECT entityId1, userOrGroupId FROM UMSecurityAssociations WHERE entityType1  = 133 and isUser = 1
	IF EXISTS( SELECT 1 FROM @newSearchViewTbl)
	BEGIN
		DECLARE @searchViewRoleTbl TABLE ( newPermId INt)
		INSERT INTO @searchViewRoleTbl
VALUES (201), (202), (203), (204), (107)
		INSERT INTO UMSecurityAssociations (permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
SELECT newPermId, OwnerUserID, 1, 133, searchviewId, 1, OwnerUserID
		FROM @newSearchViewTbl
		CROSS JOIN @searchViewRoleTbl
		WHERE  newPermId  NOT IN (SELECT permissionId
									FROM UMSecurityAssociations
									WHERE userOrGroupId = OwnerUserID
											AND isuser = 1
											AND permissionId in (newPermId)
AND entityType1 = 133 AND entityId1 = searchviewId
											AND entityType2 = 0 AND entityId2 = 0
											AND entityType3 = 0 AND entityId3 = 0
											AND entityType4 = 0 AND entityId4 = 0
											AND entityType5 = 0 AND entityId5 = 0
											AND isCreator = 1)
	END
	UPDATE GXGlobalParam
		SET VALUE  = '4'
		WHERE NAME  = 'isDCublePermissionHandled' AND modified = 0
	SET @isDCublePermissionHandled = 4
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeSecurityDataCube')
	delete from GxQscripts where name = 'sec_upgradeSecurityDataCube'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSecurityDataCube')
	delete from GXDBVersions where aliasname = 'sec_upgradeSecurityDataCube'
GO

insert into GXDBVersions values(2, 'sec_upgradeSecurityDataCube',  '00000000000000000000', 'sec_upgradeSecurityDataCube', '00000000000000000000')
GO

