

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeSchedulePolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		Script for schedule policy permissions upgrade
--		This script assigns all permissions under "schedule policy" category to the
--		creators of schedule policies
--
-- ------------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeSchedulePolicy <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeSchedulePolicy')
	drop procedure sec_upgradeSchedulePolicy
IF EXISTS (select * from GxQscripts where name='sec_upgradeSchedulePolicy')
	delete from GxQscripts where name = 'sec_upgradeSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSchedulePolicy')
	delete from GXDBVersions where aliasname = 'sec_upgradeSchedulePolicy'
GO
print '... Creating Procedure: sec_upgradeSchedulePolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_upgradeSchedulePolicy
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
--execute the script only if this is the first time the category is getting inserted into the DB
--for the subsequent runs, this should not be run
IF EXISTS (SELECT 1 FROM UMCategories WHERE id = 108 AND (flags & CAST(0x1000 AS INT) <> 0))
BEGIN
	DECLARE @schedulePolicyCreatorsIdTable TABLE
	(
		schedulePolicyId INT,
		creatorUserId INT
	)
	--Get list of schedule policies and its owners
	INSERT INTO @schedulePolicyCreatorsIdTable
		SELECT taskId, ownerId
		FROM TM_Task
		WHERE taskType = 4 AND ownerId <> 1			--As per Amey, if the owner of schedule policy is admin user himself, then no need to assign the permissions explicitly
	--Create the role for schedule policy
	DECLARE @schedulePolicyCreatorRoleId INT = 0
	--Removed the schedule policy role creator code from here. Because this stored procedure gets executed ONLY for upgrades and not for fresh installs.
	--We need the role to be created for all cases.
SET @schedulePolicyCreatorRoleId = ISNULL((SELECT id FROM UMRoles WHERE name = 'Schedule Policy Creator'), 0)			--USE_MACRO
	--Assign the permissions to these users on the schedule policy
	IF @schedulePolicyCreatorRoleId <> 0
	BEGIN
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, isCreator, authorId)
SELECT @schedulePolicyCreatorRoleId, 0, creatorUserId, 1, 35, schedulePolicyId, 1, 1		--USE_MACRO
			FROM @schedulePolicyCreatorsIdTable
WHERE schedulePolicyId NOT IN (SELECT entityId1 FROM UMSecurityAssociations WHERE entityType1 = 35 AND isCreator = 1)
	END
	--Unset the flag in UMCategories so that the next time upgrade is run, this script does not execute
	UPDATE UMCategories
SET flags = flags & (~ CAST(0x1000 AS INT))
WHERE id = 108
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeSchedulePolicy')
	delete from GxQscripts where name = 'sec_upgradeSchedulePolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeSchedulePolicy')
	delete from GXDBVersions where aliasname = 'sec_upgradeSchedulePolicy'
GO

insert into GXDBVersions values(2, 'sec_upgradeSchedulePolicy',  '00000000000000000000', 'sec_upgradeSchedulePolicy', '00000000000000000000')
GO

