

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeOldSecurity.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_upgradeOldSecurity.sp,v $ $Id: sec_upgradeOldSecurity.sp,v 1.7.12.8 2018/03/20 00:05:15 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeOldSecurity <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeOldSecurity')
	drop procedure sec_upgradeOldSecurity
IF EXISTS (select * from GxQscripts where name='sec_upgradeOldSecurity')
	delete from GxQscripts where name = 'sec_upgradeOldSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeOldSecurity')
	delete from GXDBVersions where aliasname = 'sec_upgradeOldSecurity'
GO
print '... Creating Procedure: sec_upgradeOldSecurity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_upgradeOldSecurity
--  +========================================================================+
--  |		 		 Name:  sec_upgradeOldSecurity()
--  | Description:  All upgrade operation will be done via this SP.
--  | Input userGroupId=0 ( upgrade all groups)
--	|  	@i_XML  is for future input parameters
--  +========================================================================+
  @errorCode INTEGER =0 OUTPUT,
  @errorString NVARCHAR(1024)  =' ' OUTPUT,
  @userGroupName nvarchar(512)='',
  @doNotUpgradeUserandGroupEntityAssociation INTEGER=0,
  @i_XML XML=''
AS
	DECLARE @roleId INTEGER=0
	DECLARE @viewroleId INT =0
SET @viewroleId  = (SELECT id FROM UMROles WHERE name = 'View' AND flags & 1 | 2 <> 0)
	DECLARE @usergroupId INT =0
	DECLARE @extraPermissionTbl TABLE(categoryId integer,permissionId integer)
	DECLARE @roleXMl XML
	DECLARE @adminUserId INTEGER=1
	DECLARE @roleError  XML
	SET @userGroupId =ISNULL((SELECT id FROM UMGroups where name=@userGroupName),0)
	BEGIN TRANSACTION
	IF(@userGroupId=0)
	BEGIN
		DECLARE userGroupList CURSOR FOR
		SELECT id
		FROM UMGroups
		WHERE name <> 'CV_Restricted_Visibility' AND name <> 'master' AND name <> 'View All'
		OPEN userGroupList
		FETCH NEXT FROM userGroupList  INTO @userGroupId
		WHILE @@FETCH_STATUS =0
		BEGIN
			DELETE @extraPermissionTbl
			IF NOT EXISTS (SELECT 1 FROM UMGroupCapability WHERE groupId = @userGroupId) AND
			   NOT EXISTS (SELECT 1 FROM UMGroupAssociation WHERE groupId = @userGroupId) AND
			   NOT EXISTS(SELECT 1 FROM UMgroups WHERE id=@userGroupId AND (allAssociations<>0 OR allCapabilities<>0) )
			BEGIN
			   FETCH NEXT FROM userGroupList  INTO @userGroupId
			   CONTINUE
			END
			EXEC sec_UpgradeUMGroupCapability @userGroupId,@roleId OUTPUT,@errorcode OUTPUT,@errorString OUTPUT,0
			IF(@errorCode<>0)
			BEGIN
				PRINT @errorString
				ROLLBACK TRANSACTION
				CLOSE  userGroupList
				DEALLOCATE userGroupList
				RETURN
			 END
			 EXEC sec_UpgradeUMGroupAssociation @userGroupId,@roleId,@errorcode OUTPUT,@errorString OUTPUT,0
			 IF(@errorCode<>0)
			 BEGIN
				PRINT @errorString
				ROLLBACK TRANSACTION
				CLOSE  userGroupList
				DEALLOCATE userGroupList
				RETURN
			 END
			 --If administrative managment is selected. We need to give installtion permission for upgraded setups. Because in v10 there security check is or of Adminstrative management or  Installtion, we removed check to installaltion alone. To ensure users which can install in v9/v10 after upgrade too.
			 --Ignore if all capability is selected
IF EXISTS(SELECT  1 from UMGroupCapability where groupId=@userGroupId and capabilityId=1
														and groupId not in (select id from UMgroups where allCapabilities=1))
			BEGIN
				--Its commcell level associtation so we should insert both permissions "installation ( install pacakages", "install a new client"
IF EXISTS(SELECT 1 from UMGroupAssociation where groupId=@usergroupId and type1=2018 and id1=2 )
				  OR EXISTS(SELECT 1 from UMGroups where id=@usergroupId and allAssociations=1)
				 BEGIN
					  INSERT INTO @extraPermissionTbl
SELECT categoryId,id FROM UMPErmissions WHERE id in (7 ,65)
				END
				--client or client Group. Even if we remove if condition it is fine. Since there is no meaning of installation on storage policy or media agent.
ELSE IF EXISTS(SELECT 1 FROM UMGroupAssociation where groupId=@usergroupId and type1  in (2009,2572) and type2=0 and type3=0 and type4=0)
				BEGIN
					--Insert only "install packages"
					INSERT INTO @extraPermissionTbl
SELECT categoryId,id FROM UMPErmissions WHERE id in (7)
				END
			END
			-- IF report managment is present at commcell level, than give user reporting and data source permissions.
IF EXISTS(SELECT  1 from UMGroupCapability where groupId=@userGroupId and capabilityId=15
														and groupId not in (select id from UMgroups where allCapabilities=1))
			BEGIN
				--Its commcell level associtation so we should insert both permissions "installation ( install pacakages", "install a new client"
IF EXISTS(SELECT 1 from UMGroupAssociation where groupId=@usergroupId and type1=2018 and id1=2 )
				  OR EXISTS(SELECT 1 from UMGroups where id=@usergroupId and allAssociations=1)
				 BEGIN
					  INSERT INTO @extraPermissionTbl
SELECT id,0 FROM UMCategories WHERE id in (112 ,110 )
				END
			END
				--should we directly insert into table. Currently yes, as upgrade logic assign permission individuall( not all permission) so fine.
				--but in future upgrade logic may get change..so lets edit role via standard xml
			IF EXISTS(SELECT  1 FROM @extraPErmissionTbl)
			BEGIN
				SET @roleXml= (	SELECT
									(SELECT @roleId as '@roleId'
									 FOR XML PATH('role'),TYPE),
									(SELECT 2  as '@categoriesPermissionOperationType',  --add
											(SELECT permissionId as '@permissionId',
													categoryId AS '@categoryId',
CASE WHEN permissionId<>0  THEN 122
ELSE 121
													END as '@_type_'
											 FROM  @extraPermissionTbl
											FOR XML PATH('categoriesPermissionList'),TYPE)
									FOR XML PATH('categoryPermission'),TYPE)
								FOR XML PATH('Security_Role'))
				EXEC sec_EditRole @roleXml,@adminUserId,0,@roleError OUTPUT,0
				SET @errorCode = (ISNULL((SELECT @roleError.value('(App_GenericEntityResponse/@errorcode)[1]' ,'int')),0))
				if(@errorCode<>0)
				BEGIN
					SET @errorString = (SELECT @roleError.value('(App_GenericEntityResponse/@errorString)[1]','varchar(1024)'))
					PRINT @errorString
					ROLLBACK TRANSACTION
					CLOSE  userGroupList
					DEALLOCATE userGroupList
					RETURN
				END
			END
			--a special handling of installation: Installation is a no-association permission. So in v10, if there is a user group with installation capability and no
			--association then still the user can install new clients. But in v11, we need the three way model <user/group - entity - role/permission>. So for these user
			--groups we will give install client on commcell. We wont give install updates/software since it requires an association and would not work even in v10 without associations
IF ((EXISTS (SELECT 1 FROM UMGroupCapability WHERE groupId = @usergroupId AND capabilityId = 7) OR ((SELECT allcapabilities FROM UMGroups WHERE id = @usergroupId) = 1))
				AND
				(NOT EXISTS (SELECT 1 FROM UMGroupAssociation WHERE groupId = @userGroupId) AND ((SELECT allAssociations FROM UMGroups WHERE id = @userGroupId) = 0)))
			BEGIN
				--According to Amey, let us create a role than directly assigning permission
				DECLARE @installClientRoleId INT
SET @installClientRoleId = (SELECT id FROM UMRoles WHERE name = 'Install Client')
				--role is not present, so create one
				IF @installClientRoleId IS NULL
				BEGIN
					INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
VALUES (2, 'Install Client', 'Install client role created during upgrade', 0, 0, 0, 1, datediff(second, '01/01/1970', GETUTCDATE()), 0, NEWID(), '')
					SET @installClientRoleId = @@IDENTITY
					INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
SELECT @installClientRoleId, 122, categoryId, id, 0, 0
						FROM UMPermissions
WHERE id = 65
					EXEC sec_expandRoleWithPermissions @installClientRoleId, @errorCode OUTPUT, @errorString OUTPUT
					IF (@errorCode <> 0)
					BEGIN
						PRINT @errorString
						ROLLBACK TRANSACTION
						CLOSE userGroupList
						DEALLOCATE userGroupList
						RETURN
					END
				END
IF NOT EXISTS (SELECT 1 FROM UMSecurityAssociations WHERE userOrGroupId = @userGroupId AND isUser = 0 AND roleId = @installClientRoleId AND entityType1 = 1 AND entityID1 = 2)
					INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, roleId, permissionId, entityType1, entityId1, authorId)
SELECT @userGroupId, 0, @installClientRoleId, 0, 1, 2, 1
			END
			FETCH NEXT FROM userGroupList  INTO @userGroupId
		END
		CLOSE  userGroupList
		DEALLOCATE userGroupList
		--MR 174041: According to Amey we should not give User group - View - User group security association for user groups that have AD members in it.
		DECLARE @userGroupHasADMembers INT = 0
		SELECT @userGroupHasADMembers = 1
		FROM UMGroups (NOLOCK)
		WHERE id = @userGroupID AND umdsProviderId > 0
		IF @userGroupHasADMembers = 0
			SELECT @userGroupHasADMembers = 1
			FROM UMDSGroupMaps (NOLOCK)
			WHERE umGroupId = @userGroupId
		IF @userGroupHasADMembers = 0
			SELECT @userGroupHasADMembers = 1
			FROM UMUserGroup UG (NOLOCK) INNER JOIN UMUsers U (NOLOCK)
			ON UG.userId = U.id
			WHERE UG.groupId = @userGroupId AND U.umdsProviderId > 0
		IF @viewroleid <> 0	AND @userGroupHasADMembers = 0
			INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, authorId)
SELECT @viewroleId, 0, id, 0, 15, id, 1
				 FROM UMGroups G
WHERE NOT EXISTS (SELECT 1 FROM UMSecurityAssociations WHERE userOrGroupId = G.id AND isUser = 0 AND roleId = @viewroleId AND entityType1 = 15 AND entityId1 = G.id)
	END
	ELSE
	BEGIN
		EXEC sec_UpgradeUMGroupCapability @userGroupId,@roleId OUTPUT,@errorcode OUTPUT,@errorString OUTPUT,0
			IF(@errorCode<>0)
			BEGIN
				PRINT @errorString
				ROLLBACK TRANSACTION
				RETURN
			 END
			 EXEC sec_UpgradeUMGroupAssociation @userGroupId,@roleId,@errorcode OUTPUT,@errorString OUTPUT,0
			 IF(@errorCode<>0)
			 BEGIN
				PRINT @errorString
				ROLLBACK TRANSACTION
				RETURN
			 END
			--If administrative managment is selected. We need to give installtion permission for upgraded setups. Because in v10 there security check is or of Adminstrative management or  Installtion, we removed check to installaltion alone. To ensure users which can install in v9/v10 after upgrade too.
			 --Ignore if all capability is selected
IF EXISTS(SELECT  1 from UMGroupCapability where groupId=@userGroupId and capabilityId=1
														and groupId not in (select id from UMgroups where allCapabilities=1))
			BEGIN
				--Its commcell level associtation so we should insert both permissions "installation ( install pacakages", "install a new client"
IF EXISTS(SELECT 1 from UMGroupAssociation where groupId=@usergroupId and type1=2018 and id1=2 )
				  OR EXISTS(SELECT 1 from UMGroups where id=@usergroupId and allAssociations=1)
				 BEGIN
					  INSERT INTO @extraPermissionTbl
SELECT categoryId,id FROM UMPErmissions WHERE id in (7 ,65)
				END
				--client or client Group. Even if we remove if condition it is fine. Since there is no meaning of installation on storage policy or media agent.
ELSE IF EXISTS(SELECT 1 FROM UMGroupAssociation where groupId=@usergroupId and type1  in (2009,2572) and type2=0 and type3=0 and type4=0)
				BEGIN
					--Insert only "install packages"
					INSERT INTO @extraPermissionTbl
SELECT categoryId,id FROM UMPErmissions WHERE id in (7)
				END
				END
			-- IF report managment is present at commcell level, than give user reporting and data source permissions.
IF EXISTS(SELECT  1 from UMGroupCapability where groupId=@userGroupId and capabilityId=15
														and groupId not in (select id from UMgroups where allCapabilities=1))
			BEGIN
				--Its commcell level associtation so we should insert both permissions "installation ( install pacakages", "install a new client"
IF EXISTS(SELECT 1 from UMGroupAssociation where groupId=@usergroupId and type1=2018 and id1=2 )
				  OR EXISTS(SELECT 1 from UMGroups where id=@usergroupId and allAssociations=1)
				 BEGIN
					  INSERT INTO @extraPermissionTbl
SELECT id,0 FROM UMCategories WHERE id in (112 ,110 )
				END
			END
				--should we directly insert into table. Currently yes, as upgrade logic assign permission individuall( not all permission) so fine.
				--but in future upgrade logic may get change..so lets edit role via standard xml
			IF EXISTS(SELECT  1 FROM @extraPErmissionTbl)
			BEGIN
				SET @roleXml= (	SELECT
									(SELECT @roleId as '@roleId'
									 FOR XML PATH('role'),TYPE),
									(SELECT 2  as '@categoriesPermissionOperationType',  --add
											(SELECT permissionId as '@permissionId',
													categoryId AS '@categoryId',
CASE WHEN permissionId<>0  THEN 122
ELSE 121
													END as '@_type_'
											 FROM  @extraPermissionTbl
											FOR XML PATH('categoriesPermissionList'),TYPE)
									FOR XML PATH('categoryPermission'),TYPE)
								FOR XML PATH('Security_Role'))
				EXEC sec_EditRole @roleXml,@adminUserId,0,@roleError OUTPUT,0
				SET @errorCode = (ISNULL((SELECT @roleError.value('(App_GenericEntityResponse/@errorcode)[1]' ,'int')),0))
				if(@errorCode<>0)
				BEGIN
					SET @errorString = (SELECT @roleError.value('(App_GenericEntityResponse/@errorString)[1]','varchar(1024)'))
					PRINT @errorString
					ROLLBACK TRANSACTION
					RETURN
				END
			END
			--a special handling of installation: Installation is a no-association permission. So in v10, if there is a user group with installation capability and no
			--association then still the user can install new clients. But in v11, we need the three way model <user/group - entity - role/permission>. So for these user
			--groups we will give install client on commcell. We wont give install updates/software since it requires an association and would not work even in v10 without associations
IF ((EXISTS (SELECT 1 FROM UMGroupCapability WHERE groupId = @usergroupId AND capabilityId = 7) OR ((SELECT allcapabilities FROM UMGroups WHERE id = @usergroupId) = 1))
				AND
				(NOT EXISTS (SELECT 1 FROM UMGroupAssociation WHERE groupId = @userGroupId) AND ((SELECT allAssociations FROM UMGroups WHERE id = @userGroupId) = 0)))
			BEGIN
				--According to Amey, let us create a role than directly assigning permission
				--DECLARE @installClientRoleId INT
SET @installClientRoleId = (SELECT id FROM UMRoles WHERE name = 'Install Client')
				--role is not present, so create one
				IF @installClientRoleId IS NULL
				BEGIN
					INSERT INTO UMRoles (commcellId, name, description, disabled, isPrivate, flags, ownerId, created, modified, GUID, xmlProperties)
VALUES (2, 'Install Client', 'Install client role created during upgrade', 0, 0, 0, 1, datediff(second, '01/01/1970', GETUTCDATE()), 0, NEWID(), '')
					SET @installClientRoleId = @@IDENTITY
					INSERT INTO UMRolesPermissions (roleId, hierarchyLevel, categoryId, permissionId, excludeCategory, excludePermission)
SELECT @installClientRoleId, 122, categoryId, id, 0, 0
						FROM UMPermissions
WHERE id = 65
					EXEC sec_expandRoleWithPermissions @installClientRoleId, @errorCode OUTPUT, @errorString OUTPUT
					IF (@errorCode <> 0)
					BEGIN
						PRINT @errorString
						ROLLBACK TRANSACTION
						RETURN
					END
				END
IF NOT EXISTS (SELECT 1 FROM UMSecurityAssociations WHERE userOrGroupId = @userGroupId AND isUser = 0 AND roleId = @installClientRoleId AND entityType1 = 1 AND entityID1 = 2)
					INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, roleId, permissionId, entityType1, entityId1, authorId)
SELECT @userGroupId, 0, @installClientRoleId, 0, 1, 2, 1
			END
		--MR 174041: According to Amey we should not give User group - View - User group security association for user groups that have AD members in it.
		SET @userGroupHasADMembers = 0
		SELECT @userGroupHasADMembers = 1
		FROM UMGroups (NOLOCK)
		WHERE id = @userGroupID AND umdsProviderId > 0
		IF @userGroupHasADMembers = 0
			SELECT @userGroupHasADMembers = 1
			FROM UMDSGroupMaps (NOLOCK)
			WHERE umGroupId = @userGroupId
		IF @userGroupHasADMembers = 0
			SELECT @userGroupHasADMembers = 1
			FROM UMUserGroup UG (NOLOCK) INNER JOIN UMUsers U (NOLOCK)
			ON UG.userId = U.id
			WHERE UG.groupId = @userGroupId AND U.umdsProviderId > 0
		IF @viewroleid <> 0	AND @userGroupHasADMembers = 0
		BEGIN
SET @viewroleId  = (SELECT id FROM UMROles WHERE name = 'View' AND flags & 1 | 2 <> 0)
IF @viewroleid <> 0 AND NOT EXISTS (SELECT 1 FROM UMSecurityAssociations WHERE roleId = @viewRoleId AND entityType1 = 15 AND entityID1 = @userGroupId AND userOrGroupid = @userGroupId AND isUser = 0)
				INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, authorId)
SELECT @viewroleid, 0, @userGroupId, 0, 15, @userGRoupID, 1
		END
	END
	print('Classic security upgrade completed successfully')
	if(@doNotUpgradeUserandGroupEntityAssociation=0)
	BEGIN
		EXEC sec_upgradeUMUserAndGroupEntityAssociation @errorCode OUTPUT,@errorString OUTPUT
		 IF(@errorCode<>0)
			 BEGIN
				PRINT @errorString
				ROLLBACK TRANSACTION
				RETURN
			 END
	END
PRINT ('Setting 0x0020 0x0020 flag for non mapped and not owner AD groups.')
	IF (@userGroupName = '')
	BEGIN
		EXEC sec_hideADGroupsInUpgrade @errorCode OUTPUT, @errorString OUTPUT
		IF (@errorCode <> 0)
		BEGIN
			PRINT @errorString
			ROLLBACK TRANSACTION
			RETURN
		END
	END
	COMMIT TRANSACTION
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeOldSecurity')
	delete from GxQscripts where name = 'sec_upgradeOldSecurity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeOldSecurity')
	delete from GXDBVersions where aliasname = 'sec_upgradeOldSecurity'
GO

insert into GXDBVersions values(2, 'sec_upgradeOldSecurity',  '00010007001200080000', 'sec_upgradeOldSecurity', '00010007001200080000')
GO

