

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_upgradeClientGroupPermissions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ------------------------------------------------------------------------------------------------------*/
/* ----------------------------------------------------------------------------------------------------------
--	Author: jswaminathan
--	Description: Gives new client group permissions to existing users and groups.
--	Agent Management on any client -> Create Client Group on Commcell - this will not be done.
--	Creators of client group -> Client Group Creator Role on his client group with isCreate(1). Remove old admin and agent management permissions
--	Admin management + Agent management of client group and Not creator -> Change client assoc + Delete client group.
---------------------------------------------------------------------------------------------------------- */
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_upgradeClientGroupPermissions <<<'

IF EXISTS (select * from sysobjects where name='sec_upgradeClientGroupPermissions')
	drop procedure sec_upgradeClientGroupPermissions
IF EXISTS (select * from GxQscripts where name='sec_upgradeClientGroupPermissions')
	delete from GxQscripts where name = 'sec_upgradeClientGroupPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeClientGroupPermissions')
	delete from GXDBVersions where aliasname = 'sec_upgradeClientGroupPermissions'
GO
print '... Creating Procedure: sec_upgradeClientGroupPermissions'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_upgradeClientGroupPermissions
  @errorCode INT = 0 OUTPUT,
  @errorString NVARCHAR(1024) = N'' OUTPUT
AS
BEGIN TRY
--execute the script only if this is the first time the category is getting inserted into the DB
--for the subsequent runs, this should not be run
IF EXISTS (SELECT 1 FROM UMCategories WHERE id = 122 AND (flags & CAST(0x1000 AS INT) <> 0))
BEGIN
	SET @errorCode = 0
	SET @errorString = N''
DECLARE @clientGroupCreatorRoleID INT = (SELECT id FROM UMRoles WHERE name = 'Client Group Creator' AND flags & 1 | 2 <> 0)					--use macro 'Client Group Creator', 1 | 2
DECLARE @clientGroupCreatePermissionId INT = 179						--use macro CAT_CLIENT_GROUP_CREATE
DECLARE @clientGroupDeletePermissionId INT = 180						--use macro CAT_CLIENT_GROUP_DELETE
DECLARE @clientGroupChangeClientAssocPermissionId INT = 181		--use macro CAT_CLIENT_GROUP_CHANGE_ASSOC
DECLARE @clientGroupCategoryId INT = 122									--use macro CATEGORY_CLIENT_GROUP
DECLARE @agentManagementPermissionID INT = 2							--use macro EV_MANAGE_APPLICATION
DECLARE @adminManagementPermissionId INT = 1								--use macro EV_SCHEDULE_ADMIN
DECLARE @commcellEntityType INT = 1											--use macro COMMCELL_ENTITY
DECLARE @clientEntityType INT = 3												--use macro CLIENT_ENTITY
DECLARE @clientGroupEntityType INT = 28									--use macro CLIENT_GROUP_ENTITY
	DECLARE @defaultCommcellId INT = 2															--use macro DEFAULT_COMMCELL_ID
DECLARE @adminuserId INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0)			--use macro USERS_ADMIN
	IF OBJECT_ID('tempdb.dbo.#rolesWithAdminManagement') IS NOT NULL
		DROP TABLE #rolesWithAdminManagement
	CREATE TABLE #rolesWithAdminManagement (roleId INT PRIMARY KEY)
	INSERT INTO #rolesWithAdminManagement
		SELECT roleId
		FROM UMRolesWithPermissionsExpanded
		WHERE permissionId = @adminManagementPermissionId
	/*IF OBJECT_ID('tempdb.dbo.#rolesWithAgentManagement') IS NOT NULL
		DROP TABLE #rolesWithAgentManagement
	CREATE TABLE #rolesWithAgentManagement (roleId INT PRIMARY KEY)
	INSERT INTO #rolesWithAgentManagement
		SELECT roleId
		FROM UMRolesWithPermissionsExpanded
		WHERE permissionId = @agentManagementPermissionID
	--1. Create Client Group on commcell for all the users or groups with agent management on any client.
	-- According to Amey, giving Create Client Group permission to user with agent management on any client
	-- creates too much clutter. So not giving Create Client Group permission. Let admin give it manually
	-- to user who wants to create client group.
	IF OBJECT_ID('tempdb.dbo.#usersGroupsWithAgentManagementOnAnyClient') IS NOT NULL
		DROP TABLE #usersGroupsWithAgentManagementOnAnyClient
	CREATE TABLE #usersGroupsWithAgentManagementOnAnyClient (userOrGroupId INT, isUser INT)
	INSERT INTO #usersGroupsWithAgentManagementOnAnyClient
		SELECT userOrGroupId, isUser
		FROM UMSecurityAssociations Sec INNER JOIN #rolesWithAgentManagement R
		ON Sec.roleID = R.roleID
		WHERE ((entityTYpe1 = @commcellEntityType AND entityId1 = @defaultCommcellId) 				--Agent Management role on commcell
			OR entityTYpe1 = @clientGroupEntityType													--Agent Management role on any client group
			OR entityTYpe1 = @clientEntityType)														--Agent Management role on any client
		UNION
		SELECT userOrGroupId, isUser
		FROM UMSecurityAssociations Sec
		WHERE permissionId = @agentManagementPermissionID
		AND	((entityTYpe1 = @commcellEntityType AND entityId1 = @defaultCommcellId) 				--Agent Management permission on commcell
			OR entityTYpe1 = @clientGroupEntityType													--Agent Management permission on any client group
			OR entityTYpe1 = @clientEntityType)														--Agent Management permission on any client
		UNION
		SELECT O.userOrGroupId, O.isUser
		FROM UMOwners O INNER JOIN UMOwnerRoles R
		ON O.entityType = R.entityType AND O.entityId = R.entityId
		WHERE O.entityType = @clientEntityType
		AND (R.roleID IN (SELECT roleId FROM #rolesWithAgentManagement)
			OR R.permissionId = @agentManagementPermissionID)
		UNION
		SELECT O.userOrGroupId, O.isUser
		FROM UMOwners O INNER JOIN APP_ClientGroupAssoc A
		ON O.entityId = A.clientId
		INNER JOIN UMOwnerRoles R
		ON R.entityTYpe = @clientGroupEntityType AND R.entityId = A.clientGRoupID
		WHERE O.entityTYpe = @clientEntityType
		AND (R.roleID IN (SELECT roleId FROM #rolesWithAgentManagement)
			OR R.permissionId = @agentManagementPermissionID)
		UNION
		SELECT O.userOrGroupId, O.isUser
		FROM UMOwners O INNER JOIN UMOwnerRoles R
		ON R.entityType = @commcellEntityType AND R.entityID = @defaultCommcellId
		WHERE O.entityType = @clientEntityType
		AND (R.roleID IN (SELECT roleId FROM #rolesWithAgentManagement)
			OR R.permissionId = @agentManagementPermissionID)
	INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, permissionId, entityType1, entityId1, authorId)
		SELECT DISTINCT userOrGroupID, isUser, @clientGroupCreatePermissionId, @commcellEntityType, @defaultCommcellId, @adminuserId
		FROM #usersGroupsWithAgentManagementOnAnyClient Input
		WHERE NOT EXISTS (SELECT 1 FROM UMSecurityAssociations
						  WHERE entityType1 = @commcellEntityType AND entityId1 = @defaultCommcellId
								AND userOrGroupId = Input.userOrGroupId AND isUser = Input.isUser
								AND permissionId = @clientGroupCreatePermissionId)*/
	--2. Client Group Creator Role for the users or groups who created Client group.
	IF OBJECT_ID('tempdb.dbo.#clientGroupCreators') IS NOT NULL
		DROP TABLE #clientGroupCreators
	CREATE TABLE #clientGroupCreators (clientGroupId INT PRIMARY KEY, userOrGroupId INT, isUser INT)
	INSERT INTO #clientGroupCreators (clientGroupid, userOrGroupId, isUser)
		SELECT DISTINCT entityID1, userOrGroupId, isUser
		FROM UMSecurityAssociations
		WHERE entityType1 = @clientGroupEntityType AND isCreator = 1
	DELETE FROM UMSecurityAssociations
	WHERE entityType1 = @clientGroupEntityType AND isCreator = 1			--Remove already existing administrative management + agent management permissions for creators. They are part of Client Group Creator Role.
	INSERT INTO UMSecurityAssociations (userOrGroupId, isUser, roleId, entityType1, entityId1, isCreator, authorId)
		SELECT DISTINCT userOrGroupId, isUser, @clientGroupCreatorRoleID, @clientGroupEntityType, clientGroupId, 1, @adminuserId
		FROM #clientGroupCreators OuterTbl
		WHERE NOT EXISTS (SELECT 1 FROM UMSecurityAssociations
						  WHERE entityTYpe1 = @clientGroupEntityType AND entityId1 = OuterTbl.clientGroupId AND isCreator = 1)
	--3. Users with administrative management + agent management on client groups to get Change Client Associations and Delete Client Groups on the client groups.
	--Let us give Change Client Associations and Delete Client Groups to users and groups with administrative management. No need to check for agent management.
	--Application layer code checks for agent management + administrative management + Change Client Associations / Delete client groups for the respective operation.
	--So even if an user gets Change Client Associations / Delete client groups just because he had admin management without agent management, still he will not be able to "actually" do the operation.
	--Reason why we are not writing code to check for both permissions is
		--1. User can have admin management on client group and agent management on commcell. (or different permutations of that).
		--2. User can have admin management on client group and user group can have agent management on client group. (or different permutations of that).
			--a. Consider user - user group, domain user - domain user group, domain user group - local group, domain user - domain user group - local group. Permission can be given at any level for any one.
		--3. Permutations of 1 and 2.
	--Writing all this is tough. 90% of cases will have both admin management and agent management together.
	IF OBJECT_ID('tempdb.dbo.#UsersGroupsWithAdminManagement') IS NOT NULL
		DROP TABLE #UsersGroupsWithAdminManagement
	CREATE TABLE #UsersGroupsWithAdminManagement (commcellId INT, clientGroupId INT, userOrGroupId INT, isUser INT)
	INSERT INTO #UsersGroupsWithAdminManagement (commcellId, clientGRoupId, userOrGRoupId, isUser)
		SELECT CASE WHEN Sec.entityTYpe1 = @commcellEntityType THEN Sec.entityID1 ELSE 0 END,
			   CASE WHEN Sec.entityTYpe1 = @clientGroupEntityType THEN Sec.entityID1 ELSE 0 END,
			   Sec.userOrGRoupId,
			   Sec.isUser
		FROM UMSecurityAssociations Sec
		WHERE Sec.entityType1 IN (@clientGroupEntityType, @commcellEntityType) AND isCreator = 0
		AND (roleID IN (SELECT roleId FROM #rolesWithAdminManagement) OR permissionId = @adminManagementPermissionId)
	--Users and groups with admin management and agent management on commcell gets change client associations and delete client group on commcell.
	INSERT INTO UMSecurityAssociations (userOrGRoupId, isUser, permissionId, entityType1, entityId1, authorId)
		SELECT DISTINCT Tbl1.userOrGroupId, Tbl1.isUser, @clientGroupChangeClientAssocPermissionId, Tbl1.entityType, Tbl1.entityId, @adminUserID
		FROM
					(
					SELECT userOrGRoupId,
						   isUser,
						   CASE WHEN commcellId <> 0 THEN @commcellEntityType ELSE @clientGRoupEntityTYpe END AS entityType,
						   CASE WHEN commcellId <> 0 THEN commcellId ELSE clientGRoupId END AS entityId
					FROM #UsersGroupsWithAdminManagement A
					) Tbl1
		WHERE NOT EXISTS
					(
					SELECT 1
					FROM UMSecurityAssociations
					WHERE userOrGroupId = Tbl1.userOrGroupId AND isUser = Tbl1.isuser
					AND entityType1 = Tbl1.entityType AND entityId1 = Tbl1.entityId
					AND permissionId = @clientGroupChangeClientAssocPermissionId
					AND isCreator = 0
					)
		UNION
		SELECT DISTINCT Tbl1.userOrGroupId, Tbl1.isUser, @clientGroupDeletePermissionId, Tbl1.entityType, Tbl1.entityId, @adminUserID
		FROM
					(
					SELECT userOrGRoupId,
						   isUser,
						   CASE WHEN commcellId <> 0 THEN @commcellEntityType ELSE @clientGRoupEntityTYpe END AS entityType,
						   CASE WHEN commcellId <> 0 THEN commcellId ELSE clientGRoupId END AS entityId
					FROM #UsersGroupsWithAdminManagement A
					) Tbl1
		WHERE NOT EXISTS
					(
					SELECT 1
					FROM UMSecurityAssociations
					WHERE userOrGroupId = Tbl1.userOrGroupId AND isUser = Tbl1.isuser
					AND entityType1 = Tbl1.entityType AND entityId1 = Tbl1.entityId
					AND permissionId = @clientGroupDeletePermissionId
					AND isCreator = 0
					)
	--Unset the flag in UMCategories so that the next time upgrade is run, this script does not execute
	UPDATE UMCategories
SET flags = flags & (~ CAST(0x1000 AS INT))
WHERE id = 122
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorString = ERROR_MESSAGE()
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_upgradeClientGroupPermissions')
	delete from GxQscripts where name = 'sec_upgradeClientGroupPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_upgradeClientGroupPermissions')
	delete from GXDBVersions where aliasname = 'sec_upgradeClientGroupPermissions'
GO

insert into GXDBVersions values(2, 'sec_upgradeClientGroupPermissions',  '00000000000000000000', 'sec_upgradeClientGroupPermissions', '00000000000000000000')
GO

