

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_updateUserCredentialsBulk.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  sec_updateUserCredentialsBulk()
--  |
--  | Description:  Accepts a comma separated string of user ids and will
--	|			    execute sec_updateUserCredentials for all of them
--  |
--  |
--	|
--  |
--  |
--  |
--  |
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_updateUserCredentialsBulk <<<'

IF EXISTS (select * from sysobjects where name='sec_updateUserCredentialsBulk')
	drop procedure sec_updateUserCredentialsBulk
IF EXISTS (select * from GxQscripts where name='sec_updateUserCredentialsBulk')
	delete from GxQscripts where name = 'sec_updateUserCredentialsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateUserCredentialsBulk')
	delete from GXDBVersions where aliasname = 'sec_updateUserCredentialsBulk'
GO
print '... Creating Procedure: sec_updateUserCredentialsBulk'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_updateUserCredentialsBulk
  @inputStr VARCHAR(MAX) 
AS
DECLARE @userIds TABLE
(
	userID INT
)
INSERT INTO @userIds
	SELECT _ID
	FROM dbo.SplitIDs(@inputStr)
DECLARE @tempUserId INT
DECLARE tempCursor CURSOR FOR
	SELECT userId FROM @userIds
OPEN tempCursor
FETCH NEXT FROM tempCursor INTO @tempUserID
WHILE @@FETCH_STATUS = 0
BEGIN
	EXEC sec_updateUserCredentials @tempUserId, 1
	FETCH NEXT FROM tempCursor INTO @tempUserID
END
CLOSE tempCursor
DEALLOCATE tempCursor
GO

IF EXISTS (select * from GxQscripts where name = 'sec_updateUserCredentialsBulk')
	delete from GxQscripts where name = 'sec_updateUserCredentialsBulk'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateUserCredentialsBulk')
	delete from GXDBVersions where aliasname = 'sec_updateUserCredentialsBulk'
GO

insert into GXDBVersions values(2, 'sec_updateUserCredentialsBulk',  '00000000000000000000', 'sec_updateUserCredentialsBulk', '00000000000000000000')
GO

