

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_updateQSDKSessionXML.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UpdateQSDKSessionXML')
BEGIN
	print '>>> Drop Stored Procedure: sec_UpdateQSDKSessionXML <<<'
	drop procedure sec_UpdateQSDKSessionXML
END
IF EXISTS (select * from GxQscripts where name='sec_UpdateQSDKSessionXML')
	delete from GxQscripts where name = 'sec_UpdateQSDKSessionXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UpdateQSDKSessionXML')
	delete from GXDBVersions where aliasname = 'sec_UpdateQSDKSessionXML'
GO
print '... Creating Procedure: sec_UpdateQSDKSessionXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UpdateQSDKSessionXML
  @sessions XML
AS
  DECLARE @o_xml XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
-- -- SP BODY BEGIN : sec_updateQSDKSession.spb ------------------------------------------------------------------------------------------------------------------------------------
    IF OBJECT_ID('tempdb.dbo.#QSDKSession_TobeUpdated') IS NOT NULL DROP TABLE #QSDKSession_TobeUpdated
    CREATE TABLE #QSDKSession_TobeUpdated(guid UNIQUEIDENTIFIER, lastAccesstime BIGINT, location NVARCHAR(2048))
    CREATE CLUSTERED INDEX QSDKSession_TobeUpdated_idx ON #QSDKSession_TobeUpdated(guid)
    INSERT INTO #QSDKSession_TobeUpdated
        SELECT  ref.value('@guid', 'uniqueidentifier'),
                ref.value('@lastAccesstime', 'bigint'),
                ref.value('@location', 'nvarchar(2014)')
        FROM @sessions.nodes('/App_UpdateSessionDetailsRequest/sessionDetails') R(ref)
        WHERE TRY_CONVERT(UNIQUEIDENTIFIER, ref.value('@guid', 'varchar(128)')) IS NOT NULL
	UPDATE  S
    SET     S.lastAccessedTime =  U.lastAccesstime, S.location = U.location
    FROM    UMQSDKSessions S JOIN #QSDKSession_TobeUpdated U ON  S.GUID = U.guid AND S.lastAccessedTime < U.lastAccesstime;
    IF OBJECT_ID('tempdb.dbo.#QSDKSession_TobeUpdated') IS NOT NULL DROP TABLE #QSDKSession_TobeUpdated
-- -- SP BODY END : sec_updateQSDKSession.spb --------------------------------------------------------------------------------------------------------------------------------------
SET @o_xml =
(
    SELECT(
	    SELECT R.[GUID]           AS '@guid',
               R.lastAccessedTime AS '@lastAccesstime',
	           R.[location]       AS '@location',
               R.created          AS '@created',
               R.consoleType      AS '@clientType',
               R.hostName         AS '@hostName',
               R.[timeout]        AS '@timeout',
              (SELECT   U.id            AS '@userId',
                        U.[login]        AS '@userName',
                        U.[userGuid]    AS '@userGUID'
               FROM     UMUsers U WITH(NOLOCK)
               WHERE    U.id = R.userId
               FOR XML PATH('user'), TYPE)
	    FROM UMQSDKSessions R WITH(NOLOCK)
        FOR XML PATH('sessionDetails'), TYPE
    )
	FOR XML PATH('App_UpdateSessionDetailsResponse'), TYPE
)
SELECT @o_xml AS [o_xml]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_updateQSDKSessionXML')
	delete from GxQscripts where name = 'sec_updateQSDKSessionXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateQSDKSessionXML')
	delete from GXDBVersions where aliasname = 'sec_updateQSDKSessionXML'
GO

insert into GXDBVersions values(2, 'sec_updateQSDKSessionXML',  '00000000000000000000', 'sec_updateQSDKSessionXML', '00000000000000000000')
GO

