

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_updateQSDKSessionRaw.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UpdateQSDKSessionRaw')
BEGIN
	print '>>> Drop Stored Procedure: sec_UpdateQSDKSessionRaw <<<'
	drop procedure sec_UpdateQSDKSessionRaw
END
IF EXISTS (select * from GxQscripts where name='sec_UpdateQSDKSessionRaw')
	delete from GxQscripts where name = 'sec_UpdateQSDKSessionRaw'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UpdateQSDKSessionRaw')
	delete from GXDBVersions where aliasname = 'sec_UpdateQSDKSessionRaw'
GO
print '... Creating Procedure: sec_UpdateQSDKSessionRaw'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UpdateQSDKSessionRaw
  @sessions XML,
  @generateList INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
-- -- SP BODY BEGIN : sec_updateQSDKSession.spb ------------------------------------------------------------------------------------------------------------------------------------
    IF OBJECT_ID('tempdb.dbo.#QSDKSession_TobeUpdated') IS NOT NULL DROP TABLE #QSDKSession_TobeUpdated
    CREATE TABLE #QSDKSession_TobeUpdated(guid UNIQUEIDENTIFIER, lastAccesstime BIGINT, location NVARCHAR(2048))
    CREATE CLUSTERED INDEX QSDKSession_TobeUpdated_idx ON #QSDKSession_TobeUpdated(guid)
    INSERT INTO #QSDKSession_TobeUpdated
        SELECT  ref.value('@guid', 'uniqueidentifier'),
                ref.value('@lastAccesstime', 'bigint'),
                ref.value('@location', 'nvarchar(2014)')
        FROM @sessions.nodes('/App_UpdateSessionDetailsRequest/sessionDetails') R(ref)
        WHERE TRY_CONVERT(UNIQUEIDENTIFIER, ref.value('@guid', 'varchar(128)')) IS NOT NULL
	UPDATE  S
    SET     S.lastAccessedTime =  U.lastAccesstime, S.location = U.location
    FROM    UMQSDKSessions S JOIN #QSDKSession_TobeUpdated U ON  S.GUID = U.guid AND S.lastAccessedTime < U.lastAccesstime;
    IF OBJECT_ID('tempdb.dbo.#QSDKSession_TobeUpdated') IS NOT NULL DROP TABLE #QSDKSession_TobeUpdated
-- -- SP BODY END : sec_updateQSDKSession.spb --------------------------------------------------------------------------------------------------------------------------------------
IF @generateList != 0 BEGIN
    SELECT  R.[GUID] AS [SessionGuid], R.lastAccessedTime, R.[location], R.created, R.consoleType, R.hostName, R.[timeout], U.id AS UserId, U.[login] AS UserName, U.userGuid
    FROM    UMQSDKSessions R INNER JOIN UMUsers U ON R.userId = U.id
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_updateQSDKSessionRaw')
	delete from GxQscripts where name = 'sec_updateQSDKSessionRaw'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateQSDKSessionRaw')
	delete from GXDBVersions where aliasname = 'sec_updateQSDKSessionRaw'
GO

insert into GXDBVersions values(2, 'sec_updateQSDKSessionRaw',  '00000000000000000000', 'sec_updateQSDKSessionRaw', '00000000000000000000')
GO

