

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_updateQSDKSession.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_UpdateQSDKSession')
BEGIN
	print '>>> Drop Stored Procedure: sec_UpdateQSDKSession <<<'
	drop procedure sec_UpdateQSDKSession
END
IF EXISTS (select * from GxQscripts where name='sec_UpdateQSDKSession')
	delete from GxQscripts where name = 'sec_UpdateQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_UpdateQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_UpdateQSDKSession'
GO
print '... Creating Procedure: sec_UpdateQSDKSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_UpdateQSDKSession
  @sessions XML
AS
-- -- SP BODY BEGIN : sec_updateQSDKSession.spb ------------------------------------------------------------------------------------------------------------------------------------
    IF OBJECT_ID('tempdb.dbo.#QSDKSession_TobeUpdated') IS NOT NULL DROP TABLE #QSDKSession_TobeUpdated
    CREATE TABLE #QSDKSession_TobeUpdated(guid UNIQUEIDENTIFIER, lastAccesstime BIGINT, location NVARCHAR(2048))
    CREATE CLUSTERED INDEX QSDKSession_TobeUpdated_idx ON #QSDKSession_TobeUpdated(guid)
    INSERT INTO #QSDKSession_TobeUpdated
        SELECT  ref.value('@guid', 'uniqueidentifier'),
                ref.value('@lastAccesstime', 'bigint'),
                ref.value('@location', 'nvarchar(2014)')
        FROM @sessions.nodes('/App_UpdateSessionDetailsRequest/sessionDetails') R(ref)
        WHERE TRY_CONVERT(UNIQUEIDENTIFIER, ref.value('@guid', 'varchar(128)')) IS NOT NULL
	UPDATE  S
    SET     S.lastAccessedTime =  U.lastAccesstime, S.location = U.location
    FROM    UMQSDKSessions S JOIN #QSDKSession_TobeUpdated U ON  S.GUID = U.guid AND S.lastAccessedTime < U.lastAccesstime;
    IF OBJECT_ID('tempdb.dbo.#QSDKSession_TobeUpdated') IS NOT NULL DROP TABLE #QSDKSession_TobeUpdated
-- -- SP BODY END : sec_updateQSDKSession.spb --------------------------------------------------------------------------------------------------------------------------------------
	select GUID, lastAccessedTime, location from UMQSDKSessions
GO

IF EXISTS (select * from GxQscripts where name = 'sec_updateQSDKSession')
	delete from GxQscripts where name = 'sec_updateQSDKSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateQSDKSession')
	delete from GXDBVersions where aliasname = 'sec_updateQSDKSession'
GO

insert into GXDBVersions values(2, 'sec_updateQSDKSession',  '00000000000000000000', 'sec_updateQSDKSession', '00000000000000000000')
GO

