

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_updateDM2CapabilitesAndAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_updateDM2CapabilitesAndAssociations.sp,v $ $Id: sec_updateDM2CapabilitesAndAssociations.sp,v 1.11.32.6 2020/06/09 04:22:18 kvinayak Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_updateDM2CapabilitesAndAssociations()
--  |
--  | Description:
--  |
--  |       Input:
--	|
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_updateDM2CapabilitesAndAssociations')
BEGIN
	print '>>> Drop Stored Procedure: sec_updateDM2CapabilitesAndAssociations <<<'
	drop procedure sec_updateDM2CapabilitesAndAssociations
END
IF EXISTS (select * from GxQscripts where name='sec_updateDM2CapabilitesAndAssociations')
	delete from GxQscripts where name = 'sec_updateDM2CapabilitesAndAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateDM2CapabilitesAndAssociations')
	delete from GXDBVersions where aliasname = 'sec_updateDM2CapabilitesAndAssociations'
GO
print '... Creating Procedure: sec_updateDM2CapabilitesAndAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_updateDM2CapabilitesAndAssociations
  @i_userId integer=0,
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
DECLARE @entityType INT = 0
DECLARE @entityId INT = 0
DECLARE @userGUID VARCHAR(36) = ''
DECLARE @canManageEntityType INT = 0
DECLARE @userTable TABLE ( t_userId int,
						   t_capabilities bigint )
DECLARE @galaxyGroupTable TABLE ( t_groupId int,
								  t_capabilities bigint)
DECLARE @externalGroupTable TABLE ( t_groupId int,
									t_providerId int,
									t_capabilities bigint )
DECLARE @o_errorCode INT = 0
DECLARE @o_errorString	NVARCHAR(MAX)
SET @entityType = ISNULL(( SELECT ref.value('@entityType', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_UpdateShareCapabilitiesOperationReq') R ( ref ) ), 0)
SET @entityId = ISNULL(( SELECT ref.value('@entityId', 'INT')
						FROM @i_xmlText.nodes('DM2ContentIndexing_UpdateShareCapabilitiesOperationReq') R ( ref ) ), 0)
SET	@userGUID = ISNULL (( SELECT ref.value('@userGuid', 'VARCHAR(36)')
					FROM  @i_xmlText.nodes ('DM2ContentIndexing_UpdateShareCapabilitiesOperationReq') R(ref)), '')
-- Get the user id from the guid
IF ( @userGUID IS NOT null  AND @userGUID <> '' )
BEGIN
	SET @i_userId = ( SELECT id FROM UMUsers WHERE userGuid = @userGUID )
END
IF ( @i_userId = 0 OR @i_userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User Id not found for GUID ' + @userGUID
-- this is error, need userid
	GOTO EXIT_ERROR
END
-- check for capabilities
-- if user is the admin, then he can share the entity with anyone
-- we don't have to check for owner or admin explicitly as it will be handled with below stored procedure.
EXEC	[dbo].[sec_canManageDM2EntityType]
		@i_commcellId = 0,
		@i_userId = @i_userId,
		@i_entityType = @entityType,
		@i_entityId = 0,
		@o_canManageEntityType = @canManageEntityType OUTPUT
IF ( @canManageEntityType = 0 )
BEGIN
-- user is not the owner
		SET @o_errorCode = -1
		SET	@o_errorString = 'User needs to be owner/admin to perform this operation'
		GOTO EXIT_ERROR
END
-- get the users and user groups
INSERT INTO @userTable
SELECT ref.value('@userId','INT'), ref.value('@capabilities','BIGINT') | CAST(POWER(2.0, 31 - 1) AS bigint)
FROM @i_xmlText.nodes('DM2ContentIndexing_UpdateShareCapabilitiesOperationReq/shareUserAndGroupCapabilityList/userDetailsAndCapabilities') R( ref )
INSERT INTO @galaxyGroupTable
SELECT ref.value('@groupId','INT'), ref.value('@capabilities','BIGINT') | CAST(POWER(2.0, 31 - 1) AS bigint)
FROM @i_xmlText.nodes('DM2ContentIndexing_UpdateShareCapabilitiesOperationReq/shareUserAndGroupCapabilityList/userGroupDetailsAndCapabilities') R( ref )
INSERT INTO @externalGroupTable
SELECT ref.value('@groupId','INT'), ref.value('@providerId','INT'), ref.value('@capabilities','BIGINT') | CAST(POWER(2.0, 31 - 1) AS bigint)
FROM @i_xmlText.nodes('DM2ContentIndexing_UpdateShareCapabilitiesOperationReq/shareUserAndGroupCapabilityList/externalGroupDetailsAndCapabilities') R( ref )
BEGIN TRAN
-- delete all the existing users and user groups
BEGIN
	DECLARE @newProtocolXML XML
	SET @newProtocolXML= (SELECT 1 as '@associationsOperationType',
							--users
							(SELECT (SELECT  t_userId as '@userId'
									 FOR XML PATH ('userOrGroup'),TYPE),
									 (SELECT(SELECT DISTINCT  permissionId  as '@permissionId',
											 categoryId AS '@categoryId',
'@_type_'= CASE WHEN permissionId<>0  THEN   122
ELSE 121
															END
											FROM   @userTable perm CROSS APPLY dbo.sec_getCapabilityBitMaskToPermissionMap(t_capabilities,0)
											WHERE perm.t_userId=Users.t_userId
											FOR XML PATH ('permissions') ,TYPE)
											FOR XML PATH('properties'),TYPE)
									 FROM  @userTable Users
							 FOR XML PATH ('associations'),TYPE),
							 --galaxy groups
							 (SELECT (SELECT  t_groupId as '@userGroupId'
									 FOR XML PATH ('userOrGroup'),TYPE),
									 (SELECT(SELECT DISTINCT  permissionId  as '@permissionId',
											 categoryId AS '@categoryId',
'@_type_'= CASE WHEN permissionId<>0  THEN   122
ELSE 121
															END
											FROM   @galaxyGroupTable perm CROSS APPLY dbo.sec_getCapabilityBitMaskToPermissionMap(t_capabilities,0)
											WHERE galaxyGroup.t_groupId=perm.t_groupId
											FOR XML PATH ('permissions') ,TYPE)
											FOR XML PATH('properties'),TYPE)
									 FROM  @galaxyGroupTable galaxyGroup
							 FOR XML PATH ('associations'),TYPE),
							 --external groups
							 (SELECT (SELECT  t_groupId as '@groupId',
											  t_providerId as '@providerId'
									 FOR XML PATH ('userOrGroup'),TYPE),
									 (SELECT(SELECT DISTINCT  permissionId  as '@permissionId',
											 categoryId AS '@categoryId',
'@_type_'= CASE WHEN permissionId<>0  THEN   122
ELSE 121
															END
											FROM   @externalGroupTable perm CROSS APPLY dbo.sec_getCapabilityBitMaskToPermissionMap(t_capabilities,0)
											WHERE externalGroup.t_groupId=perm.t_groupId and externalGroup.t_providerId=perm.t_providerId
											FOR XML PATH ('permissions') ,TYPE)
											FOR XML PATH('properties'),TYPE)
									 FROM  @externalGroupTable externalGroup
							 FOR XML PATH ('associations'),TYPE)
					 FOR XML PATH  ('App_SecurityAssociationForEntityList'))
	--All security checks are done. Call this with admin userId to by pass security checks.
DECLARE @adminId INT = (SELECT TOP(1) id FROM UMUSERS WHERE ((UMUsers.flags & 0x040) <> 0) AND UMUsers.Name <> 'ROMS')
	DECLARE @errorTable TABLE(errorCode INT, errorString NVARCHAR(MAX))
	DECLARE @CvEntitiesType INTEGER=dbo.sec_ObjectTypeToEntitytype(@entityType)
	INSERT INTO @errorTable
		EXEC sec_setSecurityAssociationsFromEntity @newProtocolXML,@adminId,1,0,@CvEntitiesType,@entityId,0,0,0,0,0,0,0,0
    SET @o_errorCode = (SELECT TOP 1 errorcode FROM @errorTable)
    SET @o_errorString = (SELECT TOP 1 errorString FROM @errorTable )
	if(@o_errorCode=0)
	BEGIN
		--security associations is saved. update authorId
		UPDATE UMSecurityAssociations
		set authorId=@i_userId
		WHERE entityType1=dbo.sec_ObjectTypeToEntitytype(@entityType) and entityId1=@entityId
	END
END
IF(@o_errorCode<>0)
BEGIN
	ROLLBACK TRAN
	GOTO EXIT_ERROR
END
COMMIT TRAN
EXIT_ERROR:
	SELECT	@o_errorCode			as 'errList/@errorCode',
			@o_errorString			as 'errList/@errLogMessage'
	FOR XML PATH(''), ROOT('DM2ContentIndexing_GenericResp')
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_updateDM2CapabilitesAndAssociations')
	delete from GxQscripts where name = 'sec_updateDM2CapabilitesAndAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_updateDM2CapabilitesAndAssociations')
	delete from GXDBVersions where aliasname = 'sec_updateDM2CapabilitesAndAssociations'
GO

insert into GXDBVersions values(2, 'sec_updateDM2CapabilitesAndAssociations',  '00010011003200060000', 'sec_updateDM2CapabilitesAndAssociations', '00010011003200060000')
GO

