

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_tryUnlockUserAccounts.sp] ---------- 

-- ---------------------------------------------------------------------------------------------------------
--
--  Procedure   : sec_tryUnlockUserAccounts.sp
--  Author      : Pranshu Pranjal
--
--  Description : Unlock user accounts after checking if the caller has the appropriate permission for it
--  Input XML example:
--			<Api_UnlockAccountsReq>
--			   <lockedAccounts>
--			      <user userName="test1" />
--			   </lockedAccounts>
--			   <lockedAccounts>
--			      <user userId="18" />
--			   </lockedAccounts>
--			   <lockedAccounts>
--			      <user userName="test3" userId="19" />
--			   </lockedAccounts>
--			   <processinginstructioninfo>
--					<user userId="1" />
--					<locale localeId="0" />
--				</processinginstructioninfo>
--			</Api_UnlockAccountsReq>
--
-- ---------------------------------------------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_tryUnlockUserAccounts.sp,v $ $Id: sec_tryUnlockUserAccounts.sp,v 1.1.2.1 2020/11/10 09:30:43 jswaminathan Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_tryUnlockUserAccounts')
BEGIN
	print '>>> Drop Stored Procedure: sec_tryUnlockUserAccounts <<<'
	drop procedure sec_tryUnlockUserAccounts
END
IF EXISTS (select * from GxQscripts where name='sec_tryUnlockUserAccounts')
	delete from GxQscripts where name = 'sec_tryUnlockUserAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_tryUnlockUserAccounts')
	delete from GXDBVersions where aliasname = 'sec_tryUnlockUserAccounts'
GO
print '... Creating Procedure: sec_tryUnlockUserAccounts'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_tryUnlockUserAccounts
  @xmlText XML OUTPUT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @accountLockedDuration INT = ISNULL((SELECT CAST(VALUE as int) from GXGlobalParam where name = 'AccountLockDuration' and ISNUMERIC(value) = 1), 0)
DECLARE @failedLoginAttemptLimit INT = ISNULL((SELECT CAST(VALUE as int) from GXGlobalParam where name = 'FailedLoginAttemptLimit' and ISNUMERIC(value) = 1),0)
DECLARE @currentTimeUnix INT = ISNULL(dbo.GetUnixTime(GetUTCdate()), 0)
DECLARE @outputXml XML
DECLARE @loggedInUserId INT = ISNULL (( SELECT ref.value('@userId', 'INT') FROM @xmlText.nodes ('/Api_UnlockAccountsReq/processinginstructioninfo/user') R(ref)), 0)
DECLARE @localeId INT = ISNULL (( SELECT ref.value('@localeId', 'INT') FROM @xmlText.nodes ('/Api_UnlockAccountsReq/processinginstructioninfo/locale') R(ref)), 0)
-- Store incoming request as table
IF OBJECT_ID('tempdb.dbo.#userUnlockReqList') IS NOT NULL
	DROP TABLE #userUnlockReqList
CREATE TABLE #userUnlockReqList
(
	userId INT,
	userName nvarchar(255),
	status nvarchar(255)
);
-- Permission Table
IF OBJECT_ID('tempdb.dbo.#UnlockPermissionTable') IS NOT NULL
	DROP TABLE #UnlockPermissionTable
CREATE TABLE #UnlockPermissionTable
(
	userId INT PRIMARY KEY
);
-- Currently locked accounts
IF OBJECT_ID('tempdb.dbo.#LockedAccountsCurrently') IS NOT NULL
	DROP TABLE #LockedAccountsCurrently
CREATE TABLE #LockedAccountsCurrently
(
	userId INT PRIMARY KEY
);
-- Convert XML to table
INSERT INTO #userUnlockReqList (userId, userName)
	SELECT ref.value('@userId', 'INT'), ref.value('@userName', 'NVARCHAR(255)')
	FROM @xmlText.nodes ('Api_UnlockAccountsReq/lockedAccounts/user') R(ref)
-- Fill userId if not present but UserName is present
UPDATE #userUnlockReqList
	SET userId = UMU.id
FROM #userUnlockReqList T1
	INNER JOIN UMUsers UMU
		ON T1.userName = UMU.login
WHERE T1.userId IS NULL
-- Fill permission table
EXEC sec_getUsersForThisUser '#UnlockPermissionTable', @loggedInUserId, 1, 0
---Get currently Locked Accounts
INSERT INTO #LockedAccountsCurrently
SELECT componentNameId FROM UMUsersProp UMP WHERE UMP.attrName = 'Failed login attempts' AND UMP.cs_attrName = CHECKSUM(N'Failed login attempts') AND UMP.attrVal > 0 AND UMP.attrVal >= @failedLoginAttemptLimit AND @currentTimeUnix - UMP.modified < @accountLockedDuration AND componentNameId IN (SELECT userId from #userUnlockReqList)
UPDATE #userUnlockReqList
SET status =
	CASE
		WHEN T1.userId = @loggedInUserId
THEN (4684 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --'Logged in user cannot unlock self'
		WHEN UMU.id IS NULL
THEN (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --'Unkown User'
		WHEN LAC.userId IS NULL
THEN (4682 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --'Account is not locked'
		WHEN UP.userId IS NULL
THEN (4681 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --'No permission'
	END
FROM #userUnlockReqList T1
	LEFT JOIN #UnlockPermissionTable UP
		ON T1.userId = UP.userId
	LEFT JOIN UMUsers UMU with(nolock)
		ON T1.userId = UMU.id
	LEFT JOIN #LockedAccountsCurrently LAC
		ON T1.userID = LAC.userId
-- Form the XML to contain accounts which need to be unlocked
DECLARE @unlock_req_xml XML
SET @unlock_req_xml = ( SELECT
							(SELECT userUnlockReq.userId AS '@userId', userUnlockReq.userName as '@userName' FOR XML PATH('user'), TYPE)
						FROM #userUnlockReqList userUnlockReq where status IS NULL
						FOR XML PATH('lockedAccounts'), ROOT('Api_UnlockAccountsReq'))
--Finally send to unlock
IF @unlock_req_xml IS NOT NULL
	BEGIN
		EXEC sec_UnlockUserAccounts @unlock_req_xml
	END
-- Find out which unlock failed
UPDATE #userUnlockReqList
SET status =
	CASE
		WHEN UUP.attrVal IS NOT NULL AND UUP.attrVal <> 0
THEN (4683 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --'Unlock Failed'
		ELSE
(4685 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --'Unlocked Succcessfully'
	END
FROM #userUnlockReqList T1
	LEFT JOIN UMUSERSPROP UUP with(nolock)
		ON T1.userID = UUP.componentNameId
WHERE
	T1.status IS NULL
AND	UUP.attrName ='Failed login attempts'
AND UUP.cs_attrName = CHECKSUM(N'Failed login attempts')
    AND ISNUMERIC(UUP.attrVal) = 1
--Send output
SET @outputXml = ( SELECT (SELECT message FROM EvLocaleMsgs WHERE messageId = userUnlockReq.status AND localeId = @localeId) AS '@status'
							, (SELECT userUnlockReq.userId AS '@userId', userUnlockReq.userName as '@userName' FOR XML PATH('user'), TYPE)
						FROM #userUnlockReqList userUnlockReq
						FOR XML PATH('lockedAccounts'), ROOT('Api_UnlockAccountsResp'))
PROC_EXIT:
IF @outputXml is NULL
    SET @outputXml = '<Api_UnlockAccountsResp />'
IF OBJECT_ID('tempdb.dbo.#userUnlockReqList') IS NOT NULL
     DROP TABLE #userUnlockReqList
IF OBJECT_ID('tempdb.dbo.#UnlockPermissionTable') IS NOT NULL
     DROP TABLE #UnlockPermissionTable
IF OBJECT_ID('tempdb.dbo.#LockedAccountsCurrently') IS NOT NULL
     DROP TABLE #LockedAccountsCurrently
SELECT @outputXml outputXml
SET @xmlText = @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'sec_tryUnlockUserAccounts')
	delete from GxQscripts where name = 'sec_tryUnlockUserAccounts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_tryUnlockUserAccounts')
	delete from GXDBVersions where aliasname = 'sec_tryUnlockUserAccounts'
GO

insert into GXDBVersions values(2, 'sec_tryUnlockUserAccounts',  '00010001000200010000', 'sec_tryUnlockUserAccounts', '00010001000200010000')
GO

