

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_transferUserOwnership.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++
--
--  Description: Transfers ownership of an user, user group or an entity to a new user, group.
--				 Will update UMSecurityAssociations with new user or user group Id. Updates Application tables like App_ClientGroup, TM_Task, etc.
--				 with new user Id (if new user) or new user group's hidden create as user Id (if new user group).
--				 Input: XMLIn
--							1. When transferring from old user or user group fill them in respective blobs. (oldUser/oldUserGroup)
--							2. When transferring to new user or new user group fill them in respective blobs. (newUser/newUserGroup)
--							3. When transferring from an user or user group,
--									a. If transferring all entities (owned by old user / group), set transferAllFromOldUser = 1
--											Eg.: All entities from oldUser to newUser
--											<transferInfo transferAllFromOldUser="1">
--												<oldUser userId="9" userName="oldUser"/>
--												<newUser userId="18" userName="newUser"/>
--											</transferInfo>
--											Eg.: All entities from oldUserGroup to newUserGroup
--											<transferInfo transferAllFromOldUser="1">
--												<oldUserGroup userGroupId="9" userGroupName="oldUserGroup"/>
--												<newUserGroup userGroupId="18" useGroupName="newUserGroup"/>
--											</transferInfo>
--									b. If transferring entities of particular entity type (owned by old user / group), fill them in entitiesToBeTranferred blob.
--											Eg.: All client groups from oldUser to newUserGroup (this is obsolete in old protocol.)
--											<transferInfo>
--												<oldUser userId="9" userName="oldUser"/>
--												<newUserGroup userGroupId="18" useGroupName="newUserGroup"/>
--												<entitiesToBeTranferred val="28"/>			<!-- CLIENT_GROUP_ENTITY -->
--											</transferInfo>
--							4. When transferring for a specific entity, should have entity Information filled in transferOwnershipEntity blob.
--									a. It will not care about oldOwner. It will set new owner user / group as the owner of this entity.
--									b. If this entity is supported in UMSecurityAssociations, will create an entry here if creator is missing.
--									Eg.: To transfer ownership of all client groups 4,5,6 to user group 1.
--									<transferInfo>
--										<transferOwnershipEntity entityType="28" entityId="4"/>
--										<transferOwnershipEntity entityType="28" entityId="5"/>
--										<transferOwnershipEntity entityType="28" entityId="6"/>
--										<newUserGroup userGroupId="1"/>
--									</transferInfo>
--						callerId (to do security checks)
--						locale, doReturn, errorCode, errorMessage
--						oldOwnerId : This can be filled in the XML or can be passed input param to SP. (This is old user)
--						oldOwnerGroupId : This can be filled in the XML or can be passed input param to SP. (This is old user group).
--
--				 CallerID should have (validated by another SP)
--						1. Edit user rights on new user (if new user)
--						2. Member of new user group (if new user group)
--				 CallerID should have
--						1. Change Security Settings on Commcell (or)
--						2. Change Security Settings on the entity (or)
--						3. Owner of the entity (In specific cases where security is not stored in UMSecurityAssociations table)
--				 Transfer of standalone schedules has some issues. We can deal with it later.
--  Author: jswaminathan, agoyal, saggarwal
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_transferUserOwnership')
BEGIN
	print '>>> Drop Stored Procedure: sec_transferUserOwnership <<<'
	drop procedure sec_transferUserOwnership
END
IF EXISTS (select * from GxQscripts where name='sec_transferUserOwnership')
	delete from GxQscripts where name = 'sec_transferUserOwnership'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_transferUserOwnership')
	delete from GXDBVersions where aliasname = 'sec_transferUserOwnership'
GO
print '... Creating Procedure: sec_transferUserOwnership'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_transferUserOwnership
  @xmlIn XML,   
  @callerId INT,
  @locale INT = 0,  
  @doReturn INT = 0,   
  @oldOwnerId INT = 0,						
  @oldOwnerGroupId INT = 0,
  @errorCode INT = 0 OUTPUT,   
  @errorMessage NVARCHAR(MAX) = '' OUTPUT
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorMessage NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- Variable explanations:
-- newUserId: The new user id to which owner is to be transferred.
-- newUserGroupId: The new user group id to which owner is to be transferred.
-- oldOwnerId: The old owner id from which owner is transferred.
--			   (If old owner is a group, then the SP will set the hidden creator id in this. But application layer should never pass any hidden user, etc.
--				They should invoke either with user or user group Id only).
-- oldOwnerGroupId: The old owner group ID from which owner is transferred.
-- userForUserGroupId: The hidden user Id of the new user group.
BEGIN TRY
DECLARE @newUserId INT = 0
DECLARE @newUserGroupId INT = 0
SET  @errorCode =0
SET @errorMessage  ='Success'
DECLARE @skipOwnerTransfer INT = ISNULL(@xmlIn.value('(//./@skipOwnerTransfer)[1]', 'INT'), 0)
IF @skipOwnerTransfer = 1				-- When user skips transfer from domain properties, or tomorrow may be from entity properties, then we can return right away.
BEGIN
	RETURN
END
IF @oldOwnerId = 0 AND @oldOwnerGroupID = 0
BEGIN
	IF @xmlIn.exist('//../oldUser/@userId') = 1
		SET @oldOwnerId = @xmlIn.value('(//../oldUser/@userId)[1]','int')
	IF @xmlIn.exist('//../oldUserGroup/@userGroupId') = 1
		SET @oldOwnerGroupId = @xmlIn.value('(//../oldUserGroup/@userGroupId)[1]','int')
END
IF (@oldOwnerId <> 0 AND @oldOwnerGroupId <> 0)
BEGIN
SET @errorCode=(3495 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage=(SELECT message FROM EvLocaleMsgs WHERE messageId = (3495 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	GOTO EXITPROC
END
IF @xmlIn.exist('//../newUser/@userId') = 1
BEGIN
	SET @newUserId = @xmlIn.value('(//../newUser/@userId)[1]','int')
END
IF @xmlIn.exist('//../newUserGroup/@userGroupId') = 1
BEGIN
	SET @newUserGroupId = @xmlIn.value('(//../newUserGroup/@userGroupId)[1]','int')
END
IF (@newUserId = 0 AND @newUserGroupId = 0)
BEGIN
	-- If newUserId and newUserGroupId is 0 then check if oldOwner/oldOwnerGroup is owner of any entity.
	-- If oldOwner is creator of any entity then throw error.
	-- If oldOwner is not creator of any entity then exit without error.
	DECLARE @isUserorGroupOwner INT = 1
	DECLARE @i_xmlText XML
	IF (@oldOwnerId <> 0)
	BEGIN
		SET @i_xmlText = (SELECT @oldOwnerId as '@userId' for XML PATH('user'), ROOT('App_OwnershipCheckReq'))
		EXEC sec_ownershipCheck @i_xmlText OUTPUT
		SET @isUserorGroupOwner = ISNULL(@i_xmlText.value('(/App_OwnershipCheckResp/ownershipCheck/@isOwner)[1]','int'), 1) -- If error then assume user is owner of some entities.
	END
	IF (@oldOwnerGroupId <> 0)
	BEGIN
		SET @i_xmlText = (SELECT @oldOwnerGroupId as '@userGroupId' for XML PATH('userGroup'), ROOT('App_OwnershipCheckReq'))
		EXEC sec_ownershipCheck @i_xmlText OUTPUT
		SET @isUserorGroupOwner = ISNULL(@i_xmlText.value('(/App_OwnershipCheckResp/ownershipCheck/@isOwner)[1]','int'), 1)
	END
	IF (@isUserorGroupOwner = 1)
	BEGIN
SET @errorCode=(2840 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage=(SELECT message FROM EvLocaleMsgs WHERE messageId = (2840 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	END
	-- If newUserId and newUserGroupId are zero then goto exit, no need to transfer ownership
	GOTO EXITPROC
END
IF (@newUserId <> 0 AND @newUserGroupId <> 0)
BEGIN
SET @errorCode=(3495 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage=(SELECT message FROM EvLocaleMsgs WHERE messageId = (3495 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	GOTO EXITPROC
END
-- Do not allow Users / User group of one company to transfer ownership to Users / User group of another company.
IF ((@oldOwnerGroupId <> 0) OR (@oldOwnerId <> 0))
BEGIN
	DECLARE @oldCompanyId INT = 0
	DECLARE @newCompanyId INT = 0
	DECLARE @oldEntityName NVARCHAR(MAX) = N''
	DECLARE @newEntityName NVARCHAR(MAX) = N''
	DECLARE @oldCompanyName NVARCHAR(MAX) = N''
	DECLARE @newCompanyName NVARCHAR(MAX) = N''
	DECLARE @parentCompanies TABLE		-- This contains parents of oldCompanyId.
	(
		companyId INT PRIMARY KEY
	)
	IF @oldOwnerGroupID > 0
	BEGIN
		SET @oldCompanyId = dbo.AppGetCompanyForUserOrUserGroup(@oldOwnerGroupID, 0)
		SELECT
			@oldEntityName = CASE WHEN P.id > 0 THEN P.domainname + '\' + G.name ELSE G.name END
		FROM UMGroups G (NOLOCK)
			LEFT JOIN UMDSProviders P (NOLOCK)
				ON G.umdsProviderID = P.id
		WHERE G.id = @oldOwnerGroupID
	END
	ELSE IF @oldOwnerId > 0
	BEGIN
		SET @oldCompanyId = dbo.AppGetCompanyForUserOrUserGroup(@oldOwnerId, 1)
		SELECT
			@oldEntityName = CASE WHEN name IS NOT NULL AND name <> '' THEN name ELSE login END
		FROM UMUsers (NOLOCK)
		WHERE id = @oldOwnerId
	END
	IF @newUserGroupId > 0
	BEGIN
		SET @newCompanyId = dbo.AppGetCompanyForUserOrUserGroup(@newUserGroupId, 0)
		SELECT
			@newEntityName = CASE WHEN P.id > 0 THEN P.domainname + '\' + G.name ELSE G.name END
		FROM UMGroups G (NOLOCK)
			LEFT JOIN UMDSProviders P (NOLOCK)
				ON G.umdsProviderID = P.id
		WHERE G.id = @newUserGroupId
	END
	ELSE IF @newUserId > 0
	BEGIN
		SET @newCompanyId = dbo.AppGetCompanyForUserOrUserGroup(@newUserId, 1)
		SELECT
			@newEntityName = CASE WHEN name IS NOT NULL AND name <> '' THEN name ELSE login END
		FROM UMUsers (NOLOCK)
		WHERE id = @newUserId
	END
	IF @oldCompanyId <> @newCompanyID
	BEGIN
		;WITH ParentCTECompanies(parentCompanyId) AS			-- you can transfer ownership either to the same company or one of its parents or to MSP.
		(
			SELECT
				ownerCompany AS parentCompanyId
			FROM UMDSProviders (NOLOCK)
			WHERE (id = @oldCompanyId) AND (ownerCompany <> 0)
			UNION ALL
			SELECT
				P.ownerCompany AS parentCompanyId
			FROM UMDSProviders P (NOLOCK)
				INNER JOIN ParentCTECompanies PCC
					ON P.id = PCC.parentCompanyId
			WHERE P.ownerCompany > 0
		)
		INSERT INTO @parentCompanies
			SELECT DISTINCT
				parentCompanyId
			FROM ParentCTECompanies
		INSERT INTO @parentCompanies
			VALUES (0)
		IF @oldCompanyId <> 0
			INSERT INTO @parentCompanies
				VALUES (@oldCompanyId)
		IF NOT EXISTS (SELECT 1 FROM @parentCompanies WHERE companyId = @newCompanyID)
		BEGIN
			SELECT
				@oldCompanyName = CASE WHEN domainName IS NOT NULL AND domainName <> '' THEN domainName ELSE hostName END
			FROM UMDSProviders (NOLOCK)
			WHERE id = @oldCompanyID
			SELECT
				@newCompanyName = CASE WHEN domainName IS NOT NULL AND domainName <> '' THEN domainName ELSE hostName END
			FROM UMDSProviders (NOLOCK)
			WHERE id = @newCompanyID
SET @errorCode = (4710 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errorMessage = (SELECT message FROM EvLocaleMsgs (NOLOCK) WHERE messageId = @errorCode AND localeid = @locale)
			SET @errorMessage = REPLACE (@errorMessage, '^1%s', @oldEntityName)
			SET @errorMessage = REPLACE (@errorMessage, '^2%s', @oldCompanyName)
			SET @errorMessage = REPLACE (@errorMessage, '^3%s', @newEntityName)
			SET @errorMessage = REPLACE (@errorMessage, '^4%s', @newCompanyName)
			-- Cannot transfer ownership from [Tenant Admin] of [CompanyABC] to [Tenant Admin] of [CompanyXYZ], as they belong to different companies.
			GOTO EXITPROC
		END
	END
END
-- Both old owner Id and old owner group ID would be 0 if it is transferred from an entity level.
IF (@oldOwnerGroupId <> 0)
BEGIN
	-- Schedule entity saves the hidden user Id in TM table not in UMSecurityAssociations. Same with DM2 entities.
	-- So when identifying the user group created entities, we need to fetch schedules and DM2 entities that are created by this user group too.
	-- FOr that we need to query TM and DM tables with hidden user Id of the old owner group.
	-- Do not call the stored procedure here!!! It creates a new hidden user Id for the group if it is not there.
	-- We do not want that here, we just want the existing user Id if one is there, if not just zero.
SET @oldOwnerId = ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp (NOLOCK) WHERE componentNameId = @OldOwnerGroupId AND attrName = N'Create As User'  AND modified = 0), 0)
END
EXEC sec_validateNewOwnerInfo @callerId, @newUserId, @newUserGroupId, @locale, @errorCode OUTPUT, @errorMessage OUTPUT
IF @errorCode <> 0
	GOTO EXITPROC
DECLARE @userForUserGroupId INT = 0
IF @newUserGroupId <> 0
BEGIN
	EXEC sec_getCreateAsUserId 0, 0, @userForUserGroupId OUTPUT, 0, 0, @newUserGroupId
END
DECLARE @auditTable table(entityTypeMsgId int,entityTypeName NVARCHAR(MAX),entityName NVARCHAR(MAX))
DECLARE @entityTypeTransfered  TABLE ( entityType INT)
IF OBJECT_ID('tempdb.dbo.#entityToBeTransfered') IS NOT NULL
    DROP TABLE #entityToBeTransfered
CREATE TABLE #entityToBeTransfered
(
    entityType1 INT,
    entityId1 INT,
    entityType2 INT,
    entityId2 INT,
    entityType3 INT,
    entityId3 INT,
    entityType4 INT,
    entityId4 INT,
    entityType5 INT,
    entityId5 INT,
    includeAll INT
)
DECLARE @transferAllFromOldUser INT = 0
IF @xmlIn.exist('//../@transferAllFromOldUser') = 1
	SET @transferAllFromOldUser = @xmlIn.value('(//../@transferAllFromOldUser)[1]','int')
IF @transferAllFromOldUser = 1
BEGIN
	INSERT INTO #entityToBeTransfered
	SELECT entityType1, entityId1,
			entityType2, entityId2,
			entityType3, entityId3,
			entityType4, entityId4,
			entityType5, entityId5,
			includeAll
	FROM UMSecurityAssociations
		WHERE userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
									ELSE @oldOwnerGroupId
									END
			AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
								ELSE 0
								END
			AND isCreator = 1
	-- These entities (DM2, Schedule) do not save owner Id in UMSecurityAssociations.
	-- They put it in their own tables. Older transfer protocol (SP10) used to update these tables too on user deletion.
	-- So adding these special cases in new protocol too. User group support is not yet added. It will be done on SP12.
	-- This is not to break backward compatibility, so bringing back same code from SP10 into SP11.
	UNION
	SELECT containerType, containerId,
		   0,0,0,0,0,0,0,0,0
	FROM DM2Container
	WHERE
		userId = @oldOwnerId
	UNION
SELECT 9505, id,
		   0,0,0,0,0,0,0,0,0
	FROM DM2CompliancePolicy
	WHERE
		owneruserId = @oldOwnerID
	UNION
SELECT 68, ST.subTaskId,
		   0,0,0,0,0,0,0,0,0
	FROM TM_SubTask ST
		 INNER JOIN TM_Task T
			ON ST.taskId = T.taskId
	WHERE
		ownerId = @oldOwnerId
		AND T.taskType <> 4								-- Only schedules. Schedule policy is already covered.
END
ELSE
BEGIN
	INSERT INTO #entityToBeTransfered
	SELECT ref.value('@entityType','int'),
		   ISNULL(ref.value('@entityId','int'), 0),
		   0, 0, 0, 0, 0, 0, 0, 0,
		   ISNULL(ref.value('(flags/@includeAll)[1]', 'INT'), 0)
	FROM @xmlIn.nodes('//../transferOwnershipEntity') R ( ref )
	INSERT INTO @entityTypeTransfered
		SELECT  ref.value('@val', 'int')
        FROM @xmlIn.nodes('//../entitiesToBeTranferred') R ( ref )
END
IF OBJECT_ID('tempdb.dbo.#sec_transferUserOwnership_GetEntity') IS NOT NULL
	DROP TABLE #sec_transferUserOwnership_GetEntity
CREATE  TABLE #sec_transferUserOwnership_GetEntity ( entityId INT)
IF OBJECT_ID('tempdb.dbo.#sec_entityToBeTransferred') IS NOT NULL
	DROP TABLE #sec_entityToBeTransferred
CREATE  TABLE #sec_entityToBeTransferred ( entityId INT)
--if both entity to be transfered and entity type is present, fail the request. Only one can be done in 1 request.
IF EXISTS(SELECT 1 FROM @entityTypeTransfered)  AND EXISTS(SELECT 1 FROM #entityToBeTransfered)
BEGIN
SET @errorCode=(2841 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage=(SELECT message FROM EvLocaleMsgs WHERE messageId = (2841 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	GOTO EXITPROC
END
-- Lets do a check for 'Change Security Settings' permission on commcell to avoid multiple calls for security check if user has this permission on commcell
-- Also set errorCode and errorMessage to use later if required.
DECLARE @hasChangeSecurityPermissionOnCommcell INT = 0
DECLARE @errorCodeForChangeSecurityPermissionOnCommcell INT = 0
DECLARE @errorMessageForChangeSecurityPermissionOnCommcell NVARCHAR(MAX) = ''
exec sec_checkPermissionOnEntity @callerId, 107, @hasChangeSecurityPermissionOnCommcell OUTPUT, 1, 2
IF(@hasChangeSecurityPermissionOnCommcell = 0)
BEGIN
SET @errorCodeForChangeSecurityPermissionOnCommcell = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessageForChangeSecurityPermissionOnCommcell = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2408 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
	SET @errorMessageForChangeSecurityPermissionOnCommcell = REPLACE(@errorMessageForChangeSecurityPermissionOnCommcell, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessageForChangeSecurityPermissionOnCommcell = REPLACE(@errorMessageForChangeSecurityPermissionOnCommcell, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2406 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
SET @errorMessageForChangeSecurityPermissionOnCommcell = REPLACE(@errorMessageForChangeSecurityPermissionOnCommcell, '^3%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (468 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
END
--CHECK FOR EACH ENTITY TYPE, GET OWNER ENTITIES, DO SECURITY CHECK ON EACH entity AND SET ASSOCIATIONS
IF EXISTS (SELECT 1 FROM #entityToBeTransfered)
BEGIN
	DECLARE @tempEntityType  INT
	DECLARE @entityNameString NVARCHAR(MAX) = ''
	DECLARE @SQLString NVARCHAR(MAX)
	DECLARE @tableName  NVARCHAR(512)
	DECLARE @idColName  NVARCHAR(512)
	DECLARE @entityNameColName  NVARCHAR(512)
	DECLARE @entityTypeName NVARCHAR(512)
	DECLARE @entityTypeNameMessageId INT
	DECLARE @whereClause NVARCHAR(MAX) = ''
	DECLARE @skipSecurityCheck INT = 0
	DECLARE entityCursor CURSOR STATIC FOR
		SELECT DISTINCT dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityTYpe4, entityType5)
		FROM #entityToBeTransfered
	OPEN entityCursor
	FETCH NEXT FROM entityCursor INTO @tempEntityType
	WHILE @@FETCH_STATUS=0
	BEGIN
			SET @skipSecurityCheck = 0
IF (@tempentitytype NOT IN (3, 4, 5, 6, 7))
			BEGIN
				IF EXISTS (SELECT 1 FROM #entityToBeTransfered WHERE entityType1 = @tempEntityType AND includeAll = 1)
				BEGIN
					DELETE FROM #entityToBeTransfered WHERE entityType1 = @tempEntityType
IF @tempEntityType = 68 -- Include only independent schedules. Do not include schedules which are part of schedule policy
					BEGIN
						INSERT INTO #entityToBeTransfered
							SELECT @tempEntityType, subTask.subTaskId, 0, 0, 0, 0, 0, 0, 0, 0, 0
								FROM TM_Task task INNER JOIN TM_SubTask subTask
									ON task.taskId = subTask.taskId
									WHERE task.taskType <> 4
					END
					ELSE
					BEGIN
						SELECT @tableName = tableName, @idColName = idColName, @whereClause = whereClause FROM APP_Entity WHERE entityType = @tempEntityType
						IF @whereClause <> ''
							SET @SQLString = N'SELECT @entityType, ' + @idColName + ', 0, 0, 0, 0, 0, 0, 0, 0, 0 FROM ' + @tableName + ' WHERE ' + @whereClause
						ELSE
							SET @SQLString = N'SELECT @entityType, ' + @idColName + ', 0, 0, 0, 0, 0, 0, 0, 0, 0 FROM ' + @tableName
						INSERT INTO #entityToBeTransfered
							EXECUTE sp_executesql  @SQLString, N'@entityType INT', @entityType = @tempEntityType
					END
				END
				--throw error if any schedule is a part of schedule policy as changing owner of that schedule will affect the schedule policy and other schedules in that schedule policy
IF @tempEntityType = 68 AND EXISTS (SELECT 1 FROM TM_Task task INNER JOIN TM_SubTask subTask
																				ON task.taskId = subTask.taskId
																				INNER JOIN #entityToBeTransfered entities
																				ON entities.entityType1 = @tempEntityType
																					AND entities.includeAll = 0
																					AND subTask.subTaskId = entities.entityId1
																					WHERE task.taskType = 4)
				BEGIN
SET @errorCode = (3199 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3199 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
					CLOSE entityCursor
					DEALLOCATE entityCursor
					GOTO EXITPROC
				END
				-- If caller has 'Change Security Settings' permission on commcell we do not have to do explicit check on entities for 'Change Security Settings' permission.
				IF @hasChangeSecurityPermissionOnCommcell = 0
				BEGIN
					-- We dont want security check for sharedEnity since we dont enter ownerId into umsecurityassociation table
					-- For other entities below we will not do security check if caller is owner of the entity(s) whose ownership is to be transferred
IF (@tempEntityType = 9674)
					BEGIN
						SET @skipSecurityCheck = 1
					END
ELSE IF (@tempEntityType = 68 AND
								NOT EXISTS (SELECT 1
												FROM TM_Task task INNER JOIN TM_SubTask subTask
													ON task.taskId = subTask.taskId
													INNER JOIN #entityToBeTransfered entities
													ON entities.entityType1 = @tempEntityType
														AND subTask.subTaskId = entities.entityId1
														WHERE task.ownerId <> @callerId)
							)
					BEGIN
						SET @skipSecurityCheck = 1
					END
ELSE IF (@tempEntityType = 9501 AND
								NOT EXISTS (SELECT 1
												FROM DM2Container RS INNER JOIN #entityToBeTransfered entities
													ON entities.entityType1 = @tempEntityType
AND RS.containerType = 9501
														AND RS.containerId = entities.entityId1
														WHERE RS.userId <> @callerId)
							)
					BEGIN
						SET @skipSecurityCheck = 1
					END
ELSE IF (@tempEntityType = 9502 AND
								NOT EXISTS (SELECT 1
												FROM DM2Container QS INNER JOIN #entityToBeTransfered entities
													ON entities.entityType1 = @tempEntityType
AND QS.containerType = 9502
														AND QS.containerId = entities.entityId1
														WHERE QS.userId <> @callerId)
							)
					BEGIN
						SET @skipSecurityCheck = 1
					END
ELSE IF (@tempEntityType = 9503 AND
								NOT EXISTS (SELECT 1
												FROM DM2Container DS INNER JOIN #entityToBeTransfered entities
													ON entities.entityType1 = @tempEntityType
AND DS.containerType = 9503
														AND DS.containerId = entities.entityId1
														WHERE DS.userId <> @callerId)
							)
					BEGIN
						SET @skipSecurityCheck = 1
					END
ELSE IF (@tempEntityType = 9504 AND
								NOT EXISTS (SELECT 1
												FROM DM2Container TS INNER JOIN #entityToBeTransfered entities
													ON entities.entityType1 = @tempEntityType
AND TS.containerType = 9504
														AND TS.containerId = entities.entityId1
														WHERE TS.userId <> @callerId)
							)
					BEGIN
						SET @skipSecurityCheck = 1
					END
ELSE IF (@tempEntityType = 9505 AND
								NOT EXISTS (SELECT 1
												FROM DM2CompliancePolicy LH INNER JOIN #entityToBeTransfered entities
													ON entities.entityType1 = @tempEntityType
														AND LH.id = entities.entityId1
														WHERE LH.ownerUserId <> @callerId)
							)
					BEGIN
						SET @skipSecurityCheck = 1
					END
					TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
					IF @skipSecurityCheck = 0
					BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, @tempEntityType, 107, '#sec_transferUserOwnership_GetEntity'
						IF EXISTS (SELECT 1 FROM #entityToBeTransfered E LEFT OUTER JOIN #sec_transferUserOwnership_GetEntity sec
											ON E.entityId1 = sec.entityId
										WHERE E.entityType1 = @tempEntityType AND sec.entityId IS NULL)
						BEGIN
IF @tempEntityType = 68
OR @tempEntityType = 9501 OR @tempEntityType = 9502 OR @tempEntityType = 9503 OR @tempEntityType = 9504
OR @tempEntityType = 9505
							BEGIN
								SET @errorCode = @errorCodeForChangeSecurityPermissionOnCommcell
								SET @errorMessage = @errorMessageForChangeSecurityPermissionOnCommcell
								CLOSE entityCursor
								DEALLOCATE entityCursor
								GOTO EXITPROC
							END
							IF OBJECT_ID('tempdb.dbo.#sec_DoNotHaveRightsEntity') IS NOT NULL
								DROP TABLE #sec_DoNotHaveRightsEntity
							CREATE  TABLE #sec_DoNotHaveRightsEntity ( entityId INT )
							INSERT INTO #sec_DoNotHaveRightsEntity
							SELECT E.entityId1 FROM #entityToBeTransfered E LEFT OUTER JOIN #sec_transferUserOwnership_GetEntity sec
											ON E.entityId1 = sec.entityId
										WHERE E.entityType1 = @tempEntityType AND sec.entityId IS NULL
							SET @entityNameString = ''
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
							SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2406 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
							SELECT @tableName = tableName, @idColName = idColName, @entityNameColName = entityNameColName, @entityTypeNameMessageId = entityTypeNameMessageId FROM APP_Entity WHERE entityType = @tempEntityType
							IF(@entityNameColName <> '')
							BEGIN
								SET @SQLString = N'SET @entity_NameString = (STUFF((SELECT '', ''' + '+' + @entityNameColName + ' FROM ' + @tableName + ' WHERE ' + @idColName + ' IN (SELECT entityId FROM #sec_DoNotHaveRightsEntity ) FOR XML PATH('''')),1,2,''''))'
								EXECUTE sp_executesql  @SQLString, N'@entity_NameString NVARCHAR(MAX) OUTPUT', @entity_NameString = @entityNameString OUTPUT
								SET @errorMessage = REPLACE(@errorMessage, '^3%s', @entityNameString)
							END
							SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = @entityTypeNameMessageId and localeid = @locale))
							DROP TABLE #sec_DoNotHaveRightsEntity
							CLOSE entityCursor
							DEALLOCATE entityCursor
							GOTO EXITPROC
						END
					END
				END
				UPDATE Tbl
					SET userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
						isUser = CASE WHEN @newUserId <> 0 THEN 1
										ELSE 0
										END
					FROM UMSecurityAssociations Tbl JOIN #entityToBeTransfered E
					ON Tbl.entityType1 = E.entityType1
						AND Tbl.entityId1 = E.entityId1
						AND Tbl.entityType2 = 0
						AND Tbl.isCreator = 1
						AND E.entityType1 = @tempEntityType
				-- Currently for some entities in this ownership transfer protocol we dont enter owner information in UMSecurityAssociations table.
				-- And this insert statement won't make an entry in UMSecurityAssociations until we add creator permissions info in 'sec_getPermissionForEntityTypeCreator' function for those entities.
				INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
				SELECT DISTINCT P.roleId, P.permissionId,
								CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @newUserGroupId
										END,
								CASE WHEN @newUserId <> 0 THEN 1
										ELSE 0
										END,
								E.entityType1, E.entityId1, 1, @callerId
				FROM UMSecurityAssociations Tbl RIGHT OUTER JOIN #entityToBeTransfered E
				ON Tbl.entityType1 = E.entityType1
					AND Tbl.entityId1 = E.entityId1
					AND Tbl.entityType2 = 0
					AND Tbl.isCreator = 1
				CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(@tempEntityType) as P
				WHERE E.entityType1 = @tempEntityType AND Tbl.entityType1 IS NULL
				SET @entityNameString=''
				SELECT @tableName = tableName, @idColName = idColName, @entityNameColName = entityNameColName, @entityTypeNameMessageId = entityTypeNameMessageId FROM APP_Entity WHERE entityType = @tempEntityType
				IF(@entityNameColName <> '')
				BEGIN
					INSERT INTO #sec_entityToBeTransferred
					SELECT entityId1 FROM #entityToBeTransfered WHERE entityType1 = @tempEntityType
					SET @SQLString = N'SET @entity_NameString = (STUFF((SELECT '', ''' + '+' + @entityNameColName + ' FROM ' + @tableName + ' WHERE ' + @idColName + ' IN (SELECT entityId FROM #sec_entityToBeTransferred ) FOR XML PATH('''')),1,2,''''))'
					EXECUTE sp_executesql  @SQLString, N'@entity_NameString NVARCHAR(MAX) OUTPUT', @entity_NameString = @entityNameString OUTPUT
					INSERT into @auditTable(entityName,entityTypeMsgId) values(@entityNameString,@entityTypeNameMessageId)
					TRUNCATE TABLE #sec_entityToBeTransferred
				END
				--Write Application layer specific code
IF (@tempEntityType = 35)
				BEGIN
					UPDATE tbl1
					SET tbl1.ownerId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END,
						tbl1.runUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM TM_Task as tbl1 INNER JOIN #entityToBeTransfered as tbl2
					ON tbl2.entityType1 = @tempEntityType
						AND tbl1.taskId = tbl2.entityId1
				END
ELSE IF (@tempEntityType = 68)
				BEGIN
					UPDATE task
					SET task.ownerId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END,
						task.runUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM TM_Task as task INNER JOIN TM_SubTask as subTask
					ON task.taskId = subTask.taskId
					INNER JOIN #entityToBeTransfered as E
					ON E.entityType1 = @tempEntityType
						AND subTask.subTaskId = E.entityId1
				END
ELSE IF (@tempEntityType = 28)
				BEGIN
					UPDATE tbl1
					SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM APP_ClientGroup as tbl1 INNER JOIN #entityToBeTransfered as tbl2
					ON tbl2.entityType1 = @tempEntityType
						AND tbl1.id = tbl2.entityId1
				END
ELSE IF (@tempEntityType = 83)
				BEGIN
					UPDATE tbl1
					SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM WF_Definition as tbl1 INNER JOIN #entityToBeTransfered as tbl2
					ON tbl2.entityType1 = @tempEntityType
						AND tbl1.WorkflowId = tbl2.entityId1
				END
ELSE IF (@tempEntityType = 90)
				BEGIN
					UPDATE tbl1
					SET tbl1.attrVal = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM APP_MonitoringPolicyProp as tbl1 INNER JOIN #entityToBeTransfered as tbl2
					ON tbl2.entityType1 = @tempEntityType
						AND tbl1.monitorPolicyId = tbl2.entityId1
						WHERE tbl1.attrName = 'Creater User Id'
				END
ELSE IF (@tempEntityType = 64)
				BEGIN
					UPDATE tbl1
					SET tbl1.notifOwner = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM NTnotificationRule as tbl1 INNER JOIN #entityToBeTransfered as tbl2
					ON tbl2.entityType1 = @tempEntityType
						AND tbl1.id = tbl2.entityId1
				END
ELSE IF (@tempEntityType = 9674)
				BEGIN
					UPDATE lmSearchTbl
					SET lmSearchTbl.creatorUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
														ELSE @userForUserGroupId
														END
					FROM App_SharedEntityInfo as shareTbl INNER JOIN #entityToBeTransfered as tbl2
					ON tbl2.entityType1 = @tempEntityType AND shareTbl.SharedEntityId = tbl2.entityId1
					INNER JOIN LMUserSearch lmSearchTbl
					ON shareTbl.OriginalEntityId = lmSearchTbl.searchId
WHERE shareTbl.SharedEntityType = 134
					UPDATE lmDashTbl
					SET lmDashTbl.creatorUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
														ELSE @userForUserGroupId
														END
					FROM App_SharedEntityInfo as shareTbl INNER JOIN #entityToBeTransfered as tbl2
					ON tbl2.entityType1 = @tempEntityType AND shareTbl.SharedEntityId = tbl2.entityId1
					INNER JOIN LMDashBoard lmDashTbl
					ON shareTbl.OriginalEntityId = lmDashTbl.dashBoardId
WHERE shareTbl.SharedEntityType = 137
				END
				----------------------------------------------------------------------------------------------------------------------------------
				-- For Review Set, Query Set, Download Set and Tag Set also updating containerName by appending it with old owner's login name.
				-- Doing this on behalf of DM2 team as suggested by Karthikeyan Shanmuga Sundaram. Please refer to him for any queries with this.
				----------------------------------------------------------------------------------------------------------------------------------
ELSE IF (@tempEntityType = 9501)
				BEGIN
					UPDATE RS
					SET RS.containerName = RS.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = RS.userId
																								AND RS.userId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																														ELSE @userForUserGroupId
																														END) + ')'), '')
					FROM DM2Container RS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND RS.containerType = 9501
							AND RS.containerId = entities.entityId1
					UPDATE RS
					SET RS.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM DM2Container RS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND RS.containerType = 9501
							AND RS.containerId = entities.entityId1
				END
ELSE IF (@tempEntityType = 9502)
				BEGIN
					UPDATE QS
					SET QS.containerName = QS.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = QS.userId
																								AND QS.userId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																														ELSE @userForUserGroupId
																														END) + ')'), '')
					FROM DM2Container QS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND QS.containerType = 9502
							AND QS.containerId = entities.entityId1
					UPDATE QS
					SET QS.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM DM2Container QS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND QS.containerType = 9502
							AND QS.containerId = entities.entityId1
				END
ELSE IF (@tempEntityType = 9503)
				BEGIN
					UPDATE DS
					SET DS.containerName = DS.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = DS.userId
																								AND DS.userId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																														ELSE @userForUserGroupId
																														END) + ')'), '')
					FROM DM2Container DS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND DS.containerType = 9503
							AND DS.containerId = entities.entityId1
					UPDATE DS
					SET DS.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM DM2Container DS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND DS.containerType = 9503
							AND DS.containerId = entities.entityId1
				END
ELSE IF (@tempEntityType = 9504)
				BEGIN
					UPDATE TS
					SET TS.containerName = TS.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = TS.userId
																								AND TS.userId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																														ELSE @userForUserGroupId
																														END) + ')'), '')
					FROM DM2Container TS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND TS.containerType = 9504
							AND TS.containerId = entities.entityId1
					UPDATE TS
					SET TS.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM DM2Container TS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
AND TS.containerType = 9504
							AND TS.containerId = entities.entityId1
				END
ELSE IF (@tempEntityType = 9505)
				BEGIN
					UPDATE LH
					SET LH.ownerUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM DM2CompliancePolicy LH INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
							AND LH.id = entities.entityId1
				END
ELSE IF (@tempEntityType = 132)
				BEGIN
					UPDATE DS
					SET DS.OwnerUserID = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM SEDataSource DS INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
							AND DS.DataSourceId = entities.entityId1
				END
ELSE IF (@tempEntityType = 133)
				BEGIN
					UPDATE SV
					SET SV.OwnerUserID = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM SESearchView SV INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
							AND SV.status = 0
							AND SV.SearchViewId = entities.entityId1
				END
ELSE IF (@tempEntityType = 157)
				BEGIN
					UPDATE SH
					SET SH.OwnerUserID = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM SESearchView SH INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
							AND SH.status = 1
							AND SH.SearchViewId = entities.entityId1
				END
ELSE IF (@tempEntityType = 131)
				BEGIN
					UPDATE RE
					SET RE.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM APP_Reports RE INNER JOIN #entityToBeTransfered entities
						ON entities.entityType1 = @tempEntityType
							AND RE.reportId = entities.entityId1
				END
			END
			ELSE
			BEGIN
				-- If caller has 'Change Security Settings' permission on commcell we do not have to do explicit check on entities for 'Change Security Settings' permission.
				IF @hasChangeSecurityPermissionOnCommcell = 0
				BEGIN
					IF @skipSecurityCheck = 0
					BEGIN
						IF OBJECT_ID('tempdb.dbo.#sec_transferUserOwnership_GetIdaEntity') IS NOT NULL
							DROP TABLE #sec_transferUserOwnership_GetIdaEntity
						CREATE TABLE #sec_transferUserOwnership_GetIdaEntity (clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT)
EXEC sec_getIdaObjectsForUser @callerId, @tempentitytype, 107, 0, '#sec_transferUserOwnership_GetIdaEntity'
						IF EXISTS (SELECT 1 FROM #entityToBeTransfered E LEFT OUTER JOIN #sec_transferUserOwnership_GetIdaEntity sec
ON (E.entityType1 = 3 AND E.entityId1 = sec.clientId)
AND (@tempEntityType < 4 OR (E.entityType2 = 4 AND E.entityId2 = sec.appTypeId))
AND (@tempEntityType < 5 OR (E.entityType3 = 5 AND E.entityId3 = sec.instanceId))
AND (@tempEntityType < 6 OR (E.entityType4 = 6 AND E.entityId4 = sec.backupsetid))
AND (@tempEntityType < 7 OR (E.entityType5 = 7 AND E.entityId5 = sec.subclientId))
										WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype AND sec.clientId IS NULL)
						BEGIN
							IF OBJECT_ID('tempdb.dbo.#sec_DoNotHaveRightsIdaEntity') IS NOT NULL
								DROP TABLE #sec_DoNotHaveRightsIdaEntity
							CREATE  TABLE #sec_DoNotHaveRightsIdaEntity ( clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT )
							INSERT INTO #sec_DoNotHaveRightsIdaEntity
							SELECT DISTINCT entityId1, entityId2, entityId3, entityId4, entityId5
								FROM #entityToBeTransfered E LEFT OUTER JOIN #sec_transferUserOwnership_GetIdaEntity sec
ON (E.entityType1 = 3 AND E.entityId1 = sec.clientId)
AND (@tempEntityType < 4 OR (E.entityType2 = 4 AND E.entityId2 = sec.appTypeId))
AND (@tempEntityType < 5 OR (E.entityType3 = 5 AND E.entityId3 = sec.instanceId))
AND (@tempEntityType < 6 OR (E.entityType4 = 6 AND E.entityId4 = sec.backupsetid))
AND (@tempEntityType < 7 OR (E.entityType5 = 7 AND E.entityId5 = sec.subclientId))
								WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype AND sec.clientId IS NULL
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
							SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2406 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
							SELECT @entityTypeNameMessageId = entityTypeNameMessageId FROM APP_Entity WHERE entityType = @tempEntityType
							SET @entityNameString = ''
IF @tempentitytype = 3
							BEGIN
								SET @entityNameString = STUFF((SELECT ', ' + client.name
																FROM #sec_DoNotHaveRightsIdaEntity E
																	INNER JOIN APP_Client client
																		ON E.clientId = client.id
																FOR XML PATH('')), 1, 2, '')
							END
ELSE IF @tempentitytype = 4
							BEGIN
								SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName
																FROM #sec_DoNotHaveRightsIdaEntity E
																INNER JOIN APP_Client client
																	ON E.clientId = client.id
																INNER JOIN APP_IDAType ida
																	ON E.appTypeId = ida.type
																FOR XML PATH('')), 1, 2, '')
							END
ELSE IF @tempentitytype = 5
							BEGIN
								SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName + '>' + instance.name
																FROM #sec_DoNotHaveRightsIdaEntity E
																INNER JOIN APP_Client client
																	ON E.clientId = client.id
																INNER JOIN APP_IDAType ida
																	ON E.appTypeId = ida.type
																INNER JOIN APP_InstanceName instance
																	ON E.instanceId = instance.id
																FOR XML PATH('')), 1, 2, '')
							END
ELSE IF @tempentitytype = 6
							BEGIN
IF EXISTS (SELECT 1 FROM #sec_DoNotHaveRightsIdaEntity WHERE appTypeId = 1030)
								BEGIN
SELECT @entityTypeNameMessageId = entityTypeNameMessageId FROM APP_Entity WHERE entityType = 65
									SET @entityNameString = STUFF((SELECT ', ' + backupset.name
																	FROM #sec_DoNotHaveRightsIdaEntity E
																	INNER JOIN APP_BackupSetName backupset
																		ON E.backupsetId = backupset.id
AND E.apptypeId = 1030
																	FOR XML PATH('')), 1, 2, '')
								END
								ELSE
								BEGIN
									SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName + '>' + instance.name + '>' + backupset.name
																	FROM #sec_DoNotHaveRightsIdaEntity E
																	INNER JOIN APP_Client client
																		ON E.clientId = client.id
																	INNER JOIN APP_IDAType ida
																		ON E.appTypeId = ida.type
AND E.apptypeId <> 1030
																	INNER JOIN APP_InstanceName instance
																		ON E.instanceId = instance.id
																	INNER JOIN APP_BackupSetName backupset
																		ON E.backupsetId = backupset.id
																	FOR XML PATH('')), 1, 2, '')
								END
							END
ELSE IF @tempentitytype = 7
							BEGIN
								SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName + '>' + instance.name + '>' + backupset.name + '>' + subclient.subclientName
																FROM #sec_DoNotHaveRightsIdaEntity E
																INNER JOIN APP_Client client
																	ON E.clientId = client.id
																INNER JOIN APP_IDAType ida
																	ON E.appTypeId = ida.type
																INNER JOIN APP_InstanceName instance
																	ON E.instanceId = instance.id
																INNER JOIN APP_BackupSetName backupset
																	ON E.backupsetId = backupset.id
																INNER JOIN APP_Application subclient
																	ON E.subclientId = subclient.id
																FOR XML PATH('')), 1, 2, '')
							END
							SET @errorMessage = REPLACE(@errorMessage, '^3%s', @entityNameString)
							SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = @entityTypeNameMessageId and localeid = @locale))
							DROP TABLE #sec_DoNotHaveRightsIdaEntity
							CLOSE entityCursor
							DEALLOCATE entityCursor
							GOTO EXITPROC
						END
						DROP TABLE #sec_transferUserOwnership_GetIdaEntity
					END
				END
				UPDATE Tbl
					SET userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
						isUser = CASE WHEN @newUserId <> 0 THEN 1
										ELSE 0
										END
					FROM UMSecurityAssociations Tbl JOIN #entityToBeTransfered E
					ON Tbl.entityType1 = E.entityType1
						AND Tbl.entityId1 = E.entityId1
						AND Tbl.entityType2 = E.entityType2
						AND Tbl.entityId2 = E.entityId2
						AND Tbl.entityType3 = E.entityType3
						AND Tbl.entityId3 = E.entityId3
						AND Tbl.entityType4 = E.entityType4
						AND Tbl.entityId4 = E.entityId4
						AND Tbl.entityType5 = E.entityType5
						AND Tbl.entityId5 = E.entityId5
						AND Tbl.isCreator = 1
					WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
				-- Application layer code
IF (@tempentitytype = 6 AND EXISTS (SELECT 1 FROM #entityToBeTransfered WHERE entityId2 = 1030))  -- Subclient Policy
				BEGIN
					UPDATE ScpProp
					SET ScpProp.attrVal = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
					FROM APP_BackupsetProp as ScpProp INNER JOIN #entityToBeTransfered as E
						ON ScpProp.componentNameId = E.entityId4
AND E.entityId2 = 1030
						AND ScpProp.attrName = 'Subclient Policy Create UserId'
					WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
				END
				-- Audit info
				SELECT @entityTypeNameMessageId = entityTypeNameMessageId FROM APP_Entity WHERE entityType = @tempEntityType
				SET @entityNameString=''
IF @tempentitytype = 3
				BEGIN
					SET @entityNameString = STUFF((SELECT ', ' + client.name
													FROM #entityToBeTransfered E
														INNER JOIN APP_Client client
															ON E.entityId1 = client.id
													WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
													FOR XML PATH('')), 1, 2, '')
					INSERT INTO @auditTable(entityName,entityTypeMsgId) values(@entityNameString,@entityTypeNameMessageId)
				END
ELSE IF @tempentitytype = 4
				BEGIN
					SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName
													FROM #entityToBeTransfered E
													INNER JOIN APP_Client client
														ON E.entityId1 = client.id
													INNER JOIN APP_IDAType ida
														ON E.entityId2 = ida.type
													WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
													FOR XML PATH('')), 1, 2, '')
					INSERT INTO @auditTable(entityName,entityTypeMsgId) values(@entityNameString,@entityTypeNameMessageId)
				END
ELSE IF @tempentitytype = 5
				BEGIN
					SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName + '>' + instance.name
													FROM #entityToBeTransfered E
													INNER JOIN APP_Client client
														ON E.entityId1 = client.id
													INNER JOIN APP_IDAType ida
														ON E.entityId2 = ida.type
													INNER JOIN APP_InstanceName instance
														ON E.entityId3 = instance.id
													WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
													FOR XML PATH('')), 1, 2, '')
					INSERT INTO @auditTable(entityName,entityTypeMsgId) values(@entityNameString,@entityTypeNameMessageId)
				END
ELSE IF @tempentitytype = 6
				BEGIN
					SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName + '>' + instance.name + '>' + backupset.name
													FROM #entityToBeTransfered E
													INNER JOIN APP_Client client
														ON E.entityId1 = client.id
													INNER JOIN APP_IDAType ida
														ON E.entityId2 = ida.type
AND E.entityId2 <> 1030
													INNER JOIN APP_InstanceName instance
														ON E.entityId3 = instance.id
													INNER JOIN APP_BackupSetName backupset
														ON E.entityId4 = backupset.id
													WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
													FOR XML PATH('')), 1, 2, '')
					INSERT INTO @auditTable(entityName,entityTypeMsgId) values(@entityNameString,@entityTypeNameMessageId)
IF EXISTS (SELECT 1 FROM #entityToBeTransfered WHERE entityId2 = 1030)
					BEGIN
SELECT @entityTypeNameMessageId = entityTypeNameMessageId FROM APP_Entity WHERE entityType = 65
						SET @entityNameString = STUFF((SELECT ', ' + backupset.name
														FROM #entityToBeTransfered E
														INNER JOIN APP_BackupSetName backupset
															ON E.entityId4 = backupset.id
AND E.entityId2 = 1030
														WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
														FOR XML PATH('')), 1, 2, '')
						INSERT INTO @auditTable(entityName,entityTypeMsgId) values(@entityNameString,@entityTypeNameMessageId)
					END
				END
ELSE IF @tempentitytype = 7
				BEGIN
					SET @entityNameString = STUFF((SELECT ', ' + client.name + '>' + ida.displayName + '>' + instance.name + '>' + backupset.name + '>' + subclient.subclientName
													FROM #entityToBeTransfered E
													INNER JOIN APP_Client client
														ON E.entityId1 = client.id
													INNER JOIN APP_IDAType ida
														ON E.entityId2 = ida.type
													INNER JOIN APP_InstanceName instance
														ON E.entityId3 = instance.id
													INNER JOIN APP_BackupSetName backupset
														ON E.entityId4 = backupset.id
													INNER JOIN APP_Application subclient
														ON E.entityId5 = subclient.id
													WHERE dbo.getEntityLevelFromEntityHierarchy(E.entityType1, E.entityType2, E.entityType3, E.entityTYpe4, E.entityType5) = @tempentitytype
													FOR XML PATH('')), 1, 2, '')
					INSERT INTO @auditTable(entityName,entityTypeMsgId) values(@entityNameString,@entityTypeNameMessageId)
				END
			END
			FETCH NEXT FROM entityCursor INTO @tempEntityType
	END
	CLOSE entityCursor
	DEALLOCATE entityCursor
	TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
END
IF EXISTS(SELECT 1 FROM @entityTypeTransfered)
BEGIN
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=68)    --SCHEDULE POLICY and --Schedules.
	BEGIN
		IF EXISTS(SELECT 1 FROM TM_TASK WHERE ownerId=@oldOwnerId and taskType<>4) -- other schedules
		BEGIN
			IF(@hasChangeSecurityPermissionOnCommcell =0)
			BEGIN
				SET @errorCode = @errorCodeForChangeSecurityPermissionOnCommcell
				SET @errorMessage = @errorMessageForChangeSecurityPermissionOnCommcell
				GOTO EXITPROC
			END
		END
		DECLARE @schedulePolicyId TABLE (id INTEGER)
		INSERT INTO @schedulePolicyId
			SELECT taskId
			FROM TM_Task
			WHERE ownerId=@oldOwnerId and taskType=4 --Schedule policy
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 35
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS( SELECT 1 FROM @schedulePolicyId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 35, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @schedulePolicyId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + taskName
																				FROM TM_Task WHERE taskId IN (SELECT id FROM @schedulePolicyId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (1869 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.ownerId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END,
				tbl1.runUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM TM_Task as tbl1 INNER JOIN @schedulePolicyId as tbl2
			ON tbl1.taskId = tbl2.id
		--For other schedules if CAT_USER_MANAGMENT_ASSOC_ON_ENTITY on commcell, as we cant set security for independent schedules.
		--check if any owner is there.
		UPDATE TM_Task
			SET ownerId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END,
				runUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			WHERE ownerId = @oldOwnerId
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @schedulePolicyId as tbl2
ON tbl1.entityType1 = 35
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
35, tbl1.id, 1, @callerId
			FROM @schedulePolicyId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 35
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(35) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+taskName from TM_Task where taskId in (SELECT id FROM @schedulePolicyId) FOR XML PATH('')),1,2,''),(1869 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=28)    --client group
	BEGIN
		DECLARE @clientGroupId TABLE (id INTEGER)
		IF dbo.isNewSecurity() = 0
		BEGIN
			INSERT INTO @clientGroupId
SELECT objectId FROM UMUserandGroupEntityAssociation WHERE userId=@oldOwnerId and entityType= 2572 and ownerUserId=0
EXEC sec_getNonIdaObjectsForThisUser @callerId,28,107,'#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @clientGroupId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + name
																				FROM APP_ClientGroup WHERE id IN (SELECT id FROM @clientGroupId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (1013 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
			UPDATE UMUserandGroupEntityAssociation
			SET  userId=@newUserId
WHERE userId=@oldOwnerId and entityType= 2572 and ownerUserId=0
		END
		ELSE
		BEGIN
			--Is there a better way for this - not to query from UMSecurityAssociations
			INSERT INTO @clientGroupId
				SELECT id
				FROM APP_ClientGroup
				WHERE userId = @oldOwnerId
				UNION
				SELECT DISTINCT entityId1
				FROM UMSecurityAssociations
WHERE entityType1 = 28
					AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
												ELSE @oldOwnerGroupId
												END
					AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
										ELSE 0
										END
					AND isCreator = 1
			 IF EXISTS( SELECT 1 FROM @clientGroupId) AND @hasChangeSecurityPermissionOnCommcell = 0
			 BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId,28,107,'#sec_transferUserOwnership_GetEntity'
				IF EXISTS( SELECT * FROM @clientGroupId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
				BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
					SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
					SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + name
																					FROM APP_ClientGroup WHERE id IN (SELECT id FROM @clientGroupId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																					FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (1013 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
					GOTO EXITPROC
				END
			END
			UPDATE tbl1
				SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @userForUserGroupId
										END
				FROM APP_ClientGroup as tbl1 INNER JOIN @clientGroupId as tbl2
				ON tbl1.id = tbl2.id
			UPDATE tbl1
				SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
												ELSE @newUserGroupId
												END,
					tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
										ELSE 0
										END
				FROM UMSecurityAssociations as tbl1 INNER JOIN @clientGroupId as tbl2
ON tbl1.entityType1 = 28
					AND tbl1.entityId1 = tbl2.id
				WHERE tbl1.isCreator = 1
			INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
				SELECT DISTINCT P.roleId, P.permissionId,
								CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @newUserGroupId
										END,
								CASE WHEN @newUserId <> 0 THEN 1
										ELSE 0
										END,
28, tbl1.id, 1, @callerId
				FROM @clientGroupId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 28
					AND tbl1.id = tbl2.entityId1
					AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(28) as P
				WHERE tbl2.entityId1 IS NULL
		END
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+name from APP_ClientGroup where id in (SELECT id FROM @clientGroupId) for xml path('')),1,2,''), (1013 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=83)    --workflow
	BEGIN
		DECLARE @workflowId TABLE (id INTEGER)
		INSERT INTO @workflowId
			SELECT WorkflowId
			FROM WF_Definition
			WHERE userId = @oldOwnerId
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 83
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS( SELECT 1 FROM @workflowId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 83, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @workflowId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + Name
																				FROM WF_Definition WHERE WorkflowId IN (SELECT id FROM @workflowId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2376 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM WF_Definition as tbl1 INNER JOIN @workflowId as tbl2
			ON tbl1.WorkflowId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @workflowId as tbl2
ON tbl1.entityType1 = 83
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
83, tbl1.id, 1, @callerId
			FROM @workflowId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 83
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(83) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+Name from WF_Definition where WorkflowId in (SELECT id FROM @workflowId) FOR XML PATH ('')) ,1,2,'') ,(2376 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=90)    --monitoring policy
	BEGIN
		DECLARE @monitoringPolicyId TABLE (id INTEGER)
		INSERT INTO @monitoringPolicyId
			SELECT monitorPolicyId
			FROM APP_MonitoringPolicyProp
			WHERE attrName = 'Creater User Id' AND attrVal = @oldOwnerId
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 90
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS( SELECT 1 FROM @monitoringPolicyId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 90, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @monitoringPolicyId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + MonitorPolicyName
																				FROM APP_MonitoringPolicy WHERE monitorPolicyId IN (SELECT id FROM @monitoringPolicyId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2104 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.attrVal = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM APP_MonitoringPolicyProp as tbl1 INNER JOIN @monitoringPolicyId as tbl2
			ON tbl1.monitorPolicyId = tbl2.id
			WHERE tbl1.attrName = 'Creater User Id'
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @monitoringPolicyId as tbl2
ON tbl1.entityType1 = 90
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
90, tbl1.id, 1, @callerId
			FROM  @monitoringPolicyId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 90
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(90) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+MonitorPolicyName from APP_MonitoringPolicy where monitorPolicyId in (SELECT id FROM @monitoringPolicyId) FOR XML PATH('')),1,2,'') ,(2104 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=64)    --alert
	BEGIN
		DECLARE @alertId TABLE (id INTEGER)
		INSERT INTO @alertId
			SELECT id
			FROM NTnotificationRule
			WHERE notifOwner = @oldOwnerId
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 64
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS( SELECT 1 FROM @alertId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 64, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @alertId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + notificationName
																				FROM NTnotificationRule WHERE id IN (SELECT id FROM @alertId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.notifOwner = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM NTnotificationRule as tbl1 INNER JOIN @alertId as tbl2
			ON tbl1.id = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @alertId as tbl2
ON tbl1.entityType1 = 64
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
64, tbl1.id, 1, @callerId
			FROM  @alertId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 64
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(64) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+notificationName from NTnotificationRule where id in (SELECT id FROM @alertId) FOR XML PATH('')),1,2,'') ,(2812 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS (SELECT 1 FROM @entityTypeTransfered WHERE entityType=9674)
	BEGIN
		UPDATE lmSearchTbl
		SET lmSearchTbl.creatorUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
		FROM App_SharedEntityInfo as shareTbl
		INNER JOIN LMUserSearch lmSearchTbl
		ON shareTbl.OriginalEntityId = lmSearchTbl.searchId
WHERE shareTbl.SharedEntityType = 134 AND lmSearchTbl.creatorUserId = @oldOwnerId
		UPDATE lmDashTbl
		SET lmDashTbl.creatorUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @userForUserGroupId
											END
		FROM App_SharedEntityInfo as shareTbl
		INNER JOIN LMDashBoard lmDashTbl
		ON shareTbl.OriginalEntityId = lmDashTbl.dashBoardId
WHERE shareTbl.SharedEntityType = 137 AND lmDashTbl.creatorUserId = @oldOwnerId
	END
	----------------------------------------------------------------------------------------------------------------------------------
	-- For Review Set, Query Set, Download Set and Tag Set also updating containerName by appending it with old owner's login name.
	-- Doing this on behalf of DM2 team as suggested by Karthikeyan Shanmuga Sundaram. Please refer to him for any queries with this.
	----------------------------------------------------------------------------------------------------------------------------------
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=9501)    --Review sets.
	BEGIN
		DECLARE @reviewSetId TABLE (id INTEGER)
		INSERT INTO @reviewSetId
			SELECT containerId
			FROM DM2Container
WHERE userId = @oldOwnerId and containerType = 9501
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 9501
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @reviewSetId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
			SET @errorCode = @errorCodeForChangeSecurityPermissionOnCommcell
			SET @errorMessage = @errorMessageForChangeSecurityPermissionOnCommcell
			GOTO EXITPROC
		END
		UPDATE tbl1
			SET tbl1.containerName = tbl1.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = @oldOwnerId
																						AND @oldOwnerId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																												ELSE @userForUserGroupId
																												END) + ')'), '')
			FROM DM2Container as tbl1 INNER JOIN @reviewSetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM DM2Container as tbl1 INNER JOIN @reviewSetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @reviewSetId as tbl2
ON tbl1.entityType1 = 9501
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
9501, tbl1.id, 1, @callerId
			FROM  @reviewSetId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 9501
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(9501) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+containerName from DM2Container where containerId in (SELECT id FROM @reviewSetId) FOR XML PATH('')),1,2,''),(3272 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=9502)    --Query sets.
	BEGIN
		DECLARE @querySetId TABLE (id INTEGER)
		INSERT INTO @querySetId
			SELECT containerId
			FROM DM2Container
WHERE userId = @oldOwnerId and containerType = 9502
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 9502
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @querySetId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
			SET @errorCode = @errorCodeForChangeSecurityPermissionOnCommcell
			SET @errorMessage = @errorMessageForChangeSecurityPermissionOnCommcell
			GOTO EXITPROC
		END
		UPDATE tbl1
			SET tbl1.containerName = tbl1.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = @oldOwnerId
																						AND @oldOwnerId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																												ELSE @userForUserGroupId
																												END) + ')'), '')
			FROM DM2Container as tbl1 INNER JOIN @querySetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM DM2Container as tbl1 INNER JOIN @querySetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @querySetId as tbl2
ON tbl1.entityType1 = 9502
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
9502, tbl1.id, 1, @callerId
			FROM  @querySetId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 9502
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(9502) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+containerName from DM2Container where containerId in (SELECT id FROM @querySetId) FOR XML PATH('')),1,2,''),(2438 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=9503)    --Download sets.
	BEGIN
		DECLARE @downloadSetId TABLE (id INTEGER)
		INSERT INTO @downloadSetId
			SELECT containerId
			FROM DM2Container
WHERE userId = @oldOwnerId and containerType = 9503
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 9503
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @downloadSetId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
			SET @errorCode = @errorCodeForChangeSecurityPermissionOnCommcell
			SET @errorMessage = @errorMessageForChangeSecurityPermissionOnCommcell
			GOTO EXITPROC
		END
		UPDATE tbl1
			SET tbl1.containerName = tbl1.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = @oldOwnerId
																						AND @oldOwnerId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																												ELSE @userForUserGroupId
																												END) + ')'), '')
			FROM DM2Container as tbl1 INNER JOIN @downloadSetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM DM2Container as tbl1 INNER JOIN @downloadSetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @downloadSetId as tbl2
ON tbl1.entityType1 = 9503
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
9503, tbl1.id, 1, @callerId
			FROM  @downloadSetId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 9503
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(9503) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+containerName from DM2Container where containerId in (SELECT id FROM @downloadSetId) FOR XML PATH('')),1,2,''),(2439 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=9504)    --Tag sets.
	BEGIN
		DECLARE @tagSetId TABLE (id INTEGER)
		INSERT INTO @tagSetId
			SELECT containerId
			FROM DM2Container
WHERE userId = @oldOwnerId and containerType = 9504
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 9504
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @tagSetId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
			SET @errorCode = @errorCodeForChangeSecurityPermissionOnCommcell
			SET @errorMessage = @errorMessageForChangeSecurityPermissionOnCommcell
			GOTO EXITPROC
		END
		UPDATE tbl1
			SET tbl1.containerName = tbl1.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WHERE id = @oldOwnerId
																						AND @oldOwnerId <> CASE WHEN @newUserId <> 0 THEN @newUserId
																												ELSE @userForUserGroupId
																												END) + ')'), '')
			FROM DM2Container as tbl1 INNER JOIN @tagSetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @userForUserGroupId
									END
			FROM DM2Container as tbl1 INNER JOIN @tagSetId as tbl2
			ON tbl1.containerId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @tagSetId as tbl2
ON tbl1.entityType1 = 9504
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
9504, tbl1.id, 1, @callerId
			FROM  @tagSetId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 9504
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(9504) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+containerName from DM2Container where containerId in (SELECT id FROM @tagSetId) FOR XML PATH('')),1,2,''),(2440 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=9505)    --Legal Holds.
	BEGIN
		DECLARE @legalHoldId TABLE (id INTEGER)
		INSERT INTO @legalHoldId
			SELECT id
			FROM DM2CompliancePolicy
			WHERE ownerUserId = @oldOwnerId
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 9505
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @legalHoldId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
			SET @errorCode = @errorCodeForChangeSecurityPermissionOnCommcell
			SET @errorMessage = @errorMessageForChangeSecurityPermissionOnCommcell
			GOTO EXITPROC
		END
		UPDATE tbl1
			SET tbl1.ownerUserId = CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @userForUserGroupId
										END
			FROM DM2CompliancePolicy as tbl1 INNER JOIN @legalHoldId as tbl2
			ON tbl1.id = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @legalHoldId as tbl2
ON tbl1.entityType1 = 9505
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
9505, tbl1.id, 1, @callerId
			FROM  @legalHoldId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 9505
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(9505) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+CompPolicyName from DM2CompliancePolicy where id in (SELECT id FROM @legalHoldId) FOR XML PATH('')),1,2,''),(2441 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=132)    --Data Cube Source.
	BEGIN
		DECLARE @dataSourceId TABLE (id INTEGER)
		INSERT INTO @dataSourceId
			SELECT DataSourceId
			FROM SEDataSource
			WHERE OwnerUserID = @oldOwnerId
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 132
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @dataSourceId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 132, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @dataSourceId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + DataSourceName
																				FROM SEDataSource WHERE DataSourceId IN (SELECT id FROM @dataSourceId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2781 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.OwnerUserID = CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @userForUserGroupId
										END
			FROM SEDataSource as tbl1 INNER JOIN @dataSourceId as tbl2
			ON tbl1.DataSourceId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @dataSourceId as tbl2
ON tbl1.entityType1 = 132
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
132, tbl1.id, 1, @callerId
			FROM  @dataSourceId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 132
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(132) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+DataSourceName from SEDataSource where DataSourceId in (SELECT id FROM @dataSourceId) FOR XML PATH('')),1,2,''),(2781 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=133)    --Data Cube Search View.
	BEGIN
		DECLARE @searchViewId TABLE (id INTEGER)
		INSERT INTO @searchViewId
			SELECT SearchViewId
			FROM SESearchView
			WHERE OwnerUserID = @oldOwnerId and status = 0
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 133
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @searchViewId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 133, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @searchViewId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + SearchViewName
																				FROM SESearchView WHERE SearchViewId IN (SELECT id FROM @searchViewId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2782 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.OwnerUserID = CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @userForUserGroupId
										END
			FROM SESearchView as tbl1 INNER JOIN @searchViewId as tbl2
			ON tbl1.SearchViewId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @searchViewId as tbl2
ON tbl1.entityType1 = 133
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
133, tbl1.id, 1, @callerId
			FROM  @searchViewId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 133
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(133) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+SearchViewName from SESearchView where SearchViewId in (SELECT id FROM @searchViewId) FOR XML PATH('')),1,2,''),(2782 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=157)    --Data Cube Search Handler.
	BEGIN
		DECLARE @searchHandlerId TABLE (id INTEGER)
		INSERT INTO @searchHandlerId
			SELECT SearchViewId
			FROM SESearchView
			WHERE OwnerUserID = @oldOwnerId and status = 1
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 157
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @searchHandlerId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 157, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @searchHandlerId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + SearchViewName
																				FROM SESearchView WHERE SearchViewId IN (SELECT id FROM @searchHandlerId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2783 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.OwnerUserID = CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @userForUserGroupId
										END
			FROM SESearchView as tbl1 INNER JOIN @searchHandlerId as tbl2
			ON tbl1.SearchViewId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @searchHandlerId as tbl2
ON tbl1.entityType1 = 157
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
157, tbl1.id, 1, @callerId
			FROM  @searchHandlerId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 157
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(157) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+SearchViewName from SESearchView where SearchViewId in (SELECT id FROM @searchHandlerId) FOR XML PATH('')),1,2,''),(2783 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
IF EXISTS( SELECT 1 FROM @entityTypeTransfered WHERE entityType=131)    --reports entity:131
	BEGIN
		DECLARE @reportsId TABLE (id INTEGER)
		INSERT INTO @reportsId
			SELECT reportId
			FROM APP_Reports
			WHERE userId = @oldOwnerId
			UNION
			SELECT DISTINCT entityId1
			FROM UMSecurityAssociations
WHERE entityType1 = 131
				AND userOrGroupId = CASE WHEN @oldOwnerGroupId = 0 THEN @oldOwnerId
											ELSE @oldOwnerGroupId
											END
				AND isUser = CASE WHEN @oldOwnerGroupId = 0 THEN 1
									ELSE 0
									END
				AND isCreator = 1
		IF EXISTS(SELECT 1 FROM @reportsId) AND @hasChangeSecurityPermissionOnCommcell = 0
		BEGIN
EXEC sec_getNonIdaObjectsForThisUser @callerId, 131, 107, '#sec_transferUserOwnership_GetEntity'
			IF EXISTS( SELECT * FROM @reportsId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
			BEGIN
SET @errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale)
				SET @errorMessage = REPLACE(@errorMessage, '^1%s', ISNULL((SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers WHERE id = @callerId),''))
SET @errorMessage = REPLACE(@errorMessage, '^2%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2403 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				SET @errorMessage = REPLACE(@errorMessage, '^3%s', STUFF((SELECT ', ' + name
																				FROM App_Reports WHERE reportId IN (SELECT id FROM @reportsId EXCEPT SELECT entityId from #sec_transferUserOwnership_GetEntity)
																				FOR XML PATH('')), 1, 2, ''))
SET @errorMessage = REPLACE(@errorMessage, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2782 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @locale))
				GOTO EXITPROC
			END
		END
		UPDATE tbl1
			SET tbl1.userId = CASE WHEN @newUserId <> 0 THEN @newUserId
										ELSE @userForUserGroupId
										END
			FROM App_Reports as tbl1 INNER JOIN @reportsId as tbl2
			ON tbl1.reportId = tbl2.id
		UPDATE tbl1
			SET tbl1.userOrGroupId = CASE WHEN @newUserId <> 0 THEN @newUserId
											ELSE @newUserGroupId
											END,
				tbl1.isUser = CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END
			FROM UMSecurityAssociations as tbl1 INNER JOIN @reportsId as tbl2
ON tbl1.entityType1 = 131
				AND tbl1.entityId1 = tbl2.id
			WHERE tbl1.isCreator = 1
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityId1, isCreator, authorId)
			SELECT DISTINCT P.roleId, P.permissionId,
							CASE WHEN @newUserId <> 0 THEN @newUserId
									ELSE @newUserGroupId
									END,
							CASE WHEN @newUserId <> 0 THEN 1
									ELSE 0
									END,
131, tbl1.id, 1, @callerId
			FROM  @reportsId as tbl1 LEFT OUTER JOIN UMSecurityAssociations as tbl2
ON tbl2.entityType1 = 131
				AND tbl1.id = tbl2.entityId1
				AND tbl2.isCreator = 1
CROSS JOIN dbo.sec_getPermissionForEntityTypeCreator(131) as P
			WHERE tbl2.entityId1 IS NULL
		INSERT INTO @auditTable(entityName,entityTypeMsgId)
VALUES(stuff((select ', '+name from App_Reports where reportId in (SELECT id FROM @reportsId) FOR XML PATH('')),1,2,''),(2782 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
		TRUNCATE TABLE #sec_transferUserOwnership_GetEntity
	END
END
-- When we transfer ownership from old users / groups to new users / groups (during Delete User, etc.) we need to transfer the Scope of client groups belonging to them to new owner as well.
-- Scope is saved in a new table, not in Security Associations table. So pulling this block of code outside.
IF @oldOwnerId <> 0 OR @oldOwnerGroupId <> 0
BEGIN
	DECLARE @newScopeEntityType INT = CASE
WHEN @newUserGroupID <> 0 THEN 15
WHEN @newUserID <> 0 THEN 13
											ELSE 0
										END
	DECLARE @newScopeEntityId INT = CASE
											WHEN @newUserGroupID <> 0 THEN @newUserGroupId
											WHEN @newUserID <> 0 THEN @newUserId
											ELSE 0
									END
	DECLARE @oldScopeEntityType INT = CASE
WHEN @oldOwnerGroupID <> 0 THEN 15
WHEN @oldOwnerId <> 0 THEN 13
											ELSE 0
										END
	DECLARE @oldScopeEntityId INT = CASE
											WHEN @oldOwnerGroupID <> 0 THEN @oldOwnerGroupId
											WHEN @oldOwnerId <> 0 THEN @oldOwnerId
											ELSE 0
										END
	-- Security checks for old and new owner, etc. are already done in the beginning of this stored proc, so when we come here, we are good. Just update the scope.
	IF @newScopeEntityType <> 0 AND @newScopeEntityId <> 0 AND @oldScopeEntityType <> 0 AND @oldScopeEntityId <> 0
	BEGIN
		UPDATE APP_SCGScope
		SET entityType = @newScopeEntityType,
			entityId = @newScopeEntityId
		WHERE
			entityType = @oldScopeEntityType
			AND entityId = @oldScopeEntityId
	END
END
--GUI AUDIT ownership transfer
IF EXISTS(select 1 from @auditTable where entityName is not null)
BEGIN
	UPDATE tbl1
		SET tbl1.entityTypeName = tbl2.message
		FROM @auditTable as tbl1 INNER JOIN EvLocaleMsgs as tbl2
		on tbl1.entityTypeMsgId = tbl2.messageId
		where tbl2.localeid = @locale
    DECLARE @opId int
DECLARE @opMsgId int = (520 | (CAST(POWER(2, 24) AS BIGINT) * 84))
	DECLARE @opEvMsgId int
	DECLARE @dataisEvent int = 0
	DECLARE @newOwner NVARCHAR(MAX) = CASE WHEN @newUserId <> 0 THEN (SELECT login FROM UMUsers WHERE id = @newUserId)
																ELSE (SELECT CASE WHEN G.umdsProviderId > 0 THEN Prov.domainName + '\' + G.name
																											ELSE G.name
																			END
																		FROM UMGroups G LEFT OUTER JOIN UMDSProviders Prov
																			ON G.umdsProviderId = Prov.id
																		WHERE G.id = @newUserGroupId)
											END
DECLARE @paramMsgId int = (1473 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	DECLARE @paramEntityType NVARCHAR(MAX)
	DECLARE @paramEntityName NVARCHAR(MAX)
    EXEC EvGuiAuditSetOperation @opMsgId, @callerId, @opEvMsgId OUTPUT, @opId OUTPUT
	EXEC EvGuiAuditSetParamData @opId, @newOwner, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @callerId
SET @paramMsgId = (1472 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	DECLARE auditCur CURSOR
	FOR SELECT DISTINCT entityTypeName, entityName from @auditTable where entityName is not null
	OPEN auditCur
	FETCH NEXT FROM auditCur INTO @paramEntityType, @paramEntityName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		EXEC EvGuiAuditSetParamData @opId, @paramEntityType, @dataIsEvent
		EXEC EvGuiAuditSetParamData @opId, @paramEntityName, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @callerId
		FETCH NEXT FROM auditCur INTO @paramEntityType, @paramEntityName
	END
	CLOSE auditCur
	DEALLOCATE auditCur
END
END TRY
BEGIN CATCH
		PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
 -- Call procedure to print error information.
 -- Call procedure to get error information.
 EXECUTE dbo.GetError @errorMessage OUTPUT , @errorCode OUTPUT
END CATCH
EXITPROC:
IF(@doReturn<>0)
	SELECT @errorCode,@errorMessage
IF OBJECT_ID('tempdb.dbo.#sec_transferUserOwnership_GetEntity') IS NOT NULL
	DROP TABLE #sec_transferUserOwnership_GetEntity
IF OBJECT_ID('tempdb.dbo.#sec_entityToBeTransferred') IS NOT NULL
	DROP TABLE #sec_entityToBeTransferred
GO

IF EXISTS (select * from GxQscripts where name = 'sec_transferUserOwnership')
	delete from GxQscripts where name = 'sec_transferUserOwnership'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_transferUserOwnership')
	delete from GXDBVersions where aliasname = 'sec_transferUserOwnership'
GO

insert into GXDBVersions values(2, 'sec_transferUserOwnership',  '00000000000000000000', 'sec_transferUserOwnership', '00000000000000000000')
GO

