

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_storePreviousPassword.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------------------------------
--        ProcName    : sec_storePreviousPassword
--        Description : Stores the current password and salt of the given user in UMUsersProp
--		                based on the number of passwords that has to be remembered for the user.
--						To be called before the password is updated in umusers table.
--		  Input       : userId
-------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_storePreviousPassword <<<'

IF EXISTS (select * from sysobjects where name='sec_storePreviousPassword')
	drop procedure sec_storePreviousPassword
IF EXISTS (select * from GxQscripts where name='sec_storePreviousPassword')
	delete from GxQscripts where name = 'sec_storePreviousPassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_storePreviousPassword')
	delete from GXDBVersions where aliasname = 'sec_storePreviousPassword'
GO
print '... Creating Procedure: sec_storePreviousPassword'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_storePreviousPassword
  @userId INT
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @noOfPasswordsToRemember INT = 0
	DECLARE @noOfOldHashesMaintained INT = 0
	DECLARE @noOfOldSaltsMaintained INT = 0
	DECLARE @nowTime INT = dbo.GetUnixTime (GetUTCdate())
	--get the number of passwords to be remembered
	EXEC sec_getPasswordsToRememberForUser @userId, @noOfPasswordsToRemember OUTPUT
	IF @noOfPasswordsToRemember < 3
		SET @noOfPasswordsToRemember = 3 -- maintain minimum 3 passwords for commvaultid
	--number of hashes,salt to maintain will be 1  less than number of passwords to remember
	SET @noOfPasswordsToRemember = @noOfPasswordsToRemember-1
SELECT @noOfOldHashesMaintained = count(*) from umusersprop WHERE attrname = N'Old Password Hash' and componentNameId = @userId and modified = 0
SELECT @noOfOldSaltsMaintained = count(*) from umusersprop WHERE attrname = N'Old Password Salt' and componentNameId = @userId and modified = 0
	IF @noOfOldHashesMaintained >= @noOfPasswordsToRemember
	BEGIN
		WITH hashTemp AS
(SELECT TOP (1 + @noOfOldHashesMaintained - @noOfPasswordsToRemember)* FROM UMUsersProp  WHERE attrname = N'Old Password Hash' and componentNameId = @userId  and modified = 0
		ORDER BY created ASC)
		DELETE FROM hashTemp
	END
	IF @noOfOldSaltsMaintained >= @noOfPasswordsToRemember
	BEGIN
		WITH saltTemp AS
(SELECT TOP (1 + @noOfOldSaltsMaintained - @noOfPasswordsToRemember)* FROM UMUsersProp  WHERE attrname = N'Old Password Salt' and componentNameId = @userId  and modified = 0
		ORDER BY created ASC)
		DELETE FROM saltTemp
	END
	DECLARE @currentPassword NVARCHAR(1024)
	DECLARE @currentSalt NVARCHAR(1024)
	SELECT @currentPassword = password , @currentSalt = salt FROM UMUsers WHERE id = @userId
	-- Now store the hash and password in UMUsersProp
	INSERT INTO UMUsersProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@userId, N'Old Password Hash', 1, @currentPassword, @nowTime,0)
	INSERT INTO UMUsersProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@userId, N'Old Password Salt', 1, @currentSalt, @nowTime,0)
GO

IF EXISTS (select * from GxQscripts where name = 'sec_storePreviousPassword')
	delete from GxQscripts where name = 'sec_storePreviousPassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_storePreviousPassword')
	delete from GXDBVersions where aliasname = 'sec_storePreviousPassword'
GO

insert into GXDBVersions values(2, 'sec_storePreviousPassword',  '00000000000000000000', 'sec_storePreviousPassword', '00000000000000000000')
GO

