

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_sortUsersOrGroupsByPermissions.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_sortUsersOrGroupsByPermissions.sp,v $ $Id: sec_sortUsersOrGroupsByPermissions.sp,v 1.1.2.5 2019/12/18 21:53:06 jge Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_sortUsersOrGroupsByPermissions()
--  |
--  | Description:
--  |
--  |       Input:
--	|
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_sortUsersOrGroupsByPermissions')
BEGIN
	print '>>> Drop Stored Procedure: sec_sortUsersOrGroupsByPermissions <<<'
	drop procedure sec_sortUsersOrGroupsByPermissions
END
IF EXISTS (select * from GxQscripts where name='sec_sortUsersOrGroupsByPermissions')
	delete from GxQscripts where name = 'sec_sortUsersOrGroupsByPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sortUsersOrGroupsByPermissions')
	delete from GXDBVersions where aliasname = 'sec_sortUsersOrGroupsByPermissions'
GO
print '... Creating Procedure: sec_sortUsersOrGroupsByPermissions'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_sortUsersOrGroupsByPermissions
  @Id_List xml
AS
IF object_id('tempdb.dbo.#AdminIdTbl') is not null
	DROP TABLE #AdminIdTbl
IF object_id('tempdb.dbo.#UserOrGroupIdTbl') is not null
	DROP TABLE #UserOrGroupIdTbl
IF object_id('tempdb.dbo.#ResultTbl') is not null
	DROP TABLE #ResultTbl
--load user and group id from xml options into #UserOrGroupIdTbl
create table #UserOrGroupIdTbl
(
	userOrGroupId int,
	isUser int,
	shadowId int
)
insert into #UserOrGroupIdTbl
select distinct O.userOrGroupId, 1, 0 from (
	SELECT T.C.value('@userId', 'int') as 'userOrGroupId'
	FROM @Id_List.nodes('TMMsg_RptCommonOptions/emailUsers') T(C)
	union
	SELECT T.C.value('@userId', 'int') as 'userOrGroupId'
	FROM @Id_List.nodes('TMMsg_RptCommonOptions/emailExternalUsers') T(C)
) as O
join UMUsers
on UMUsers.enabled != 0 and UMUsers.id = O.userOrGroupId
union
select distinct E.id as 'userOrGroupId', 0, 0
from (
	SELECT T.C.value('@userGroupId', 'int') as 'id'
	FROM @Id_List.nodes('TMMsg_RptCommonOptions/emailUserGroups') T(C)
	union
	SELECT T.C.value('@userGroupId', 'int') as 'id'
	FROM @Id_List.nodes('TMMsg_RptCommonOptions/emailExternalUserGroups') T(C)
) E
join UMGroups
on UMGroups.groupFlags != 0 and UMGroups.id = E.id
--get admin usr and group from #UserOrGroupIdTbl
create table #AdminIdTbl
(
	userOrGroupId int,
	isUser int
)
insert into #AdminIdTbl
select distinct Data.AdminId, 1
from (
	SELECT UD.userId as 'AdminId'
	FROM UMDSUserGroup UD INNER JOIN UMDSGroupMaps GM
	ON UD.groupId = GM.umDSgroupId
	INNER JOIN #UserOrGroupIdTbl as UG
	ON UG.userOrGroupId = UD.userId and UG.isUser = 1
	where GM.umgroupId = dbo.GetMasterGroupID()
	union
	SELECT id as 'AdminId'
	FROM UMUserGroup INNER JOIN UMUsers
	ON UMUserGroup.userId = UMUsers.id
	INNER JOIN #UserOrGroupIdTbl as UG
	ON UG.userOrGroupId = UMUsers.id and UG.isUser = 1
	WHERE UMUserGroup.groupId = dbo.GetMasterGroupID()
) as Data
insert into #AdminIdTbl
select distinct Data.AdminId, 0
from (
	select UG.userOrGroupId as 'AdminId'
	from #UserOrGroupIdTbl UG
	where UG.userOrGroupId = dbo.GetMasterGroupID() and UG.isUser = 0
	union
	SELECT GM.umDSgroupId as 'AdminId'
	FROM UMDSGroupMaps GM
	INNER JOIN #UserOrGroupIdTbl as UG
	ON UG.userOrGroupId = GM.umDSgroupId and UG.isUser = 0
	WHERE GM.umgroupId = dbo.GetMasterGroupID()
) as Data
--#UserOrGroupIdTbl only contain non-admin user and group
delete from #UserOrGroupIdTbl
where exists(
	select A.userOrGroupId from #AdminIdTbl A where A.userOrGroupId = #UserOrGroupIdTbl.userOrGroupId and A.isUser = #UserOrGroupIdTbl.isUser
)
--user's shadowId is userId
update #UserOrGroupIdTbl
set shadowId = userOrGroupId
where isUser = 1
--if a group has a hidden user, then set hidden user's Id for a group
update #UserOrGroupIdTbl
set shadowId = B.hiddenUserId
from #UserOrGroupIdTbl as A
join (
	select B.groupId, A.id as hiddenUserId
	from UMUsers as A
	join UMUserGroup as B
on A.flags & 0x800 = 0x800 and A.id = B.userId
) B
on A.isUser = 0 and A.userOrGroupId = B.groupId
--if a group doesn't have a hidden user, then create the hidden user and set hidden user's Id for a group
declare @userOrGroupId int
DECLARE @groupCursor CURSOR
SET @groupCursor = CURSOR FOR
select userOrGroupId from #UserOrGroupIdTbl where isUser = 0 and shadowId = 0
OPEN @groupCursor
FETCH NEXT FROM @groupCursor INTO @userOrGroupId
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @hiddenUserId INT = 0
	EXEC sec_getCreateAsUserId 0,0,@hiddenUserID OUTPUT,0,0,@userOrGroupId
	update #UserOrGroupIdTbl
	set shadowId = @hiddenUserId
	where userOrGroupId = @userOrGroupId and isUser = 0
	FETCH NEXT FROM @groupCursor INTO @userOrGroupId
END
CLOSE @groupCursor
DEALLOCATE @groupCursor
create table #ResultTbl
(
     userorGroupReq xml
)
--insert admin group and usr into #ResultTbl
insert into #ResultTbl
select cast(
	(
		SELECT cast(A.userOrGroupId as varchar(128)) as '@userId'
		,
		case
			when A.isUser = 1
			then '13'
			else '15'
		end as '@_type_'
		, '' as '@userName'
		, '1' as '@shadowId'
		FROM #AdminIdTbl A
		order by A.userOrGroupId
		FOR XML PATH('users')
	)
as xml)
--insert non-admin group and usr into #ResultTbl
insert into #ResultTbl
select cast(
	(
		SELECT cast(B.userOrGroupId as varchar(128)) as '@userId'
		,
		case
			when B.isUser = 1
			then '13'
			else '15'
		end as '@_type_'
		, '' as '@userName'
		, B.shadowId as '@shadowId'
		FROM #UserOrGroupIdTbl B
		WHERE A.shadowId=B.shadowId
		FOR XML PATH('users')
	) as xml
) AS Row
FROM #UserOrGroupIdTbl A
select cast( (
select * from #ResultTbl
FOR XML PATH(''), ROOT('TMMsg_ReportsEndUserSecurityReq')
) as xml) display_result
IF object_id('tempdb.dbo.#AdminIdTbl') is not null
	DROP TABLE #AdminIdTbl
IF object_id('tempdb.dbo.#UserOrGroupIdTbl') is not null
	DROP TABLE #UserOrGroupIdTbl
IF object_id('tempdb.dbo.#ResultTbl') is not null
	DROP TABLE #ResultTbl
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'sec_sortUsersOrGroupsByPermissions')
	delete from GxQscripts where name = 'sec_sortUsersOrGroupsByPermissions'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sortUsersOrGroupsByPermissions')
	delete from GXDBVersions where aliasname = 'sec_sortUsersOrGroupsByPermissions'
GO

insert into GXDBVersions values(2, 'sec_sortUsersOrGroupsByPermissions',  '00010001000200050000', 'sec_sortUsersOrGroupsByPermissions', '00010001000200050000')
GO

