

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_skipAuditLoginAndLogout.sp] ---------- 

-- 	+------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_skipAuditLoginAndLogout"
--	|	Description: Stored procedure to check if auditing of login and logout can be skipped.
--	|	Input: userId, shouldSelectOutput(set to 1 from C++ code to return output)
--	|	Output: True or false.
--	|	Author: jswaminathan
-- 	+------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_skipAuditLoginAndLogout')
BEGIN
	print '>>> Drop Stored Procedure: sec_skipAuditLoginAndLogout <<<'
	drop procedure sec_skipAuditLoginAndLogout
END
IF EXISTS (select * from GxQscripts where name='sec_skipAuditLoginAndLogout')
	delete from GxQscripts where name = 'sec_skipAuditLoginAndLogout'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_skipAuditLoginAndLogout')
	delete from GXDBVersions where aliasname = 'sec_skipAuditLoginAndLogout'
GO
print '... Creating Procedure: sec_skipAuditLoginAndLogout'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_skipAuditLoginAndLogout
  @userId INT,
  @shouldSelectOutput INT = 0
AS
-- Output:
  DECLARE @skipAuditForLoginAndLogout INT 
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
SET @skipAuditForLoginAndLogout = 0		-- Default, do not skip audit of login and logout.
DECLARE @value NVARCHAR(MAX)
SELECT @value = value
FROM APP_AdvanceSettings
WHERE
keyName = 'skipAuditLoginAndLogout'
	AND relativePath = 'CommservDB.Console'
	AND enabled = 1
	AND deleted = 0
AND entityType = 13			-- 13
	AND entityId = @userId
IF @value IS NULL			-- Check on commcell too if key is not present against User entity.
	SELECT @value = value
	FROM APP_AdvanceSettings
	WHERE
keyName = 'skipAuditLoginAndLogout'
		AND relativePath = 'CommservDB.Console'
		AND enabled = 1
		AND deleted = 0
		AND entityType = 3
		AND entityId = 2
IF (@value IS NOT NULL)
BEGIN
	IF (@value = 'true')
		SET @skipAuditForLoginAndLogout = 1
	ELSE IF (@value = 'false')
		SET @skipAuditForLoginAndLogout = 0
END
IF @shouldSelectOutput = 1
	SELECT @skipAuditForLoginAndLogout
GO

IF EXISTS (select * from GxQscripts where name = 'sec_skipAuditLoginAndLogout')
	delete from GxQscripts where name = 'sec_skipAuditLoginAndLogout'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_skipAuditLoginAndLogout')
	delete from GXDBVersions where aliasname = 'sec_skipAuditLoginAndLogout'
GO

insert into GXDBVersions values(2, 'sec_skipAuditLoginAndLogout',  '00000000000000000000', 'sec_skipAuditLoginAndLogout', '00000000000000000000')
GO

