

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_sharingUpdateCapabilitesAndAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_sharingUpdateCapabilitesAndAssociations.sp,v $ $Id: sec_sharingUpdateCapabilitesAndAssociations.sp,v 1.5.88.2 2020/12/21 14:43:13 jswaminathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_sharingUpdateCapabilitesAndAssociations()
--  |
--  | Description:
--  |
--  |       Input:
--	|
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_sharingUpdateCapabilitesAndAssociations')
BEGIN
	print '>>> Drop Stored Procedure: sec_sharingUpdateCapabilitesAndAssociations <<<'
	drop procedure sec_sharingUpdateCapabilitesAndAssociations
END
IF EXISTS (select * from GxQscripts where name='sec_sharingUpdateCapabilitesAndAssociations')
	delete from GxQscripts where name = 'sec_sharingUpdateCapabilitesAndAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sharingUpdateCapabilitesAndAssociations')
	delete from GXDBVersions where aliasname = 'sec_sharingUpdateCapabilitesAndAssociations'
GO
print '... Creating Procedure: sec_sharingUpdateCapabilitesAndAssociations'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_sharingUpdateCapabilitesAndAssociations
  @i_userId integer=0,
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
DECLARE @ownerId INT=0
DECLARE @entityType INT = 0
DECLARE @entityId INT = 0
DECLARE @canManageEntityType INT = 0
DECLARE @userTable TABLE ( t_userId int,
						   t_capabilities bigint )
DECLARE @galaxyGroupTable TABLE ( t_groupId int,
								  t_capabilities bigint)
DECLARE @externalGroupTable TABLE ( t_groupId int,
									t_providerId int,
									t_capabilities bigint )
DECLARE @o_errorCode INT = 0
DECLARE @o_errorString	NVARCHAR(MAX)
SET @entityType = ISNULL(( SELECT ref.value('@entityType', 'INT')
						FROM @i_xmlText.nodes('GuiServer_UpdateUsersAndGroupsForSharingRequest') R ( ref ) ), 0)
SET @entityId = ISNULL(( SELECT ref.value('@entityId', 'INT')
						FROM @i_xmlText.nodes('GuiServer_UpdateUsersAndGroupsForSharingRequest') R ( ref ) ), 0)
IF ( @i_userId = 0 OR @i_userId IS null )
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User Id not supplied'
	GOTO EXIT_ERROR
END
-- check for capabilities
-- if user is the admin, then he can share the entity with anyone
DECLARE @isUserAdmin int
EXECUTE sec_isUserAdmin   @i_userid = @i_userId ,@o_isUserAdmin = @isUserAdmin  OUTPUT
IF (@isUserAdmin = 1)
BEGIN
	SET @canManageEntityType = 1
END
ELSE IF EXISTS(Select * From UMUserandGroupEntityAssociation Where entityType = @entityType And objectId = @entityId And ownerUserId = @i_userId)
BEGIN
	SET @canManageEntityType = 1
END
IF (@canManageEntityType = 0)
BEGIN
	SET @o_errorCode = -1
	SET	@o_errorString = 'User needs to be owner/admin to perform this operation'
	GOTO EXIT_ERROR
END
-- get the users and user groups
INSERT INTO @userTable
SELECT ref.value('user[1]/@userId','INT'), ref.value('@capabilities','BIGINT')
FROM @i_xmlText.nodes('GuiServer_UpdateUsersAndGroupsForSharingRequest/userAndGroupCapabilityList/userCapabilities') R( ref )
INSERT INTO @galaxyGroupTable
SELECT ref.value('group[1]/@userGroupId','INT'), ref.value('@capabilities','BIGINT')
FROM @i_xmlText.nodes('GuiServer_UpdateUsersAndGroupsForSharingRequest/userAndGroupCapabilityList/userGroupCapabilities') R( ref )
INSERT INTO @externalGroupTable
SELECT ref.value('externalGroup[1]/@groupId','INT'), ref.value('externalGroup[1]/@providerId','INT'), ref.value('@capabilities','BIGINT')
FROM @i_xmlText.nodes('GuiServer_UpdateUsersAndGroupsForSharingRequest/userAndGroupCapabilityList/externalGroupCapabilities') R( ref )
BEGIN TRAN
-- delete all the existing users and user groups for this specific entity , retain owner User Id and insert same..for check done above.
--This is done because multiple rows with different ownerUser Id can lead to problem that which capability user has on that entity.
SET @ownerId=ISNULL((SELECT Top 1 ownerUserId FROM UMUserandGroupEntityAssociation WHERE entityType = @entityType And objectId = @entityId ),@i_userId)
--OwnerUserId will have only 1 entry for a entity ( it should be id of creator, not the one( can be admin) who is changing capability of that user)
DELETE UMUserandGroupEntityAssociation
WHERE  entityType = @entityType AND objectId = @entityId
-- insert the users and groups
INSERT INTO UMUserandGroupEntityAssociation(userId, groupId, providerId, capabilities, entityType, objectId, ownerUserId)
SELECT DISTINCT t_userId, 0, 0, t_capabilities, @entityType, @entityId, @ownerId
FROM @userTable
INSERT INTO UMUserandGroupEntityAssociation(userId, groupId, providerId, capabilities, entityType, objectId, ownerUserId)
SELECT DISTINCT 0, t_groupId, 0, t_capabilities, @entityType, @entityId, @ownerId
FROM @galaxyGroupTable
INSERT INTO UMUserandGroupEntityAssociation(userId, groupId, providerId, capabilities, entityType, objectId, ownerUserId)
SELECT DISTINCT 0, t_groupId, t_providerId, t_capabilities, @entityType, @entityId, @ownerId
FROM @externalGroupTable
SET @o_errorCode = 0
SET @o_errorString = 'Entity Successfully Shared'
COMMIT TRAN
EXIT_ERROR:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [CVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_sharingUpdateCapabilitesAndAssociations')
	delete from GxQscripts where name = 'sec_sharingUpdateCapabilitesAndAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sharingUpdateCapabilitesAndAssociations')
	delete from GXDBVersions where aliasname = 'sec_sharingUpdateCapabilitesAndAssociations'
GO

insert into GXDBVersions values(2, 'sec_sharingUpdateCapabilitesAndAssociations',  '00010005008800020000', 'sec_sharingUpdateCapabilitesAndAssociations', '00010005008800020000')
GO

