

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_sharingGetUsersAndGroupsList.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_sharingGetUsersAndGroupsList()
--  | Description:  Gets list of Users and User Groups
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_sharingGetUsersAndGroupsList.sp,v $ $Id: sec_sharingGetUsersAndGroupsList.sp,v 1.6.48.3 2018/03/20 00:13:06 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_sharingGetUsersAndGroupsList <<<'

IF EXISTS (select * from sysobjects where name='sec_sharingGetUsersAndGroupsList')
	drop procedure sec_sharingGetUsersAndGroupsList
IF EXISTS (select * from GxQscripts where name='sec_sharingGetUsersAndGroupsList')
	delete from GxQscripts where name = 'sec_sharingGetUsersAndGroupsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sharingGetUsersAndGroupsList')
	delete from GXDBVersions where aliasname = 'sec_sharingGetUsersAndGroupsList'
GO
print '... Creating Procedure: sec_sharingGetUsersAndGroupsList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_sharingGetUsersAndGroupsList
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @entityType INT = 0
	--DECLARE @i_capability		INT
	DECLARE @i_hideAdmin		INT
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
DECLARE @adminFlags			bigint = (convert(int, 0x0008))
	SET @o_errorCode = 0
	SET @o_errorString = ''
	--GET USER NAME FOR INPUT FROM JAVA GUI
	--SET @i_capability = 25
	SET @entityType = ISNULL(( SELECT ref.value('@entityType', 'INT')
						FROM @i_xmlText.nodes('GuiServer_GetAllUsersAndGroupsListRequest') R ( ref ) ), 0)
	SET @i_hideAdmin = ISNULL(( SELECT ref.value('@hideAdmin', 'INT')
						FROM @i_xmlText.nodes('GuiServer_GetAllUsersAndGroupsListRequest') R ( ref ) ), 0)
	DECLARE	@IntAdmGrps	TABLE (id INT)
	DECLARE	@ExtAdmGrps	TABLE (id INT)
	IF @i_hideAdmin = 1
	BEGIN
		INSERT INTO @IntAdmGrps
		values (dbo.GetMasterGroupID())
		INSERT INTO @ExtAdmGrps
		SELECT umDSgroupId FROM UMDSGroupMaps WHERE umgroupId in (
			SELECT id FROM @IntAdmGrps
		)
	END
	-- Fetch the user list
		SET @o_xmlText =
		(
		 SELECT
			(
			 	SELECT 	id 'user/@userId',
						userGuid 'user/@userGUID',
						login 'user/@userName'
				FROM UMUsers
				WHERE id > 0
				AND flags > 0
				AND id NOT in
				(
					SELECT userId FROM UMDSUserGroup WHERE groupId in
					(
						SELECT id FROM @ExtAdmGrps
					)
					UNION
					SELECT userId FROM UMUserGroup WHERE groupId in
					(
						SELECT id FROM @IntAdmGrps
					)
				)
				ORDER BY login
			 	FOR XML PATH('userCapabilities'), TYPE
			 ),
			 (
			 	SELECT	id 'group/@userGroupId',
						name 'group/@userGroupName'
			 	FROM UMGroups UG
			 	WHERE ( UG.groupFlags & 1 = 1 ) AND id NOT in
					(
						SELECT id FROM @IntAdmGrps
					)
				AND umdsProviderId = 0
				ORDER BY name
				FOR XML PATH('userGroupCapabilities'), TYPE
			 ),
			 (
				SELECT	UG.id 'externalGroup/@groupId',
						UG.umdsProviderId 'externalGroup/@providerId',
						UP.domainName + '\' + UG.name 'externalGroup/@externalGroupName'
				FROM UMgroups UG
				INNER JOIN UMDSProviders UP ON UG.umdsProviderId = UP.id
				WHERE ug.groupFlags & 1 = 1 AND UG.id not in
				(
						(
							SELECT id FROM @ExtAdmGrps
						)
				)
				AND UG.umdsProviderId <> 0
				ORDER BY UP.domainName, UG.name
			 	FOR XML PATH('externalGroupCapabilities'), TYPE
			 )
		 FOR XML PATH('userAndGroupCapabilityList'), ROOT('GuiServer_GetAllUsersAndGroupsListResponse')
		)
		SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_sharingGetUsersAndGroupsList')
	delete from GxQscripts where name = 'sec_sharingGetUsersAndGroupsList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sharingGetUsersAndGroupsList')
	delete from GXDBVersions where aliasname = 'sec_sharingGetUsersAndGroupsList'
GO

insert into GXDBVersions values(2, 'sec_sharingGetUsersAndGroupsList',  '00010006004800030000', 'sec_sharingGetUsersAndGroupsList', '00010006004800030000')
GO

