

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_sharingGetUserAndGroupListSharingCap.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_sharingGetUserAndGroupListSharingCap()
--  | Description:  SP to return Sharing information for Entities
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_sharingGetUserAndGroupListSharingCap.sp,v $ $Id: sec_sharingGetUserAndGroupListSharingCap.sp,v 1.2.200.1 2018/03/20 00:06:59 jiechen Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_sharingGetUserAndGroupListSharingCap <<<'

IF EXISTS (select * from sysobjects where name='sec_sharingGetUserAndGroupListSharingCap')
	drop procedure sec_sharingGetUserAndGroupListSharingCap
IF EXISTS (select * from GxQscripts where name='sec_sharingGetUserAndGroupListSharingCap')
	delete from GxQscripts where name = 'sec_sharingGetUserAndGroupListSharingCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sharingGetUserAndGroupListSharingCap')
	delete from GXDBVersions where aliasname = 'sec_sharingGetUserAndGroupListSharingCap'
GO
print '... Creating Procedure: sec_sharingGetUserAndGroupListSharingCap'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_sharingGetUserAndGroupListSharingCap
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId integer = 0,
  @i_xmlText XML
AS
  DECLARE @o_xmlText XML
SET NOCOUNT ON
BEGIN
	DECLARE @entityType INT = 0
	DECLARE @entityId   INT = 0
	DECLARE @localeId     INT = 0
	DECLARE @o_errorCode		INT
	DECLARE @o_errorString		NVARCHAR(MAX)
	SET @o_errorCode = 0
	SET @o_errorString = ''
	SET @entityType = ISNULL(( SELECT ref.value('@entityType', 'INT')
						FROM @i_xmlText.nodes('GuiServer_GetUsersAndGroupsForSharingRequest') R ( ref ) ), 0)
	SET @entityId = ISNULL(( SELECT ref.value('@entityId', 'INT')
						FROM @i_xmlText.nodes('GuiServer_GetUsersAndGroupsForSharingRequest') R ( ref ) ), 0)
	SET @localeId = ISNULL(( SELECT ref.value('@localeId', 'INT')
						FROM @i_xmlText.nodes('GuiServer_GetUsersAndGroupsForSharingRequest') R ( ref ) ), 0)
	IF ( @userId = 0 OR @userId IS null )
	BEGIN
		SET @o_errorCode = -1
		SET	@o_errorString = 'User not found or not mentioned'
		GOTO EXIT_ERROR
	END
	-- Fetch the user list
	SET @o_xmlText =
	(
		SELECT
		(
			-- Get the list of users, usergroups and external groups with their sharing rights
			SELECT
			(
				SELECT 	UUG.capabilities '@capabilities',
						id 'user/@userId',
						login 'user/@userName',
						userGuid 'user/@userGUID'
				FROM UMUsers UU
				INNER JOIN UMUserandGroupEntityAssociation UUG ON UU.id = UUG.userId
				--WHERE  UUG.ownerUserId = @userId
				WHERE UUG.entityType = @entityType
				AND ( UUG.objectId = @entityId OR UUG.objectId = -10 )
				FOR XML PATH('userCapabilities'), TYPE
			),
			(
				SELECT 	UUG.capabilities '@capabilities',
						id 'group/@userGroupId',
						name 'group/@userGroupName'
				FROM UMGroups UG
				INNER JOIN UMUserandGroupEntityAssociation UUG ON UG.id = UUG.groupId AND UUG.providerId = 0
				--WHERE  UUG.ownerUserId = @userId
				WHERE UUG.entityType = @entityType
				AND ( UUG.objectId = @entityId OR UUG.objectId = -10 )
				FOR XML PATH('userGroupCapabilities'), TYPE
			),
			(
				SELECT 	UUG.capabilities '@capabilities',
						UG.id 'externalGroup/@groupId',
						umdsProviderId 'externalGroup/@providerId',
						UP.domainName + '\' + UG.name 'externalGroup/@externalGroupName'
				FROM UMDSgroups UG
				INNER JOIN UMDSProviders UP ON UG.umdsProviderId = UP.id
				INNER JOIN UMUserandGroupEntityAssociation UUG ON UUG.groupId = UG.id AND UUG.providerId = UG.umdsProviderId
				--WHERE  UUG.ownerUserId = @userId
				WHERE UUG.entityType = @entityType
				AND ( UUG.objectId = @entityId OR UUG.objectId = -10 )
				FOR XML PATH('externalGroupCapabilities'), TYPE
			)
			FOR XML PATH('userAndGroupCapabilityList'), TYPE
		)
		FOR XML PATH(''), ROOT('GuiServer_GetUsersAndGroupsForSharingResponse')
	)
EXIT_ERROR:
	if(@o_errorCode <> 0)
	BEGIN
		SET @o_xmlText = (
			SELECT	1				as TAG,
					0				as Parent,
					@o_errorCode	as [CVGui_GenericResp!1!errorCode],
					@o_errorString	as [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT)
    END
	SELECT @o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_sharingGetUserAndGroupListSharingCap')
	delete from GxQscripts where name = 'sec_sharingGetUserAndGroupListSharingCap'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_sharingGetUserAndGroupListSharingCap')
	delete from GXDBVersions where aliasname = 'sec_sharingGetUserAndGroupListSharingCap'
GO

insert into GXDBVersions values(2, 'sec_sharingGetUserAndGroupListSharingCap',  '00010002020000010000', 'sec_sharingGetUserAndGroupListSharingCap', '00010002020000010000')
GO

