

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setStoragePolicyCreator.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_setStoragePolicyCreator
--  |
--  | Description:  setting creator role for SP entity in UMSecurityAssociations
--  |
--  |       Logic copied from addUserToArchGroup
--  |
--  |
--  |
--  |
--  |
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_setStoragePolicyCreator <<<'

IF EXISTS (select * from sysobjects where name='sec_setStoragePolicyCreator')
	drop procedure sec_setStoragePolicyCreator
IF EXISTS (select * from GxQscripts where name='sec_setStoragePolicyCreator')
	delete from GxQscripts where name = 'sec_setStoragePolicyCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setStoragePolicyCreator')
	delete from GXDBVersions where aliasname = 'sec_setStoragePolicyCreator'
GO
print '... Creating Procedure: sec_setStoragePolicyCreator'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setStoragePolicyCreator
  @creatorUserId INT,			
  @archGroupId INT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
	DECLARE @userHasRights INT = 0
DECLARE @capRequired BIGINT = CAST(POWER(2.0, 10 - 1) AS bigint)
	EXEC sec_userHasCapability @creatorUserId, @capRequired, @userHasRights OUTPUT
	IF @userHasRights = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'User does not have [Media Management] rights to perform this operation'
		GOTO PROC_EXIT
	END
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(10 AS NVARCHAR(10))
	-- Setting Storage Policy Mangement permission for the creator.
SET @permissionsList = @permissionsList + ',' + CAST(4 AS NVARCHAR(10))
SET @permissionsList = @permissionsList + ',' + CAST(107 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @creatorUserId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 17, @archGroupId
	PROC_EXIT:
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setStoragePolicyCreator')
	delete from GxQscripts where name = 'sec_setStoragePolicyCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setStoragePolicyCreator')
	delete from GXDBVersions where aliasname = 'sec_setStoragePolicyCreator'
GO

insert into GXDBVersions values(2, 'sec_setStoragePolicyCreator',  '00000000000000000000', 'sec_setStoragePolicyCreator', '00000000000000000000')
GO

