

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setSecurityAssociationsFromUserOrUserGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_setSecurityAssociationsFromUserOrUserGroup')
BEGIN
	print '>>> Drop Stored Procedure: sec_setSecurityAssociationsFromUserOrUserGroup <<<'
	drop procedure sec_setSecurityAssociationsFromUserOrUserGroup
END
IF EXISTS (select * from GxQscripts where name='sec_setSecurityAssociationsFromUserOrUserGroup')
	delete from GxQscripts where name = 'sec_setSecurityAssociationsFromUserOrUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssociationsFromUserOrUserGroup')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssociationsFromUserOrUserGroup'
GO
print '... Creating Procedure: sec_setSecurityAssociationsFromUserOrUserGroup'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_setSecurityAssociationsFromUserOrUserGroup
  @xmlIn XML,
  @userIdDoingThis INT,
  @userId INT,
  @userGroupId INT,
  @isCmdLine INT
AS
--Output variables
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(1024)
	 SET @errorCode = 0			--be optimistic
	 SET @errorString = 'Successful'
	 DECLARE @localeId INT
	 DECLARE @invalidChar NVARCHAR(MAX) = ''
	--Read inputs
	DECLARE @associationsOperationType AS INT
	DECLARE @processHiddenPermissions AS INT =0
	SET @associationsOperationType = ISNULL((SELECT ref.value('@associationsOperationType','INT') AS role
										FROM @xmlIn.nodes('App_SecurityAssociationForUserOrGroupList') R (ref)),0)
	SET @localeId = ISNULL((SELECT ref.value('@localeId','INT') AS role
										FROM @xmlIn.nodes('App_SecurityAssociationForUserOrGroupList/processinginstructioninfo') R (ref)),0)
	SET @processHiddenPermissions = ISNULL((SELECT ref.value('@processHiddenPermission','INT') AS role
										FROM @xmlIn.nodes('App_SecurityAssociationForUserOrGroupList') R (ref)),0)
	DECLARE @inputtempTable TABLE
	(
				entityType1 INT,
				entityId1 INT,
				entityType2 INT,
				entityId2 INT,
				entityType3 INT,
				entityId3 INT,
				entityType4 INT,
				entityId4 INT,
				entityType5 INT,
				entityId5 INT,
				entityAssociatedBlob XML,
				entityAssociatedModifiedBlob XML,
				roleId INT,
				roleName NVARCHAR(MAX),
				permissionId INT,
				permissionName NVARCHAR(MAX),
				includeAll INT,
				customRoleXML XML,
				entityCompanyId INT DEFAULT 0
	)
	INSERT INTO @inputTempTable(entityAssociatedBlob, roleId, roleName, permissionId, permissionName, includeAll)
		SELECT Entity.query('.'),
			   ISNULL(R.value('(@roleId)[1]', 'INT'), 0),
			   ISNULL(R.value('(@roleName)[1]', 'NVARCHAR(MAX)'), N''),
			   0,
			   N'',
			   ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0)
		FROM @xmlIn.nodes('App_SecurityAssociationForUserOrGroupList/associations/entities/entity') AS Input(Entity)
		CROSS APPLY
		Input.entity.nodes('../../properties/role') AS Role(R)
	INSERT INTO @inputTempTable(entityAssociatedBlob, roleId, roleName, permissionId, permissionName, includeAll)
		SELECT Entity.query('.'),
			   0,
			   N'',
			   ISNULL(P.value('(@permissionId)[1]', 'INT'), 0),
			   ISNULL(P.value('(@permissionName)[1]', 'NVARCHAR(MAX)'), N''),
			   ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0)
		FROM @xmlIn.nodes('App_SecurityAssociationForUserOrGroupList/associations/entities/entity') AS Input(Entity)
		CROSS APPLY
		Input.entity.nodes('../../properties/permissions') AS Permissions(P)
		INSERT INTO @inputTempTable(entityAssociatedBlob, roleId, roleName, permissionId, permissionName, includeAll,customRoleXMl)
		SELECT Entity.query('.'),
			   0,
			   N'',
			  0,
			   N'',
			   ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0),
			   R.query('categoryPermission')
		FROM @xmlIn.nodes('App_SecurityAssociationForUserOrGroupList/associations/entities/entity') AS Input(Entity)
		CROSS APPLY
			Input.Entity.nodes('../../properties') AS CR(R)
		WHERE R.exist('categoryPermission')<>0
	UPDATE @inputtempTable
	SET entityAssociatedModifiedBlob = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(entityAssociatedBlob)
	UPDATE @inputtempTable
	SET entityType1 = (SELECT ref.value('@entityType1', 'INT') AS entityType1
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId1 = (SELECT ref.value('@entityId1', 'INT') AS entityId1
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType2 = (SELECT ref.value('@entityType2', 'INT') AS entityType2
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId2 = (SELECT ref.value('@entityId2', 'INT') AS entityId2
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType3 = (SELECT ref.value('@entityType3', 'INT') AS entityType3
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId3 = (SELECT ref.value('@entityId3', 'INT') AS entityId3
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType4 = (SELECT ref.value('@entityType4', 'INT') AS entityType4
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId4 = (SELECT ref.value('@entityId4', 'INT') AS entityId4
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityType5 = (SELECT ref.value('@entityType5', 'INT') AS entityType5
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
		entityId5 = (SELECT ref.value('@entityId5', 'INT') AS entityId5
					   FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	DELETE tbl
	FrOM @inputTempTable tbl
	WHERE permissionId<>0 and exists( SELECT 1 FROM @inputTempTable tbl2 WHERE  tbl.entityType1=tbl2.entityType1 and tbl.entityId1 =tbl2.entityId1 and
																				tbl.entityType2=tbl2.entityType2 and tbl.entityId2 =tbl2.entityId2 and
																				tbl.entityType3=tbl2.entityType3 and tbl.entityId3 =tbl2.entityId3 and
																				tbl.entityType4=tbl2.entityType4 and tbl.entityId4 =tbl2.entityId4 and
																				tbl.entityType5=tbl2.entityType5 and tbl.entityId5 =tbl2.entityId5 and
																				tbl.includeALL=tbl2.includeALL and
																				 tbl2.customRoleXML.exist('categoryPermission')<>0)
	--we will save EXTERNAL_GROUP_ENTITY as USERGROUP_ENTITY in security tables
	UPDATE @inputTempTable
SET entityType1 = 15
WHERE entityType1 = 62		--ids are anyhow going to be same
	IF @isCmdLine = 1
	BEGIN
		--a. Role id is mandatory
		IF EXISTS (SELECT * FROM @inputTempTable WHERE roleId <= 0 AND permissionId <= 0 AND customRoleXml.exist('categoryPermission')=0)
		BEGIN
			SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ roleName
														 FROM @inputtemptable
														 WHERE roleId <= 0 AND roleName <> ''
														 FOR XML PATH('')), 2, 2147483647), ''))
			IF @invalidChar <> ''
			BEGIN
SET @errorCode = (2425 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2425 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
				SET @invalidChar = ''
			END
			SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ permissionName
														 FROM @inputtemptable
														 WHERE permissionId <= 0 AND permissionName <> ''
														 FOR XML PATH('')), 2, 2147483647), ''))
			IF @invalidChar <> ''
			BEGIN
SET @errorCode = (2426 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2426 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeID = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
				SET @invalidChar = ''
			END
			GOTO END_PROCESSING
		END
		--b. Sanity check: Either one of entityId(1) or includeAll flag must be set for all the associations (unless it is all associations)
		--Cannot specify entityId(1) or includeAll(1) for all associations
		IF EXISTS (SELECT *
				   FROM @inputtempTable
WHERE ((entityType1 = 1 AND includeAll = 1) OR
				          (entityId1 <> 0 AND includeAll <> 0)))
		BEGIN
SET @errorCode = (2430 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2430 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeID = @localeId)
			GOTO END_PROCESSING
		END
	END
	--Verify that entity company id and user company id are associated with each other.
	DECLARE @companyIdOfUser INT = 0
	SET @companyIdOfUser = dbo.AppGetCompanyForUserOrUserGroup(
	CASE WHEN @userId <> 0 THEN @userId ELSE @userGroupId END,
	CASE WHEN @userId <> 0 THEN 1 ELSE 0 END)
DECLARE @entType INT = CASE WHEN @userId <> 0 THEN 13 ELSE 15 END
	DECLARE @entId INT = CASE WHEN @userId <> 0 THEN @userId ELSE @userGroupId END
IF OBJECT_ID('tempdb.dbo.#validCompaniesOfCompanyUser') IS NOT NULL
    DROP TABLE #validCompaniesOfCompanyUser
CREATE TABLE #validCompaniesOfCompanyUser
    (
        companyId INT NOT NULL
        primary key (companyId)
    )
DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
IF @doNotUseCompanyEntitiesTableForFiltering = 1
BEGIN
	SET @companyIdOfUser = 0
END
IF @companyIdOfUser <> 0
BEGIN
    declare @parentCompanyId int = @companyIdOfUser
        ;with parentCompany as
        (
            select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            union all
            select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select childCompanyId
        from parentCompany
    declare @childCompanyId int = @companyIdOfUser
        ;with childCompany as
        (
            select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
            union all
            select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select parentCompanyId
        from childCompany
    INSERT INTO #validCompaniesOfCompanyUser values (@companyIdOfUser) , (0)   -- Company Id 0 For MSP entities
END
	IF @companyIdOfUser <> 0
	BEGIN
		UPDATE @inputtempTable
		SET entityCompanyId = ISNULL((SELECT companyId
								FROM App_CompanyEntities App
								WHERE entityType =
									CASE WHEN entityType5 <> 0 THEN entityType5
										 WHEN entityType4 <> 0 THEN entityType4
										 WHEN entityType3 <> 0 THEN entityType3
										  ELSE entityType1 END
									AND entityId =
									CASE WHEN entityId5 <> 0 THEN entityId5
										 WHEN entityId4 <> 0 THEN entityId4
										 WHEN entityId3 <> 0 THEN entityId3
										  ELSE entityId1 END), 0)
		DECLARE @entityCompanyId INT
		DECLARE @entityType1 INT, @entityId1 INT, @entityType2 INT, @entityId2 INT, @entityType3 INT, @entityId3 INT, @entityType4 INT, @entityId4 INT, @entityType5 INT, @entityId5 INT
		SELECT top 1 @entityCompanyId = entityCompanyId, @entityType1 = entityType1, @entityId1 = entityId1, @entityType2 = entityType2, @entityId2 = entityId2, @entityType3 = entityType3, @entityId3 = entityId3,
		  @entityType4 = entityType4, @entityId4 = entityId4, @entityType5 = entityType5, @entityId5 = entityId5
		FROM @inputtempTable I
		LEFT JOIN #validCompaniesOfCompanyUser C
			ON I.entityCompanyId = C.companyId
		WHERE entityCompanyId <> 0
			AND C.companyId IS NULL
		IF @entityCompanyId <> 0 AND @entityCompanyId IS NOT NULL
		BEGIN
			DECLARE @userCompanyName NVARCHAR(255)
			SELECT @userCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @companyIdOfUser), N'')
			DECLARE @entityCompanyName NVARCHAR(255)
			SELECT @entityCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @entityCompanyId), N'')
SET @errorCode = (4653 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4653 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @userCompanyName )
			EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
			SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
			SET @errorString = REPLACE(@errorString, '^3%s', @entityCompanyName )
			GOTO END_PROCESSING
		END
		DECLARE @roleCompanyId INT = 0
		SELECT @roleCompanyId = ACE.companyId
				FROM @inputTempTable I
				INNER JOIN App_companyEntities ACE WITH(NOLOCK)
ON ACE.entityType = 120
						AND ACE.entityId = I.roleId
				LEFT JOIN #validCompaniesOfCompanyUser C
					ON ACE.companyId = C.companyId
				WHERE C.companyId IS NULL
		IF @roleCompanyId > 0 AND @roleCompanyId IS NOT NULL
		BEGIN
			DECLARE @roleCompanyName NVARCHAR(255)
			SELECT @roleCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @roleCompanyId), N'')
			SELECT @userCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @companyIdOfUser), N'')
SET @errorCode = (4713 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4713 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @roleCompanyName )
			EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entType, @entId, 0, 0, 0, 0, 0, 0, 0, 0
			SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
			SET @errorString = REPLACE(@errorString, '^3%s', @userCompanyName )
			GOTO END_PROCESSING
		END
	END
	ELSE
	BEGIN
		SELECT @roleCompanyId = ACE.companyId
		FROM @inputTempTable I
		INNER JOIN App_companyEntities ACE WITH(NOLOCK)
ON ACE.entityType = 120
				AND ACE.entityId = I.roleId
		IF @roleCompanyId > 0 AND @roleCompanyId IS NOT NULL
		BEGIN
			SELECT @roleCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @roleCompanyId), N'')
SET @errorCode = (4715 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4715 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @roleCompanyName )
			EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entType, @entId, 0, 0, 0, 0, 0, 0, 0, 0
			SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
			GOTO END_PROCESSING
		END
	END
	IF OBJECT_ID ('tempdb.dbo.#inputConsolidated') IS NOT NULL DROP TABLE #inputConsolidated
	CREATE TABLE #inputConsolidated
	(
		entityType1 INT,
		entityId1 INT,
		entityType2 INT,
		entityId2 INT,
		entityType3 INT,
		entityId3 INT,
		entityType4 INT,
		entityId4 INT,
		entityType5 INT,
		entityId5 INT,
		roleId INT,
		permissionId INT,
		userOrGroupId INT,
		isUser INT,
		includeAll INT,
		customRoleXML XML
	)
	INSERT INTO #inputConsolidated
		SELECT  entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5,
			   roleId, permissionId,
			   CASE WHEN @userId <> 0 THEN @userId ELSE @userGroupId END,
			   CASE WHEN @userId <> 0 THEN 1 ELSE 0 END,
			   includeAll ,customRoleXML
		FROM @inputTempTable
	EXEC sec_populateSecurityAssociationsTable @userIdDoingThis, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, @userId , @userGroupId , 2, @associationsOperationType, @localeId, 0, @errorCode OUTPUT, @errorString OUTPUT,@processHiddenPermissions
	IF OBJECT_ID ('tempdb.dbo.#inputConsolidated') IS NOT NULL DROP TABLE #inputConsolidated
	END_PROCESSING:
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setSecurityAssociationsFromUserOrUserGroup')
	delete from GxQscripts where name = 'sec_setSecurityAssociationsFromUserOrUserGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssociationsFromUserOrUserGroup')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssociationsFromUserOrUserGroup'
GO

insert into GXDBVersions values(2, 'sec_setSecurityAssociationsFromUserOrUserGroup',  '00000000000000000000', 'sec_setSecurityAssociationsFromUserOrUserGroup', '00000000000000000000')
GO

