

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setSecurityAssociationsFromEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------------
--      This SP is used to perform explicit security associations from entity level
--      and owner associations
--      Specify the entity on which the security associations is to be done
--      and the list of <role - user / group> combinations
--
--      The user who is doing this operation should have
--			1. Associate role for user or user groups to entity permission on the entity
--			2. All the permissions specified in the roles that are part of this modification
--			3. Should be able to see the users and user groups in the associations
--
--		skipSecurityCheck is a flag when set to 1 will skip the above 3 checks
--
--		Authors: jswaminathan & saggarwal
-- -----------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_setSecurityAssociationsFromEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_setSecurityAssociationsFromEntity <<<'
	drop procedure sec_setSecurityAssociationsFromEntity
END
IF EXISTS (select * from GxQscripts where name='sec_setSecurityAssociationsFromEntity')
	delete from GxQscripts where name = 'sec_setSecurityAssociationsFromEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssociationsFromEntity')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssociationsFromEntity'
GO
print '... Creating Procedure: sec_setSecurityAssociationsFromEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_setSecurityAssociationsFromEntity
  @xmlIn XML,
  @userId INT,
  @isCmdLine INT,
  @skipSecurityCheck INT, 
  @entityType1 INT,
  @entityId1 INT,
  @entityType2 INT,
  @entityId2 INT,
  @entityType3 INT,
  @entityId3 INT,
  @entityType4 INT,
  @entityId4 INT,
  @entityType5 INT,
  @entityId5 INT
AS
--Output variables
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(1024)
	SET @errorCode = 0						--be optimistic
	SET @errorString = 'Successful'
	DECLARE @nowtime AS INT
	SET @nowtime = dbo.GetUnixTime(GETUTCDATE())
	DECLARE @invalidChar NVARCHAR(MAX) = N''
	DECLARE @localeId INT
	DECLARE @processHiddenPermissions INT =0
	DECLARE @isServiceCommcell INT=0
		--check if its service commcell
			IF EXISTS (SELECT 1 FROM APP_CommCell AC
inner join APP_ComponentProp ACP on AC.id = ACP.componentId where componentType = 1048  and propertyTypeId = 2 and AC.id=2
						and longVal=1)
						SET @isServiceCommcell=1
	--Read inputs
	DECLARE @associationsOperationType AS INT
	SET @associationsOperationType = ISNULL((SELECT ref.value('@associationsOperationType','INT') AS role
										FROM @xmlIn.nodes('App_SecurityAssociationForEntityList') R (ref)),0)
	SET @localeId = ISNULL((SELECT ref.value('@localeId','INT') AS role
										FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/processinginstructioninfo') R (ref)),0)
	SET @processHiddenPermissions = ISNULL((SELECT ref.value('@processHiddenPermission','INT') AS role
										FROM @xmlIn.nodes('App_SecurityAssociationForEntityList') R (ref)),0)
IF @entityType1 = 62			--we are merging external group entity with user group entity. If some one calls this SP with external group entity, convert to user group entity
SET @entityType1 = 15
	DECLARE @inputTempTable TABLE
	(
		userId INT,
		userName NVARCHAR(MAX),
		userGroupId INT,
		userGroupName NVARCHAR(MAX),
		providerId INT,
		providerName NVARCHAR(MAX),
		roleId INT,
		roleName NVARCHAR(MAX),
		permissionId INT,
		permissionName NVARCHAR(MAX),
		customRoleXML XML,
		umGUID VARCHAR(255)
	)
	INSERT INTO @inputTempTable (userId, userName, userGroupId, userGroupName, providerId, providerName, roleId, roleName, permissionId, permissionName,umGUID)
		SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@userName)[1]', 'NVARCHAR(MAX)'), N''),
			   CASE WHEN UG.value('(@userGroupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@userGroupId)[1]', 'INT')
					WHEN UG.value('(@groupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@groupId)[1]', 'INT')
					ELSE 0
			   END,
			   CASE WHEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)')
					WHEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)')
					ELSE N''
			   END,
			   ISNULL(UG.value('(@providerId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@providerDomainName)[1]', 'NVARCHAR(MAX)'), N''),
			   ISNULL(R.value('(@roleId)[1]', 'INT'), 0),
			   ISNULL(R.value('(@roleName)[1]', 'NVARCHAR(MAX)'), N''),
			   0,
			   N'',
			    CASE WHEN UG.value('(@userGUID)[1]', 'VARCHAR(255)') IS NOT NULL THEN UG.value('(@userGUID)[1]', 'VARCHAR(255)')
				     WHEN UG.value('(@GUID)[1]', 'VARCHAR(255)') IS NOT NULL THEN UG.value('(@GUID)[1]', 'VARCHAR(255)')
					 ELSE  NEWID()
					 END
		FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/associations/userOrGroup') AS Input(UG)
		CROSS APPLY
		Input.UG.nodes('../properties/role') AS Role(R)
	INSERT INTO @inputTempTable (userId, userName, userGroupId, userGroupName, providerId, providerName, roleId, roleName, permissionId, permissionName,umGUID)
		SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@userName)[1]', 'NVARCHAR(MAX)'), N''),
			   CASE WHEN UG.value('(@userGroupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@userGroupId)[1]', 'INT')
					WHEN UG.value('(@groupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@groupId)[1]', 'INT')
					ELSE 0
			   END,
			   CASE WHEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)')
					WHEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)')
					ELSE N''
			   END,
			   ISNULL(UG.value('(@providerId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@providerDomainName)[1]', 'NVARCHAR(MAX)'), N''),
			   0,
			   N'',
			   ISNULL(P.value('(@permissionId)[1]', 'INT'), 0),
			   ISNULL(P.value('(@permissionName)[1]', 'NVARCHAR(MAX)'), N'')
			   ,
			    CASE WHEN UG.value('(@userGUID)[1]', 'VARCHAR(255)') IS NOT NULL THEN UG.value('(@userGUID)[1]', 'VARCHAR(255)')
				     WHEN UG.value('(@GUID)[1]', 'VARCHAR(255)') IS NOT NULL THEN UG.value('(@GUID)[1]', 'VARCHAR(255)')
					 ELSE  NEWID()
					 END
		FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/associations/userOrGroup') AS Input(UG)
		CROSS APPLY
		Input.UG.nodes('../properties/permissions') AS Permissions(P)
	INSERT INTO @inputTempTable (userId, userName, userGroupId, userGroupName, providerId, providerName, roleId, roleName, permissionId, permissionName,customRoleXML,umGUID)
		SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@userName)[1]', 'NVARCHAR(MAX)'), N''),
			   CASE WHEN UG.value('(@userGroupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@userGroupId)[1]', 'INT')
					WHEN UG.value('(@groupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@groupId)[1]', 'INT')
					ELSE 0
			   END,
			   CASE WHEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)')
					WHEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)')
					ELSE N''
			   END,
			   ISNULL(UG.value('(@providerId)[1]', 'INT'), 0),
			   ISNULL(UG.value('(@providerDomainName)[1]', 'NVARCHAR(MAX)'), N''),
			   0,
			   N'',
			   0,
			   N'',
			   R.query('categoryPermission'),
			    CASE WHEN UG.value('(@userGUID)[1]', 'VARCHAR(255)') IS NOT NULL THEN UG.value('(@userGUID)[1]', 'VARCHAR(255)')
				     WHEN UG.value('(@GUID)[1]', 'VARCHAR(255)') IS NOT NULL THEN UG.value('(@GUID)[1]', 'VARCHAR(255)')
					 ELSE NEWID()
					 END
		FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/associations/userOrGroup') AS Input(UG)
		CROSS APPLY
		Input.UG.nodes('../properties') AS CR(R)
		WHERE R.exist('categoryPermission')<>0
	--If categoryPermissionXMl is user/userGroup combination than we should not process individual permission for same. This is needed until we have not change all application layer code.
DECLARE @mapRoleId INT=(SELECT TOP 1 id from UMROles where flags& 2048<>0 )
	  IF(@isServiceCommcell=1)
            BEGIN
                --its a local CS, so request will have userId, groupId , roleId of global CS
				INSERT UMDSProviders (domainName, hostName, description, login, password, trustedHostUser, trustedHostPW, flags, enabled, serviceType,
                            modified, dnsRoot, dnsRootStatus, useSecureLdap, origCCId, GUID, port, resourceId, checkTime,ownerCompany,ownerId )
				SELECT DISTINCT SUBSTRING(umEntity, 1, CHARINDEX('\', umEntity, 1)-1),SUBSTRING(umEntity, 1, CHARINDEX('\', umEntity, 1)-1) ,'synced from IDP',
				'', '', '', '', 0x0004, 1, 12,
                            0,'','',0, 0, newid(), 0, 0,86400,0,1
				FROM	(SELECT username  as umEntity FROM @inputTempTable
						UNION
						SELECT userGroupName as umEntity from @inputTempTable ) TBL
					LEFT JOIN UMDSProviders Prov
					ON  SUBSTRING(umEntity, 1, CHARINDEX('\', umEntity, 1)-1) = Prov.domainName
					where Prov.id IS NULL and Tbl.umEntity <> N''
				and CHARINDEX('\', umEntity, 1)<>0
				UPDATE @inputTempTable
				set providerName = SUBSTRING(userGroupName, 1, CHARINDEX('\', userGroupName, 1)-1)
				,userGroupName= SUBSTRING(userGroupName, CHARINDEX('\', userGroupName, 1)+1, LEN(usergroupNAme))
				WHERE CHARINDEX('\', userGroupName, 1)<>0
                INSERT INTO UMUsers([name]
                ,[description]
                ,[login]
                ,[password]
                ,[email]
                ,[datePasswordSet]
                ,[dateExpires]
                ,[policy]
                ,[enabled]
                ,[flags]
                ,[modified]
                ,[pVer]
                ,[Pager]
                ,[lastLogInTime]
                ,[credSetTime]
                ,[umDSproviderId]
                ,[userGuid]
                ,[origUserGuid])
    SELECT  userName,'From Global CS',userName,'dummy password','update later',0,0,0,1,1,0,0,0,0,0,providerId,umGUID,''
    from
    (SELECT DISTINCT userNAme,Prov.id as providerId,umGUID FROM @inputTempTable Tbl JOIN UMDSProviders Prov ON  SUBSTRING(userName, 1, CHARINDEX('\', userName, 1)-1) = Prov.domainName LEFT  JOIN UMUsers Users on Users.login=userName
    where USers.id IS NULL and Tbl.userName <> N''
    and CHARINDEX('\', userName, 1)<>0) tbl
         INSERT INTO UMUsers([name]
                ,[description]
                ,[login]
                ,[password]
                ,[email]
                ,[datePasswordSet]
                ,[dateExpires]
                ,[policy]
                ,[enabled]
                ,[flags]
                ,[modified]
                ,[pVer]
                ,[Pager]
                ,[lastLogInTime]
                ,[credSetTime]
                ,[umDSproviderId]
                ,[userGuid]
                ,[origUserGuid])
    SELECT DISTINCT userName,'From Global CS',userName,'dummy password','update later',0,0,0,1,1,0,0,0,0,0,0,umGUID,''
        from
    (SELECT DISTINCT userNAme,umGUID FROM @inputTempTable Tbl  LEFT  JOIN UMUsers Users on Users.login=userName
    where USers.id IS NULL and Tbl.userName <> N''
    and CHARINDEX('\', userName, 1)=0) tbl
	--For USERGROUP we have special check as per GUID
	--Lets update group as per  guid. if the ky is set
	DECLARE @MergeSameGroupName INT = ISNULL((select value from GXGlobalParam where name='bMergeGroupMultiCommcell' and modified=0 ),1)
	if(@MergeSameGroupName=0)
	BEGIN
	DECLARE @CommcellType varchar(255)
DECLARE @globalCommcellName  nvarchar(255)
DECLARE @o_commcellName nvarchar(255)
DECLARE @o_errorCode INT
DECLARE @o_errorStr nvarchar(MAX)
EXEC MCC_GetCommcellTypeAndNameForMultiCommcell  0 ,@commcellType OUTPUT, @globalCommcellName OUTPUT,@o_commcellName OUTPUT , @o_errorCode OUTPUT,@o_errorStr OUTPUT
	  --first lets update input table with name present in DB.
	   update @inputTempTable
	   set usergroupName = G.name
	   FROM @inputTempTable TBL JOIN UMgroups G ON TBL.umGUID= G.guid and TBL.userGRoupName<>'' and TBL.providerID=0 and G.umdsproviderId=0
	   update @inputTempTable
	   set usergroupName = @globalCommcellName +'_'+G.name
	   FROM @inputTempTable TBL JOIN UMgroups G ON TBL.umGUID<> G.guid and TBL.userGRoupName=G.name and TBL.providerID=0 and G.umdsproviderId=0 and TBL.userGRoupName<>''
	 END
         INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, email, GUID, umdsProviderId, origCCId)
		SELECT 1 , 0, 0, 1,userGroupName, 'Auto-Created group for Multicommcell', '', umGUID, PROVIDERiD, 2
		from
		(select distinct userGroupName,0 as providerId,umGUID
		FROM @inputTempTable member LEFT JOIN UMGroups UG  on member.userGroupName=UG.name
			WHERE UG.id is NULL and member.userGroupName <> N'' and providerName='' and providerId=0
			UNION
			select distinct userGroupName,P.id as providerId,umGUID
		FROM @inputTempTable member JOIN UMDSpRoviders P ON  ((member.providerID<>0 and P.id=member.providerId) Or P.domainName=member.providerName)
		 LEFT JOIN UMGroups UG  on member.userGroupName=UG.name   AND Ug.umdsProviderId=P.id
			WHERE UG.id is NULL and member.userGroupName <> N'') AS TBL
  END
	DELETE tbl
	FrOM @inputTempTable tbl
	WHERE permissionId<>0 and exists( SELECT 1 FROM @inputTempTable tbl2 WHERE  tbl.userId=tbl2.userId and tbl.userGroupId=tbl2.userGroupId and tbl2.customRoleXML.exist('categoryPermission')<>0)
	UPDATE Tbl
	SET Tbl.userId = Users.id
	FROM @inputTempTable Tbl INNER JOIN UMUsers Users
	ON Tbl.userName = Users.login
	WHERE Tbl.userName <> N'' AND Tbl.userID <= 0
	--user groups that came as external group entity
	UPDATE Tbl
	SET Tbl.userGroupId = Groups.id
	FROM @inputTempTable Tbl INNER JOIN UMGroups Groups
	ON Tbl.userGroupName = Groups.name AND Tbl.providerId = Groups.umdsProviderId
	WHERE Tbl.userGroupName <> N'' AND CHARINDEX('\', userGroupName, 1) <= 0 AND Tbl.userGroupId <= 0
	--user groups that came as user group entity
	UPDATE Tbl
	SET Tbl.userGroupId = Groups.id, Tbl.providerID = Groups.umdsProviderID
	FROM @inputTempTable Tbl INNER JOIN UMDSProviders Prov
	ON SUBSTRING(userGroupName, 1, CHARINDEX('\', userGroupName, 1)-1) = Prov.domainName
	INNER JOIN UMGroups Groups
	ON SUBSTRING(userGroupName, CHARINDEX('\', userGroupName, 1)+1, LEN(userGroupName)) = Groups.name AND Prov.id = Groups.umdsProviderId
	WHERE Tbl.userGroupName <> N'' AND CHARINDEX('\', userGroupName, 1) > 0 AND Tbl.userGroupId <= 0
	UPDATE Tbl
	SET Tbl.userGroupId = Groups.id, Tbl.providerID = Groups.umdsProviderID
	FROM @inputTempTable Tbl INNER JOIN UMDSProviders Prov
	ON Tbl.providerName = Prov.domainName
	INNER JOIN UMGroups Groups
	ON userGroupName = Groups.name AND Prov.id = Groups.umdsProviderId
	WHERE Tbl.userGroupName <> N''AND Tbl.userGroupId <= 0 AND TBL.providerName<>'N'
	--if AD users/groups are hidden and coming in input xml, then the caller wants to explicitly add them - meaning unhide them.
	UPDATE UMUsers
SET flags = flags & ~(CAST(0x004 AS INT))
	FROM @inputTempTable
	WHERE id = userID AND userID <> 0 AND UMUsers.umdsProviderID <> 0
	UPDATE UMGroups
SET groupflags = groupflags & ~(CAST(0x0020 AS INT))
	FROM @inputTempTable
	WHERE id = userGroupId AND userGroupId <> 0 --AND UMGroups.umdsProviderID IN (SELECT FROM UMDSProviders WHERE serviceType = UMDS_PROVIDER_ACTIVE_DIR)
	--Sanity check
		--a. Role id or permissionId is mandatory
		IF EXISTS (SELECT * FROM @inputTempTable WHERE roleId <= 0 AND permissionId <= 0 AND customRoleXml.exist('categoryPermission')=0)
		BEGIN
			SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ roleName
														 FROM @inputtemptable
														 WHERE roleId <= 0 AND roleName <> ''
														 FOR XML PATH ('')), 2, 2147483647), ''))
			IF @invalidChar <> ''
			BEGIN
SET @errorCode = (2425 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2425 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
				SET @invalidChar = ''
			END
			SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ permissionName
														 FROM @inputtemptable
														 WHERE permissionId <= 0 AND permissionName <> ''
														 FOR XML PATH ('')), 2, 2147483647), ''))
			IF @invalidChar <> ''
			BEGIN
SET @errorCode = (2426 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2426 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
				SET @invalidChar = ''
			END
			GOTO END_PROCESSING
		END
		--b. userId
		IF EXISTS (SELECT * FROM @inputTempTable WHERE userId <= 0 AND userName <> N'')
		BEGIN
			SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ userName
														 FROM @inputtemptable
														 WHERE userId <= 0 AND userName <> N''
														 FOR XML PATH ('')), 2, 2147483647), ''))
SET @errorCode = (2427 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2427 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
			GOTO END_PROCESSING
		END
		--c. userGroupId
		IF EXISTS (SELECT * FROM @inputTempTable WHERE userGroupId <= 0 AND userGroupName <> N'')
		BEGIN
			SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ userGroupName
														 FROM @inputtemptable
														 WHERE userGroupId <= 0 AND userGroupName <> N''
														 FOR XML PATH ('')), 2, 2147483647), ''))
SET @errorCode = (2428 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2428 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
			GOTO END_PROCESSING
		END
		--d. 1. Verify that entity company id and user company id are associated with each other.
		--   2. Verify that entity company id and role company id are associated with each other
		--	 3. If entity is MSP, verify role is MSP
		DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
		SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
		IF @doNotUseCompanyEntitiesTableForFiltering = 0
		BEGIN
			DECLARE @entityCompanyId INT = 0
			SET @entityCompanyId = ISNULL((SELECT companyId
										FROM App_CompanyEntities App
										WHERE entityType =
											CASE WHEN @entityType5 <> 0 THEN @entityType5
												 WHEN @entityType4 <> 0 THEN @entityType4
												 WHEN @entityType3 <> 0 THEN @entityType3
												 ELSE @entityType1 END
											AND entityId =
											CASE WHEN @entityId5 <> 0 THEN @entityId5
												 WHEN @entityId4 <> 0 THEN @entityId4
												 WHEN @entityId3 <> 0 THEN @entityId3
												  ELSE @entityId1 END), 0)
			IF @entityCompanyId <> 0
			BEGIN
				-- TODO: Use code of ValidCompaniesForCompanyUser.spb to populate table #validCompaniesOfEntity
				IF OBJECT_ID('tempdb.dbo.#validCompaniesOfEntity') IS NOT NULL
				DROP TABLE #validCompaniesOfEntity
				CREATE TABLE #validCompaniesOfEntity
					(
						companyId INT NOT NULL
						primary key (companyId)
					)
				INSERT INTO #validCompaniesOfEntity
				select @entityCompanyId
				UNION
				select 0  -- for MSP
				declare @parentCompanyId int = @entityCompanyId
				;with parentCompany as
				(
					select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
					union all
					select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
				)
				INSERT INTO #validCompaniesOfEntity(companyId)
				select childCompanyId
				from parentCompany
				declare @childCompanyId int = @entityCompanyId
				;with childCompany as
				(
					select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
					union all
					select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
				)
				INSERT INTO #validCompaniesOfEntity(companyId)
				select parentCompanyId
				from childCompany
				UPDATE @inputtempTable
				SET providerId = dbo.AppGetCompanyForUserOrUserGroup(
						CASE WHEN userId <> 0 THEN userId
							 WHEN userGroupId <> 0 THEN usergroupId END,
					   CASE WHEN userId <> 0 THEN 1 ELSE 0 END)			-- using providerId column as companyId column for this check.
				DECLARE @userCompanyId INT = 0
				SELECT @userCompanyId = providerId
				FROM @inputTempTable I
				LEFT JOIN #validCompaniesOfEntity C
					ON I.providerId = C.companyId
				WHERE providerId <> 0
					AND C.companyId IS NULL
				IF @userCompanyId <> 0 AND @userCompanyId IS NOT NULL
				BEGIN
					DECLARE @userCompanyName NVARCHAR(255)
					SELECT @userCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @userCompanyId), N'')
					DECLARE @entityCompanyName NVARCHAR(255)
					SELECT @entityCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @entityCompanyId), N'')
SET @errorCode = (4653 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4653 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					SET @errorString = REPLACE(@errorString, '^1%s', @userCompanyName )
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					SET @errorString = REPLACE(@errorString, '^3%s', @entityCompanyName )
					GOTO END_PROCESSING
				END
				DECLARE @roleCompanyId INT = 0
				SELECT @roleCompanyId = ACE.companyId
				FROM @inputTempTable I
				INNER JOIN App_companyEntities ACE WITH(NOLOCK)
ON ACE.entityType = 120
						AND ACE.entityId = I.roleId
				LEFT JOIN #validCompaniesOfEntity C
					ON ACE.companyId = C.companyId
				WHERE C.companyId IS NULL
				IF @roleCompanyId > 0 AND @roleCompanyId IS NOT NULL
				BEGIN
					DECLARE @roleCompanyName NVARCHAR(255)
					SELECT @roleCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @roleCompanyId), N'')
					SELECT @entityCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @entityCompanyId), N'')
SET @errorCode = (4713 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4713 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					SET @errorString = REPLACE(@errorString, '^1%s', @roleCompanyName )
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					SET @errorString = REPLACE(@errorString, '^3%s', @entityCompanyName )
					GOTO END_PROCESSING
				END
			END
			ELSE
			BEGIN
				SELECT @roleCompanyId = ACE.companyId
				FROM @inputTempTable I
				INNER JOIN App_companyEntities ACE WITH(NOLOCK)
ON ACE.entityType = 120
						AND ACE.entityId = I.roleId
				IF @roleCompanyId > 0 AND @roleCompanyId IS NOT NULL
				BEGIN
					SELECT @roleCompanyName = ISNULL((SELECT hostName FROM UMDSProviders WHERE id= @roleCompanyId), N'')
SET @errorCode = (4714 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4714 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					SET @errorString = REPLACE(@errorString, '^1%s', @roleCompanyName )
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					GOTO END_PROCESSING
				END
			END
		END
	--Frame the input consolidated table and call sec_populateSecurityAssociationsTable.sp
	IF OBJECT_ID ('tempdb.dbo.#inputConsolidated') IS NOT NULL DROP TABLE #inputConsolidated
	CREATE TABLE #inputConsolidated
	(
		entityType1 INT,
		entityId1 INT,
		entityType2 INT,
		entityId2 INT,
		entityType3 INT,
		entityId3 INT,
		entityType4 INT,
		entityId4 INT,
		entityType5 INT,
		entityId5 INT,
		roleId INT,
		permissionId INT,
		userOrGroupId INT,
		isUser INT,
		includeAll INT,
		customRoleXML XML
	)
	if(@isServiceCommcell=1)
	BEGIN
	--need to update roleId
DECLARE @commcellNAME VARCHAR(MAX)= (SELECt aliasName from APP_CommCell where id=2)
UPDATE iTBL
set roleName=name
FROM @inputTempTable iTBL JOIN UMRoles on roleNAme= @commcellNAME+'_'+name
INSERT INTO UMRoles(commcellId,name,description,disabled,isPrivate,flags,ownerId,created,modified,GUID)
select 2,roleName,'Inherited from CS',0,0,1,1,datediff(second, '01/01/1970', GETUTCDATE()),0,NEWID()
 FROM @inputTempTable LEFT JOIN UMRoles on ( roleName =name )
 WHERE  name is NULL and roleId > 0
INSERT INTO UMRoleProp (componentNameId,attrName,attrType,attrVal,created,modified)
	SELECT UMRoles.id,'Global roleId',1,roleId,1,0
	FROM @inputTempTable JOIN UMRoles ON roleName =name
	LEFT JOIN UMRoleProp ON componentNameId=roleId and attrName='Global roleId'
	WHERE componentNameId is null
 UPDATE TBL
 set roleId=id
 FROM @inputTempTable TBL JOIN UMRoles ON roleName=name
		  INSERT INTO #inputConsolidated
		  SELECT  @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,
			   @mapRoleId,0,
			   CASE WHEN userId <> 0 THEN userId
					WHEN userGroupId <> 0 THEN usergroupId
			   END,
			   CASE WHEN userId <> 0 THEN 1 ELSE 0 END,
			   0, --hard-coding includeAll to 0 since we cannot select includeAll entities from entity properties
			   ''
		FROM @inputTempTable
	END
	INSERT INTO #inputConsolidated
		SELECT  @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,
			   roleId, permissionId,
			   CASE WHEN userId <> 0 THEN userId
					WHEN userGroupId <> 0 THEN usergroupId
			   END,
			   CASE WHEN userId <> 0 THEN 1 ELSE 0 END,
			   0, --hard-coding includeAll to 0 since we cannot select includeAll entities from entity properties
			   customRoleXML
		FROM @inputTempTable where roleId<>@mapRoleId OR @mapRoleId is NULL
	EXEC sec_populateSecurityAssociationsTable @userId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5, 0, 0, 1, @associationsOperationType, @localeId, @skipSecurityCheck, @errorCode OUTPUT, @errorString OUTPUT,@processHiddenPermissions
	IF OBJECT_ID ('tempdb.dbo.#inputConsolidated') IS NOT NULL DROP TABLE #inputConsolidated
	IF @errorCode <> 0
		GOTO END_PROCESSING
	IF @entityType2 = 0			--we should not call owner protocol when this is called as part of iDA, instance, backupset or subclient properties
		EXEC sec_populateOwnersTable @xmlIn, @userId, @localeId, @isCmdLine, @entityType1, @entityId1, @skipSecurityCheck, @errorCode OUTPUT, @errorString OUTPUT
	END_PROCESSING:
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setSecurityAssociationsFromEntity')
	delete from GxQscripts where name = 'sec_setSecurityAssociationsFromEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssociationsFromEntity')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssociationsFromEntity'
GO

insert into GXDBVersions values(2, 'sec_setSecurityAssociationsFromEntity',  '00000000000000000000', 'sec_setSecurityAssociationsFromEntity', '00000000000000000000')
GO

