

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setSecurityAssociationsForItemBasedEntities.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_setSecurityAssociationsForItemBasedEntities <<<'

IF EXISTS (select * from sysobjects where name='sec_setSecurityAssociationsForItemBasedEntities')
	drop procedure sec_setSecurityAssociationsForItemBasedEntities
IF EXISTS (select * from GxQscripts where name='sec_setSecurityAssociationsForItemBasedEntities')
	delete from GxQscripts where name = 'sec_setSecurityAssociationsForItemBasedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssociationsForItemBasedEntities')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssociationsForItemBasedEntities'
GO
print '... Creating Procedure: sec_setSecurityAssociationsForItemBasedEntities'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setSecurityAssociationsForItemBasedEntities
  @inXML XML,
  @userId INT,
  @isCmdLine INT
AS
/*SET @inXML = '<App_SetSecurityAssociationListForEntityRequest>
  <entityAssociated _type_="7" clientId="2" applicationId="33" instanceId="1" backupsetId="6" subclientId="5"/>
  <entitySecurityAssociations opType="1">
    <securityAssociations>
      <role roleId="4" roleName="ALL Permission" _type_="120" />
      <associationProperties isAllowed="1" isPropagateToChildObjects="1" isTimeBasedAssociation="0">
        <roleValidityDate time="0" />
        <timeZone TimeZoneID="0" />
      </associationProperties>
      <associatedUserOrGroup>
        <associatedUserOrUserGroup _type_="15" userGroupId="1" userGroupName="master" />
      </associatedUserOrGroup>
    </securityAssociations>
  </entitySecurityAssociations>
</App_SetSecurityAssociationListForEntityRequest>'*/
--Output variables
  DECLARE @errorCode INT 
  DECLARE @errorString NVARCHAR(MAX)
--Get the entity type and Id from the inXML
DECLARE @entityType1 AS INT = 0
DECLARE @entityId1 AS INT = 0
DECLARE @entityType2 AS INT = 0
DECLARE @entityId2 AS INT = 0
DECLARE @entityType3 AS INT = 0
DECLARE @entityId3 AS INT = 0
DECLARE @entityType4 AS INT = 0
DECLARE @entityId4 AS INT = 0
DECLARE @entityType5 AS INT = 0
DECLARE @entityId5 AS INT = 0
DECLARE @genericEntityXML XML
DECLARE @entityAssociatedModifiedBlob XML
--1. Get the input entities
DECLARE @inputEntitiesTable TABLE (entityAssociatedBlob XML, entityAssociatedModifiedBlob XML)
INSERT INTO @inputEntitiesTable (entityAssociatedBlob)
	SELECT T.C.query('.')
	FROM @inXML.nodes('App_UpdateSecurityAssociationRequest/entityAssociated/entity') T(C)
UPDATE @inputEntitiesTable
SET entityAssociatedModifiedBlob = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(entityAssociatedBlob)
--2. Get the security associations
DECLARE @securityAssociationsXML AS XML
SET @securityAssociationsXML =  (SELECT T.C.value('@associationsOperationType','INT') AS '@associationsOperationType',
									   T.C.query('associations')
								FROM @inXML.nodes('App_UpdateSecurityAssociationRequest/securityAssociations') T(C)
								FOR XML PATH ('App_SecurityAssociationForEntityList'))
DECLARE @errorTable TABLE(errorCode INT, errorString NVARCHAR(MAX))
--3. For each entity call the sec_setsecurityassociationsfromentityproperties.sp with the securityAssociationsXML
DECLARE inputEntitiesCursor CURSOR STATIC FOR
	SELECT entityAssociatedModifiedBlob
	FROM @inputEntitiesTable
OPEN inputEntitiesCursor
FETCH NEXT FROM inputEntitiesCursor INTO @entityAssociatedModifiedBlob
WHILE @@FETCH_STATUS = 0
BEGIN
	DELETE FROM @errorTable
	SET @entityType1 = (SELECT ref.value('@entityType1', 'INT') AS entityType1
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET @entityId1 = (SELECT ref.value('@entityId1', 'INT') AS entityId1
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType2 = (SELECT ref.value('@entityType2', 'INT') AS entityType2
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId2 = (SELECT ref.value('@entityId2', 'INT') AS entityId2
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType3 = (SELECT ref.value('@entityType3', 'INT') AS entityType3
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId3 = (SELECT ref.value('@entityId3', 'INT') AS entityId3
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType4 = (SELECT ref.value('@entityType4', 'INT') AS entityType4
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId4 = (SELECT ref.value('@entityId4', 'INT') AS entityId4
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityType5 = (SELECT ref.value('@entityType5', 'INT') AS entityType5
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	SET	@entityId5 = (SELECT ref.value('@entityId5', 'INT') AS entityId5
						   FROM @entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
	IF @entityType1 = 0 OR @entityId1 = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Missing entity type or entity id information.'
		GOTO LOOP_EXIT
	END
	INSERT INTO @errorTable
		EXEC [dbo].[sec_setSecurityAssociationsFromEntity] @securityAssociationsXML, @userId, @isCmdLine, 0, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
	SET @errorCode = (SELECT TOP 1 errorcode FROM @errorTable)
	SET @errorString = (SELECT TOP 1 errorString FROM @errorTable )
LOOP_EXIT:
	IF @errorCode <> 0
	BEGIN
		CLOSE inputEntitiesCursor
		DEALLOCATE inputEntitiesCursor
		GOTO ERR_EXIT
	END
	FETCH NEXT FROM inputEntitiesCursor INTO @entityAssociatedModifiedBlob
END
CLOSE inputEntitiesCursor
DEALLOCATE inputEntitiesCursor
ERR_EXIT:
SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setSecurityAssociationsForItemBasedEntities')
	delete from GxQscripts where name = 'sec_setSecurityAssociationsForItemBasedEntities'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssociationsForItemBasedEntities')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssociationsForItemBasedEntities'
GO

insert into GXDBVersions values(2, 'sec_setSecurityAssociationsForItemBasedEntities',  '00000000000000000000', 'sec_setSecurityAssociationsForItemBasedEntities', '00000000000000000000')
GO

