

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setSecurityAssocOnCloudService.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
/*  This SP is for Cloud Service. It will create user if not exists based on
	details received from customer CS.
	a) If user is part of master group in customer CS then, in cloud service it will be added in Tenant Admin group of given company.
	b) If user has any other permissions on customer CS then, in cloud Service it will be added in Tenant Users of given company.
*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_setSecurityAssocOnCloudService')
BEGIN
	print '>>> Drop Stored Procedure: sec_setSecurityAssocOnCloudService <<<'
	drop procedure sec_setSecurityAssocOnCloudService
END
IF EXISTS (select * from GxQscripts where name='sec_setSecurityAssocOnCloudService')
	delete from GxQscripts where name = 'sec_setSecurityAssocOnCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssocOnCloudService')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssocOnCloudService'
GO
print '... Creating Procedure: sec_setSecurityAssocOnCloudService'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_setSecurityAssocOnCloudService
  @i_assocXml XML,
  @i_csGUID nvarchar(255),            
  @i_companyGUID varchar(MAX) 
AS
  DECLARE @o_errorCode INT
  DECLARE @o_errorString VarChar(2048)
  DECLARE @o_userId INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT
DECLARE @errorString VarChar(2048)
DECLARE @userType INT = 1 -- 1 means local user on subscriber and 2 means tenant user on subscriber
DECLARE @isEnabled INT = 0
DECLARE @umdsflags INT = 0
BEGIN TRANSACTION
	BEGIN TRY
		DECLARE @nowTime INT
		SET @nowTime = dbo.GetUnixTime(GETUTCDATE())
		DECLARE @userGuid nvarchar (MAX)= ISNULL((SELECT ref.value('@userGUID','nvarchar(MAX)') FROM @i_assocXml.nodes('/App_GlobalCStoLocalCSUserResponse/users/userEntity') R (ref)),NEWID())
		DECLARE @login NVARCHAR(MAX) = (SELECT ref.value('@userName','nvarchar(MAX)') FROM @i_assocXml.nodes('/App_GlobalCStoLocalCSUserResponse/user/userEntity') R (ref))
		DECLARE @origlogin NVARCHAR(MAX) = @login
		DECLARE @domainId INT =0
		DECLARE @localUserId INT=-1
		DECLARE @email nvarchar(MAX) = (SELECT ref.value('@email','nvarchar(MAX)') FROM @i_assocXml.nodes('/App_GlobalCStoLocalCSUserResponse/user') R (ref))
		DECLARE @isADUser INT = 0
		DECLARE @isAdminUser INT = (SELECT ref.value('@isAdmin', 'int') FROM @i_assocXml.nodes('/App_GlobalCStoLocalCSUserResponse/userRights') R (ref))
		DECLARE @domainName VARCHAR(MAX) = (SELECT ref.value('@providerDomainName','nvarchar(MAX)') FROM @i_assocXml.nodes('/App_GlobalCStoLocalCSUserResponse/user/providerDomain') R (ref))
		DECLARE @mspCompanyGUID nvarchar(256) =  (SELECT ref.value('@GUID','nvarchar(256)') FROM @i_assocXml.nodes('/App_GlobalCStoLocalCSUserResponse/user/company') R (ref))
		-- check for third party app
		DECLARE @thirdPartyAppId INT = 0
		DECLARE @flags INT = ISNULL((SELECT ref.value('@flags','nvarchar(MAX)') FROM @i_assocXml.nodes('/App_GlobalCStoLocalCSUserResponse/user') R (ref)),0)
		SET @thirdPartyAppId = ISNULL((SELECT id from App_ThirdPartyApp WHERE appType = 3 and appName = @i_csGUID),0)
		IF (@thirdPartyAppId = 0)
		BEGIN
			SET @errorCode=1
			SET @errorString=@i_csGUID +': thirdparty app doesnt exist'
			GOTO PROC_EXIT
		END
IF (@flags & 0x8000 = 0x8000)
		BEGIN
			SET @errorCode=1
			SET @errorString= 'Tenant operator login denied.'
			GOTO PROC_EXIT
		END
		DECLARE @cloudServiceCompanyIdForMSP INT = NULL
		IF @mspCompanyGUID IS NOT NULL
		BEGIN
SET @cloudServiceCompanyIdForMSP = (Select  componentNameId from App_CompanyProp where attrName = 'Cloud Service Company MSP Subscriber Guid' and attrVal = @mspCompanyGUID)
			IF @cloudServiceCompanyIdForMSP IS NULL
			BEGIN
				SET @errorCode = 2
				SET @errorString = 'No company associated for on-prim: ' + @i_csGUID
				GOTO PROC_EXIT
			END
		END
		-- check for company guid, (companyguid of customer's company in cloud service is stored in customer's CS: App_componentProp).
		DECLARE @companyId INT = NULL
		DECLARE @companyAlias NVARCHAR(1024) = ''
		-- get company details associated with Third party app
IF EXISTS(SELECT TOP(1) 1 FROM App_ComponentProp WHERE componentType = 1034
AND componentId = @thirdPartyAppId AND propertyTypeId = 5)  -- check if third party app is for on-prim CS registered to cloud
		BEGIN
			SELECT @companyId = UMDS.id, @companyAlias = UMDS.domainName FROM App_ComponentProp ACP
INNER JOIN UMDSProviders UMDS ON UMDS.id = ACP.longlongVal AND UMDS.serviceType = 5
WHERE ACP.componentType = 1034 AND ACP.componentId = @thirdPartyAppId AND ACP.propertyTypeId = 61 AND (@cloudServiceCompanyIdForMSP IS NULL OR @cloudServiceCompanyIdForMSP = UMDS.id)
		END
		IF (@companyId = 0 OR @companyAlias='')
		BEGIN
			SET @errorCode=2
			SET @errorString='No company associated for on-prim: ' + @i_csGUID
			GOTO PROC_EXIT
		END
		IF @mspCompanyGUID IS NOT NULL
		BEGIN
IF NOT EXISTS (Select top 1 id from App_CompanyProp where attrName = 'Cloud Service Company MSP Subscriber Guid' and componentNameId = @companyId and attrVal = @mspCompanyGUID)
			BEGIN
				SET @errorCode = 2
				SET @errorString = 'No company associated for on-prim: ' + @i_csGUID
				GOTO PROC_EXIT
			END
		END
		SELECT  @isEnabled = UMDS.enabled, @umdsflags = UMDS.flags FROM UMDSProviders UMDS WHERE UMDS.id = @companyId
		IF(@isEnabled = 0)
		BEGIN
		    SET @errorCode = 2
		    SET @errorString = 'Company is disabled'
		    GOTO PROC_EXIT
		END
IF(@umdsflags & 0x0010 = 0x0010)
		BEGIN
		    -- check if login is disabled or not
		    DECLARE @loginDisabled INT = 0
SELECT @loginDisabled = attrVal FROM App_CompanyProp WHERE componentNameId = @companyId AND attrName = 'Disable Login'
		    -- if flags = 16 i.e. company deactivated and login is disabled then throw error
		    IF(@loginDisabled = 1)
		    BEGIN
		        SET @errorCode = 2
		        SET @errorString = 'Company is deactivated and login is disabled'
		        GOTO PROC_EXIT
		    END
		END
		-- Get Tenant Admin and Tenant Users for given Company
DECLARE @TenantAdminGrpId INT = ISNULL((SELECT id FROM UMGroups WHERE umdsProviderId = @companyId AND groupFlags & 0x10000 = 0x10000), 0)
DECLARE @TenantUsersGrpId INT = ISNULL((SELECT id FROM UMGroups WHERE umdsProviderId = @companyId AND name = 'Tenant Users'), 0)
		DECLARE @ownerCompany INT = NULL
		-- find if the domain\login format OR only login name given
		DECLARE @pos INT =CHARINDEX('\',@login,1)
		IF @pos  <> 0
		BEGIN
			SET @isADUser = 1
			IF @domainName IS NULL
			BEGIN
				SET @domainName =LTRIM(RTRIM(LEFT(@login,@pos-1)))
				SET @isADUser = 0
			END
			-- check if this domain is already present
			-- if domain is not present then create, if present in same company then go on, if present for different company then error
			SET @domainId = (SELECT id FROM UMDSproviders where domainName=@domainName)
			IF @domainId IS NULL OR @isADUser = 0
				SET @domainId = 0
			IF(@domainId <> 0 AND @isADUser = 1)
			BEGIN
				SELECT @ownerCompany = ownerCompany FROM UMDSProviders WHERE id = @domainId
				IF(@ownerCompany <> @companyId) -- check if owner company of domain is same company associated with tp app
				BEGIN
					SET @errorCode=3
					SET @errorString=@domainName +': cannot create duplicate domain'
					GOTO PROC_EXIT
				END
			END
			IF(@isADUser = 0)
			BEGIN
IF NOT EXISTS(Select TOP 1 attrVal from App_CompanyProp where componentNameId = @companyId and attrName = 'Cloud Service Company MSP Subscriber Guid' AND attrVal= @mspCompanyGUID ) -- company of user is not registered.
				BEGIN
					SET @errorCode=3
					SET @errorString=@domainName +': not registered for cloud service'
					GOTO PROC_EXIT
				END
				SET @login = @companyAlias + '\' + SUBSTRING(@login,charindex('\',@login)+1,LEN(@login))
			END
			IF(@domainId = 0 AND @isADUser = 1)
			BEGIN
				-- Create a dummy domain
				DECLARE @desc NVARCHAR(128) = 'Domain created by system for cloud service at ' + CAST(GETUTCDATE() AS NVARCHAR(64))
				INSERT UMDSProviders (domainName, hostName, description, login, password, trustedHostUser, trustedHostPW, flags, enabled, serviceType,
										modified, dnsRoot, dnsRootStatus, useSecureLdap, origCCId, GUID, port, resourceId, checkTime,ownerCompany,ownerId )
VALUES(@domainName, @domainName, @desc,'', '', '', '', CAST(0x0004 AS INT), 1, 12,
										0,'','',0, default, default, 0, 0,86400,@companyId,1)
				SET @domainId = ISNULL((SELECT id FROM UMDSProviders WITH (READUNCOMMITTED) WHERE hostname = @domainName AND ownerCompany = @companyId),0)
			END
			-- associate domain with third party app
IF(@domainId <> 0 AND NOT EXISTS(SELECT TOP 1 1 FROM App_ComponentProp WHERE componentType = 1034 AND componentId = @thirdPartyAppId AND propertyTypeId = 61 AND dataType = 1 AND longlongVal = @domainId))
			BEGIN
				INSERT INTO APP_ComponentProp (componentType,componentId,propertyTypeId,dataType,longVal,longlongVal,created,modified)
VALUES(1034,@thirdPartyAppId, 61, 1, 0, @domainId, @nowTime, 0)
			END
		END
		ELSE  --include companyAlias as prefix
		BEGIN
			SET @login = @companyAlias + '\' + @login
		END
		--User Insert
		DECLARE @newUserCreated INT = 0
		DECLARE @deletedUserRenewed INT = 0
		SET @localuserId = ISNULL((SELECT TOP(1) id  FROM UMUsers WHERE login = @login ),0)
		IF(@localuserid <> 0)
		BEGIN
			-- safety check : verify company to which user belongs is same as that of company associated with third party app
			DECLARE @u_umdspId INT = 0
			SELECT @u_umdspId = umdsproviderId FROM UMUsers WHERE id = @localuserId
			IF(@u_umdspId = 0) --either user should be company user/ad user inside company
			BEGIN
				SET @errorCode=4
				SET @errorString=@login+': cannot create duplicate user'
				GOTO PROC_EXIT
			END
			ELSE
			BEGIN
				IF(@companyId <> @u_umdspId)
				BEGIN
					DECLARE @u_ownerCompany INT = 0
					SELECT @u_ownerCompany = ownerCompany FROM UMDSProviders WHERE id = @u_umdspId
					IF(@ownerCompany <> @companyId)
					BEGIN
						SET @errorCode=5
						SET @errorString=@login+': cannot create duplicate AD user'
						GOTO PROC_EXIT
					END
				END
			END
		END
		IF(@localUserId=0)
		BEGIN
			IF EXISTS(SELECT 1 FROM UMUsers WHERE login like @login + '(Deleted,%' )
				BEGIN
					SET @localuserId = (SELECT TOP(1) id  FROM UMUsers WHERE login like @login + '(Deleted,%' ORDER BY id DESC)
					UPDATE UMUsers
					SET login = @login,
						flags = 1,
						enabled = 1,
						email = @email,
						umDSproviderId = (CASE WHEN @domainId <> 0 THEN @domainId ELSE  @companyId END)
					WHERE id = @localuserId
					SET @deletedUserRenewed = 1
				END
			ELSE
				BEGIN
					INSERT INTO UMUsers([name]
					,[description]
					,[login]
					,[password]
					,[email]
					,[datePasswordSet]
					,[dateExpires]
					,[policy]
					,[enabled]
					,[flags]
					,[modified]
					,[pVer]
					,[Pager]
					,[lastLogInTime]
					,[credSetTime]
					,[umDSproviderId]
					,[userGuid]
					,[origUserGuid])
					VALUES(@login, --name
					'Auto-Created user for Cloud Service',
					@login, -- login
					'Password Disabled',
					@email,--email
					0,--datePWDset
					0,--dateExpires
					0,--policy
					1,--enabled
					1,--flags
					0,--modified
					0,--pVer
					0,--Pager
					0,--lastLogInTime
					0,--credSetTime
					CASE WHEN @domainId <> 0 THEN @domainId ELSE  @companyId END,
					@userGUID,--userGUID
					''--origUserGuid
					)
					SET @localuserId = SCOPE_IDENTITY()
					SET @newUserCreated = 1
			END
		END
IF EXISTS (select 1 from App_CompanyProp where componentNameId = @companyId and attrName='Cloud Service Company MSP Subscriber Guid')
		BEGIN
			SET @userType = 2
		END
		-- for login redirection
IF (NOT EXISTS(SELECT 1 FROM UMUsersProp WHERE componentNameId = @localuserId AND attrName = 'Cloud service user'  AND modified = 0)) AND (@newUserCreated = 1 OR @deletedUserRenewed = 1)
		BEGIN
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@localuserId, 'Cloud service user', 1, @userType, dbo.GetUnixTime(GETUTCDATE()), 0)
		END
		-- for switcher
IF NOT EXISTS(SELECT 1 FROM UMUsersProp WHERE componentNameId = @localuserId AND attrName = 'Redirected Cloud service user' AND attrVal = '1' AND modified = 0)
        	BEGIN
            		INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@localuserId, 'Redirected Cloud service user', 1, '1', dbo.GetUnixTime(GETUTCDATE()), 0)
        	END
		-- Insert user group association
		-- If user has admin mgmt permission at commcell level in customer cs then add user in Tenant Admin of company
		IF(@newUserCreated = 1 OR @deletedUserRenewed = 1)
		BEGIN
			IF(@isAdminUser = 1)
			BEGIN
				INSERT INTO UMUserGroup (userId, groupId, flag)
				SELECT @localuserId, @TenantAdminGrpId, 0
			END
			ELSE  --otherwise associate user to Tenant Users
			BEGIN
				INSERT INTO UMUserGroup (userId, groupId, flag)
				SELECT @localuserId, @TenantUsersGrpId, 0
			END
		END
		ELSE  -- If user rights are updated in customer CS then update grp membership in cloud service
		BEGIN
			-- remove from tenant admin and associate with tenant users group
			IF (@isAdminUser = 0 AND EXISTS(SELECT 1 FROM UMUserGroup where userId = @localuserId AND groupId = @TenantAdminGrpId))
			BEGIN
				DELETE UM FROM UMUserGroup UM WHERE userId = @localuserId AND groupId = @TenantAdminGrpId
				-- insert into tenant users grp
				IF NOT EXISTS(SELECT 1 FROM UMUserGroup where userId = @localuserId AND groupId = @TenantUsersGrpId)
					INSERT INTO UMUserGroup (userId, groupId, flag)
					SELECT @localuserId, @TenantUsersGrpId, 0
			END
			-- if user is adminuser now, previously it was non-admin then associate with tenant admin grp & remove from tenant users
			IF(@isAdminUser = 1 AND NOT EXISTS(SELECT 1 FROM UMUserGroup where userId = @localuserId AND groupId = @TenantAdminGrpId))
			BEGIN
				INSERT INTO UMUserGroup (userId, groupId, flag)
				SELECT @localuserId, @TenantAdminGrpId, 0
				-- remove from tenant users grp if exists
				IF EXISTS(SELECT 1 FROM UMUserGroup where userId = @localuserId AND groupId = @TenantUsersGrpId)
				BEGIN
					DELETE UM FROM UMUserGroup UM WHERE userId = @localuserId AND groupId = @TenantUsersGrpId
				END
			END
		END
	END TRY
	BEGIN CATCH
			PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
			ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
			PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
			ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
			ERROR MESSAGE: ' + ERROR_MESSAGE() + '
			ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
			ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorCode= ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
	END CATCH
PROC_EXIT:
IF(@errorCode<>0)
BEGIN
	ROLLBACK TRANSACTION
END
ELSE
BEGIN
		COMMIT TRANSACTION
END
SELECT @errorCode,@errorString,@localUserId
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setSecurityAssocOnCloudService')
	delete from GxQscripts where name = 'sec_setSecurityAssocOnCloudService'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSecurityAssocOnCloudService')
	delete from GXDBVersions where aliasname = 'sec_setSecurityAssocOnCloudService'
GO

insert into GXDBVersions values(2, 'sec_setSecurityAssocOnCloudService',  '00000000000000000000', 'sec_setSecurityAssocOnCloudService', '00000000000000000000')
GO

