

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setSchedulePolicyCreator.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_setSchedulePolicyCreator
--  |
--  | Description:  setting creator role for SP entity in UMSecurityAssociations
--  |
--  |
--  |
--  |
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_setSchedulePolicyCreator <<<'

IF EXISTS (select * from sysobjects where name='sec_setSchedulePolicyCreator')
	drop procedure sec_setSchedulePolicyCreator
IF EXISTS (select * from GxQscripts where name='sec_setSchedulePolicyCreator')
	delete from GxQscripts where name = 'sec_setSchedulePolicyCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSchedulePolicyCreator')
	delete from GXDBVersions where aliasname = 'sec_setSchedulePolicyCreator'
GO
print '... Creating Procedure: sec_setSchedulePolicyCreator'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setSchedulePolicyCreator
  @creatorUserId INT,			
  @taskId INT,
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT
AS
	/*
	enum TaskType
{
	@Text(text="None")
	NONE=0,
	@Text(text="Immediate")
	IMMEDIATE=1,
	@Text(text="Schedule")
	SCHEDULE=2,
	@Text(text="Saved Report")
	SAVED_REPORT=3,
	@Text(text="Schedule Policy")
	SCHEDULE_POLICY=4,
	@Text(text="Workflow")
	WORKFLOW=5,
	@Text(text="Preview")
	PREVIEW=6,
	@UI(visible=true)
	AUTOMATIC_COPY=7,
	@Text(text="Agentless SRM")
	AGENTLESS_SRM
}
*/
DECLARE @roleId INT = (SELECT id FROM UMRoles WHERE name = 'Schedule Policy Creator')
	DECLARE @permissionsList NVARCHAR(MAX) = ''
	--SET @permissionsList = CAST(CAT_SCHEDULING_POLICY_CREATE AS NVARCHAR(10)) + ',' + CAST(CAT_SCHEDULING_POLICY_EDIT AS NVARCHAR(10)) + ',' + CAST(CAT_SCHEDULING_POLICY_DELETE AS NVARCHAR(10)) + ',' + CAST(CAT_SCHEDULING_POLICY_ASSOCIATIONS_ADD_REMOVE AS NVARCHAR(10))
	IF EXISTS(SELECT 1 FROM TM_Task WHERE TaskId = @taskID AND taskType=4)-- taskType schedule policy
	BEGIN
EXEC sec_setCreatorForEntity @creatorUserId, @roleId, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 35, @taskId
	END
	ELSE IF EXISTS(SELECT 1 FROM TM_Task WHERE TaskId = @taskID AND taskType=2 ) -- taskType schedule
	BEGIN
		DECLARE @subTaskId int
		SELECT @subTaskId = subTaskId FROM TM_SubTask WITH (NOLOCK) WHERE    taskId = @taskId
EXEC sec_setCreatorForEntity @creatorUserId, @roleId, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 68, @subTaskId
	END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setSchedulePolicyCreator')
	delete from GxQscripts where name = 'sec_setSchedulePolicyCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setSchedulePolicyCreator')
	delete from GXDBVersions where aliasname = 'sec_setSchedulePolicyCreator'
GO

insert into GXDBVersions values(2, 'sec_setSchedulePolicyCreator',  '00000000000000000000', 'sec_setSchedulePolicyCreator', '00000000000000000000')
GO

