

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setLogMonitorCreator.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_setLogMonitorCreator
--  |
--  | Description:  setting creator role for LM entity in UMSecurityAssociations
--  |
--  |
--  |
--  |
--  |
--  |
--  |
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_setLogMonitorCreator <<<'

IF EXISTS (select * from sysobjects where name='sec_setLogMonitorCreator')
	drop procedure sec_setLogMonitorCreator
IF EXISTS (select * from GxQscripts where name='sec_setLogMonitorCreator')
	delete from GxQscripts where name = 'sec_setLogMonitorCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setLogMonitorCreator')
	delete from GXDBVersions where aliasname = 'sec_setLogMonitorCreator'
GO
print '... Creating Procedure: sec_setLogMonitorCreator'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setLogMonitorCreator
  @creatorUserId INT,			
  @logMonitorPolicyId INT
AS
  DECLARE @errorCode INT = 0
  DECLARE @errorString NVARCHAR(MAX) = ''
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(31 AS NVARCHAR(10)) + ',' + CAST(109 AS NVARCHAR(10)) + ',' + CAST(111 AS NVARCHAR(10)) + ',' + CAST(110 AS NVARCHAR(10)) + ',' + CAST(107 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @creatorUserId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 90, @logMonitorPolicyId
	IF @errorCode = 0
	BEGIN TRY
		IF NOT EXISTS (SELECT * FROM APP_MonitoringPolicyProp WHERE monitorPolicyId = @logMonitorPolicyId AND attrName='Creater User Id')
			INSERT INTO APP_MonitoringPolicyProp (monitorPolicyId, commcellId, attrName, attrType, attrVal, created, modified)
				SELECT @logMonitorPolicyId, 2,  'Creater User Id', 7, @creatorUserId, dbo.getUnixTime(GETUTCDATE()), 0
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END CATCH
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setLogMonitorCreator')
	delete from GxQscripts where name = 'sec_setLogMonitorCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setLogMonitorCreator')
	delete from GXDBVersions where aliasname = 'sec_setLogMonitorCreator'
GO

insert into GXDBVersions values(2, 'sec_setLogMonitorCreator',  '00000000000000000000', 'sec_setLogMonitorCreator', '00000000000000000000')
GO

