

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setLibraryCreator.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_setLibraryCreator
--  |
--  | Description:  setting creator role for Library entity in UMSecurityAssociations
--  |
--  |       Logic copied from addUserToLibrary
--  |
--  |
--  |
--  |
--  |
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_setLibraryCreator')
BEGIN
	print '>>> Drop Stored Procedure: sec_setLibraryCreator <<<'
	drop procedure sec_setLibraryCreator
END
IF EXISTS (select * from GxQscripts where name='sec_setLibraryCreator')
	delete from GxQscripts where name = 'sec_setLibraryCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setLibraryCreator')
	delete from GXDBVersions where aliasname = 'sec_setLibraryCreator'
GO
print '... Creating Procedure: sec_setLibraryCreator'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setLibraryCreator
  @creatorUserId INT,			
  @libraryId INT
AS
  DECLARE @errorCode INT
  DECLARE @errorString NVARCHAR(MAX)
	DECLARE @userHasRights INT = 0
EXEC sec_userHasCapability @creatorUserId, 0, @userHasRights OUTPUT, 0, 1 , '10, 8'
	IF @userHasRights = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'User does not have [MediaAgent Management and Library Management] rights to perform this operation.'
		GOTO PROC_EXIT
	END
	DECLARE @permissionsList NVARCHAR(MAX)
SET @permissionsList = CAST(10 AS NVARCHAR(10)) + ',' + CAST(8 AS NVARCHAR(10))
EXEC sec_setCreatorForEntity @creatorUserId, 0, @permissionsList, @errorCode OUTPUT, @errorString OUTPUT, 9, @libraryId
	PROC_EXIT:
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setLibraryCreator')
	delete from GxQscripts where name = 'sec_setLibraryCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setLibraryCreator')
	delete from GXDBVersions where aliasname = 'sec_setLibraryCreator'
GO

insert into GXDBVersions values(2, 'sec_setLibraryCreator',  '00000000000000000000', 'sec_setLibraryCreator', '00000000000000000000')
GO

