

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setDM2CreatorOwner.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_setDM2CreatorOwner()
--  | Description:  Provide the owner of DM2 Entity all the permissions that are needed at the time of set creation
--	|				This is wrapper to sec_setCreatorForEntity so that it can be called when creating entities such as review set, legal hold etc.
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_setDM2CreatorOwner.sp,v $ $Id: sec_setDM2CreatorOwner.sp,v 1.1.2.4 2018/12/12 22:37:07 sgolla Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_setDM2CreatorOwner')
BEGIN
	print '>>> Drop Stored Procedure: sec_setDM2CreatorOwner <<<'
	drop procedure sec_setDM2CreatorOwner
END
IF EXISTS (select * from GxQscripts where name='sec_setDM2CreatorOwner')
	delete from GxQscripts where name = 'sec_setDM2CreatorOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setDM2CreatorOwner')
	delete from GXDBVersions where aliasname = 'sec_setDM2CreatorOwner'
GO
print '... Creating Procedure: sec_setDM2CreatorOwner'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setDM2CreatorOwner
  @i_EntityType INT, 
  @i_OwnerId INT,
  @i_EntityId INT,
  @o_ErrorCode int output,
  @o_ErrorString NVARCHAR(MAX) output
AS
BEGIN
	DECLARE @permissionsList 	NVARCHAR(MAX)
	--
	-- Change Security Settings is commonly needed for all owners
	SET @permissionsList = CAST(107 as nvarchar(10))
	--
	-- Get list of permissions depending on the entity type
	SELECT @permissionsList = @permissionsList + ',' + CAST(A.capabilityId AS VARCHAR(10)) FROM UMDM2EntityCapability A, UMPermissions B
	WHERE A.entityType = @i_EntityType AND A.capabilityId = B.id
	Group By A.CapabilityId
	--
	-- Call SP that actually assigns necessary permissions for the owner
	EXEC sec_setCreatorForEntity @i_OwnerId, 0, @permissionsList, @o_ErrorCode OUTPUT, @o_ErrorString OUTPUT, @i_EntityType, @i_EntityId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setDM2CreatorOwner')
	delete from GxQscripts where name = 'sec_setDM2CreatorOwner'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setDM2CreatorOwner')
	delete from GXDBVersions where aliasname = 'sec_setDM2CreatorOwner'
GO

insert into GXDBVersions values(2, 'sec_setDM2CreatorOwner',  '00010001000200040000', 'sec_setDM2CreatorOwner', '00010001000200040000')
GO

