

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setCreatorForEntityInApplicationTable.sp] ---------- 

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setCreatorForEntity.sp] ----------
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_setCreatorForEntityInApplicationTable
--  |
--  | Description:  setting creator in application table
--  |
--	|
--	|
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS : entityType and comma separted list of that entitytype, and userId
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_setCreatorForEntityInApplicationTable')
BEGIN
	print '>>> Drop Stored Procedure: sec_setCreatorForEntityInApplicationTable <<<'
	drop procedure sec_setCreatorForEntityInApplicationTable
END
IF EXISTS (select * from GxQscripts where name='sec_setCreatorForEntityInApplicationTable')
	delete from GxQscripts where name = 'sec_setCreatorForEntityInApplicationTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCreatorForEntityInApplicationTable')
	delete from GXDBVersions where aliasname = 'sec_setCreatorForEntityInApplicationTable'
GO
print '... Creating Procedure: sec_setCreatorForEntityInApplicationTable'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setCreatorForEntityInApplicationTable
  @creatorUserId INT,
  @entityType INT,
  @entityIdList VARCHAR(MAX)
AS
--ONLy these entity Types are supported for application layer to save creatorId. WE should not continue adding creator ID in application tables.
IF @entityType NOT IN (35,28,90, 64,9674,9501,9502,9503
,9504,9505, 132,133,157,68)
RETURN
DECLARE @inputEntityTable TABLE(entityId INT primary key)
			INSERT INTO @inputEntityTable
			SELECT DISTINCT _ID
			FROM dbo.SplitIDs(@entityIdList)
IF (@entityType = 35)
                BEGIN
                    UPDATE tbl1
                    SET tbl1.ownerId = @creatorUserId
                    FROM TM_Task as tbl1 INNER JOIN @inputEntityTable as tbl2  ON
                         tbl1.taskId = tbl2.entityId
                END
ELSE IF (@entityType = 68)
                BEGIN
                    UPDATE task
                    SET task.ownerId = @creatorUserId
                    FROM TM_Task as task INNER JOIN TM_SubTask as subTask
                    ON task.taskId = subTask.taskId
                    INNER JOIN @inputEntityTable as E
                    ON     subTask.subTaskId = E.entityId
                END
ELSE IF (@entityType = 28)
                BEGIN
                    UPDATE tbl1
                    SET tbl1.userId = @creatorUserId
                    FROM APP_ClientGroup as tbl1 INNER JOIN @inputEntityTable as tbl2 ON
                         tbl1.id = tbl2.entityId
                END
ELSE IF (@entityType = 83)
                BEGIN
                    UPDATE tbl1
                    SET tbl1.userId = @creatorUserId
                    FROM WF_Definition as tbl1 INNER JOIN @inputEntityTable as tbl2
                                      ON      tbl1.WorkflowId = tbl2.entityId
                END
ELSE IF (@entityType = 90)
                BEGIN
                    UPDATE tbl1
                    SET tbl1.attrVal = @creatorUserId
                    FROM APP_MonitoringPolicyProp as tbl1 INNER JOIN @inputEntityTable as tbl2
                        ON tbl1.monitorPolicyId = tbl2.entityId
                        WHERE tbl1.attrName = 'Creater User Id'
                END
ELSE IF (@entityType = 64)
                BEGIN
                    UPDATE tbl1
                    SET tbl1.notifOwner = @creatorUserId
                    FROM NTnotificationRule as tbl1 INNER JOIN @inputEntityTable as tbl2
                        ON tbl1.id = tbl2.entityId
                END
ELSE IF (@entityType = 9674)
                BEGIN
                    UPDATE lmSearchTbl
                    SET lmSearchTbl.creatorUserId = @creatorUserId
                    FROM App_SharedEntityInfo as shareTbl INNER JOIN @inputEntityTable as tbl2
                    ON shareTbl.SharedEntityId = tbl2.entityId
                    INNER JOIN LMUserSearch lmSearchTbl
                    ON shareTbl.OriginalEntityId = lmSearchTbl.searchId
WHERE shareTbl.SharedEntityType = 134
                    UPDATE lmDashTbl
                    SET lmDashTbl.creatorUserId = @creatorUserId
                    FROM App_SharedEntityInfo as shareTbl INNER JOIN @inputEntityTable as tbl2
                    ON shareTbl.SharedEntityId = tbl2.entityId
                    INNER JOIN LMDashBoard lmDashTbl
                    ON shareTbl.OriginalEntityId = lmDashTbl.dashBoardId
WHERE shareTbl.SharedEntityType = 137
                END
                ----------------------------------------------------------------------------------------------------------------------------------
                -- For Review Set, Query Set, Download Set and Tag Set also updating containerName by appending it with old owner's login name.
                -- Doing this on behalf of DM2 team as suggested by Karthikeyan Shanmuga Sundaram. Please refer to him for any queries with this.
                ----------------------------------------------------------------------------------------------------------------------------------
ELSE IF (@entityType in ( 9501,9502,9503,9504))
                BEGIN
                    UPDATE RS
                    SET RS.containerName = RS.containerName + ISNULL(('(' + (SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = RS.userId
                                                                                                AND RS.userId <> @creatorUserId ) + ')'), '')
                    FROM DM2Container RS INNER JOIN @inputEntityTable entities
                        ON RS.containerType = @entityType
                            AND RS.containerId = entities.entityId
                    UPDATE RS
                    SET RS.userId = @creatorUserId
                    FROM DM2Container RS INNER JOIN @inputEntityTable entities
                        ON  RS.containerType = @entityType
                            AND RS.containerId = entities.entityId
                END
ELSE IF (@entityType = 9505)
                BEGIN
                    UPDATE LH
                    SET LH.ownerUserId = @creatorUserId
                    FROM DM2CompliancePolicy LH INNER JOIN @inputEntityTable entities
                        ON  LH.id = entities.entityId
                END
ELSE IF (@entityType = 132)
                BEGIN
                    UPDATE DS
                    SET DS.OwnerUserID =@creatorUserId
                    FROM SEDataSource DS INNER JOIN @inputEntityTable entities
                        ON DS.DataSourceId = entities.entityId
                END
ELSE IF (@entityType = 133)
                BEGIN
                    UPDATE SV
                    SET SV.OwnerUserID = @creatorUserId
                    FROM SESearchView SV INNER JOIN @inputEntityTable entities
                        ON  SV.status = 0
                            AND SV.SearchViewId = entities.entityId
                END
ELSE IF (@entityType = 157)
                BEGIN
                    UPDATE SH
                    SET SH.OwnerUserID = @creatorUserId
                    FROM SESearchView SH INNER JOIN @inputEntityTable entities
                        ON  SH.status = 1
                            AND SH.SearchViewId = entities.entityId
                END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setCreatorForEntityInApplicationTable')
	delete from GxQscripts where name = 'sec_setCreatorForEntityInApplicationTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCreatorForEntityInApplicationTable')
	delete from GXDBVersions where aliasname = 'sec_setCreatorForEntityInApplicationTable'
GO

insert into GXDBVersions values(2, 'sec_setCreatorForEntityInApplicationTable',  '00000000000000000000', 'sec_setCreatorForEntityInApplicationTable', '00000000000000000000')
GO

