

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setCreatorForEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +====================================================================================================================================+
--  |   Procedure:  sec_setCreatorForEntity
--  |
--  |	Description:  setting creator role for any entity in UMSecurityAssociations
--  |
--	|	1. Can set a creator for a entity with a given role (or)
--  |   2. Can set a creator for a entity with a given set of permissions (or)
--  |   3. Can transfer creator row of a entity from one user to another user (in this case both role and permissions list should be empty)
--	|
--  |   loggedInUserId: This will be sent from all Calling code. If no explicit Creator user / group is configured, then use this logged in user
--	|   Id as the creator. If this user belongs to Tenant Admin / Master, then Tenant Admin / Master will be
--	|	made default creator.
--	|
--	|	CreatorUserGroupId, CreatorUserId: If some one explicitly configures a creator user / creator user group, then we will set this as
--	|	creator after doing Security check on logged in User on this entity.
--	|
--	|	Authors: saggarwal & jswaminathan
--  +====================================================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_setCreatorForEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_setCreatorForEntity <<<'
	drop procedure sec_setCreatorForEntity
END
IF EXISTS (select * from GxQscripts where name='sec_setCreatorForEntity')
	delete from GxQscripts where name = 'sec_setCreatorForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCreatorForEntity')
	delete from GXDBVersions where aliasname = 'sec_setCreatorForEntity'
GO
print '... Creating Procedure: sec_setCreatorForEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_setCreatorForEntity
  @loggedInUserId INT,									
  @creatorRoleId INT,						
  @creatorPermissions NVARCHAR(MAX),		
  @errorCode INT OUTPUT,					
  @errorString NVARCHAR(MAX) OUTPUT,
  @entityType1 INT,							
  @entityId1 INT,
  @entityType2 INT = 0,
  @entityId2 INT = 0,
  @entityType3 INT = 0,
  @entityId3 INT = 0,
  @entityType4 INT = 0,
  @entityId4 INT = 0,
  @entityType5 INT = 0,
  @entityId5 INT = 0,
  @creatorUserGroupId INT = 0,
  @returnCursor INT = 0,
  @creatorUserId INT = 0
AS
  DECLARE @errorCodeOutput INT 
  DECLARE @errorStringOutput NVARCHAR(MAX)
	SET @errorCode = 0						--optimistic
	SET @errorString = 'Successful'
	DECLARE @permissionTable TABLE (permissionId INT)
	IF @creatorPermissions <> ''
	BEGIN
		IF CHARINDEX(',', @creatorPermissions, LEN(@creatorPermissions)) = 0
		SET @creatorPermissions = @creatorPermissions + ','
		DECLARE @delimPos INT = CHARINDEX(',', @creatorPermissions, 1)
		WHILE @delimPos > 0
		BEGIN
			INSERT INTO @permissionTable
				SELECT LTRIM(RTRIM(SUBSTRING(@creatorPermissions, 1, @delimPos-1)))
			SET @creatorPermissions = SUBSTRING(@creatorPermissions, @delimPos+1, LEN(@creatorPermissions))
			SET @delimPos = CHARINDEX(',', @creatorPermissions, 1)
		END
	END
	IF @loggedInUserID = 0 AND @creatorUserID = 0 AND @creatorUserGroupId = 0			--wrong call, just quit
		GOTO EXIT_PROC
	-- Behavior:
	--		If there are no explicit Creator user / group configured, then use logged in user Id as the default creator.
	--			If he belongs to a Tenant Admin group, then make that group as the default creator.
	--			If he belongs to Master group, then make Master as default creator.
	--		If explicit creator is specified, then just use that. Do not do any switching in that case.
	-- PS: Till now, the last argument was passed as authorUserId, but no one was passing it. So setting that as explicit CreatorUserID and fixing client group and credentials code to set it when explicit creator is set.
	-- And most of the code is passing logged in user Id as the first argument. So renaming that variable as loggedInUserID.
	IF @creatorUserId <> 0 OR @creatorUserGroupID <> 0
	BEGIN
		-- Validate whether the logged in user can configure this user / group as the new owner.
		EXEC sec_validateNewOwnerInfo @loggedInUserID, @creatorUserId, @creatorUserGroupID, 0, @errorCode OUTPUT, @errorString OUTPUT
		IF @errorCode <> 0
			GOTO EXIT_PROC
	END
	ELSE IF (@creatorUserId = 0 AND @creatorUserGroupID = 0)
	BEGIN
		-- Check if logged in user Id is part of a group set with the SetCreatorGroupAlways flag. If so, use that group Id as creator, else use logged in user as creator.
		DECLARE @UserGroupWithFlagSet INT = 0
		SET @UserGroupWithFlagSet = ISNULL((SELECT TOP 1 id
											FROM UMGroups WITH(NOLOCK)
												INNER JOIN UMUserGroup WITH (NOLOCK)
													ON groupId = id AND userId = @loggedInUserId
											WHERE
groupFlags & (CAST(0x10000 AS INT)| CAST(0x0008 AS INT)) <> 0 ORDER BY id), 0)
		-- There are few entities (DM2 entities for example) which do not have support for user group as creator. They assume that creator would always be a valid user Id.
		-- If we set user group as default creator for these entities, it would break their features.
		-- So restricting this switching to user group as owner, only for few entities, that have this support and CMR came up for this in the past.
		DECLARE @canSetGroupAsCreator INT = 0
IF @entityType1 IN (28,
35,
68,
158,
120,
179,
180,
181,
182,
183)
			SET @canSetGroupAsCreator = 1
		IF EXISTS
					(
							SELECT id
							FROM UMGroups (NOLOCK)
WHERE (id = @UserGroupWithFlagSet) AND ((groupFlags & CAST(0x40000 AS INT)) <> 0)
					)
			SET @canSetGroupAsCreator = 0
		IF ((@UserGroupWithFlagSet <> 0) AND (@canSetGroupAsCreator = 1))
		BEGIN
			SET @creatorUserGroupId = @UserGroupWithFlagSet
			SET @creatorUserId = 0
		END
		ELSE
			SET @creatorUserId = @loggedInUserId
	END
	BEGIN TRY
		DECLARE @companyId INT = 0
        IF (@creatorUserId <> 0)
        BEGIN
            SET @companyId = dbo.AppGetCompanyForUserOrUserGroup(@creatorUserId, 1)
        END
        ELSE
        BEGIN
            SET @companyId = dbo.AppGetCompanyForUserOrUserGroup(@creatorUserGroupId, 0)
        END
		IF EXISTS (SELECT 1 FROM @permissionTable) OR @creatorROleId <> 0		--a new set of permissions and role is given, this needs to go for the creator
		BEGIN
			IF EXISTS (SELECT 1
							FROM UMSecurityAssociations
							WHERE entityType1 = @entityType1 AND entityId1 = @entityId1
								  AND entityType2 = @entityType2 AND entityId2 = @entityId2
								  AND entityType3 = @entityType3 AND entityId3 = @entityId3
								  AND entityType4 = @entityType4 AND entityId4 = @entityId4
								  AND entityType5 = @entityType5 AND entityId5 = @entityId5
								  AND isCreator = 1)
			BEGIN			--in case a creator already exists then delete it
				DELETE FROM UMSecurityAssociations
				WHERE entityType1 = @entityType1 AND entityId1 = @entityId1
								  AND entityType2 = @entityType2 AND entityId2 = @entityId2
								  AND entityType3 = @entityType3 AND entityId3 = @entityId3
								  AND entityType4 = @entityType4 AND entityId4 = @entityId4
								  AND entityType5 = @entityType5 AND entityId5 = @entityId5
								  AND isCreator = 1
			END
			IF EXISTS (SELECT 1 FROM @permissionTable)
			BEGIN
				INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, isCreator, authorId, companyId)
							SELECT 0, permissionId, CASE WHEN @creatorUserId <> 0 THEN @creatorUserId ELSE @creatorUserGroupId END, CASE WHEN @creatorUserId <> 0 THEN 1 ELSE 0 END, @entityType1, @entityID1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5, 0, 1, @loggedInUserId, @companyId
							FROM @permissionTable
			END
			IF @creatorRoleId <> 0
			BEGIN
				INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, isCreator, authorId, companyId)
					SELECT @creatorRoleId, 0, CASE WHEN @creatorUserId <> 0 THEN @creatorUserId ELSE @creatorUserGroupId END, CASE WHEN @creatorUserId <> 0 THEN 1 ELSE 0 END, @entityType1, @entityID1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5, 0, 1, @loggedInUserId, @companyId
			END
		END
		ELSE
		BEGIN
			UPDATE UMSecurityAssociations
			SET userOrGroupId = CASE WHEN @creatorUserId <> 0 THEN @creatorUserId ELSE @creatorUserGroupId END,
				isUser = CASE WHEN @creatorUserId <> 0 THEN 1 ELSE 0 END,
				companyId = @companyId
			WHERE entityType1 = @entityType1 AND entityId1 = @entityId1
								  AND entityType2 = @entityType2 AND entityId2 = @entityId2
								  AND entityType3 = @entityType3 AND entityId3 = @entityId3
								  AND entityType4 = @entityType4 AND entityId4 = @entityId4
								  AND entityType5 = @entityType5 AND entityId5 = @entityId5
								  AND isCreator = 1
		END
		-- Tag entity with company
		DECLARE @entityTypeToTag INT = 0
		DECLARE @entityIdToTag INT = 0
		IF @entityTYpe2 = 0 AND @entityId2 = 0
		BEGIN
			SET @entityTypeToTag = @entityType1
			SET @entityIdToTag = @entityId1
		END
		ELSE IF @entityType2 != 0 AND @entityId2 != 0 AND @entityType3 = 0
		BEGIN
			SET @entityTypeToTag = @entityType2
			SET @entityIdToTag = @entityId2
		END
		ELSE IF @entityType3 != 0 AND @entityId3 != 0 AND @entityType4 = 0
		BEGIN
			SET @entityTypeToTag = @entityType3
			SET @entityIdToTag = @entityId3
		END
		ELSE IF @entityType4 != 0 AND @entityId4 != 0 AND @entityType5 = 0
		BEGIN
			SET @entityTypeToTag = @entityType4
			SET @entityIdToTag = @entityId4
		END
		ELSE IF @entityType5 != 0 AND @entityId5 != 0
		BEGIN
			SET @entityTypeToTag = @entityType5
			SET @entityIdToTag = @entityId5
		END
		-- Special handling for User entity. Users can be created on "behalf" of another company. Tag those users with the correct company.
		-- There are different cases like a) MSP User choosing UG as Company UG. b) MSP User creating an AD user, and AD belongs to Company, etc.
		-- Ultimately they all hit here, so before calling SetCompanyIdForEntity, set the company Id based on the User entity being created,
		-- and not based on the logged in user.
IF (@entityTypeToTag = 13)
			SET @companyId = dbo.AppGetCompanyForUserOrUserGroup(@entityIdToTag, 1)
ELSE IF (@entityTypeToTag = 15)
			SET @companyId = dbo.AppGetCompanyForUserOrUserGroup(@entityIdToTag, 0)
		EXEC sec_setCompanyIdForEntity @entityTypeToTag, @entityIdToTag, @companyId
	--Need add Updating Application specific code here also.
	--Lets do it separte stored proc , so can be called individually in future too.
	DECLARE @applicationTableCreatorUserId INT =@creatorUserId
	if(@creatorUserGroupId<>0)
	BEGIN
		exec sec_getCreateAsUserId 0,0,@applicationTableCreatorUserId OUTPUT,0,0,@creatorUSerGroupId
	END
	exec  sec_setCreatorForEntityInApplicationTable @applicationTableCreatorUserId ,@entityType1,@entityId1
	DECLARE @hiddenRoleForPlanAsSuperSetId INT = 0
	SELECT @hiddenRoleForPlanAsSuperSetId = id
	FROM UMRoles (NOLOCK)
	WHERE
flags & 1024 <> 0
IF (@entityType1 = 158)				-- Plan creator needs to have this role on his plan, thereby he can edit his associated entities.
	BEGIN								-- This code is already there in sec_populateSecurityAssociations, we need it here also for creator to have this permission by default.
IF NOT EXISTS (SELECT 1 FROM UMSecurityAssociations WHERE entityTYpe1 = 158 AND entityId1 = @entityId1 AND roleId = @hiddenRoleForPlanAsSuperSetId)
			INSERT INTO UMSecurityAssociations (entityType1, entityId1, isUser, userOrGroupId, isCreator, authorId, roleId)
VALUES(158, @entityId1, CASE WHEN @creatorUserGroupId = 0 THEN 1 ELSE 0 END, CASE WHEN @creatorUserGroupId = 0 THEN @creatorUserId ELSE @creatorUserGroupId END, 0, @loggedInUserId, @hiddenRoleForPlanAsSuperSetId)
	END
END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorCode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE()
	END CATCH
EXIT_PROC:
	IF @returnCursor <> 0
		SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setCreatorForEntity')
	delete from GxQscripts where name = 'sec_setCreatorForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCreatorForEntity')
	delete from GXDBVersions where aliasname = 'sec_setCreatorForEntity'
GO

insert into GXDBVersions values(2, 'sec_setCreatorForEntity',  '00000000000000000000', 'sec_setCreatorForEntity', '00000000000000000000')
GO

