

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setCompanyIdForEntity.sp] ---------- 

--  +------------------------------------------------------------------------------------------+
--  |   Procedure : "sec_setCompanyIdForEntity"
--  |   Description: Stored procedure to set company Id for an entity i.e. to tag an entity with
--  |   with company.
--  |   Input: entityType, entityId, companyId, i_xmlText
--  |   Author: sghatbale
--  +------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_setCompanyIdForEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_setCompanyIdForEntity <<<'
	drop procedure sec_setCompanyIdForEntity
END
IF EXISTS (select * from GxQscripts where name='sec_setCompanyIdForEntity')
	delete from GxQscripts where name = 'sec_setCompanyIdForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCompanyIdForEntity')
	delete from GXDBVersions where aliasname = 'sec_setCompanyIdForEntity'
GO
print '... Creating Procedure: sec_setCompanyIdForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setCompanyIdForEntity
  @i_entityType INT,
  @i_entityId INT,
  @i_companyId INT
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @nowTime integer
SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
IF @i_entityType <> 0 AND @i_entityId <> 0
BEGIN
	IF @i_companyId = 0 AND EXISTS (SELECT 1 FROM App_CompanyEntities WHERE entityType = @i_entityType AND entityId = @i_entityId)
	BEGIN
		DELETE FROM App_CompanyEntities
		WHERE entityType = @i_entityType AND entityId = @i_entityId
	END
	ELSE IF @i_companyId <> 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_CompanyEntities WHERE entityType = @i_entityType AND entityId = @i_entityId)
		BEGIN
			INSERT INTO App_CompanyEntities(entityType, entityId, companyId, created) VALUES
				(@i_entityType, @i_entityId, @i_companyId, @nowTime)
		END
		ELSE
		BEGIN
			UPDATE App_CompanyEntities
			SET companyId = @i_companyId, modified = @nowTime
			WHERE entityType = @i_entityType AND entityId = @i_entityId AND companyId <> @i_companyId
		END
	END
END
ELSE IF OBJECT_ID('tempdb.dbo.#EntitiesToTagWithCompany') IS NOT NULL
BEGIN
	IF @i_companyId <> 0
	BEGIN
		-- Create Company rewrite. Replacing the Merge with Update and Insert.
		UPDATE Dest
		SET companyId = @i_companyId,
		    created = @nowTime
		FROM App_CompanyEntities Dest
			INNER JOIN #EntitiesToTagWithCompany Src
				ON Dest.entityType = Src.entityType
				AND Dest.entityId = Src.entityId
				AND Dest.companyId <> @i_companyId
		INSERT INTO App_CompanyEntities (entityType, entityId, companyId, created, modified)
			SELECT Src.entityType, Src.entityId, @i_companyId, @nowTime, 0
			FROM #EntitiesToTagWithCompany Src
				LEFT JOIN App_CompanyEntities Dest
					ON Src.entityType = Dest.entityType
					AND Src.entityId = Dest.entityId
			WHERE
				Dest.entityId IS NULL
	END
	ELSE
	BEGIN
		DELETE  App
	        FROM APP_CompanyEntities App
	        INNER JOIN #EntitiesToTagWithCompany AS SOURCE ON
	        (App.entityId = SOURCE.entityId AND App.entityType = SOURCE.entityType)
	END
	DROP TABLE #EntitiesToTagWithCompany
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setCompanyIdForEntity')
	delete from GxQscripts where name = 'sec_setCompanyIdForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCompanyIdForEntity')
	delete from GXDBVersions where aliasname = 'sec_setCompanyIdForEntity'
GO

insert into GXDBVersions values(2, 'sec_setCompanyIdForEntity',  '00000000000000000000', 'sec_setCompanyIdForEntity', '00000000000000000000')
GO

