

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setCommvaultUserAsResellerForCompany.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
--  +===================================================================================+
--  |		Name: sec_setCommvaultUserAsResellerForCompany.sp
--  |		Description: This is to set reseller user for company. It does these things.
--	|					 1. Configure him as operator in App_CompanyProp for this company.
--	|					 2. Give him Tenant Operator role on the company.
--	|					 3. Generate a impersonation account for this user within the company.
--  |					 4. Link him to the original operator account.
--	|					 5. Make this impersonation account member of Tenant operator group
--	|						of that company.
--	|					 When operator is removed it will revoke the above things.
--	|					 1. Remove him as operator from APP_CompanyProp for this company.
--	|					 2. Remove Tenant Operator role given on the company.
--	|					 3. Delete the impersonation account for this user within the company.
--	|						(Soft-Delete, so that if he is made operator again, re-use the id).
--	|					 4. Unlink him from the original operator account.
--	|					 5. Remove this impersonation account from Tenant operator group
--	|						of that company.
--  |		Author: jswaminathan
--  +===================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_setCommvaultUserAsResellerForCompany')
BEGIN
	print '>>> Drop Stored Procedure: sec_setCommvaultUserAsResellerForCompany <<<'
	drop procedure sec_setCommvaultUserAsResellerForCompany
END
IF EXISTS (select * from GxQscripts where name='sec_setCommvaultUserAsResellerForCompany')
	delete from GxQscripts where name = 'sec_setCommvaultUserAsResellerForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCommvaultUserAsResellerForCompany')
	delete from GXDBVersions where aliasname = 'sec_setCommvaultUserAsResellerForCompany'
GO
print '... Creating Procedure: sec_setCommvaultUserAsResellerForCompany'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setCommvaultUserAsResellerForCompany
  @userID INT,
  @localeId INT,
  @xmlIn XML,
  @companyId INT,
  @errorCode INT OUTPUT,
  @errorString VARCHAR(1024) OUTPUT,
  @returnCursor INT = 0
AS
-- Inputs
/*
-- Old XML (Specify only operator users / groups):
DECLARE @xmlIn XML = '<Api_OrganizationInfo>		<!-- or some root tag -->
	<organizationProperties operatorsOperationType="1">
		<operators>
			<user userId="54" userName="reseller2"/>
		</operators>
		<operators>
			<user userId="45" userName="reseller1"/>
		</operators>
		<operators>
			<userGroup userGroupId="45" userGroupName="commvault-nj\Dev-Server"/>
		</operators>
		<operators>
			<userGroup userGroupId="36" userGroupName="commvault-nj\Dev-Security"/>
		</operators>
	</organizationProperties>
</Api_OrganizationInfo>'
-- New XML (Specify operator users / groups + operator role):
DECLARE @xmlIn XML = '<Api_OrganizationInfo>		<!-- or some root tag -->
	<organizationProperties operatorsOperationType="1">
		<operators>
			<user userId="54" userName="reseller2"/>
			<role roleName="Backup Administrators" roleId="9"/>
		</operators>
		<operators>
			<user userId="45" userName="reseller1"/>
			<role roleName="Restore Administrators" roleId="18"/>
		</operators>
		<operators>
			<userGroup userGroupId="45" userGroupName="commvault-nj\Dev-Server"/>
			<role roleName="Configuration Managers" roleId="27"/>
		</operators>
		<operators>
			<userGroup userGroupId="36" userGroupName="commvault-nj\Dev-Security"/>
			<role roleName="User Management" roleId="36"/>
		</operators>
	</organizationProperties>
</Api_OrganizationInfo>'
DECLARE @companyID INT = 8
*/
DECLARE @tenantOperatorOperationType INT
SET @tenantOperatorOperationType = @xmlIn.value('(//../organizationProperties/@operatorsOperationType)[1]', 'INT')
-- Frame added and deleted tenant operators.
BEGIN
	DECLARE @inputUserAndGroupIdTable TABLE
	(
		userId INT,
		userGroupId INT,
		userName NVARCHAR(MAX),
		userGroupName NVARCHAR(MAX),
		roleId INT,
		roleName NVARCHAR(MAX)
	)
	INSERT INTO @inputUserAndGroupIdTable
		SELECT R.ref.value('(@userId)[1]', 'INT'), 0, R.ref.value('(@userName)[1]', 'NVARCHAR(MAX)'), '', R.ref.value('(../role/@roleId)[1]', 'INT'), R.ref.value('(../role/@roleName)[1]', 'NVARCHAR(MAX)')
		FROM @xmlIn.nodes('//../organizationProperties/operators/user') AS R(ref)
		UNION
		SELECT 0, R.ref.value('(@userGroupId)[1]', 'INT'), '', R.ref.value('(@userGroupName)[1]', 'NVARCHAR(MAX)'), R.ref.value('(../role/@roleId)[1]', 'INT'), R.ref.value('(../role/@roleName)[1]', 'NVARCHAR(MAX)')
		FROM @xmlIn.nodes('//../organizationProperties/operators/userGroup') AS R(ref)
	UPDATE @inputUserAndGroupIdTable
	SET userId = id
	FROM UMUsers (NOLOCK)
	WHERE
		userName <> ''
		AND (userId <= 0 OR userId IS NULL)
		AND login = userName
	UPDATE @inputUserAndGroupIdTable
	SET userGroupId = id
	FROM UMGroups (NOLOCK)
	WHERE
		userGroupName <> ''
		AND (userGroupId <= 0 OR userGroupId IS NULL)
		AND CHARINDEX('\', userGroupName, 1) > 0
		AND SUBSTRING(userGroupName, CHARINDEX('\', userGroupName, 1)+1, LEN(userGroupName)) = name
		AND umdsProviderId in (SELECT id FROM UMDSProviders WHERE domainName = SUBSTRING(userGroupName, 1, CHARINDEX('\', userGroupName, 1)-1))
	-- Backward compatibility: In old style XML, we do not have different role Id for different operators. They all use the same operator role set in Company properties table.
	-- So if the input table contains entries in old style, then role Id and role name will be empty/NULL. Let us get the role Id from company properties table for such cases and fill it.
	IF EXISTS (SELECT TOP 1 1
			   FROM @inputUserAndGroupIdTable
			   WHERE
				(roleId <= 0 OR roleId IS NULL)
				AND (roleName IS NULL OR roleName = '')
			  )
	BEGIN
		DECLARE @tenantOperatorRole INT
				,@tenantOperatorRoleName VARCHAR(MAX)
		SELECT @tenantOperatorRole = R.id
			   ,@tenantOperatorRoleName = R.name
		FROM App_CompanyProp CP (NOLOCK)
			INNER JOIN UMRoles R(NOLOCK)
				ON CP.attrValInt =  R.id
		WHERE
			CP.componentNameId = @companyId
AND CP.attrName = 'Operator Role'
			AND CP.modified = 0
AND CP.cs_attrName=checksum('Operator Role')
		UPDATE @inputUserAndGroupIdTable
		SET roleId = @tenantOperatorRole,
			roleName = @tenantOperatorRoleName
		WHERE
			(roleId <= 0 OR roleId IS NULL)
			AND (roleName IS NULL OR roleName = '')
	END
	UPDATE @inputUserAndGroupIdTable
	SET roleId = id
	FROM UMRoles (NOLOCK)
	WHERE
		roleName <> ''
		AND (roleId <= 0 OR roleId IS NULL)
		AND roleName = name					-- If Id is not filled, let us fill it.
	-- To do: Sanity check. If some input is wrong, show proper error message. Will do in the next form.
	DECLARE @addedOperators TABLE
	(
		userId INT,
		userGroupId INT,
		roleId INT
	)
	DECLARE @deletedOperators TABLE
	(
		userId INT,
		userGroupId INT,
		roleId INT
	)
	DECLARE @alreadyInDB TABLE
	(
		userId INT,
		userGroupId INT,
		roleId INT
	)
	INSERT INTO @alreadyInDB
		SELECT userId, userGroupId, roleId
		FROM dbo.sec_getCommvaultResellersForCompany(@companyId)
	IF @tenantOperatorOperationType = 1			-- Overwrite.
	BEGIN
		INSERT INTO @addedOperators
			SELECT userID, userGroupId, roleId
			FROM @inputUserAndGroupIdTable
			EXCEPT
			SELECT userID, userGroupId, roleId
			FROM @alreadyInDB
		-- We can just take DB - Input. There is no need to worry about whether logged in user can see all DB entries. Because this is going to be done by MSP Admin.
		INSERT INTO @deletedOperators
			SELECT userID, userGroupId, roleId
			FROM @alreadyInDB
			EXCEPT
			SELECT userID, userGroupId, roleId
			FROM @inputUserAndGroupIdTable
	END
	ELSE IF @tenantOperatorOperationType = 2			-- Add.
	BEGIN
		INSERT INTO @addedOperators
			SELECT userID, userGroupId, roleId
			FROM @inputUserAndGroupIdTable
			EXCEPT
			SELECT userID, userGroupId, roleId
			FROM @alreadyInDB
	END
	ELSE IF @tenantOperatorOperationType = 3			-- Delete.
	BEGIN
		INSERT INTO @deletedOperators
			SELECT userID, userGroupId, roleId
			FROM @inputUserAndGroupIdTable
			INTERSECT
			SELECT userId, userGroupId, roleId
			FROM @alreadyInDB
	END
END
IF NOT EXISTS (SELECT 1 FROM @addedOperators UNION SELECT 1 FROM @deletedOperators)
	GOTO PROC_EXIT
-- Insert / delete these users in company properties table.
BEGIN
	DECLARE @nowTime INT = dbo.getUnixTime(GETUTCDATE())
	INSERT INTO UMOperators (companyId, isUser, userOrGroupId, roleId, flags)
		SELECT @companyId,
			   CASE WHEN A.userId <> 0 THEN 1 ELSE 0 END,
			   CASE WHEN A.userId <> 0 THEN A.userId ELSE A.userGroupId END,
			   A.roleId,
			   0
		FROM @addedOperators A
			LEFT JOIN UMOperators UMO(NOLOCK)
				ON UMO.companyId = @companyId
				AND ((A.userId <> 0 AND UMO.isUser = 1 AND UMO.userOrgroupId = A.userId) OR (A.usergroupId <> 0 AND UMO.isUser = 0 AND UMO.userOrgroupId = A.userGroupId))
				AND UMO.roleId = A.roleId
		WHERE
			UMO.companyId IS NULL			-- Insert only those entries in Added table not already in Operators table.
	DELETE UMO								-- Delete those entries in Deleted table present in Operators table.
	FROM UMOperators UMO
		INNER JOIN @deletedOperators D
			ON UMO.companyId = @companyId
			AND ((D.userId <> 0 AND UMO.isUser = 1 AND UMO.userOrgroupId = D.userId) OR (D.usergroupId <> 0 AND UMO.isUser = 0 AND UMO.userOrgroupId = D.userGroupId))
			AND UMO.roleId = D.roleId
END
-- We need to associate tenant operator role to the original reseller users on the company.
-- We need to separately call for added and deleted tables. Not with same operation type as @tenantOperatorOperationType.
-- Because @tenantOperatorOperationType is only for operators. If that is overwrite and we pass the same to set security from entity, then it
-- will wipe off all other security associations done on the provider. That is wrong !!! So frame added and deleted tables
-- manually and invoke set security accordingly.
DECLARE @errorTable TABLE
(
	errorCode INT,
	errorString VARCHAR(MAX)
)
DECLARE @securityAssociationsXML XML
IF EXISTS (SELECT 1 FROM @addedOperators)
BEGIN
	SET @securityAssociationsXML =	(
										SELECT 2 AS '@associationsOperationType'
												,(
													SELECT
														(
															SELECT CASE WHEN userId <> 0 THEN userID END AS '@userId',
																   CASE WHEN userGroupId <> 0 THEN userGroupID END AS '@userGroupId',
CASE WHEN userId <> 0 THEN 13 ELSE 15 END AS '@_type_'
															FOR XML PATH('userOrGroup'), TYPE
														)
														,(
															SELECT
																(
																	SELECT roleId AS '@roleId'
																	FOR XML PATH ('role'), TYPE
																)
															FOR XML PATH ('properties'), TYPE
														)
													FROM @addedOperators
													FOR XML PATH ('associations'), TYPE
												)
											   ,(
													SELECT @localeId AS '@localeId'
													FOR XML PATH('processinginstructioninfo'), TYPE
											    )
										FOR XML PATH('App_SecurityAssociationForEntityList')
									)
	INSERT INTO @errorTable
EXEC sec_setSecurityAssociationsFromEntity @securityAssociationsXML, @userID, 0, 0, 61, @companyId, 0, 0, 0, 0, 0, 0, 0, 0
	SET @errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
	IF @errorCode <> 0
	BEGIN
		SET @errorString = (SELECT TOP 1 errorString FROM @errorTable)
		GOTO PROC_EXIT
	END
END
IF EXISTS (SELECT 1 FROM @deletedOperators)
BEGIN
	SET @securityAssociationsXML =	(
										SELECT 3 AS '@associationsOperationType'
												,(
													SELECT
														(
															SELECT CASE WHEN userId <> 0 THEN userID END AS '@userId',
																   CASE WHEN userGroupId <> 0 THEN userGroupID END AS '@userGroupId',
CASE WHEN userId <> 0 THEN 13 ELSE 15 END AS '@_type_'
															FOR XML PATH('userOrGroup'), TYPE
														)
														,(
															SELECT
																(
																	SELECT roleId AS '@roleId'
																	FOR XML PATH ('role'), TYPE
																)
															FOR XML PATH ('properties'), TYPE
														)
													FROM @deletedOperators
													FOR XML PATH ('associations'), TYPE
												)
												,(
													SELECT @localeId AS '@localeId'
													FOR XML PATH('processinginstructioninfo'), TYPE
												 )
										FOR XML PATH('App_SecurityAssociationForEntityList')
									)
	INSERT INTO @errorTable
EXEC sec_setSecurityAssociationsFromEntity @securityAssociationsXML, @userID, 0, 0, 61, @companyId, 0, 0, 0, 0, 0, 0, 0, 0
	SET @errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
	IF @errorCode <> 0
	BEGIN
		SET @errorString = (SELECT TOP 1 errorString FROM @errorTable)
		GOTO PROC_EXIT
	END
END
PROC_EXIT:
IF @returnCursor = 1
	SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setCommvaultUserAsResellerForCompany')
	delete from GxQscripts where name = 'sec_setCommvaultUserAsResellerForCompany'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setCommvaultUserAsResellerForCompany')
	delete from GXDBVersions where aliasname = 'sec_setCommvaultUserAsResellerForCompany'
GO

insert into GXDBVersions values(2, 'sec_setCommvaultUserAsResellerForCompany',  '00000000000000000000', 'sec_setCommvaultUserAsResellerForCompany', '00000000000000000000')
GO

