

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_setClientGroupCreator.sp] ---------- 

--  +==================================================================================+
--  |Input : userId(creator) and the clientGroupId
--  |Output: Nil
--	|Description :Gives ADMN MGMT,USER MGMT and AGENT MGMT capabilities on the clientGroup to creator(userId)
--  +==================================================================================+
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_setClientGroupCreator')
BEGIN
	print '>>> Drop Stored Procedure: sec_setClientGroupCreator <<<'
	drop procedure sec_setClientGroupCreator
END
IF EXISTS (select * from GxQscripts where name='sec_setClientGroupCreator')
	delete from GxQscripts where name = 'sec_setClientGroupCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setClientGroupCreator')
	delete from GXDBVersions where aliasname = 'sec_setClientGroupCreator'
GO
print '... Creating Procedure: sec_setClientGroupCreator'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_setClientGroupCreator
  @userId int,
  @clientGroupId int
AS
DECLARE @capabilities	bigint	= 0
DECLARE @entityType		int		= 0
--Client Group creator has ADMN MGMT,USER MGMT and AGENT MGMT capabilities on the clientGroup
SET @capabilities = CAST(POWER(2.0, 1 - 1) AS bigint)
| CAST(POWER(2.0, 2 - 1) AS bigint)
SET @entityType = 2572
BEGIN
	DECLARE @errorCode INT
	DECLARE @errorString NVARCHAR(MAX)
DECLARE @clientGroupOwnerRole INT = ISNULL((SELECT id FROM UMRoles WHERE name = 'Client Group Creator'), 0)
	IF @clientGroupOwnerRole <> 0
EXEC sec_setCreatorForEntity @userId, @clientGroupOwnerRole, '', @errorCode OUTPUT, @errorString OUTPUT, 28, @clientGroupId
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_setClientGroupCreator')
	delete from GxQscripts where name = 'sec_setClientGroupCreator'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_setClientGroupCreator')
	delete from GXDBVersions where aliasname = 'sec_setClientGroupCreator'
GO

insert into GXDBVersions values(2, 'sec_setClientGroupCreator',  '00000000000000000000', 'sec_setClientGroupCreator', '00000000000000000000')
GO

