

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_rpt_getUserGroupsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ------------------------------------------------------------------------------------------------------
--
--   Description:
--   This stored procedure is used to get the list of user groups and associated permissions and entities
--	 It is used in reports
--
--   Authors: saggarwal and jswaminathan
-- ----------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_rpt_getUserGroupsInfo')
BEGIN
	print '>>> Drop Stored Procedure: sec_rpt_getUserGroupsInfo <<<'
	drop procedure sec_rpt_getUserGroupsInfo
END
IF EXISTS (select * from GxQscripts where name='sec_rpt_getUserGroupsInfo')
	delete from GxQscripts where name = 'sec_rpt_getUserGroupsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_rpt_getUserGroupsInfo')
	delete from GXDBVersions where aliasname = 'sec_rpt_getUserGroupsInfo'
GO
print '... Creating Procedure: sec_rpt_getUserGroupsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_rpt_getUserGroupsInfo
  @userGroupIds NVARCHAR(MAX),
  @outputTableArg NVARCHAR(MAX)	
AS
--Input
--List of user group Ids
DECLARE @sqlStmt NVARCHAR(MAX) = ''
IF OBJECT_ID ('tempdb.dbo.#userGroupIdInputTbl') IS NOT NULL
	DROP TABLE #userGroupIdInputTbl
CREATE TABLE #userGroupIdInputTbl (userGroupId INT)
INSERT INTO #userGroupIdInputTbl
	SELECT _ID
	FROM dbo.SplitIDs(@userGroupIds)
IF OBJECT_ID ('tempdb.dbo.#allRoles') IS NOT NULL
	DROP TABLE #allRoles
CREATE TABLE #allRoles (roleID INT)
INSERT INTO #allRoles
	SELECT roleId
	FROM UMRolesPermissions
	WHERE hierarchyLevel = 123
	EXCEPT
	SELECT roleId
	FROM UMROlesPermissions
	WHERE excludeCategory = 1 OR excludePermission = 1
--Output
SET @sqlStmt = 'SET QUOTED_IDENTIFIER ON
				INSERT INTO '+
				@outputTableArg +
				'   SELECT DISTINCT userGroupId, 0, "All Permissions", 0, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityTYpe5, entityId5
					FROM UMSecurityAssociations
					INNER JOIN #userGroupIdInputTbl ON UMSecurityAssociations.isUser = 0 AND UMSecurityAssociations.userOrGroupId = userGroupId
					INNER JOIN #allRoles AllRoles ON AllRoles.roleID = UMSecurityAssociations.roleID
					WHERE UMSecurityAssociations.permissionId = 0
					UNION
					SELECT DISTINCT userGroupId, UMPermissions.id, UMPermissions.permissionName, UMPermissions.messageId, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityTYpe5, entityId5
					FROM UMSecurityAssociations
					INNER JOIN #userGroupIdInputTbl ON UMSecurityAssociations.isUser = 0 AND UMSecurityAssociations.userOrGroupId = userGroupId
					INNER JOIN UMRolesWithPermissionsExpanded ON UMSecurityAssociations.roleId = UMRolesWithPermissionsExpanded.roleId
					INNER JOIN UMPermissions ON UMPermissions.id = UMRolesWithPermissionsExpanded.permissionID
					WHERE UMSecurityAssociations.permissionId = 0 AND UMSecurityAssociations.roleId NOT IN (SELECT * FROM #allRoles)
					UNION
					SELECT DISTINCT userGroupId, UMPermissions.id, UMPermissions.permissionName, UMPermissions.messageId, entityType1, entityID1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityTYpe5, entityId5
					FROM UMSecurityAssociations
					INNER JOIN #userGroupIdInputTbl ON UMSecurityAssociations.isUser = 0 AND UMSecurityAssociations.userOrGroupId = userGroupId
					INNER JOIN UMPermissions ON UMPermissions.id = UMSecurityAssociations.permissionID
					WHERE UMSecurityAssociations.permissionId <> 0 '
EXEC (@sqlStmt)
GO

IF EXISTS (select * from GxQscripts where name = 'sec_rpt_getUserGroupsInfo')
	delete from GxQscripts where name = 'sec_rpt_getUserGroupsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_rpt_getUserGroupsInfo')
	delete from GXDBVersions where aliasname = 'sec_rpt_getUserGroupsInfo'
GO

insert into GXDBVersions values(2, 'sec_rpt_getUserGroupsInfo',  '00000000000000000000', 'sec_rpt_getUserGroupsInfo', '00000000000000000000')
GO

