

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_rpt_Associations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2015  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
------------------------------------------------------------------------------
set nocount on
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_rpt_Associations <<<'

IF EXISTS (select * from sysobjects where name='sec_rpt_Associations')
	drop procedure sec_rpt_Associations
IF EXISTS (select * from GxQscripts where name='sec_rpt_Associations')
	delete from GxQscripts where name = 'sec_rpt_Associations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_rpt_Associations')
	delete from GXDBVersions where aliasname = 'sec_rpt_Associations'
GO
print '... Creating Procedure: sec_rpt_Associations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_rpt_Associations
  @userId integer
AS
  DECLARE @userOrGRoupId INT
  DECLARE @isUSer INT 
  DECLARE @UMentityName INT
  DECLARE @UMentityEnabled INT
  DECLARE @entityType INT
  DECLARE @entityTypeName VARCHAR(255)
  DECLARE @userEnabled INT
  DECLARE @users VARCHAR(MAX)
  DECLARE @entityAssociations VARCHAR(MAX)
  DECLARE @permissions VARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#userGroupVisible') IS NOT NULL
    DROP TABLE #userGroupVisible
CREATE TABLE #userGroupVisible (userGroupId INT)
IF OBJECT_ID('tempdb.dbo.#users') IS NOT NULL
    DROP TABLE #users
CREATE TABLE #users (userId INT)
IF OBJECT_ID('tempdb.dbo.#entityVisibleNonIda') IS NOT NULL
    DROP TABLE #entityVisibleNonIda
CREATE TABLE #entityVisibleNonIda (entityId INT)
IF OBJECT_ID('tempdb.dbo.#entityVisibleIda') IS NOT NULL
    DROP TABLE #entityVisibleIda
CREATE TABLE #entityVisibleIda (clientId INT, appTypeId INT, instanceID INT, backupsetId INT, subclientId INT)
IF OBJECT_ID('tempdb.dbo.#UserCap') IS NOT NULL
    DROP TABLE #UserCap
CREATE TABLE #UserCap(userORGRoupId INT,isUSer INT,entitytype1 INT,AssocKind VARCHAR(50),AssocName VARCHAR(MAX) ,PErmissionName  VARCHAR(MAX))
IF OBJECT_ID('tempdb.dbo.#tuserGroupentityInfo') IS NOT NULL
    DROP TABLE #tuserGroupentityInfo
	CREATE TABLE #tuserGroupentityInfo (
    userOrGroupId INT,
    isUser INT,
    roleId INT,
    permissionId INT,
    permissionName varchar(MAX),
    messageId INT,
    includeAll INT,
    entityType1 INT,
    entityID1 INT,
    entityID2 INT,
    entityID3 INT,
    entityID4 INT,
    entityID5 INT,
    AssocKind varchar(MAX),
    AssocName varchar(MAX))
DECLARE @tableName  NVARCHAR(512)
DECLARE @idColName  NVARCHAR(512)
DECLARE @entityNameColName  NVARCHAR(512)
DECLARE @entityNameinXML    NVARCHAR(512)
DECLARE @whereClause    NVARCHAR(512)
DECLARE @AssocKind  NVARCHAR(512)
DECLARE @entityTypeNameMessageId    bigint
DECLARE @entityTypeId INTEGER
DECLARE @entityTypeTable TABLE(entityType INTEGER)
exec sec_getUserGroupsForThisUser '#userGroupVisible', @userId
exec  sec_getUsersForThisUser '#users',@userId
INSERT INTO @entityTypeTable
SELECT DISTINCT entityType1 FROM UMSecurityAssociations JOIN #userGroupVisible on userGroupId=userOrGroupId and isUser=0
UNION
SELECT DISTINCT entityType1 FROM UMSecurityAssociations JOIN #users on userId=userOrGroupId and isUser=1
DECLARE entityTypeCursor Cursor FOR
select entityType from @entityTypeTable
--IDA entities
IF EXISTS (SELECT 1 FROM @entityTypeTable where entityType=3)
BEGIN
exec sec_getIdaObjectsForUser @userId,7,0,0,'#entityVisibleIda'
INSERT INTO #tuserGroupentityInfo(userOrGroupId,isUser,entityType1,entityID1,entityID2,entityID3,entityId4,entityID5,permissionId)
SELECT DISTINCT userOrGroupId,isUser,dbo.getEntityLevelFromEntityHierarchy(entityType1,entityType2,entityType3,entityType4,entityType5),entityID1,entityID2,entityID3,entityId4,entityID5
		,CASE WHEN USA.permissionId<>0 THEN USA.permissionId ELSE R.permissionId END
FROM UMSecurityAssociations USA  LEFT OUTER JOIN #userGroupVisible on userGroupId=userOrGroupId AND isUSer=0
		LEFT OUTER JOIN #users ON userOrGroupId=userId and isUser=1
		JOIN #entityVisibleIda ON entityType1=3 and entityId1=clientID AND (entityType2=0 OR (entityType2=4 and entityID2=appTypeId) )
																		AND (entityType3=0 OR (entityType3=5 and entityID3=instanceID) )
																		AND (entityType4=0 OR (entityType4=6 and entityId4=backupsetId) )
																		AND (entityType5=0 OR (entityType5=7 and entityID5=subclientId) )
	LEFT OUTER JOIN UMRolesWithPermissionsExpanded R ON USA.roleId=R.roleId and USA.roleId<>0
	WHERE (userId IS NOT NULL OR userGroupId is NOT NULL)
INSERT INTO #tuserGroupentityInfo(userOrGroupId,isUser,entityType1,entityId1,AssocName,permissionId)
	SELECT DISTINCT userOrGroupId,isUser,dbo.getEntityLevelFromEntityHierarchy(entityType1,entityType2,entityType3,entityType4,entityType5),0,'All Associations'
		,CASE WHEN USA.permissionId<>0 THEN USA.permissionId ELSE R.permissionId END
FROM UMSecurityAssociations USA  LEFT OUTER JOIN #userGroupVisible on userGroupId=userOrGroupId AND isUSer=0
		LEFT OUTER JOIN #users ON userOrGroupId=userId and isUser=1
	LEFT OUTER JOIN UMRolesWithPermissionsExpanded R ON USA.roleId=R.roleId and USA.roleId<>0
	WHERE (userId IS NOT NULL OR userGroupId is NOT NULL)  and includeALL=1 and entityType1=3
TRUNCATE TABLE #entityVisibleIda
UPDATE Tbl
set AssocKind =entityTypeName
FROM #tuserGroupentityInfo TBL JOIN APP_entity ON entityType1=entityType
UPDATE #tuserGroupentityInfo SET AssocName=name FROM APP_client WHERE id=entityID1
  update #tuserGroupentityInfo set AssocName+=' > '+APP_IDAType.name from APP_IDAType where entityId2<>0 AND APP_IDAType.type=entityId2
    update #tuserGroupentityInfo set AssocName+=' > '+APP_InstanceName.name from APP_InstanceName where entityId3<>0 AND APP_InstanceName.id=entityId3 AND APP_InstanceName.id!=1
    update #tuserGroupentityInfo set AssocName+=' > '+APP_BackupSetName.name from APP_BackupSetName where entityId4<>0 AND APP_BackupSetName.id=entityId4
    update #tuserGroupentityInfo set AssocName+=' > '+APP_Application.subclientname from APP_Application where entityId5<>0 AND APP_Application.id=entityId5;
	 WITH USerCap_CTE(userORGroupId,isUSer,entityType1,AssocKind,AssocName,PermissionName)
	 AS
	 (
	 	 SELECT userORGroupId,isUSer,entityType1,AssocKind,AssocName,PermissionName=
	 STUFF((SELECT ';'+CAST ( P.permissionName AS varchar(MAX)) FROM #tuserGroupentityInfo UG1 JOIN UMPermissions P ON P.id=UG1.permissionId
		  WHERE UG1.userORGroupId = UG2.userORGroupID AND Ug1.isUSer=UG2.isUSer AND Ug1.AssocName=UG2.AssocName AND UG1.entityType1=UG2.entityType1 ORDER BY P.permissionName
			FOR XML PATH('') ),1,1,' ')
	 FROM #tuserGroupentityInfo UG2
	 Group by userORGroupId,isUSer,entityType1,AssocKind,AssocName)
	 INSERT INTO #userCap (userORGRoupId,isUser,entityType1,AssocKind,PErmissionName,AssocName)
	 SELECT userORGRoupId,isUSer,entitytype1,AssocKind,PErmissionName,Assoc=
		STUFF((SELECT ';'+AssocNAme FROM UserCap_CTE UG2 WHERE UG1.userORGroupId = UG2.userORGroupID AND Ug1.isUSer=UG2.isUSer AND Ug1.PermissionName=UG2.PermissionName AND UG1.entityType1=UG2.entityType1 FOR XML PATH('')),1,1,'')
	 FROM USerCap_CTE UG1
	 GROUP BY userORGRoupId,isUSer,entitytype1,AssocKind,PErmissionName
	 TRUNCATE TABLE #tuserGroupentityInfo
	 END
OPEN entityTypeCursor
FETCH NEXT FROM entityTypeCursor INTO @entityTypeId
WHILE @@FETCH_STATUS=0
BEGIN
	if(@entityTypeId<>3)
	BEGIN
		 DECLARE @SQLString nvarchar(500);
      DECLARE @retValue INT
      declare @errCode        integer
	    select @tableName = tableName, @idCOlName = idColName, @entityNameColName = entityNameColName, @entityNameInXML = entityNameInXML,  @entityTYpeName = entityTypeName
        from app_entity
        where entityType = @entityTypeId
		IF(@entityNameColName ='' OR @entityNameColName   IS NULL)
		BEGIN
		 FETCH NEXT FROM entityTypeCursor INTO @entityTypeId
			CONTINUE
		END
		exec sec_getNonIdaObjectsForThisUser @userId,@entityTypeId,0,'#entityVisibleNonIda'
		INSERT INTO #tuserGroupentityInfo (userOrGroupId, isUser, permissionId, entityType1,entityId1,AssocName)
		SELECT DISTINCT userORGroupId,isUSer,CASE WHEN USA.permissionId<>0  THEN USA.permissionId ELSE RPE.permissionId END,entityType1,entityId1,CASE   WHEN includeALL= 1 THEN 'All Associations' ELSE '' END
		FROM UMSecurityAssociations USA  LEFT OUTER JOIN #userGroupVisible on userGroupId=userOrGroupId AND isUSer=0
		LEFT OUTER JOIN #users ON userOrGroupId=userId and isUser=1
		JOIN #entityVisibleNonIda ON  entityTYpe1=@entityTypeId and entityID1=entityId
		LEFT OUTER JOIN UMRolesWithPermissionsExpanded RPE ON RPE.roleId= USA.roleId and USA.roleId<>0
		WHERE (userId IS NOT NULL or userGroupId IS NOT NULL) ANd includeALL=0
		--entityNAme to Id convertor
        select @tableName = tableName, @idCOlName = idColName, @entityNameColName = entityNameColName, @entityNameInXML = entityNameInXML,  @entityTYpeName = entityTypeName
        from app_entity
        where entityType = @entityTypeId
            if @entityTypeId <> 15 and @entityTypeId <> 62
            begin
                --normal entities like client group
                set @sqlString = 'update Tbl SET AssocName =' + @entityNameColName +
                                   ' from  #tuserGroupentityInfo TBL JOIN ' + @tableName + ' ON TBL.entityId1 = '+ @idCOlName +' AND entityType1='+CAST(@entityTypeId AS VARCHAR(10))
                exec (@sqlString)
            end
            else if @entityTypeId = 15                 --special handling for user group entity and external group entity
            begin
                 UPDATE TBL
				 SET AssocName = CASE WHEN umdsproviderId =0 THEN G.name
									 ELSE  DS.domainNAme+'\'+G.name
									 END
				FROM #tuserGroupentityInfo TBL JOIN UMGroups G ON entityType1=15 and entityId1=G.id
				 LEFT OUTER JOIN UMDSProviders DS ON umdsproviderID=DS.id
            end
		INSERT INTO #tuserGroupentityInfo (userOrGroupId, isUser, permissionId, entityType1,entityId1,AssocName)
		SELECT DISTINCT userORGroupId,isUSer,CASE WHEN USA.permissionId<>0  THEN USA.permissionId ELSE RPE.permissionId END,entityType1,entityId1,'All Associations'
		FROM UMSecurityAssociations USA  LEFT OUTER JOIN #userGroupVisible on userGroupId=userOrGroupId AND isUSer=0
		LEFT OUTER JOIN #users ON userOrGroupId=userId and isUser=1
		LEFT OUTER JOIN UMRolesWithPermissionsExpanded RPE ON RPE.roleId= USA.roleId and USA.roleId<>0
		WHERE (userId IS NOT NULL or userGroupId IS NOT NULL) and includeAll=1 and entityType1=@entityTypeId
		UPDATE #tuserGroupentityInfo
		SET AssocKind=@entityTypeName
		where entityType1=@entityTypeId
	 TRUNCATE TABLE #entityVisibleNonIda
	 END
	  FETCH NEXT FROM entityTypeCursor INTO @entityTypeId
	 END;
	 WITH USerCap_CTE(userORGroupId,isUSer,entityType1,AssocKind,AssocName,PermissionName)
	 AS
	 (
	 	 SELECT userORGroupId,isUSer,entityType1,AssocKind,AssocName,PermissionName=
	 STUFF((SELECT ';'+CAST ( P.permissionName AS varchar(MAX)) FROM #tuserGroupentityInfo UG1 JOIN UMPermissions P ON P.id=UG1.permissionId
		  WHERE UG1.userORGroupId = UG2.userORGroupID AND Ug1.isUSer=UG2.isUSer AND Ug1.entityID1=UG2.entityId1 AND UG1.entityType1=UG2.entityType1 ORDER BY P.permissionName
			FOR XML PATH('') ),1,1,' ')
	 FROM #tuserGroupentityInfo UG2
	 Group by userORGroupId,isUSer,entityType1,entityId1,AssocKind,AssocName)
	 INSERT INTO #userCap (userORGRoupId,isUser,entityType1,AssocKind,PErmissionName,AssocName)
	 SELECT userORGRoupId,isUSer,entitytype1,AssocKind,PErmissionName,Assoc=
		STUFF((SELECT ';'+AssocNAme FROM UserCap_CTE UG2 WHERE UG1.userORGroupId = UG2.userORGroupID AND Ug1.isUSer=UG2.isUSer AND Ug1.PermissionName=UG2.PermissionName AND UG1.entityType1=UG2.entityType1 FOR XML PATH('')),1,1,'')
	 FROM USerCap_CTE UG1
	 GROUP BY userORGRoupId,isUSer,entitytype1,AssocKind,PErmissionName
	--Final Select
	 select TBL.id as userORGroupId,0 as isUser,Tbl.name,Tbl.groupFlags,entitytype1,Assockind,TBL.userEnabled,TBL.users,AssocName,PErmissionName from #userCap  JOIN
	 (  SELECT G.id,G.name,G.groupFlags, userEnabled=1,users=
	 STUFF((SELECT ';'+login FROM UMUSers U1  JOIN UMUserGroup ON userId=U1.id WHERE groupId=G.id AND U1.enabled = 1  FOR XML PATH('')),1,1,'')
	 FROM
	 UMGroups G  JOIN UMUserGroup ON  G.id=groupId JOIN UMUSers U ON U.id=userID and U.enabled=1
	  GRoup By G.id,G.name,G.groupFlags
	  	  UNION
	   SELECT G.id,G.name,G.groupFlags, userEnabled=0,users=
	 STUFF((SELECT ';'+login FROM UMUSers U1  JOIN UMUserGroup ON userId=U1.id WHERE groupId=G.id AND U1.enabled = 0 FOR XML PATH('')),1,1,'')
	 FROM
	  UMGroups G  JOIN UMUserGroup ON  G.id=groupId JOIN UMUSers U ON U.id=userID and U.enabled=0
	   GRoup By G.id,G.name,G.groupFlags
	UNION
	      SELECT  DISTINCT G.id,G.name,G.groupFlags, userEnabled=0,users=''
	 FROM
	  UMGroups G   LEFT OUTER JOIN UMUserGroup UG1 ON  G.id=groupId
	  WHERE UG1.groupId is NULL
	   GRoup By G.id,G.name,G.groupFlags
	  ) TBL ON TBL.id=#UserCap.userORGRoupId and isUSer=0
	  UNION
	  SELECT U.id as userOrGRoupId, 1 as isUSer,U.login,U.enabled ,entitytype1,Assockind,0,'',AssocName,PErmissionName
	  FROM #UserCap JOIN UMUsers U ON U.id=userOrGroupId and isUser=1
	  ORDER BY isUser,name,entitytype1
CLOSE entityTypeCursor
DEALLOCATE entityTypeCursor
 IF OBJECT_ID('tempdb.dbo.#userGroupVisible') IS NOT NULL
     DROP TABLE #userGroupVisible
IF OBJECT_ID('tempdb.dbo.#users') IS NOT NULL
    DROP TABLE #users
IF OBJECT_ID('tempdb.dbo.#entityVisibleNonIda') IS NOT NULL
    DROP TABLE #entityVisibleNonIda
IF OBJECT_ID('tempdb.dbo.#entityVisibleIda') IS NOT NULL
    DROP TABLE #entityVisibleIda
IF OBJECT_ID('tempdb.dbo.#tuserGroupentityInfo') IS NOT NULL
    DROP TABLE #tuserGroupentityInfo
IF OBJECT_ID('tempdb.dbo.#UserCap') IS NOT NULL
    DROP TABLE #UserCap

IF EXISTS (select * from GxQscripts where name = 'sec_rpt_Associations')
	delete from GxQscripts where name = 'sec_rpt_Associations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_rpt_Associations')
	delete from GXDBVersions where aliasname = 'sec_rpt_Associations'
GO

insert into GXDBVersions values(2, 'sec_rpt_Associations',  '00000000000000000000', 'sec_rpt_Associations', '00000000000000000000')
GO

