

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_removeExtUser.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_removeExtUser.sp,v $ $Id: sec_removeExtUser.sp,v 1.6.42.2 2018/03/20 00:47:50 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_removeExtUser()
--  |
--  | Description:  Logically removes an Extenal user & group Associations
--  |
--  |      Inputs:  userId, 'loginName'  if userId != 0 primary check, but if userId ==0
--	|				try to resolve using loginName
--	|
--	|
--  |     Returns:  errCode, errString  - errString may have log information even if
--	|									  errCode == 0
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1        skatz	Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_removeExtUser <<<'

IF EXISTS (select * from sysobjects where name='sec_removeExtUser')
	drop procedure sec_removeExtUser
IF EXISTS (select * from GxQscripts where name='sec_removeExtUser')
	delete from GxQscripts where name = 'sec_removeExtUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_removeExtUser')
	delete from GXDBVersions where aliasname = 'sec_removeExtUser'
GO
print '... Creating Procedure: sec_removeExtUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_removeExtUser
  @userId integer,
  @loginName NVARCHAR(255)
AS
  DECLARE @errCode integer
  DECLARE @errString nvarchar(255)
SET NOCOUNT ON
-------- Local Variables    -------------
DECLARE @providerId				integer
DECLARE @lastError				AS integer 		= 0		-- Be Optimistic
DECLARE @localErrorMsg			AS varchar(512) = ''
	----------------------------------------------
	-- Figure Out needed IDs before doing work	--
	----------------------------------------------
BEGIN TRY
	BEGIN TRAN
	IF @userId = 0
	BEGIN
		SET @userId     = ISNULL((Select id from UMUSERS where login = @loginName),0)
		IF @userId = 0
		BEGIN
			SET @localErrorMsg	='No login with name ['+@loginName+'] exists.'
			Set @lastError = 1
			GOTO   RETURN_RESULTS
		END
	END
	ELSE
	BEGIN
		SET @loginName = ISNULL((Select login from UMUsers where id = @userId), '')
		IF @loginName = ''
		BEGIN
			SET @localErrorMsg = 'No user with id [' + CONVERT(varchar(4), @userId) + '] exists.'
			SET @lastError = 1
			GOTO RETURN_RESULTS
		END
	END
-- IF PROVIDER ID<=0, EITHER BECAUSE IT COULDN'T BE FOUND OR ACTUALLY IS <= 0, THEN
-- THIS IS NOT AN EXTERNAL USER AND THIS SP SHOULD NOT BE USED TO MARK IT DELETED!
	SET @providerId = ISNULL((select umdsproviderId from UMUsers where id = @userId), 0)
	IF @providerId = 0
	BEGIN
		SET @localErrorMsg	='Login['+@loginName+'] is not a member of an External Domain.'
		Set @lastError = 1
		GOTO   RETURN_RESULTS
	END
------------------------------------------------
-- DO THE WORK                          	----
------------------------------------------------
	DELETE UMDSUserGroup WHERE userId=@userId								-- Delete All Groups
	SET @lastError		= @@error
	IF(@lastError=0)
	BEGIN
	DELETE UG 	FROM UMUSERGRoup UG JOIN UMGROUPS G ON G.id=UG.groupId WHERE userId = @userId   and G.umdsProviderId<>0
		SET @lastError=@@error
	END
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg	='    Error[' +convert(varchar(12), @lastError)
					+'] when attempting removal of external group references for login ['
					+ @loginName
					+ ']. No Changes to the DB will be made.'
		GOTO RETURN_RESULTS					--- FOR NOW, DEBUGGING! !@#!
	END
	UPDATE UMUSERS
	SET login = login+'[Deleted,' +Convert(varchar(5), id)+']' ,
		password = 'Password Disabled',
		email	 = 'Email Disabled',
		enabled  = 0,
		flags    = 0
	WHERE id=@userId
	SET @lastError		= @@error
	IF @lastError <> 0
	BEGIN
		SET @localErrorMsg	='    Error[' +convert(varchar(12), @lastError)
					+'] when attempting logical removal of login ['
					+ @loginName
					+ ']. No Changes to the DB will be made.'
		GOTO RETURN_RESULTS
	END
	DELETE UMUserCredentials WHERE [userId] = @userId				-- Don't wait for a refresh, invalidate cached credentials for this user
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	Set @lastError      = ERROR_NUMBER()
		SET @localErrorMsg  = 'Procedure['+ERROR_PROCEDURE()
							+'(line '
							+CONVERT(varchar(6), ERROR_LINE())
							+')], error['
							+ERROR_MESSAGE()
							+']'
END  CATCH
RETURN_RESULTS:
		IF @lastError = 0
			COMMIT TRAN
		ELSE
			ROLLBACK TRAN
		select @lastError, @localErrorMsg
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'sec_removeExtUser')
	delete from GxQscripts where name = 'sec_removeExtUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_removeExtUser')
	delete from GXDBVersions where aliasname = 'sec_removeExtUser'
GO

insert into GXDBVersions values(2, 'sec_removeExtUser',  '00010006004200020000', 'sec_removeExtUser', '00010006004200020000')
GO

