

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_pruneSecurityAssociations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--        This stored procedure prunes the stale security associations
--        from UMSecurityAssociations, UMOwners, UMOwnerRoles table
--
--
--        Authors: jswaminathan & saggarwal
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_pruneSecurityAssociations')
BEGIN
	print '>>> Drop Stored Procedure: sec_pruneSecurityAssociations <<<'
	drop procedure sec_pruneSecurityAssociations
END
IF EXISTS (select * from GxQscripts where name='sec_pruneSecurityAssociations')
	delete from GxQscripts where name = 'sec_pruneSecurityAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_pruneSecurityAssociations')
	delete from GXDBVersions where aliasname = 'sec_pruneSecurityAssociations'
GO
print '... Creating Procedure: sec_pruneSecurityAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_pruneSecurityAssociations
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(1024) OUTPUT
AS
/*delete sec
from UMSecurityAssociations sec left outer join app_client entity
on sec.entityid1 = entity.id
where sec.entityType1 = 3 and entity.id is null and sec.entityid1 <> 0
delete sec
from UMOwners Sec left outer join App_Client entity
on Sec.entityId = entity.id
where Sec.entityType = 3 and entity.id is null and Sec.entityId <> 0
delete sec
from UMOwnerRoles Sec left outer join App_Client entity
on Sec.entityId = entity.id
where Sec.entityType = 3 and entity.id is null and Sec.entityId <> 0
*/
BEGIN TRY
	DECLARE @entityType INT
	DECLARE entityTypeCursor CURSOR STATIC FOR
		SELECT DISTINCT entityType1 FROM UMSecurityAssociations (NOLOCK)
	OPEN entityTypeCursor
	FETCH NEXT FROM entityTypeCursor INTO @entityType
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @idColumnName NVARCHAR(MAX) = N''
		DECLARE @entityTableName NVARCHAR(MAX) = N''
		DECLARE @sqlStatement NVARCHAR(MAX) = N''
		SELECT @entityTableName = tableName, @idColumnName = idColName
		FROM APP_Entity (NOLOCK)
		WHERE entityType = @entityType
		IF @entityTableName IS NULL OR @entityTableName = '' OR @idColumnName IS NULL OR @idColumnName = ''
		BEGIN
			FETCH NEXT FROM entityTypeCursor INTO @entityType
			CONTINUE
		END
		--1. Prune UMSecurityAssociations
if(@entityType=1)
		BEGIN
			SET @sqlStatement = 'DELETE Sec ' + CHAR(10) +
							'FROM UMSecurityAssociations Sec LEFT OUTER JOIN ' + @entityTableName + ' entity' + CHAR(10) +
							'ON Sec.entityId1 = entity.' + @idColumnName + CHAR(10) +
							'WHERE Sec.entityType1 = ' + CAST(@entityType AS NVARCHAR(10)) + ' AND Entity.' + @idColumnName + ' IS NULL AND Sec.entityId1 <> 0
							AND sec.entityId1<>2'
		END
		ELSE
			SET @sqlStatement = 'DELETE Sec ' + CHAR(10) +
							'FROM UMSecurityAssociations Sec LEFT OUTER JOIN ' + @entityTableName + ' entity' + CHAR(10) +
							'ON Sec.entityId1 = entity.' + @idColumnName + CHAR(10) +
							'WHERE Sec.entityType1 = ' + CAST(@entityType AS NVARCHAR(10)) + ' AND Entity.' + @idColumnName + ' IS NULL AND Sec.entityId1 <> 0'
		EXEC (@sqlStatement)
		--2. Prune UMOwners
		SET @sqlStatement = 'DELETE Sec ' + CHAR(10) +
							'FROM UMOwners Sec LEFT OUTER JOIN ' + @entityTableName + ' entity' + CHAR(10) +
							'ON Sec.entityId = entity.' + @idColumnName + CHAR(10) +
							'WHERE Sec.entityType = ' + CAST(@entityType AS NVARCHAR(10)) + ' AND Entity.' + @idColumnName + ' IS NULL AND Sec.entityId <> 0'
		EXEC (@sqlStatement)
		--3. Prune UMOwnerRoles
		SET @sqlStatement = 'DELETE Sec ' + CHAR(10) +
							'FROM UMOwnerRoles Sec LEFT OUTER JOIN ' + @entityTableName + ' entity' + CHAR(10) +
							'ON Sec.entityId = entity.' + @idColumnName + CHAR(10) +
							'WHERE Sec.entityType = ' + CAST(@entityType AS NVARCHAR(10)) + ' AND Entity.' + @idColumnName + ' IS NULL AND Sec.entityId <> 0'
		EXEC (@sqlStatement)
		FETCH NEXT FROM entityTypeCursor INTO @entityType
	END
	CLOSE entityTypeCursor
	DEALLOCATE entityTypeCursor
	--DELETE stale custom roles.
	--1.Custom role which are still associated to some entity but all permissions in them are removed.
	DELETE FROM UMSecurityAssociations
WHERE roleID  in (SELECT id FROM UMRoles where flags&32 <> 0
					 EXCEPT SELECT distinct roleId FROM UMRolesPermissions)
	--2. Delete custom roles which are not associated with any entity now.
	DECLARE @tempCustomRoleTbl TABLE (roleId integer)
	INSERT INTO  @tempCustomRoleTbl
SELECT id FROM UMRoles where flags&32 <> 0
	EXCEPT SELECT distinct roleId FROM UMSecurityAssociations where roleId<>0
	DELETE FROM UMRolesWithPermissionsExpanded  where roleId in (SELECT * from @tempCustomRoleTbl)
	DELETE FROM UMRolesPErmissions   where roleId in (SELECT * from @tempCustomRoleTbl)
	DELETE FROM UMroles  where id in (SELECT * from @tempCustomRoleTbl)
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@ERROR
	SET @errorString = 'ERROR: PROC(' + ERROR_PROCEDURE() +
						'), LINE(' + CAST(ERROR_LINE() AS NVARCHAR(10)) +
						'), ERROR(' + CAST(ERROR_NUMBER() AS NVARCHAR(10)) +
						'), INFO: ' + ERROR_MESSAGE() + '.'
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_pruneSecurityAssociations')
	delete from GxQscripts where name = 'sec_pruneSecurityAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_pruneSecurityAssociations')
	delete from GXDBVersions where aliasname = 'sec_pruneSecurityAssociations'
GO

insert into GXDBVersions values(2, 'sec_pruneSecurityAssociations',  '00000000000000000000', 'sec_pruneSecurityAssociations', '00000000000000000000')
GO

