

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_populateSecurityAssociationsTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- --------------------------------------------------------------------------------------------------
--
--   Description: This SP is used to set the security associations set
--                from entity level and user properties and user group
--				  level - this is a internal SP should not be called
--                from any SP outside
--				  When this SP is called there should be a table called as
--                #inpuConsolidated that has <entity - user / group - role / permission>
--				  This does some security checks before setting the security associations
--				  We should have these rights to do the 3 way security associations
--						1. Change Security on the entity
--						2. Permissions that the user is trying to give should be possessed by him on that entity
--						3. View rights on the user / group
--   Authors: saggarwal and jswaminathan
-- ----------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_populateSecurityAssociationsTable')
BEGIN
	print '>>> Drop Stored Procedure: sec_populateSecurityAssociationsTable <<<'
	drop procedure sec_populateSecurityAssociationsTable
END
IF EXISTS (select * from GxQscripts where name='sec_populateSecurityAssociationsTable')
	delete from GxQscripts where name = 'sec_populateSecurityAssociationsTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateSecurityAssociationsTable')
	delete from GXDBVersions where aliasname = 'sec_populateSecurityAssociationsTable'
GO
print '... Creating Procedure: sec_populateSecurityAssociationsTable'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_populateSecurityAssociationsTable
  @callerId INT,
  @entityType1 INT,
  @entityId1 INT,
  @entityType2 INT,
  @entityId2 INT,
  @entityType3 INT,
  @entityId3 INT,
  @entityType4 INT,
  @entityId4 INT,
  @entityType5 INT,
  @entityId5 INT,
  @userId INT,
  @userGroupId INT,
  @contextInformation INT,
  @securityAssociationsOperationType INT,
  @localeId INT,
  @skipSecurityCheck INT, 
  @errorCode INT OUTPUT,
  @errorString NVARCHAR(1024) OUTPUT,
  @processHiddenPermission INT = 0,
  @organizationId INT = 0
AS
--Things to do further on this SP:
		--1. Popluate all error messages properly
	--Output variables
	SET @errorCode = 0							--Be optimistic
	SET @errorString = 'Successful'
	DECLARE @skipUserSecurityCheck INT=@skipSecurityCheck
IF(@entityType1=28)
	BEGIN
		--check if caller userID is creator of client group.THan skip change security settings and 3rd security check.
		DECLARE @creatorId INT
EXEC sec_getCreateAsUserId 28, @entityId1, @creatorId OUTPUT
		IF(@callerId=@creatorID)
			SET @skipSecurityCheck=1
	END
	DECLARE @isUser INTEGER
	DECLARE @userOrGroupId INTEGER
	DECLARE @outputXML XML
	DECLARE @permissionString nvarchar(max)	=''
	DECLARE @hasAllNoAssociationsPermission INTEGER=0
	IF(@userId<>0)
	BEGIN
		SET @isUser=1
		SET @userOrGroupId=@userId
	END
	ELSE
	BEGIN
		SET @isUser=0
		SET @userOrGroupId=@usergroupId
	END
		if(@organizationId<>0)
	BEGIN
		SET @isUser=2
		SET @userOrGroupId=@organizationId
	END
	DECLARE @invalidChar NVARCHAR(MAX) = N''
DECLARE @skipAssocPermissionCheck INTEGER=(ISNULL((SELECT CASE WHEN CAST(value AS NVARCHAR(10))= 'true' AND enabled = 1 THEN 1 ELSE 0 END FROM APP_AdvanceSettings WHERE keyName = 'skipIndividualPermissionCheck'),0))
DECLARE @ifDebugging INT
SET @ifDebugging = 0						--Will be turned on if something needs to be debugged
IF @ifDebugging = 1
BEGIN
	DECLARE @tempEntityType1 AS INT
	DECLARE @tempEntityId1 AS INT
	DECLARE @tempEntityType2 AS INT
	DECLARE @tempEntityId2 AS INT
	DECLARE @tempEntityType3 AS INT
	DECLARE @tempEntityId3 AS INT
	DECLARE @tempEntityType4 AS INT
	DECLARE @tempEntityId4 AS INT
	DECLARE @tempEntityType5 AS INT
	DECLARE @tempEntityId5 AS INT
	DECLARE @tempRoleId AS INT
	DECLARE @tempPermissionId AS INT
	DECLARE @tempisUser AS INT
	DECLARE @tempUserOrGroupId AS INT
	DECLARE @customRoleXML AS XML
	DECLARE tempCursor CURSOR STATIC FOR
		SELECT entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, roleId, permissionId, userOrGroupId, isUser ,customRoleXML
		FROM #inputConsolidated
	OPEN tempCursor
	FETCH NEXT FROM tempCursor INTO @tempEntityType1, @tempEntityId1, @tempEntityType2, @tempEntityId2, @tempEntityType3, @tempEntityId3, @tempEntityType4, @tempEntityId4, @tempEntityType5, @tempEntityId5, @tempRoleId, @tempPermissionId, @tempUserOrGroupId, @tempIsUser
	WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT CAST(@tempEntityType1 AS NVARCHAR(MAX)) + ' ' + CAST (@tempEntityId1 AS NVARCHAR(MAX)) + ' ' +
			  CAST (@tempEntityTYpe2 AS NVARCHAR(MAX))  + ' '+ CAST(@tempEntityId2 AS NVARCHAR(MAX)) + ' '+
			  CAST (@tempEntityTYpe3 AS NVARCHAR(MAX))  + ' '+CAST(@tempEntityId3 AS NVARCHAR(MAX)) + ' '+
			  CAST (@tempEntityTYpe4 AS NVARCHAR(MAX))  + ' '+ CAST(@tempEntityId4 AS NVARCHAR(MAX)) + ' '+
			  CAST (@tempEntityTYpe5 AS NVARCHAR(MAX))  + ' '+CAST(@tempEntityId5 AS NVARCHAR(MAX)) + ' '+
			  CAST (@tempRoleId AS NVARCHAR(MAX))  + ' '+ CAST(@tempPermissionId AS NVARCHAR(MAX)) + ' '+
			  CAST (@tempUserOrGroupId AS NVARCHAR(MAX)) + ' ' + CAST (@tempIsUser AS NVARCHAR(MAX)) + ' ' +
			  CAST (@customRoleXML AS NVARCHAR(MAX))
		FETCH NEXT FROM tempCursor INTO @tempEntityType1, @tempEntityId1, @tempEntityType2, @tempEntityId2, @tempEntityType3, @tempEntityId3, @tempEntityType4, @tempEntityId4, @tempEntityType5, @tempEntityId5, @tempRoleId, @tempPermissionId, @tempUserOrGroupId, @tempIsUser
	END
	CLOSE tempCursor
	DEALLOCATE tempCursor
END
	--Any validation of #inputConsolidated needed ?
	IF OBJECT_ID ('tempdb.dbo.#CustomRolesExpanded') IS NOT NULL DROP TABLE #CustomRolesExpanded
	CREATE TABLE #CustomRolesExpanded
	(
		roleId INT,
		permissionId INT
	)
	IF OBJECT_ID ('tempdb.dbo.#SecurityAssociationsAdded') IS NOT NULL DROP TABLE #SecurityAssociationsAdded
	CREATE TABLE #SecurityAssociationsAdded
	(
		entityType1 INT,
		entityId1 INT,
		entityType2 INT,
		entityId2 INT,
		entityType3 INT,
		entityId3 INT,
		entityType4 INT,
		entityId4 INT,
		entityType5 INT,
		entityId5 INT,
		roleId INT,
		permissionId INT,
		userOrGroupId INT,
		isUser INT,
		includeAll INT,
		isCustomRolePermission INT DEFAULT 0
	)
	IF OBJECT_ID ('tempdb.dbo.#SecurityAssociationsDeleted') IS NOT NULL DROP TABLE #SecurityAssociationsDeleted
	CREATE TABLE #SecurityAssociationsDeleted
	(
		entityType1 INT,
		entityId1 INT,
		entityType2 INT,
		entityId2 INT,
		entityType3 INT,
		entityId3 INT,
		entityType4 INT,
		entityId4 INT,
		entityType5 INT,
		entityId5 INT,
		roleId INT,
		permissionId INT,
		userOrGroupId INT,
		isUser INT,
		includeAll INT,
		isCustomRolePermission INT DEFAULT 0
	)
	DECLARE @inputNoAssocPermission TABLE(permissionId integer)
	DECLARE  @permissionListUserDontHaveRight TABLE(permissionId INT)
	IF OBJECT_ID('tempdb.dbo.#sec_populatepermissionTablePermissionList') IS NOT NULL
				DROP TABLE #sec_populatepermissionTablePermissionList
	CREATE TABLE #sec_populatepermissionTablePermissionList (permissionId INT)
	DECLARE @usersAndGroupsVisible TABLE (userOrGroupId INT, isUser INT)
	IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
				DROP TABLE #VisibleUsersAndUserGroups
	CREATE TABLE #VisibleUsersAndUserGroups (userOrGroupId INT)
	DECLARE @usersCallerDontHaveRight TABLE (userId INT)
	DECLARE @userGroupsCallerDontHaveRight TABLE (userGroupId INT)
	DECLARE @ProviderDontHaveRight TABLE (providerId INT)
	--Processing custom Role
	DECLARE @customRoleProcess TABLE
	(
		entityType1 INT,
		entityId1 INT,
		entityType2 INT,
		entityId2 INT,
		entityType3 INT,
		entityId3 INT,
		entityType4 INT,
		entityId4 INT,
		entityType5 INT,
		entityId5 INT,
		includeALL INT,
		customRoleXml XML,
		userOrGroupId INTEGER,
		isUSer INTEGER,
		isRoleOrPermissionExist INTEGER DEFAULT 0,
		isCategorySelectinputXML INTEGEr DEFAULT 0,
		customRoleId INTEGER DEFAULT 0
	)
	--There can be duplicate row in input xml SO let combine them and than only insert
	INSERT INTO @customRoleProcess(entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5,includeALL,userOrGroupId,isUser,customRoleXML)
	SELECT entityType1,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,	entityId4 ,	entityType5 ,entityId5 ,includeALL,userOrGroupId ,isUser,
			(SELECT @securityAssociationsOperationType as '@operationType',
				(SELECT customRoleXML.query('/categoryPermission/categoriesPermissionList')
					From #inputConsolidated Tbl
					WHERE tbl.entityType1=Input.entityType1 and tbl.entityId1=Input.entityId1
						and tbl.entityType2=Input.entityType2 and tbl.entityId2=Input.entityId2
						and tbl.entityType3=Input.entityType3 and tbl.entityId3=Input.entityId3
						and tbl.entityType4=Input.entityType4 and tbl.entityId4=Input.entityId4
						and tbl.entityType5=Input.entityType5 and tbl.entityId5=Input.entityId5
						and tbl.includeALL=Input.includeALL
						and tbl.isUSer=Input.isUser and tbl.userORGroupId=Input.userORGroupId
						AND roleId=0 and permissionId=0 and customRoleXML.exist('categoryPermission')<>0
					FOR XML PATH(''),TYPE)
					FOR XML PATH('categoryPermission'))
		FROM #inputConsolidated Input
		WHERE roleId=0 and permissionId=0 and customRoleXML.exist('categoryPermission')<>0
		group by entityType1,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,	entityId4 ,	entityType5 ,entityId5 ,includeALL,userOrGroupId ,isUser
		UPDATE CR
		set isRoleOrPermissionExist =1, customRoleId=SA.roleId
		fROM @customRoleProcess CR
		JOIN UMSecurityAssociations SA WITH ( NOLOCK   )
		ON CR.entityType1=SA.entityType1 AND CR.entityId1=Sa.entityId1
		  AND CR.entityType2=SA.entityType2 AND CR.entityId2=Sa.entityId2
		  AND CR.entityType3=SA.entityType3 AND CR.entityId3=Sa.entityId3
		  AND CR.entityType4=SA.entityType4 AND CR.entityId4=Sa.entityId4
		  AND CR.entityType5=SA.entityType5 AND CR.entityId5=Sa.entityId5
		  AND CR.userOrGroupId =SA.userOrGroupId
		AND CR.isUSer=SA.isUSer
JOIN UMRoles ON roleId=id and flags&32<>0
	WHERE SA.roleId<>0
	UPDATE CR
		set isRoleOrPermissionExist =2
		fROM @customRoleProcess CR
		JOIN UMSecurityAssociations SA  WITH ( NOLOCK   )
		ON CR.entityType1=SA.entityType1 AND CR.entityId1=Sa.entityId1
		  AND CR.entityType2=SA.entityType2 AND CR.entityId2=Sa.entityId2
		  AND CR.entityType3=SA.entityType3 AND CR.entityId3=Sa.entityId3
		  AND CR.entityType4=SA.entityType4 AND CR.entityId4=Sa.entityId4
		  AND CR.entityType5=SA.entityType5 AND CR.entityId5=Sa.entityId5
		  AND CR.userOrGroupId =SA.userOrGroupId
		  AND CR.isUSer=SA.isUSer
		WHERE permissionId<>0
	UPDATE CR
	SET isCategorySelectinputXML=1
	FROM @customRoleProcess CR
	CROSS APPLY
	CR.customRoleXml.nodes('categoryPermission/categoriesPermissionList') AS P(R)
WHERE R.value('(@_type_)[1]', 'INT') in (121,123)  OR  (R.value('(@_type_)[1]', 'INT')=122 and  R.value('(flags/@exclude)[1]', 'INT')=1)
	--Now for rows in @customRoleProcess for which isCategorySelectionInputXml=0 and isRolesOrPERmissionExists<>1 implies they are plain permissions and can just directly be added/deleted in UMsecurityAssocitions
	--We will just insert into #inputConsolidated. Rest will be taken care by code flow.
	INSERT INTO #inputConsolidated(entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4,entityType5,entityId5,roleId,permissionId ,customRoleXML ,userOrGroupId ,isUser ,includeAll)
	SELECT  entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4,entityType5,entityId5,0,R.value('(@permissionId)[1]','INT') ,'' ,userOrGroupId ,isUser ,includeAll
	FROM @customRoleProcess CR
	CROSS APPLY CR.customRoleXml.nodes('categoryPermission/categoriesPermissionList') AS P(R)
WHERE R.value('(@_type_)[1]', 'INT') =122 AND isCategorySelectinputXML=0 and isRoleOrPermissionExist<>1
	DELETE FROM @customRolePRocess
	WHERE isCategorySelectinputXML=0 and isRoleOrPermissionExist<>1
---------------------------------------------Custom Role Computation and Calcualting Diff for custom role permission alone------------------------------------------------------
	--Now for rows for which isRoleOrPermissionsExist=1 ( means some role is already selected and we should edit that role only)
						 -- isRoleOrPermissionsExist=2 : only some individual permissions are present in DB and we should condider them.
	--So for isRoleOrPermissionsExist=1 OR isCategorySelectionInputXML , we should consider role. flag isRoleOrPErmissionsExist can be used to decide if we need to send add role or edit role and to include permission
	DECLARE @CREntityType1 AS INT
	DECLARE @CREntityId1 AS INT
	DECLARE @CREntityType2 AS INT
	DECLARE @CREntityId2 AS INT
	DECLARE @CREntityType3 AS INT
	DECLARE @CREntityId3 AS INT
	DECLARE @CREntityType4 AS INT
	DECLARE @CREntityId4 AS INT
	DECLARE @CREntityType5 AS INT
	DECLARE @CREntityId5 AS INT
	DECLARE @CRXML AS XML
	DECLARE @CRisRoleOrPermissionExist AS INT
	DECLARE @CRUserOrGroupId AS INT
	DECLARE @CRisUser AS INT
	DECLARE @CRcustomRoleId  AS INT
	DECLARE @CRincludeAll AS INT
	DECLARE customRoleCursor CURSOR STATIC FOR
		SELECT  entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5,includeALL,userOrGroupId, isUser,customRoleXML,isRoleOrPermissionExist,customRoleId
		FROM @customRoleProcess
		WHERE isRoleOrPermissionExist=1 OR isCategorySelectinputXML=1
	OPEN customRoleCursor
	FETCH NEXT FROM customRoleCursor INTO @CREntityType1, @CREntityId1, @CREntityType2, @CREntityId2, @CREntityType3, @CREntityId3, @CREntityType4, @CREntityId4, @CREntityType5, @CREntityId5,@CRincludeAll,@CRUserOrGroupId, @CRisUser, @CRXML, @CRisRoleOrPermissionExist, @CRcustomRoleId
	WHILE @@FETCH_STATUS=0
	BEGIN
		--Any validation of #inputConsolidated needed ?
IF OBJECT_ID ('tempdb.dbo.#UMRolesPermissionExpandedTempTable') IS NOT NULL DROP TABLE #UMRolesPermissionExpandedTempTable
CREATE TABLE #UMRolesPermissionExpandedTempTable
	(
		roleId integer,
		categoryId integer,
		permissionId integer
	)
		--Depending on operation type and  isRoleOrPermissionExist flag do operation.
		DECLARE @customRoleName nvarchar(510)
		--1. For overwrite operation nothing needs to be manipulated. Just fire edit or create role request.
		--2. For operationType =2 ADD.. need to check if some permission is present in UMSecurity Table , we should merge it
		IF(@securityAssociationsOperationType=2 AND @CRisRoleOrPermissionExist=2)  -- implies some permission exists in UMSecurityAssocition table. So we should merge it if operationtype is ADD.
		BEGIN
DECLARE @existingPermissionXMl XML = (SELECT  122 	as '@_type_',
														  permissionId  as '@permissionId'
													FROM UMSecurityAssociations SA  WITH ( NOLOCK   )
													WHERE @CREntityType1=SA.entityType1 AND @CREntityId1=Sa.entityId1
														  AND @CREntityType2=SA.entityType2 AND @CREntityId2=Sa.entityId2
														  AND @CREntityType3=SA.entityType3 AND @CREntityId3=Sa.entityId3
														  AND @CREntityType4=SA.entityType4 AND @CREntityId4=Sa.entityId4
														  AND @CREntityType5=SA.entityType5 AND @CREntityId5=Sa.entityId5
														  AND @CRUserOrGroupId =SA.userOrGroupId
														  AND @CRIsUSer=SA.isUser
														  AND	@CRincludeAll=SA.includeALL
														  AND permissionId<>0
													FOR XML PATH ('categoriesPermissionList'))
			IF(@existingPermissionXMl.exist('categoriesPermissionList')<>0)
			SET @CRXML.modify('insert sql:variable("@existingPermissionXMl") into (/categoryPermission)[1]')
		END
		IF(@CRisRoleOrPermissionExist=1 and @CRcustomRoleId<>0)  --some custom role already exists for this associations so lets get roleId and edit same.
		BEGIN
			DECLARE @customRoleEditXML XML=
			(SELECT 'Custom role for entity' AS '@description',
                                   (SELECT @CRcustomRoleId AS '@roleId'
                                   FOR XML PATH ('role'), TYPE),
                                    (SELECT @securityAssociationsOperationType as '@categoriesPermissionOperationType',
											(SELECT @CRXML.query('categoryPermission/categoriesPermissionList') FOR XML PATH(''),TYPE)
										FOR XML PATH('categoryPermission'),TYPE)
                           FOR XML PATH ('Security_Role'))
EXEC sec_editRole @customRoleEditXML, 1, 1, @outputXML OUTPUT, 0
			SET @errorCode = ISNULL((SELECT UG.value('@errorCode', 'INT')
                                 FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), 0)
			SET @errorString = ISNULL((SELECT UG.value('@errorString', 'NVARCHAR(MAX)')
                                   FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), N'')
            IF @errorCode <> 0
			BEGIN
				CLOSE customRoleCursor
				DEALLOCATE customRoleCursor
				GOTO END_PROCESSING
			END
		END
		ELSE
		BEGIN
			--Custom role doesn't exists,
SET @customRoleName = 'CustomRole'+'_Entity'+'_'+CAST(@CREntityType1 AS varchar(MAX))+'_'+CAST(@CREntityId1 AS varchar(MAX))
																+'_'+CAST(@CREntityType2 AS varchar(MAX))+'_'+CAST(@CREntityId2 AS varchar(MAX))
																+'_'+CAST(@CREntityType3 AS varchar(MAX))+'_'+CAST(@CREntityId3 AS varchar(MAX))
																+'_'+CAST(@CREntityType4 AS varchar(MAX))+'_'+CAST(@CREntityId4 AS varchar(MAX))
																+'_'+CAST(@CREntityType5 AS varchar(MAX))+'_'+CAST(@CREntityId5 AS varchar(MAX))
																+'_UserORGroup'+CAST(@CRUserOrGroupId AS varchar(MAX))+'_'+CAST(@isUser AS varchar(MAX))
																+ '_' + CAST(dbo.getUnixTime(GETUTCDATE()) AS NVARCHAR(MAX))
			SET @customRoleXML = (SELECT 'System created owner role for entity' AS '@description',
                                   (SELECT @customRoleName AS '@roleName'
                                   FOR XML PATH ('role'), TYPE),
                                    (SELECT @securityAssociationsOperationType as '@categoriesPermissionOperationType',
											(SELECT @CRXML.query('categoryPermission/categoriesPermissionList') FOR XML PATH(''),TYPE)
										FOR XML PATH('categoryPermission'),TYPE)
                           FOR XML PATH ('Security_Role'))
EXEC sec_createRole @customRoleXML, 1, 1, @outputXML OUTPUT, 0, 36
			SET @CRcustomRoleId=(SELECt id from UMroles WHERE NAME =@customRoleName)
			SET @errorCode = ISNULL((SELECT UG.value('@errorCode', 'INT')
                                 FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), 0)
			SET @errorString = ISNULL((SELECT UG.value('@errorString', 'NVARCHAR(MAX)')
                                   FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), N'')
            IF @errorCode <> 0 and @CRcustomRoleId<>0
			BEGIN
				CLOSE customRoleCursor
				DEALLOCATE customRoleCursor
				GOTO END_PROCESSING
			END
		END
		INSERT INTO #CustomRolesExpanded
		SELECT  @CRcustomRoleId,permissionId
FROM #UMRolesPermissionExpandedTempTable
		--there might be chance there is no permissions in role. SO in that case #UMRolesPermissionExpandedTempTable will be empty. But in end of procedure we need to delete it from our UMRolesWithPErmissionExpanded table.
		--For this we need to have roleId, so lets insert roleId in #customROlesExpanded so we can delete it later with permissionId as NULL
		IF NOT EXISTS (SELECT 1 FROM #UMRolesPermissionExpandedTempTable)
			INSERT INTO #CustomRolesExpanded (roleId)
			SELECT @CRcustomRoleId
		--now to ensure custom role get added and deleted we will insert into #inputConsolidated so later on it can be considered into diff automaticallye
		IF (@securityAssociationsOperationType = 1) OR (@securityAssociationsOperationType = 2)
		INSERT INTO #inputConsolidated(entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4,entityType5,entityId5,roleId,permissionId ,customRoleXML ,userOrGroupId ,isUser ,includeAll)
		SELECT @CREntityType1, @CREntityId1, @CREntityType2, @CREntityId2, @CREntityType3, @CREntityId3, @CREntityType4, @CREntityId4, @CREntityType5, @CREntityId5,
			    @CRcustomRoleId,0,'', @CRuserOrGroupId, @CRisUser,@CRincludeAll
		--Add into added or deleted table for security checks.we dont need to worry about operation type here.
		INSERT INTO #SecurityAssociationsAdded
		SELECT @CREntityType1, @CREntityId1, @CREntityType2, @CREntityId2, @CREntityType3, @CREntityId3, @CREntityType4, @CREntityId4, @CREntityType5, @CREntityId5,
			    0,permissionId, @CRuserOrGroupId, @CRisUser,@CRincludeAll,1
FROM #UMRolesPermissionExpandedTempTable
		WHERE permissionId not in (SELECT permissionId FROM UMRolesWithPermissionsExpanded where roleId=@CRcustomRoleId
									UNION
									SELECT permissionId FROM UMSecurityAssociations SA
									WHERE @CREntityType1=SA.entityType1 AND @CREntityId1=Sa.entityId1
														  AND @CREntityType2=SA.entityType2 AND @CREntityId2=Sa.entityId2
														  AND @CREntityType3=SA.entityType3 AND @CREntityId3=Sa.entityId3
														  AND @CREntityType4=SA.entityType4 AND @CREntityId4=Sa.entityId4
														  AND @CREntityType5=SA.entityType5 AND @CREntityId5=Sa.entityId5
														  AND @CRUserOrGroupId =SA.userOrGroupId
														  AND @CRIsUSer=SA.userOrGroupId
														  AND	@CRincludeAll=SA.includeALL
														  AND permissionId<>0
									)
		INSERT INTO #SecurityAssociationsDeleted
		SELECT @CREntityType1, @CREntityId1, @CREntityType2, @CREntityId2, @CREntityType3, @CREntityId3, @CREntityType4, @CREntityId4, @CREntityType5, @CREntityId5,
			    0,permissionId, @CRuserOrGroupId, @CRisUser,@CRincludeAll,1
		FROM
		(SELECT permissionId
				FROM UMRolesWithPermissionsExpanded WHERE roleId=@CRcustomRoleId
		 UNION
		 SELECT permissionId FROM UMSecurityAssociations  SA
									WHERE @CREntityType1=SA.entityType1 AND @CREntityId1=Sa.entityId1
														  AND @CREntityType2=SA.entityType2 AND @CREntityId2=Sa.entityId2
														  AND @CREntityType3=SA.entityType3 AND @CREntityId3=Sa.entityId3
														  AND @CREntityType4=SA.entityType4 AND @CREntityId4=Sa.entityId4
														  AND @CREntityType5=SA.entityType5 AND @CREntityId5=Sa.entityId5
														  AND @CRUserOrGroupId =SA.userOrGroupId
														  AND @CRIsUSer=SA.userOrGroupId
														  AND	@CRincludeAll=SA.includeALL
														  AND permissionId<>0
		)tbl
where permissionId not in (select permissionId FROM #UMRolesPermissionExpandedTempTable)
		FETCH NEXT FROM customRoleCursor INTO @CREntityType1, @CREntityId1, @CREntityType2, @CREntityId2, @CREntityType3, @CREntityId3, @CREntityType4, @CREntityId4, @CREntityType5, @CREntityId5,@CRincludeAll,@CRUserOrGroupId, @CRisUser, @CRXML, @CRisRoleOrPermissionExist, @CRcustomRoleId
	END
	CLOSE customRoleCursor
	DEALLOCATE customRoleCursor
	--For OVERWRITE and ADD operation types, Added table is Input - DB (excluding creator entries)
	IF(@contextInformation = 3)
	BEGIN
		DECLARE @excludedCommcellsforMulticommcell TABLE (entityId INT)
		INSERT INTO @excludedCommcellsforMulticommcell
		SELECT ACP.CommCellId FROM 	APP_CommCell AC
						INNER JOIN APP_CommCellProp ACP
								ON AC.id = ACP.CommCellId
						INNER JOIN APP_ClientProp CP
								ON CP.componentNameId = AC.clientId
WHERE (ACP.CommcellType & 16 = 16)
AND CP.attrName = 'Cloud Service For MSP' AND CP.attrVal = 1
	END
	IF (@securityAssociationsOperationType = 1) OR (@securityAssociationsOperationType = 2)
	BEGIN
		IF @contextInformation = 1			--from entity level
		BEGIN
			INSERT INTO #SecurityAssociationsAdded (entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4 ,entityType5 ,entityId5 ,roleId ,permissionId ,userOrGroupId ,isUser ,includeAll)
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, 0
				FROM #inputConsolidated
				WHERE roleId<>0 OR permissionId<>0
				EXCEPT
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, 0
				FROM UMSecurityAssociations
				WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND entityType2 = @entityType2 AND entityId2 = @entityId2 AND entityType3 = @entityType3 AND entityId3 = @entityId3 AND entityType4 = @entityType4 AND entityId4 = @entityId4 AND entityType5 = @entityType5 AND entityId5 = @entityId5
				AND isCreator = 0
		END
		ELSE IF @contextInformation = 2
		BEGIN
			INSERT INTO #SecurityAssociationsAdded(entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4 ,entityType5 ,entityId5 ,roleId ,permissionId ,userOrGroupId ,isUser ,includeAll)
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM #inputConsolidated
				WHERE roleId<>0 OR permissionId<>0
				EXCEPT
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM UMSecurityAssociations
				WHERE isUser = @isUser AND userOrGroupId = @UserOrGroupId
				AND isCreator = 0
		END
		ELSE IF @contextInformation = 3
		BEGIN
			INSERT INTO #SecurityAssociationsAdded(entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4 ,entityType5 ,entityId5 ,roleId ,permissionId ,userOrGroupId ,isUser ,includeAll)
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM #inputConsolidated
				LEFT JOIN @excludedCommcellsforMulticommcell ex
ON ex.entityId = #inputConsolidated.entityId1 and #inputConsolidated.entityType1 = 194
				WHERE roleId<>0 and entityType1=@entityType1 and (@entityId1 = 0 or @entityId1 = entityId1) and (ex.entityId IS NULL)
				EXCEPT
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM UMSecurityAssociations
				WHERE isCreator = 0 and entityType1=@entityType1
		END
	END
	--For OVERWRITE, Deleted table is DB(excluding creator entry) - Input
	IF @securityAssociationsOperationType = 1	--OVERWRITE
	BEGIN
		IF @contextInformation = 1
		BEGIN
			INSERT INTO #SecurityAssociationsDeleted(entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4 ,entityType5 ,entityId5 ,roleId ,permissionId ,userOrGroupId ,isUser ,includeAll)
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, 0
				FROM UMSecurityAssociations
				WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND entityType2 = @entityType2 AND entityId2 = @entityId2 AND entityType3 = @entityType3 AND entityId3 = @entityId3 AND entityType4 = @entityType4 AND entityId4 = @entityId4 AND entityType5 = @entityType5 AND entityId5 = @entityId5
				AND isCreator = 0
				EXCEPT
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, 0
				FROM #inputConsolidated
				WHERE roleId<>0 OR permissionId<>0
		END
		ELSE IF @contextInformation = 2
		BEGIN
			INSERT INTO #SecurityAssociationsDeleted(entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4 ,entityType5 ,entityId5 ,roleId ,permissionId ,userOrGroupId ,isUser ,includeAll)
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM UMSecurityAssociations
				WHERE isUser = @isUser AND userOrGroupId = @UserOrGroupId
				AND isCreator = 0
				EXCEPT
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM #inputConsolidated
				WHERE roleId<>0 OR permissionId<>0
		END
		ELSE IF @contextInformation = 3
		BEGIN
			INSERT INTO #SecurityAssociationsDeleted(entityType1 ,entityId1 ,entityType2 ,entityId2 ,entityType3 ,entityId3 ,entityType4 ,entityId4 ,entityType5 ,entityId5 ,roleId ,permissionId ,userOrGroupId ,isUser ,includeAll)
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM UMSecurityAssociations
				LEFT JOIN @excludedCommcellsforMulticommcell ex
ON ex.entityId = UMSecurityAssociations.entityId1 and UMSecurityAssociations.entityType1 = 194
				WHERE isCreator = 0 and entityType1=@entityType1 and (@entityId1 = 0 or @entityId1=entityId1) and (@organizationId =0 OR (@organizationId = userOrGroupId and isUser=2 ) ) AND (ex.entityId IS NULL)
				EXCEPT
				SELECT entityType1, entityId1, entityType2, entityID2, entityTYpe3, entityId3, entityType4, entityId4, entityType5, entityId5,
					   roleId, permissionId, userOrGroupId, isUser, includeAll
				FROM #inputConsolidated
				WHERE roleId<>0
		END
	END
	--For DELETE, Deleted table is Input table
	IF @securityAssociationsOperationType = 3 --DELETE
	BEGIN
		INSERT INTO #SecurityAssociationsDeleted (entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, roleId, permissionId, userOrGroupId, isUser)
			SELECT entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, roleId, permissionId, userOrGroupId, isUser
			FROM #inputConsolidated
			WHERE roleId<>0 OR permissionId<>0
	END
	-- When coming as overwrite, we should not remove the hidden roles.
	-- Remove these hidden roles from Deleted table right away.
	-- Else these hidden roles mess around when we are doing Security checks down the code.
	IF @securityAssociationsOperationType = 1			-- OVERWRITE
		DELETE Deleted
		FROM #SecurityAssociationsDeleted Deleted
			INNER JOIN UMROles R
				ON Deleted.RoleId > 0 AND Deleted.roleID = R.id
		WHERE
(R.flags & 4 = 4) AND (R.flags & 32 = 0)
	--Sanity checking, if nothing is here, then user is trying to change some other property apart from security setting
	--so dont do anything in this SP
	IF ((SELECT COUNT(*) FROM #SecurityAssociationsAdded) = 0) AND
	   ((SELECT COUNT(*) FROM #SecurityAssociationsDeleted) = 0)
			GOTO END_PROCESSING
	--Check do we need to process hidden permission or not.
	IF(@processHiddenPermission=0)
	BEGIN
DELETE FROM #SecurityAssociationsAdded   WHERE permissionId in (SELECT id from UMPermissions where flags&2<>0)
DELETE FROM #SecurityAssociationsDeleted   WHERE permissionId in (SELECT id from UMPermissions where flags&2<>0)
	END
	--Security checks
	--For a user "caller" doing a 3 way association like <user/group - entity - role/permission>, caller needs to have
		--1. Change security permission on the entity
		--2. all the permissions that he is trying to give the user / group on this entity himself
		--3. view on the user or user group
	IF(@contextInformation=1)				--entity level
	BEGIN
			IF(@skipSecurityCheck=0)
			BEGIN
				--Let us get list of permissions that caller has on the entity
				EXEC sec_getPermissionsOnEntity '#sec_populatepermissionTablePermissionList',@callerID, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,0,1
				--1. Check if the user has Change security on the entity
IF NOT EXISTS (SELECT * FROM #sec_populatepermissionTablePermissionList WHERE permissionId = 107)
				BEGIN
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedPermission(107, @localeId))
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					GOTO END_PROCESSING
				END
			END
			--2. User needs to atleast "see" the user and user groups that he is trying to associate with the entity
			EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups', @callerId
			INSERT INTO @usersAndGroupsVisible
				SELECT userOrGroupId, 1
				FROM #VisibleUsersAndUserGroups
			DELETE FROM #VisibleUsersAndUserGroups
			EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups', @callerId, @includeAllTenantGroups = 1
			INSERT INTO @usersAndGroupsVisible
				SELECT userOrGroupId, 0
				FROM #VisibleUsersAndUserGroups
			DELETE FROM #VisibleUsersAndUserGroups
			--Special handling for OVERWRITE condition, if some association is present in deleted table that is not visible to this caller
			--then caller would not have even selected it in the first place from GUI
			--So let us not "delete" those entries
			IF @securityAssociationsOperationType = 1			--OVERWRITE
			BEGIN
				DELETE Tbl
				FROM #SecurityAssociationsDeleted Tbl LEFT OUTER JOIN @usersAndGroupsVisible See
				ON Tbl.userOrGroupId = See.userOrGroupId AND Tbl.isUser = See.isUser
				WHERE See.isUser IS NULL AND See.userOrGroupId IS NULL
			END
			IF(@skipUserSecurityCheck=0)
			BEGIN
				INSERT INTO @usersCallerDontHaveRight
						SELECT userOrGroupID
						FROM #SecurityAssociationsAdded
						WHERE isUser = 1
						UNION
						SELECT userOrGroupId
						FROM #SecurityAssociationsDeleted
						WHERE isUser = 1
						EXCEPT
						(SELECT userOrGroupId
						FROM @usersAndGroupsVisible
						WHERE isUser = 1)
				INSERT INTO @userGroupsCallerDontHaveRight
						SELECT userOrGroupID
						FROM #SecurityAssociationsAdded
						WHERE isUser = 0
						UNION
						SELECT userOrGroupId
						FROM #SecurityAssociationsDeleted
						WHERE isUser = 0
						EXCEPT
						(SELECT userOrGroupId
						FROM @usersAndGroupsVisible
						WHERE isUser = 0)
				IF EXISTS (SELECT * FROM @usersCallerDontHaveRight)
				BEGIN
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' + Users.login
																FROM @usersCallerDontHaveRight Tbl INNER JOIN UMUsers Users
																ON Tbl.userId = Users.id
																FOR XML PATH('')), 2, 2147483647), ''))
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE (@errorString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
					SET @errorString = REPLACE (@errorString, '[^2%s]', 'Users : ['+@invalidChar+']')
					GOTO END_PROCESSING
				END
				IF EXISTS (SELECT * FROM @userGroupsCallerDontHaveRight)
				BEGIN
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' + Groups .name
																FROM @userGroupsCallerDontHaveRight Tbl INNER JOIN UMGroups Groups
																ON Tbl.userGroupId = Groups.id
																FOR XML PATH('')), 2, 2147483647), ''))
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE (@errorString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
					SET @errorString = REPLACE (@errorString, '[^2%s]', 'UserGroups : ['+@invalidChar+']')
					GOTO END_PROCESSING
				END
			END
			--3. User can modify only those permissions, which he is already having on this entity. (applicable for both addition and deletion)
			IF(@skipAssocPermissionCheck=0 AND @skipSecurityCheck=0)
			BEGIN
					INSERT INTO @permissionListUserDontHaveRight
					SELECT modifiedPermission.permissionId
					FROM (SELECT DISTINCT permissionId						--role associations
						  FROM UMRolesWithPermissionsExpanded RPE
						  INNER JOIN (SELECT DISTINCT roleId FROM #SecurityAssociationsAdded WHERE roleId <> 0
									  UNION
									  SELECT DISTINCT roleId FROM #SecurityAssociationsDeleted WHERE roleId <> 0
									 ) Roles
						  ON RPE.roleId = Roles.roleId
						  UNION
						  SELECT DISTINCT permissionId						--direct permission associations
						  FROM #SecurityAssociationsAdded
						  WHERE permissionId <> 0
						  UNION
						  SELECT DISTINCT permissionId
						  FROM #SecurityAssociationsDeleted
						  WHERE permissionId <> 0
						 ) AS modifiedPermission
						EXCEPT
						(SELECT permissionId FROM #sec_populatepermissionTablePermissionList
						 UNION
SELECT id from UMPermissions where flags & 2 <> 0) -- skip third security check.( user should have this permission to assign others for hidden permissions)
			--check for no associations permission list too. If exists.
				INSERT INTO @inputNoAssocPermission
SELECT permissionId FROM @permissionListUserDontHaveRight where permissionId in (SELECT id FROM UMPermissions WHERE flags& 1 <>0  )
				IF EXISTS ( SELECT * FROM @inputNoAssocPermission)
				BEGIN
					SET @permissionString=N''
					SELECT @permissionString =CASE WHEN @permissionString=''
															THEN CAST(permissionId as varchar(10))
															ELSE @permissionString+ ',' +CAST(permissionId as varchar(10))
												END
															FROM @inputNoAssocPermission
					EXEC sec_userHasCapability @callerId,0,@hasAllNoAssociationsPermission OUTPUT,0,0,@permissionString
					IF(@hasAllNoAssociationsPermission=1)
					BEGIN
						DELETE FROM @permissionListUserDontHaveRight WHERE permissionId IN (SELECT permissionId FROM @inputNoAssocPermission)
					END
				END
				IF EXISTS(SELECT * FROM @permissionListUserDontHaveRight)
				BEGIN
SET @errorCode = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' +  dbo.sec_getLocalizedPermission(permissionId, @localeId)
																FROM @permissionListUserDontHaveRight
																FOR XML PATH('')), 2, 2147483647), ''))
					SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					GOTO END_PROCESSING
				END
			END
		END
	ELSE IF (@contextInformation = 2 AND @skipSecurityCheck = 0)				--from user or user group level
	BEGIN
		--1. On added table caller should have change security and permissions that he is trying to edit on all the entity
		--2. On deleted table caller should have change security and permissions that he is trying to edit on only the entities he can see
		--because the other entities would not have even shown up in GUI
		--So deleting the entities from deleted table that the caller cannot even "see"
		IF @securityAssociationsOperationType = 1			--OVERWRITE
		BEGIN
			DECLARE deleteSpecialCursor CURSOR STATIC FOR
				SELECT DISTINCT Sec.entityType1, Sec.entityId1, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityId3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityId5
				FROM #SecurityAssociationsDeleted Sec
			OPEN deleteSpecialCursor
			FETCH NEXT FROM deleteSpecialCursor INTO @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DELETE FROM #sec_populatepermissionTablePermissionList
				EXEC sec_getPermissionsOnEntity '#sec_populatepermissionTablePermissionList', @callerId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
				IF NOT EXISTS (SELECT * FROM #sec_populatepermissionTablePermissionList)
				BEGIN
					--User cannot even see this entity, so he could not have de-selected it from GUI
					DELETE FROM #SecurityAssociationsDeleted
					WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND
						  entityType2 = @entityType2 AND entityId2 = @entityId2 AND
						  entityType3 = @entityType3 AND entityId3 = @entityId3 AND
						  entityType4 = @entityType4 AND entityId4 = @entityId4 AND
						  entityType5 = @entityType5 AND entityId5 = @entityId5
				END
				FETCH NEXT FROM deleteSpecialCursor INTO @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
			END
			CLOSE deleteSpecialCursor
			DEALLOCATE deleteSpecialCursor
		END
		--On each entity in added and deleted table, the caller should have "Change security" and the permissions that he is going to edit on the entity
		DECLARE SecurityAssocCursor CURSOR STATIC FOR
		SELECT DISTINCT Sec.entityType1, Sec.entityId1, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityId3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityId5
		FROM #SecurityAssociationsAdded Sec
		UNION
		SELECT DISTINCT Sec.entityType1, Sec.entityId1, Sec.entityType2, Sec.entityId2, Sec.entityType3, Sec.entityId3, Sec.entityType4, Sec.entityId4, Sec.entityType5, Sec.entityId5
		FROM #SecurityAssociationsDeleted Sec
		--First check for ALL no association permissions first from added and deleted table. So later for in cursor , dont have to do multuple times.
		IF(@skipAssocPermissionCheck=0)
		BEGIN
			INSERT INTO @inputNoAssocPermission
			SELECT modifiedPermission.permissionId
			FROM (SELECT DISTINCT permissionId
				 FROM UMRolesWithPermissionsExpanded RPE
				 INNER JOIN (SELECT DISTINCT roleId
							   FROM #SecurityAssociationsAdded
							   WHERE roleId <> 0
							   UNION
							   SELECT DISTINCT roleId
							   FROM #SecurityAssociationsDeleted
							   WHERE  roleId <> 0
							  )Roles
						ON RPE.roleId=Roles.roleId
				UNION
				SELECT DISTINCT permissionId
				FROM #SecurityAssociationsAdded
				WHERE permissionId <> 0
				UNION
				SELECT DISTINCT permissionId
				FROM #SecurityAssociationsDeleted
				WHERE 	  permissionId <> 0
				)AS modifiedPermission
JOIN UMPermissions P ON P.id=permissionId and P.flags & 1 <>0  and P.flags & 2= 0
			IF EXISTS ( SELECT * FROM @inputNoAssocPermission)
			BEGIN
				SET @permissionString=N''
				SELECT @permissionString =CASE WHEN @permissionString=''
															THEN CAST(permissionId as varchar(10))
															else @permissionString+','+CAST(permissionId as varchar(10))
															end
															FROM @inputNoAssocPermission
				EXEC sec_userHasCapability @callerId,0,@hasAllNoAssociationsPermission OUTPUT,0,0,@permissionString
				IF(@hasAllNoAssociationsPermission=0)
				BEGIN
SET @errorCode = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2497 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					SET @permissionString=''
					SELECT @permissionString =CASE WHEN @permissionString=''
															THEN dbo.sec_getLocalizedPermission(permissionId, @localeId)
															else @permissionString+','+dbo.sec_getLocalizedPermission(permissionId, @localeId)
															end
															FROM @inputNoAssocPermission
					SET @errorString = REPLACE(@errorString, '^1%s',@permissionString)
					GOTO END_PROCESSING
				END
			END
		END
		OPEN SecurityAssocCursor
		FETCH NEXT FROM SecurityAssocCursor into @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
		WHILE @@FETCH_STATUS=0
		BEGIN
			DELETE #sec_populatepermissionTablePermissionList
			DELETE @permissionListUserDontHaveRight
			EXEC sec_getPermissionsOnEntity '#sec_populatepermissionTablePermissionList', @callerID, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5,0,1
IF NOT EXISTS (SELECT * FROM #sec_populatepermissionTablePermissionList WHERE permissionId = 107)
			BEGIN
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedPermission(107, @localeId))
				EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
				SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
				CLOSE SecurityAssocCursor
				DEALLOCATE SecurityAssocCursor
				GOTO END_PROCESSING
			END
			IF(@skipAssocPermissionCheck=0)
			BEGIN
				INSERT INTO @permissionListUserDontHaveRight
						SELECT modifiedPermission.permissionId
						FROM (SELECT DISTINCT permissionId
							 FROM UMRolesWithPermissionsExpanded RPE
							 INNER JOIN
								   (SELECT DISTINCT roleId
								   FROM #SecurityAssociationsAdded
								   WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND
										 entityType2 = @entityType2 AND entityId2 = @entityId2 AND
										 entityType3 = @entityType3 AND entityId3 = @entityId3 AND
										 entityType4 = @entityType4 AND entityId4 = @entityId4 AND
										 entityType5 = @entityType5 AND entityId5 = @entityId5 AND
										 roleId <> 0
								   UNION
								   SELECT DISTINCT roleId
								   FROM #SecurityAssociationsDeleted
								   WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND
										 entityType2 = @entityType2 AND entityId2 = @entityId2 AND
										 entityType3 = @entityType3 AND entityId3 = @entityId3 AND
										 entityType4 = @entityType4 AND entityId4 = @entityId4 AND
										 entityType5 = @entityType5 AND entityId5 = @entityId5 AND
										 roleId <> 0
								  )Roles
							ON RPE.roleId=Roles.roleId
							UNION
							SELECT DISTINCT permissionId
							FROM #SecurityAssociationsAdded
							WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND
								  entityType2 = @entityType2 AND entityId2 = @entityId2 AND
								  entityType3 = @entityType3 AND entityId3 = @entityId3 AND
								  entityType4 = @entityType4 AND entityId4 = @entityId4 AND
								  entityType5 = @entityType5 AND entityId5 = @entityId5 AND
								  permissionId <> 0
							UNION
							SELECT DISTINCT permissionId
							FROM #SecurityAssociationsDeleted
							WHERE entityType1 = @entityType1 AND entityId1 = @entityId1 AND
								  entityType2 = @entityType2 AND entityId2 = @entityId2 AND
								  entityType3 = @entityType3 AND entityId3 = @entityId3 AND
								  entityType4 = @entityType4 AND entityId4 = @entityId4 AND
								  entityType5 = @entityType5 AND entityId5 = @entityId5 AND
								  permissionId <> 0
							)AS modifiedPermission
						EXCEPT
						(SELECT permissionId FROM #sec_populatepermissionTablePermissionList
						UNION
SELECT id FROM UMPermissions P WHERE  P.flags & (1|CAST(2 AS INT)) <>0)
				IF EXISTS(SELECT * FROM @permissionListUserDontHaveRight)
				BEGIN
SET @errorCode = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' +  dbo.sec_getLocalizedPermission(permissionId, @localeId)
																FROM @permissionListUserDontHaveRight
																FOR XML PATH('')), 2, 2147483647), ''))
					SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					CLOSE SecurityAssocCursor
					DEALLOCATE SecurityAssocCursor
					GOTO END_PROCESSING
				END
		END
			FETCH NEXT FROM SecurityAssocCursor INTO @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5,@entityId5
		END
		CLOSE SecurityAssocCursor
		DEALLOCATE SecurityAssocCursor
	END   --multiple user and entity of type @entityType1
	ELSE IF  (@contextInformation = 3)
	BEGIN
			--get list of unique list of user\group\domain
			EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups', @callerId
			INSERT INTO @usersAndGroupsVisible
				SELECT userOrGroupId, 1
				FROM #VisibleUsersAndUserGroups
			DELETE FROM #VisibleUsersAndUserGroups
			EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups', @callerId
			INSERT INTO @usersAndGroupsVisible
				SELECT userOrGroupId, 0
				FROM #VisibleUsersAndUserGroups
			DELETE FROM #VisibleUsersAndUserGroups
			EXEC sec_getNameServersForThisUser '#VisibleUsersAndUserGroups', @callerId,0,1
			INSERT INTO @usersAndGroupsVisible
				SELECT userOrGroupId, 2
				FROM #VisibleUsersAndUserGroups
			--Special handling for OVERWRITE condition, if some association is present in deleted table that is not visible to this caller
			--then caller would not have even selected it in the first place from GUI
			--So let us not "delete" those entries
			IF @securityAssociationsOperationType = 1			--OVERWRITE
			BEGIN
				DELETE Tbl
				FROM #SecurityAssociationsDeleted Tbl LEFT OUTER JOIN @usersAndGroupsVisible See
				ON Tbl.userOrGroupId = See.userOrGroupId AND Tbl.isUser = See.isUser
				WHERE See.isUser IS NULL AND See.userOrGroupId IS NULL
			END
			IF(@skipUserSecurityCheck=0)
			BEGIN
				INSERT INTO @usersCallerDontHaveRight
						SELECT userOrGroupID
						FROM #SecurityAssociationsAdded
						WHERE isUser = 1
						UNION
						SELECT userOrGroupId
						FROM #SecurityAssociationsDeleted
						WHERE isUser = 1
						EXCEPT
						(SELECT userOrGroupId
						FROM @usersAndGroupsVisible
						WHERE isUser = 1)
				INSERT INTO @userGroupsCallerDontHaveRight
						SELECT userOrGroupID
						FROM #SecurityAssociationsAdded
						WHERE isUser = 0
						UNION
						SELECT userOrGroupId
						FROM #SecurityAssociationsDeleted
						WHERE isUser = 0
						EXCEPT
						(SELECT userOrGroupId
						FROM @usersAndGroupsVisible
						WHERE isUser = 0)
				INSERT  INTO @userGroupsCallerDontHaveRight
						SELECT userOrGroupID
						FROM #SecurityAssociationsAdded
						WHERE isUser = 2
						UNION
						SELECT userOrGroupId
						FROM #SecurityAssociationsDeleted
						WHERE isUser = 2
						EXCEPT
						(SELECT userOrGroupId
						FROM @usersAndGroupsVisible
						WHERE isUser = 2)
				IF EXISTS (SELECT * FROM @usersCallerDontHaveRight)
				BEGIN
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' + Users.login
																FROM @usersCallerDontHaveRight Tbl INNER JOIN UMUsers Users
																ON Tbl.userId = Users.id
																FOR XML PATH('')), 2, 2147483647), ''))
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE (@errorString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
					SET @errorString = REPLACE (@errorString, '[^2%s]', 'Users : ['+@invalidChar+']')
					GOTO END_PROCESSING
				END
				IF EXISTS (SELECT * FROM @userGroupsCallerDontHaveRight)
				BEGIN
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' + Groups .name
																FROM @userGroupsCallerDontHaveRight Tbl INNER JOIN UMGroups Groups
																ON Tbl.userGroupId = Groups.id
																FOR XML PATH('')), 2, 2147483647), ''))
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE (@errorString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
					SET @errorString = REPLACE (@errorString, '[^2%s]', 'UserGroups : ['+@invalidChar+']')
					GOTO END_PROCESSING
				END
				-- @ProviderDontHaveRight table is not being used at present.
				IF EXISTS (SELECT * FROM @ProviderDontHaveRight)
				BEGIN
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' + Prov.domainNAME
																FROM @ProviderDontHaveRight Tbl INNER JOIN UMDSPRoviders Prov
																ON Tbl.providerId = Prov.id
																FOR XML PATH('')), 2, 2147483647), ''))
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE (@errorString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
					SET @errorString = REPLACE (@errorString, '[^2%s]', 'Providers : ['+@invalidChar+']')
					GOTO END_PROCESSING
				END
			END
			--now get list of users who have change security settings
			DECLARE @entityList TABLE(entityId INT)
			INSERT INTO @entityLIST
				SELECT DISTINCT entityId1
				FROM #SecurityAssociationsAdded
				UNION
				SELECT DISTINCT entityId1
				FROM #SecurityAssociationsDeleted
			--logged in user should have change security settings on the entity list.
			IF OBJECT_ID('tempdb.dbo.#sec_getNonIdaObjectsForThisUserPopulateSecurityTbl') IS NOT NULL
					DROP TABLE #sec_getNonIdaObjectsForThisUserPopulateSecurityTbl
			CREATE TABLE #sec_getNonIdaObjectsForThisUserPopulateSecurityTbl
			(
				entityId INT
			)
EXEC sec_getNonIdaObjectsForThisUser @callerId,@entityType1,107, '#sec_getNonIdaObjectsForThisUserPopulateSecurityTbl'
			DECLARE @errorEntityId INT
			SET @errorEntityId= ISNULL((SELECT TOP 1  Assoc.entityId fROM #sec_getNonIdaObjectsForThisUserPopulateSecurityTbl Assoc RIGHT JOIN @entityLIST Input ON Input.entityId=Assoc.entityId
			where Assoc.entityId is null),0)
			IF (@errorEntityId<>0)
				BEGIN
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedPermission(107, @localeId))
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType1, @entityId1, @entityType2, @entityId2, @entityType3, @entityId3, @entityType4, @entityId4, @entityType5, @entityId5
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					GOTO END_PROCESSING
				END
	END
	BEGIN TRY
		INSERT INTO UMSecurityAssociations (roleId, permissionId, userOrGroupId, isUser, isROleAllowed, propagateToChildObjects, roleValidityDate, timeZone, exclude, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, includeAll, iscreator, authorId)
			SELECT roleId, permissionId, userOrGroupId, isUser, 1, 1, 0, 0, 0, entityType1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityId5, ISNULL(includeAll, 0), 0, @callerId
			FROM #SecurityAssociationsAdded
			WHERE isCustomRolePermission=0
		DELETE Sec
		FROM UMSecurityAssociations Sec INNER JOIN #SecurityAssociationsDeleted Input ON
		Sec.entityType1 = Input.entityType1 AND Sec.entityId1 = Input.entityId1 AND
		Sec.entityType2 = Input.entityType2 AND Sec.entityId2 = Input.entityId2 AND
		Sec.entityType3 = Input.entityType3 AND Sec.entityId3 = Input.entityId3 AND
		Sec.entityType4 = Input.entityType4 AND Sec.entityId4 = Input.entityId4 AND
		Sec.entityType5 = Input.entityType5 AND Sec.entityId5 = Input.entityId5
		AND Sec.roleId = Input.roleId AND Sec.permissionId = Input.permissionId
		AND Sec.isUser = Input.isUser AND Sec.userOrGroupId = Input.userOrGroupId
		WHERE (isCreator = 0) and isCustomRolePermission=0
		DELETE FROM UMRolesWithPermissionsExpanded where roleId in (Select roleId FROM #CustomRolesExpanded)
		INSERT INTO UMRolesWithPermissionsExpanded
		SELECT CR.roleId,categoryId,CR.permissionId
		FROM #CustomRolesExpanded CR
		JOIN UMPermissions P on CR.permissionId=P.id
		WHERE CR.permissionId IS NOT NULL
		IF EXISTS (
					  SELECT entityType1
					  FROM #SecurityAssociationsAdded Added
							LEFT JOIN UMRolesWithPermissionsExpanded RPE
								ON (Added.roleID = RPE.roleID)
					  WHERE
entityType1 = 158
AND (Added.permissionId = 157 OR RPE.permissionID = 157)
					  UNION
					  SELECT entityType1
					  FROM #SecurityAssociationsDeleted Deleted
							LEFT JOIN UMRolesWithPermissionsExpanded RPE
								ON (Deleted.roleID = RPE.roleID)
					  WHERE
entityType1 = 158
AND (Deleted.permissionId = 157 OR RPE.permissionID = 157)
				 )
		BEGIN
			DECLARE @hiddenRoleForPlanAsSuperSetId INT = 0
			SELECT @hiddenRoleForPlanAsSuperSetId = id
			FROM UMRoles
			WHERE
flags & 1024 <> 0
			IF @hiddenRoleForPlanAsSuperSetId <> 0
			BEGIN
				DELETE Sec
				FROM UMSecurityAssociations Sec
					INNER JOIN #SecurityAssociationsDeleted Deleted
						ON Sec.entityType1 = Deleted.entityType1
						AND Sec.entityId1 = Deleted.entityId1
						AND Sec.isUser = Deleted.isUser
						AND Sec.userOrGroupId = Deleted.userOrGroupId
					LEFT JOIN UMRolesWithPermissionsExpanded RPE
						ON Deleted.roleID = RPE.roleID
				WHERE
Sec.entityType1 = 158
					AND Sec.roleID = @hiddenRoleForPlanAsSuperSetId
AND (Deleted.permissionID = 157 OR RPE.permissionId = 157)
				INSERT INTO UMSecurityAssociations (entityType1, entityId1, roleId, userOrGroupId, isUser, authorId)
					SELECT entityType1, entityId1, @hiddenRoleForPlanAsSuperSetId, userOrGroupId, isUser, @callerId
					FROM #SecurityAssociationsAdded Added
						LEFT JOIN UMRolesWithPermissionsExpanded RPE
							ON (Added.roleID = RPE.roleID)
				    WHERE
entityType1 = 158
AND (Added.permissionId = 157 OR RPE.permissionID = 157)
						AND NOT EXISTS (SELECT 1
										FROM UMSecurityAssociations Sec
										WHERE
											Sec.entityType1 = Added.entityType1
											AND Sec.entityID1 = Added.entityId1
											AND Sec.roleId = @hiddenRoleForPlanAsSuperSetId
											AND Sec.isUser = Added.isUser
											AND Sec.userOrGroupId = Added.userOrGroupId)
			END
		END
		-- Requirement: When an entity is shared with Tenant Admin of a company, give the same rights to the Tenant Operator of that company.
		-- Similarly, when rights are revoked for Tenant Admin, revoke the rights for Tenant Opeartor too.
		IF EXISTS
		(
			SELECT entityType1
			FROM #SecurityAssociationsAdded Added
				INNER JOIN UMGroups G (NOLOCK)
					ON	Added.isUser = 0 AND G.id = Added.userOrGroupId
AND G.groupFlags & 0x10000 <> 0
			UNION
			SELECT entityType1
			FROM #SecurityAssociationsDeleted Deleted
				INNER JOIN UMGroups G (NOLOCK)
					ON  Deleted.isUser = 0 AND G.id = Deleted.userOrGroupId
AND G.groupFlags & 0x10000 <> 0
		)
		BEGIN
			-- Since Tenant Operator UG is going to be hidden from SP22, when anything is shared with Tenant Admin, share with Tenant Operator too.
			-- Just be cautious, if Tenant Admin role is given for Tenant Admin UG on an entity (common use case), replace with Tenant Operator role for Tenant Operator UG.
			-- This assumption is safe, because this is the common use case and configuration that we see on most setups.
			-- When tenant admin is revoked rights from an entity, revoke for Tenant Operator too.
			DECLARE @tenantAdminRoleId INT = 0
			DECLARE @tenantOperatorRoleId INT = 0
SELECT @tenantAdminRoleId = id FROM UMRoles (NOLOCK) WHERE flags & 256 <> 0
SELECT @tenantOperatorRoleId = id FROM UMRoles (NOLOCK) WHERE flags & 512 <> 0
			UPDATE Added
			SET roleId = @tenantOperatorRoleId
			FROM #SecurityAssociationsAdded Added
				INNER JOIN UMGroups TenantAdmin (NOLOCK)
ON (Added.isUser = 0) AND (TenantAdmin.id = Added.userOrGroupId) AND ((TenantAdmin.groupFlags & 0x10000) <> 0)
			WHERE roleId = @tenantAdminRoleId
			DELETE Sec
			FROM #SecurityAssociationsDeleted Deleted
				INNER JOIN UMGroups TenantAdmin (NOLOCK)
					ON  Deleted.isUser = 0 AND TenantAdmin.id = Deleted.userOrGroupId
AND TenantAdmin.groupFlags & 0x10000 <> 0
				INNER JOIN UMGroups TenantOperator (NOLOCK)
					ON  TenantOperator.umdsProviderID = TenantAdmin.umdsProviderID
AND TenantOperator.groupFlags & 0x40000 <> 0
				INNER JOIN UMSecurityAssociations Sec
						ON  Deleted.entityType1 = Sec.entityTYpe1 AND Deleted.entityId1 = Sec.entityId1
							AND Deleted.entityType2 = Sec.entityTYpe2 AND Deleted.entityId2 = Sec.entityId2
							AND Deleted.entityType3 = Sec.entityTYpe3 AND Deleted.entityId3 = Sec.entityId3
							AND Deleted.entityType4 = Sec.entityTYpe4 AND Deleted.entityId4 = Sec.entityId4
							AND Deleted.entityType5 = Sec.entityTYpe5 AND Deleted.entityId5 = Sec.entityId5
							AND Deleted.includeAll = Sec.includeAll
							AND (Deleted.roleId = Sec.roleID OR (Deleted.roleID = @tenantAdminRoleId AND Sec.roleid = @tenantOperatorRoleId)) AND Deleted.permissionId = Sec.permissionID
							AND Sec.isUSer = 0 AND Sec.userORGroupId = TenantOperator.id
			WHERE
				Sec.isCreator = 0
				AND Deleted.isCustomRolePermission = 0
			INSERT INTO UMSecurityAssociations (isUser, userOrGroupId, entityTYpe1, entityId1, entityType2, entityId2, entityType3, entityId3, entityType4, entityId4, entityType5, entityID5, roleId, permissionId, includeAll, authorId)
				SELECT DISTINCT 0, TenantOperator.id, Added.entityTYpe1, Added.entityId1, Added.entityType2, Added.entityId2, Added.entityTYpe3, Added.entityId3, Added.entityTYpe4, Added.entityId4, Added.entityType5, Added.entityId5, Added.roleId, Added.permissionId, Added.includeAll, @callerId
				FROM #SecurityAssociationsAdded Added
					INNER JOIN UMGroups TenantAdmin (NOLOCK)
						ON  Added.isUser = 0 AND TenantAdmin.id = Added.userOrGroupId
AND TenantAdmin.groupFlags & 0x10000 <> 0
					INNER JOIN UMGroups TenantOperator (NOLOCK)
						ON  TenantOperator.umdsProviderID = TenantAdmin.umdsProviderID
AND TenantOperator.groupFlags & 0x40000 <> 0
					LEFT JOIN UMSecurityAssociations Sec
						ON  Added.entityType1 = Sec.entityTYpe1 AND Added.entityId1 = Sec.entityId1
							AND Added.entityType2 = Sec.entityTYpe2 AND Added.entityId2 = Sec.entityId2
							AND Added.entityType3 = Sec.entityTYpe3 AND Added.entityId3 = Sec.entityId3
							AND Added.entityType4 = Sec.entityTYpe4 AND Added.entityId4 = Sec.entityId4
							AND Added.entityType5 = Sec.entityTYpe5 AND Added.entityId5 = Sec.entityId5
							AND Added.includeAll = Sec.includeAll
							AND Added.roleId = Sec.roleID AND Added.permissionId = Sec.permissionID
							AND Sec.isUSer = 0 AND Sec.userORGroupId = TenantOperator.id
				WHERE
					Sec.isUser IS NULL		-- Insert only if it not exists already.
					AND Added.isCustomRolePermission = 0			-- Same logic as in #945
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @errorcode = ERROR_NUMBER()
		SET @errorString = ERROR_MESSAGE ()
		GOTO END_PROCESSING
	END CATCH
END_PROCESSING:
	IF OBJECT_ID ('tempdb.dbo.#SecurityAssociationsAdded') IS NOT NULL DROP TABLE #SecurityAssociationsAdded
	IF OBJECT_ID ('tempdb.dbo.#SecurityAssociationsDeleted') IS NOT NULL DROP TABLE #SecurityAssociationsDeleted
	IF OBJECT_ID ('tempdb.dbo.#sec_populatepermissionTablePermissionList') IS NOT NULL DROP TABLE #sec_populatepermissionTablePermissionList
	IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL DROP TABLE #VisibleUsersAndUserGroups
GO

IF EXISTS (select * from GxQscripts where name = 'sec_populateSecurityAssociationsTable')
	delete from GxQscripts where name = 'sec_populateSecurityAssociationsTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateSecurityAssociationsTable')
	delete from GXDBVersions where aliasname = 'sec_populateSecurityAssociationsTable'
GO

insert into GXDBVersions values(2, 'sec_populateSecurityAssociationsTable',  '00000000000000000000', 'sec_populateSecurityAssociationsTable', '00000000000000000000')
GO

