

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_populateOwnersTable.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- --------------------------------------------------------------------------------------------------
--
--   Description: This SP is used to set the owner associations from entity level
--
--				  Should be called with input XML that has tag as 'App_SecurityAssociationForEntityList'
--
--
--
--				  This does some security checks before setting the owner associations
--				  We should have these rights to do the 3 way owner associations
--						1. Change Security on the entity
--						2. Permissions that the user is trying to give should be possessed by him on that entity
--						3. View rights on the user / group
--   Authors: saggarwal and jswaminathan
-- ----------------------------------------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_populateOwnersTable')
BEGIN
	print '>>> Drop Stored Procedure: sec_populateOwnersTable <<<'
	drop procedure sec_populateOwnersTable
END
IF EXISTS (select * from GxQscripts where name='sec_populateOwnersTable')
	delete from GxQscripts where name = 'sec_populateOwnersTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateOwnersTable')
	delete from GXDBVersions where aliasname = 'sec_populateOwnersTable'
GO
print '... Creating Procedure: sec_populateOwnersTable'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_populateOwnersTable
  @xmlIn XML, 
  @callerId INT,
  @localeId INT,
  @cmdLine INT,
  @entityType INT,
  @entityId INT,
  @skipSecurityCheck INT, 
  @errorCode INT OUTPUT, 
  @errorString NVARCHAR(MAX) OUTPUT
AS
--Local variables
DECLARE @invalidChar NVARCHAR(MAX) = ''
SET @errorCode = 0									--be optimistic
SET @errorString = 'Successful'
DECLARE @skipAssocPermissionCheck INTEGER=(ISNULL((SELECT CASE WHEN CAST(value AS NVARCHAR(10))= 'true' AND enabled = 1 THEN 1 ELSE 0 END FROM APP_AdvanceSettings WHERE keyName = 'skipIndividualPermissionCheck'),0))
	--Input processing
	DECLARE @ownerTable TABLE
	(
		userId INT,
		userName NVARCHAR(MAX),
		userGroupId INT,
		userGroupName NVARCHAR(MAX),
		providerId INT,
		providerName NVARCHAR(MAX),
		flags INT
	)
	DECLARE @ownerPermissionsTable TABLE
	(
		permissionId INT
	)
	DECLARE @ownersAdded TABLE
	(
		userOrGroupId INT,
		isUser INT,
		flags INT
	)
	DECLARE @ownersDeleted TABLE
	(
		userOrGroupId INT,
		isUser INT,
		flags INT
	)
	DECLARE @ownersModified TABLE
	(
		userOrGroupId INT,
		isUser INT,
		flags INT
	)
	DECLARE @ownerPermissionsAdded TABLE
	(
		permissionId INT
	)
	DECLARE @ownerPermissionsDeleted TABLE
	(
		permissionId INT
	)
	--Owners processing
	DECLARE @ownersOperationType INT = 0
	SET @ownersOperationType = ISNULL((SELECT UG.value('@ownersOperationType', 'INT')
									   FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/ownerAssociations') AS Input(UG)), 0)
	DECLARE @entityOwnersOperationType INT = 0
	SET @entityOwnersOperationType = ISNULL((SELECT UG.value('@entityOwnersOperationType', 'INT')
									   FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/ownerAssociations') AS Input(UG)), 0)
	IF @ownersOperationType <> 0 AND @entityOwnersOperationType <> 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Cannot set both owners and entity owners operation type in the same XML'
		GOTO END_PROCESSING
	END
	IF @ownersOperationType <> 0
		INSERT INTO @ownerTable (userId, userName, userGroupId, userGroupName, providerId, providerName)
			SELECT ISNULL(UG.value('(@userId)[1]', 'INT'), 0),
				   ISNULL(UG.value('(@userName)[1]', 'NVARCHAR(MAX)'), N''),
				   CASE WHEN UG.value('(@userGroupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@userGroupId)[1]', 'INT')
						WHEN UG.value('(@groupId)[1]', 'INT') IS NOT NULL THEN UG.value('(@groupId)[1]', 'INT')
						ELSE 0
				   END,
				   CASE WHEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@userGroupName)[1]', 'NVARCHAR(MAX)')
						WHEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)') IS NOT NULL THEN UG.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)')
						ELSE N''
				   END,
				   ISNULL(UG.value('(@providerId)[1]', 'INT'), 0),
				   ISNULL(UG.value('(@providerDomainName)[1]', 'NVARCHAR(MAX)'), N'')
			FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/ownerAssociations/owners') AS Input(UG)
	ELSE IF @entityOwnersOperationType <> 0
		INSERT INTO @ownerTable (userId, userName, userGroupId, userGroupName, providerId, providerName, flags)
			SELECT ISNULL(UG.value('(ownerUser/@userId)[1]', 'INT'), 0),
				   ISNULL(UG.value('(ownerUser/@userName)[1]', 'NVARCHAR(MAX)'), N''),
				   ISNULL(UG.value('(ownerUserGroup/@userGroupId)[1]', 'INT'), 0),
				   ISNULL(UG.value('(ownerUserGroup/@userGroupName)[1]', 'NVARCHAR(MAX)'), N''),
				   0,						--no need of provider Info here
				   '',
				   ISNULL(UG.value('(@flags)[1]', 'INT'), 1)				--assume to be manual owners
			FROM @xmlIn.nodes('App_SecurityAssociationForEntityList/ownerAssociations/entityOwners') AS Input(UG)
	--New AD users and user groups discovered as part of setSecurityNew() function, will have the id as 0 in this xml
	--So check for them before sanity check
	  DECLARE @isServiceCommcell INT=0
        --check if its service commcell
            IF EXISTS (SELECT 1 FROM APP_CommCell AC
inner join APP_ComponentProp ACP on AC.id = ACP.componentId where componentType = 1048  and propertyTypeId = 2 and AC.id=2
                        and longVal=1)
                        SET @isServiceCommcell=1
      IF(@isServiceCommcell=1)
            BEGIN
                --its a local CS, so request will have userId, groupId , roleId of global CS
                INSERT UMDSProviders (domainName, hostName, description, login, password, trustedHostUser, trustedHostPW, flags, enabled, serviceType,
                            modified, dnsRoot, dnsRootStatus, useSecureLdap, origCCId, GUID, port, resourceId, checkTime,ownerCompany,ownerId )
                SELECT DISTINCT SUBSTRING(umEntity, 1, CHARINDEX('\', umEntity, 1)-1),SUBSTRING(umEntity, 1, CHARINDEX('\', umEntity, 1)-1) ,'synced from IDP',
                '', '', '', '', 0x0004, 1, 12,
                            0,'','',0, 0, newid(), 0, 0,86400,0,1
                FROM    (SELECT username  as umEntity FROM @ownerTable
                        UNION
                        SELECT userGroupName as umEntity from @ownerTable ) TBL
                    LEFT JOIN UMDSProviders Prov
                    ON  SUBSTRING(umEntity, 1, CHARINDEX('\', umEntity, 1)-1) = Prov.domainName
                    where Prov.id IS NULL and Tbl.umEntity <> N''
                and CHARINDEX('\', umEntity, 1)<>0
                UPDATE @ownerTable
                set providerName = SUBSTRING(userGroupName, 1, CHARINDEX('\', userGroupName, 1)-1)
                ,userGroupName= SUBSTRING(userGroupName, CHARINDEX('\', userGroupName, 1)+1, LEN(usergroupNAme))
                WHERE CHARINDEX('\', userGroupName, 1)<>0
                INSERT INTO UMUsers([name]
                ,[description]
                ,[login]
                ,[password]
                ,[email]
                ,[datePasswordSet]
                ,[dateExpires]
                ,[policy]
                ,[enabled]
                ,[flags]
                ,[modified]
                ,[pVer]
                ,[Pager]
                ,[lastLogInTime]
                ,[credSetTime]
                ,[umDSproviderId]
                ,[userGuid]
                ,[origUserGuid])
    SELECT  userName,'From Global CS',userName,'dummy password','update later',0,0,0,1,1,0,0,0,0,0,providerId,NewId(),''
    from
    (SELECT DISTINCT userNAme,Prov.id as providerId FROM @ownerTable Tbl JOIN UMDSProviders Prov ON  SUBSTRING(userName, 1, CHARINDEX('\', userName, 1)-1) = Prov.domainName LEFT  JOIN UMUsers Users on Users.login=userName
    where USers.id IS NULL and Tbl.userName <> N''
    and CHARINDEX('\', userName, 1)<>0) tbl
         INSERT INTO UMUsers([name]
                ,[description]
                ,[login]
                ,[password]
                ,[email]
                ,[datePasswordSet]
                ,[dateExpires]
                ,[policy]
                ,[enabled]
                ,[flags]
                ,[modified]
                ,[pVer]
                ,[Pager]
                ,[lastLogInTime]
                ,[credSetTime]
                ,[umDSproviderId]
                ,[userGuid]
                ,[origUserGuid])
    SELECT DISTINCT userName,'From Global CS',userName,'dummy password','update later',0,0,0,1,1,0,0,0,0,0,0,NewId(),''
        from
    (SELECT DISTINCT userNAme FROM @ownerTable Tbl  LEFT  JOIN UMUsers Users on Users.login=userName
    where USers.id IS NULL and Tbl.userName <> N''
    and CHARINDEX('\', userName, 1)=0) tbl
         INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, email, GUID, umdsProviderId, origCCId)
        SELECT 1 , 0, 0, 1,userGroupName, 'Auto-Created group for Multicommcell', '', NEWID(), PROVIDERiD, 2
        from
        (select distinct userGroupName,0 as providerId
        FROM @ownerTable member LEFT JOIN UMGroups UG  on member.userGroupName=UG.name
            WHERE UG.id is NULL and member.userGroupName <> N'' and providerName='' and providerId=0
            UNION
            select distinct userGroupName,P.id as providerId
        FROM @ownerTable member JOIN UMDSpRoviders P ON  ((member.providerID<>0 and P.id=member.providerId) Or P.domainName=member.providerName)
         LEFT JOIN UMGroups UG  on member.userGroupName=UG.name   AND Ug.umdsProviderId=P.id
            WHERE UG.id is NULL and member.userGroupName <> N'') AS TBL
  END
	UPDATE Tbl
	SET Tbl.userId = Users.id
	FROM @ownerTable Tbl INNER JOIN UMUsers Users
	ON Tbl.userName = Users.login
	WHERE Tbl.userName <> N'' AND Tbl.userID <= 0
	UPDATE Tbl
	SET Tbl.providerId=id
	FROM @ownerTable Tbl INNER JOIN UMDSProviders
	ON Tbl.providerName = domainName AND Tbl.providerName <> N''
	AND Tbl.providerId <= 0
	--there may be local simpana groups or AD groups that came as "domainName\GroupName"
	UPDATE Tbl
	SET Tbl.userGroupId=Groups.id
	FROM @ownerTable Tbl INNER JOIN UMGroups Groups
	ON Groups.name = Tbl.userGRoupName AND Groups.umdsProviderId = Tbl.providerId		--for local groups, Tbl.providerId = 0
	WHERE Tbl.userGroupName <> N'' AND Tbl.userGroupId <= 0 AND CHARINDEX('\', Tbl.userGroupName, 1) <= 0
	UPDATE Tbl
	SET Tbl.userGroupId = Groups.id, Tbl.providerID = Groups.umdsProviderID
	FROM @ownerTable Tbl INNER JOIN UMDSProviders Prov
	ON SUBSTRING(userGroupName, 1, CHARINDEX('\', userGroupName, 1)-1) = Prov.domainName
	INNER JOIN UMGroups Groups
	ON SUBSTRING(userGroupName, CHARINDEX('\', userGroupName, 1)+1, LEN(userGroupName)) = Groups.name AND Prov.id = Groups.umdsProviderId
	WHERE Tbl.userGroupName <> N'' AND Tbl.userGroupId <= 0 AND CHARINDEX('\', userGroupName, 1) > 0
	--if AD users are hidden and coming in input xml, then the caller wants to explicitly add them - meaning unhide them.
	UPDATE UMUsers
SET flags = UMUsers.flags & ~(CAST(0x004 AS INT))
	FROM @ownerTable
	WHERE id = userID AND userID <> 0 AND UMUsers.umdsProviderID <> 0
	--Sanity check:
		--a. User Id
		IF EXISTS (SELECT * FROM @ownerTable WHERE userId <= 0 AND userName <> N'')
		BEGIN
            SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ userName
                                                         FROM @ownerTable
                                                         WHERE userId <= 0 AND userName <> N''
                                                         FOR XML PATH ('')), 2, 2147483647), ''))
SET @errorCode = (2427 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2427 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
            SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
            GOTO END_PROCESSING
        END
        --b. userGroupId
        IF EXISTS (SELECT * FROM @ownerTable WHERE userGroupId <= 0 AND userGroupName <> N'')
        BEGIN
            SET @invalidChar =  (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ userGroupName
                                                         FROM @ownerTable
                                                         WHERE userGroupId <= 0 AND userGroupName <> N''
                                                         FOR XML PATH ('')), 2, 2147483647), ''))
SET @errorCode = (2428 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2428 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
            SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
            GOTO END_PROCESSING
        END
	--ease of calcuations coming later frame it in userOrGroupId format
	DECLARE @inputOwnersTable TABLE
	(
		userOrGroupId INT,
		isUser INT,
		flags INT
	)
	INSERT INTO @inputOwnersTable
		SELECT DISTINCT CASE WHEN userId <> 0 THEN userId ELSE userGroupId END,
				   CASE WHEN userId <> 0 THEN 1 ELSE 0 END,
				   flags
		FROM @ownerTable
	--Frame added and deleted tables
	IF @ownersOperationType IN (1, 2)			--OVERWRITE or ADD
	BEGIN
		--completely new owners
		INSERT INTO @ownersAdded
			SELECT userOrGroupId, isUser, 1
			FROM @inputOwnersTable
			EXCEPT
			SELECT userOrGroupId, isUser, 1
			FROM UMOwners
			WHERE entityType = @entityType AND entityId = @entityId
		--owners present already but not with flag as 1
		INSERT INTO @ownersModified
			SELECT Input.userOrGroupId, Input.isUser, (Owners.flags | 1)
			FROM @inputOwnersTable Input INNER JOIN UMOwners Owners
			ON Input.userOrGroupId = Owners.userOrGroupId AND Input.isUser = Owners.isUser
			WHERE Owners.entityType = @entityType AND owners.entityId = @entityId AND (Owners.flags & 1 = 0)
	END
	IF @ownersOperationType = 1				--OVERWRITE
	BEGIN
		--entries who have only flag as 1 set can be deleted out right if they are not present in the input
		INSERT INTO @ownersDeleted
			SELECT userOrGroupId, isUser, 1
			FROM UMOwners
			WHERE entityType = @entityType AND entityId = @entityId AND flags = 1
			EXCEPT
			SELECT userOrGroupId, isUser, 1
			FROM @inputOwnersTable
		--entries who have 1 and another bit set and not present in input should be masked for 1
		INSERT INTO @ownersModified
			SELECT Owners.userOrGroupId, Owners.isUser, Owners.flags & (~(1))
			FROM UMOwners Owners
			WHERE entityTYpe = @entityType AND entityId = @entityId AND (flags & 1 <> 0) AND (flags <> 1)
			AND NOT EXISTS (SELECT 1 FROM @inputOwnersTable WHERE userOrGroupId = Owners.userOrGroupId AND isUser = Owners.isUser)
	END
	IF @ownersOperationType = 3				--DELETE
	BEGIN
		--entries who are present in input and in table with flag as 1 can be deleted right away
		INSERT INTO @ownersDeleted
			SELECT Owners.userOrGroupId, Owners.isUser, 1
			FROM UMOwners Owners INNER JOIN @inputOwnersTable Input
			ON Owners.userOrGroupId = Input.userOrGroupId AND Owners.isUser = Input.isUser
			WHERE entityTYpe = @entityType AND entityId = @entityId AND Owners.flags = 1
		--entries who are present in input and in table with flag as 1 and another bit has to be masked for 1
		INSERT INTO @ownersModified
			SELECT Owners.userOrGroupId, Owners.isUser, Owners.flags & (~(1))
			FROM UMOwners Owners INNER JOIN @inputOwnersTable Input
			ON Owners.userOrGroupId = Input.userOrGroupId AND Owners.isUser = Input.isUser
			WHERE Owners.entityType = @entityType AND Owners.entityId = @entityId AND Owners.flags <> 1 AND (Owners.flags & 1 <> 0)
	END
	IF @entityOwnersOperationType = 1			--OVERWRITE
	BEGIN
		--completely new owners are added
		INSERT INTO @ownersAdded
			SELECT userOrGroupId, isUser, flags
			FROM @inputOwnersTable Input
			WHERE NOT EXISTS (SELECT 1 FROM UMOwners WHERE entityTYpe = @entityType AND entityId = @entityId AND userOrGroupId = Input.userOrGroupId AND isUser = Input.isUser)
		--entries present in DB but not in input table are to be deleted
		INSERT INTO @ownersDeleted
			SELECT userOrGroupId, isUser, flags
			FROM UMOwners Owners
			WHERE entityType = @entityType AND entityId = @entityId
			AND NOT EXISTS (SELECT 1 FROM @inputOwnersTable WHERE userOrGroupId = Owners.userOrGroupId AND isUser = Owners.isUser)
		--entries present in DB and input with flags changed - update to input flag
		INSERT INTO @ownersModified
			SELECT Input.userOrGroupId, Input.isUser, Input.flags
			FROM UMOwners Owners INNER JOIN @inputOwnersTable Input
			ON Owners.userOrGroupId = Input.userOrGroupId AND Owners.isUser = Input.isUser
			WHERE Owners.entityType = @entityType AND Owners.entityId = @entityId AND Owners.flags <> Input.flags
	END
	IF @entityOwnersOperationType = 2					--ADD
	BEGIN
		--completely new owners are added
		INSERT INTO @ownersAdded
			SELECT userOrGroupId, isUser, flags
			FROM @inputOwnersTable Input
			WHERE NOT EXISTS (SELECT 1 FROM UMOwners WHERE entityTYpe = @entityType AND entityId = @entityId AND userOrGroupId = Input.userOrGroupId AND isUser = Input.isUser)
		--for entries present already OR with given flag
		INSERT INTO @ownersModified
			SELECT Input.userOrGroupId, Input.isUser, Input.flags | UMOwners.flags
			FROM @inputOwnersTable Input INNER JOIN UMOwners
			ON Input.userOrGroupId = UMOwners.userOrGroupId AND Input.isUser = UMOwners.isUser
			WHERE UMOwners.entityType = @entityType AND UMOwners.entityId = @entityId AND Input.flags <> UMOwners.flags
	END
	IF @entityOwnersOperationType = 3				--DELETE
	BEGIN
		--owners with same flag are deleted
		INSERT INTO @ownersDeleted
			SELECT Owners.userOrGroupId, Owners.isUser, Owners.flags & (~(Input.flags))
			FROM UMOwners Owners INNER JOIN @inputOwnersTable Input
			ON Owners.userOrGroupId = Input.userOrGroupId AND Owners.isUser = Input.isUser
			WHERE entityType = @entityType AND entityId = @entityId AND Input.flags | Owners.flags = Input.flags			--owners have either lesser or same bits as input, so delete the rows
		--for owners with other flags also set apart from this given flag, just unset these given bits alone
		INSERT INTO @ownersModified
			SELECT Owners.userOrGroupId, Owners.isUser, Owners.flags & (~(Input.flags))
			FROM UMOwners Owners INNER JOIN @inputOwnersTable Input
			ON Owners.userOrGroupId = Input.userOrGroupId AND Owners.isUser = Input.isUser
			WHERE entityType = @entityType AND entityId = @entityId AND Input.flags | Owners.flags <> Input.flags			--some extra bits are set for owners so unsetting only the ones in input
	END
	DECLARE @skipUserSecurityCheck INT=@skipSecurityCheck
IF(@entityType=28)
	BEGIN
		--check if caller userID is creator of client group.THan skip change security settings and 3rd security check.
		DECLARE @creatorId INT
EXEC sec_getCreateAsUserId 28, @entityId, @creatorId OUTPUT
		IF(@callerId=@creatorID)
			SET @skipSecurityCheck=1
	END
	--Security checks:
	IF OBJECT_ID('tempdb.dbo.#sec_populatepermissionTablePermissionList') IS NOT NULL
                DROP TABLE #sec_populatepermissionTablePermissionList
    CREATE TABLE #sec_populatepermissionTablePermissionList (permissionId INT)
	EXEC sec_getPermissionsOnEntity '#sec_populatepermissionTablePermissionList',@callerID, @entityType, @entityId,0,0,0,0,0,0,0,0,0,1
	IF NOT EXISTS (SELECT * FROM @ownersAdded) AND
	   NOT EXISTS (SELECT * FROM @ownersDeleted) AND
	   NOT EXISTS (SELECT * FROM @ownersModified)
			GOTO OWNER_CAPS_PROCESSING				--Owners are not changed. May be he is trying to change only the owner capabilities
	IF @skipSecurityCheck = 0
	BEGIN
	 --1. Check if the user has Change security on the entity
IF NOT EXISTS (SELECT * FROM #sec_populatepermissionTablePermissionList WHERE permissionId = 107)
     BEGIN
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedPermission(107, @localeId))
                EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType, @entityId
                SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
                GOTO END_PROCESSING
     END
	END
	 --2. User needs to atleast "see" the user and user groups that he is trying to associate with the entity
	 DECLARE @usersAndGroupsVisible TABLE (userOrGroupId INT, isUser INT)
     IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL
                DROP TABLE #VisibleUsersAndUserGroups
     CREATE TABLE #VisibleUsersAndUserGroups (userOrGroupId INT)
	 DECLARE @usersCallerDontHaveRight TABLE (userId INT)
     DECLARE @userGroupsCallerDontHaveRight TABLE (userGroupId INT)
	 EXEC sec_getUsersForThisUser '#VisibleUsersAndUserGroups', @callerId
     INSERT INTO @usersAndGroupsVisible
          SELECT userOrGroupId, 1
          FROM #VisibleUsersAndUserGroups
     DELETE FROM #VisibleUsersAndUserGroups
     EXEC sec_getUserGroupsForThisUser '#VisibleUsersAndUserGroups', @callerId
     INSERT INTO @usersAndGroupsVisible
          SELECT userOrGroupId, 0
          FROM #VisibleUsersAndUserGroups
     DELETE FROM #VisibleUsersAndUserGroups
	 --Special handling for OVERWRITE condition, if some association is present in deleted table that is not visible to this caller
     --then caller would not have even selected it in the first place from GUI
     --So let us not "delete" those entries
      IF (@ownersOperationType = 1) OR (@entityOwnersOperationType = 1)           --OVERWRITE
      BEGIN
                DELETE Tbl
                FROM @ownersDeleted Tbl LEFT OUTER JOIN @usersAndGroupsVisible See
                ON Tbl.userOrGroupId = See.userOrGroupId AND Tbl.isUser = See.isUser
                WHERE See.isUser IS NULL AND See.userOrGroupId IS NULL
				IF (@ownersOperationType = 1)
				BEGIN
					--in ownersModifiedTable if there are a few entries with flag & 1 = 0, then they also need to be removed.
					--because the user might not have seen him and so it is not present in input
					--eg., assume user 1 is owner + system created owner of a client. so the entry in DB will be <user/flags> - <user1/3>.
					--if caller cannot see user1, then it will not come in input. So we should not update user1 flags to 2 in this case.
					DELETE Tbl
					FROM @ownersModified Tbl LEFT OUTER JOIN @usersAndGroupsVisible See
					ON Tbl.userOrGroupId = See.userOrGroupId AND Tbl.isUser = See.isUser
					WHERE See.isUser IS NULL AND See.userOrGroupId IS NULL AND Tbl.flags & 1 = 0
				END
      END
	  IF(@skipUserSecurityCheck=0)
	  BEGIN
		  INSERT INTO @usersCallerDontHaveRight
						SELECT userOrGroupID
						FROM @ownersAdded
						WHERE isUser = 1
						UNION
						SELECT userOrGroupId
						FROM @ownersDeleted
						WHERE isUser = 1
						EXCEPT
						(SELECT userOrGroupId
						FROM @usersAndGroupsVisible
						WHERE isUser = 1)
		   INSERT INTO @userGroupsCallerDontHaveRight
						SELECT userOrGroupID
						FROM @ownersAdded
						WHERE isUser = 0
						UNION
						SELECT userOrGroupId
						FROM @ownersDeleted
						WHERE isUser = 0
						EXCEPT
						(SELECT userOrGroupId
						FROM @usersAndGroupsVisible
						WHERE isUser = 0)
			IF EXISTS (SELECT * FROM @usersCallerDontHaveRight)
			BEGIN
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' + Users.login
																FROM @usersCallerDontHaveRight Tbl INNER JOIN UMUsers Users
                                                                ON Tbl.userId = Users.id
                                                                FOR XML PATH('')), 2, 2147483647), ''))
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE (@errorString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
					SET @errorString = REPLACE (@errorString, '[^2%s]', 'Users : ['+@invalidChar+']')
					GOTO END_PROCESSING
			END
			IF EXISTS (SELECT * FROM @userGroupsCallerDontHaveRight)
			BEGIN
					SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' + Groups .name
																FROM @userGroupsCallerDontHaveRight Tbl INNER JOIN UMGroups Groups
																ON Tbl.userGroupId = Groups.id
																FOR XML PATH('')), 2, 2147483647), ''))
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE (@errorString, '^1%s', dbo.sec_getLocalizedPermission(31, @localeId))
					SET @errorString = REPLACE (@errorString, '[^2%s]', 'UserGroups : ['+@invalidChar+']')
					GOTO END_PROCESSING
			END
		END
		DECLARE @isLockedClient INT = 0
		DECLARE @activatedMode INT = 0
IF @entityType = 3
		BEGIN
			SET @activatedMode = (ISNULL((SELECT attrval FROM APP_CLIENTPROP WITH(NOLOCK) WHERE componentNameId = @entityId AND
(attrName = 'Activated Mode' ) AND modified = 0),0))
IF @activatedMode = 2 -- SHARED LAPTOP
			BEGIN
					SET @errorCode = 1
					SET @errorString = 'Error. Client owner(s) modification is restricted on a shared laptop.'
					GOTO END_PROCESSING
			END
		    -- Reading the encrypted Enable Data Security attributeValue and converting back to 0 and 1 respectively
			SET @isLockedClient = ISNULL((SELECT CASE attrVal
WHEN  'a45fabb9712142ea42da80d2c0314cf1f871cea2571f6bda4152f645e2424b592f0ac7691aec175a'  THEN 1
														ELSE 0
END FROM APP_ClientProp WHERE componentNameId = @entityId AND attrName = '7b70af7d447e975e31f8504a337c5458f5d51604cabfbfca348e98db02d459be18cdbd8233a5d807' AND modified = 0), 0)
			IF @isLockedClient = 1
			BEGIN
				--1. Caller should be a owner
				IF dbo.IsClientOwner(@entityID, @callerID) = 0
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Error. Only owner can change this association for a locked client'
					GOTO END_PROCESSING
				END
				--2. No user group owners should be added
				--checking on "added" table  alone is fine. Entries in "deleted" table are any how going to get deleted
				IF EXISTS (SELECT userOrGroupId FROM @ownersAdded WHERE isUser = 0)
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Error. User groups cannot be owners for a locked client'
					GOTO END_PROCESSING
				END
				--3. There should be no user owner without a email and not enabled
				IF EXISTS (SELECT id
						   FROM UMUsers
						   WHERE id IN (SELECT userOrGroupId
										FROM @ownersAdded
										WHERE isUser = 1)
								AND (enabled = 0 OR email IS NULL OR email = '' OR email = 'Email Disabled' OR email='No Email'))
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Error. Owners should have email and should be enabled'
					GOTO END_PROCESSING
				END
				--4. There should be atleast one user owner
				--So check after doing this operation that there will be atleast one user owner entry left
				IF NOT EXISTS (SELECT userOrGroupId, isUser
							  FROM UMOwners
							  WHERE entityType = @entityType AND entityId = @entityId AND isUser = 1
							  UNION
							  SELECT userOrGroupId, isUser
							  FROM @ownersAdded
							  WHERE isUser = 1
							  EXCEPT
							  SELECT userOrGroupId, isUser
							  FROM @ownersDeleted
							  WHERE isUser = 1)
				BEGIN
					SET @errorCode = 1
					SET @errorString = 'Error. There should be atleast user owner for locked client'
					GOTO END_PROCESSING
				END
			END
		END
	    BEGIN TRY
			INSERT INTO UMOwners (entityType, entityID, userOrGroupId, isUser, authorId, flags)
				SELECT @entityType, @entityId, userOrGroupId, isUser, @callerId, ISNULL(flags, 1)
				FROM @ownersAdded
			DELETE Sec
			FROM UMOwners Sec INNER JOIN @ownersDeleted Tbl
			ON Sec.isUser = Tbl.isUser AND Sec.userOrGroupId = Tbl.userOrGroupId
			WHERE Sec.entityType = @entityType AND Sec.entityId = @entityId
			UPDATE UMOwners
			SET flags = OM.flags
			FROM @ownersModified OM
			WHERE entityType = @entityType AND entityID = @entityId AND OM.userOrGroupId = UMOwners.userOrGroupId AND OM.isUser = UMOwners.isUser
			-- Need to recompute the quota information for the users/groups getting removed/added. Insert 'ReComputeQuota property in UmUsersProp table for the modified users.
			-- For groups, expand user list. An admin thread will be running in indexing layer which will check for this property and recompute the quota for all the affected users.
			DECLARE @inXml XML
			SET @inXml = (SELECT O.userId as '@id'
				FROM
					(SELECT userOrGroupId as userId
						FROM @ownersAdded
						WHERE isUser = 1
					UNION
					SELECT userOrGroupId as userId
						FROM @ownersDeleted
						WHERE isUser = 1
					UNION
					SELECT ug.userId as userId
						FROM @ownersAdded o
						JOIN UMUserGroup ug WITH(NOLOCK) on o.isUser = 0 AND o.userOrGroupId = ug.groupId
					UNION
					SELECT ug.userId as userId
						FROM @ownersDeleted o
						JOIN UMUserGroup ug WITH(NOLOCK) on o.isUser = 0 AND o.userOrGroupId = ug.groupId
					UNION
					SELECT ug.userId as userId
						FROM @ownersAdded o
						JOIN UMUserGroup ug WITH(NOLOCK) ON o.isUser = 0 AND ug.groupId in (SELECT umdsGroupId
											FROM UMDSGroupMaps WITH(NOLOCK)
											WHERE umGroupId = o.userOrGroupId)
					UNION
					SELECT ug.userId as userId
						FROM @ownersDeleted o
						JOIN UMUserGroup ug WITH(NOLOCK) ON o.isUser = 0 AND ug.groupId in (SELECT umdsGroupId
											FROM UMDSGroupMaps WITH(NOLOCK)
											WHERE umGroupId = o.userOrGroupId)
					) O
				FOR XML PATH ('userID'), ROOT('UserList')
			 )
			exec UpdateUserPropForQuota @inXml
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorcode = ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
			GOTO END_PROCESSING
		END CATCH
IF @entityType = 3
			--Copied from DM2UpdateWBAClientOwners.sp
			DELETE App_SyncCloudConfig
			WHERE NOT EXISTS   (SELECT * FROM UMOwners EA WITH (READUNCOMMITTED)
								JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = EA.userOrGroupID AND EA.isUser = 1
								WHERE entityType=3 AND entityID=clientId
								) -- USER
				AND NOT EXISTS (SELECT * FROM UMOwners EA WITH (READUNCOMMITTED)
								INNER JOIN UMUserGroup UM WITH (READUNCOMMITTED) ON EA.userOrGroupId = UM.groupId AND EA.isUser = 0
								INNER JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = UM.userId
								WHERE entityType=3 AND entityId=clientId
								) -- USER PART OF INTERNAL GROUP
				AND NOT EXISTS (SELECT * FROM UMOwners EA WITH (READUNCOMMITTED)
								INNER JOIN UMDSGroupMaps GM WITH (READUNCOMMITTED) ON EA.userOrGroupId = GM.umgroupId AND EA.isUser = 0
								INNER JOIN UMDSUserGroup UM WITH (READUNCOMMITTED) ON GM.umDSgroupId = UM.groupId
								INNER JOIN App_SyncCloudFolder CF WITH (READUNCOMMITTED) ON CF.ownerId = UM.userId
								WHERE entityType=3 AND entityId=clientId
								) -- USER PART OF EXTERNAL GROUP LINKED TO INTERNAL GROUP WHICH IS AN OWNER
				AND EXISTS		(SELECT * FROM App_SyncCloudFolder CF WITH (READUNCOMMITTED)
								 WHERE CF.syncWebFolderId = syncWebFolderId
								)
				AND NOT EXISTS (SELECT 1 FROM App_Client C WITH (READUNCOMMITTED)
								WHERE C.id = clientId AND status & 0x10000000 <> 0 ) -- Ignore Edge Clients
				AND NOT EXISTS (SELECT 1 FROM APP_IDAName I WITH (READUNCOMMITTED)
WHERE I.clientId = clientId AND I.appTypeId = 137
								) -- Ignore Exchange mailbox share clients
OWNER_CAPS_PROCESSING:
DECLARE @tranStarted INT
SET @tranStarted = 0
IF @@TRANCOUNT = 0
BEGIN
	BEGIN TRAN			--we can do the security check at the last only, after the new UMROlesWithPermissionsExpanded table is framed
					    --so if the security checks fail, then we have to roll back. Ideally the caller should have initiated the tran
						--but let us still have it in this case
	SET @tranStarted = 1
END
		DECLARE @roleIdForEntity INT = ISNULL((SELECT roleId FROM UMOwnerRoles WHERE entityTYpe = @entityType AND entityId = @entityId), 0)
		DECLARE @categoryPermissionsXML XML = (SELECT @xmlIn.query('App_SecurityAssociationForEntityList/ownerAssociations/categoryPermission'))
		DECLARE @roleXML XML
		DECLARE @outputXML XML
		DECLARE @oldPermissionsTable TABLE (permissionId INT)
		DECLARE @roleName NVARCHAR(MAX)
		IF @categoryPermissionsXML IS NULL OR (@categoryPermissionsXML.exist ('categoryPermission/@categoriesPermissionOperationType') <> 1) OR (@categoryPermissionsXML.value('(categoryPermission/@categoriesPermissionOperationType)[1]', 'INT') = 0)
		BEGIN
			--Nothing to do
			GOTO END_PROCESSING
		END
		IF @roleIdForEntity = 0			--role is not there, so create one
		BEGIN
SET @roleName = 'SystemCreatedRole_' + CAST (@entityTYpe AS NVARCHAR(MAX)) + '_' + CAST (@entityId AS NVARCHAR(MAX)) + '_' + CAST(dbo.getUnixTime(GETUTCDATE()) AS NVARCHAR(MAX))
			SET @roleXML = (SELECT 'System created owner role for entity' AS '@description',
								   (SELECT @roleName AS '@roleName'
								   FOR XML PATH ('role'), TYPE),
								   (SELECT @categoryPermissionsXML.query('.')
								   FOR XML PATH (''), TYPE)
						   FOR XML PATH ('Security_Role'))
			--Let the owner roles be created and edited by "admin" user and not the caller
			--Because one user would create the role and when another comes for altering it
			--we may face issues since roles can be edited and deleted by only the creator and admin
EXEC sec_createRole @roleXML, 1, @cmdLine, @outputXML OUTPUT, 0, 4
		END
		ELSE
		BEGIN
			INSERT INTO @oldPermissionsTable
				SELECT DISTINCT permissionId
				FROM UMRolesWithPermissionsExpanded
				WHERE roleId = @roleIdForEntity
			SET @roleName = (SELECT name FROM UMRoles WHERE id = @roleIdForEntity)
			SET @roleXML = (SELECT 'System created owner role for entity' AS '@description',
								   (SELECT @roleIdForEntity AS '@roleId'
								   FOR XML PATH ('role'), TYPE),
								   (SELECT @categoryPermissionsXML.query('.')
								   FOR XML PATH (''), TYPE)
						   FOR XML PATH ('Security_Role'))
EXEC sec_editRole @roleXML, 1, @cmdLine, @outputXML OUTPUT, 0
		END
		SET @errorCode = ISNULL((SELECT UG.value('@errorCode', 'INT')
								 FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), 0)
		SET @errorString = ISNULL((SELECT UG.value('@errorString', 'NVARCHAR(MAX)')
								   FROM @outputXML.nodes('App_GenericEntityResponse') AS Output(UG)), N'')
		IF @errorCode <> 0
		BEGIN
			GOTO END_PROCESSING
		END
		BEGIN TRY
			IF @roleIdForEntity = 0		--role is just now created. Get the id from UMROles
			BEGIN
				SET @roleIdForEntity = (SELECT id FROM UMRoles WHERE name = @roleName)
				INSERT INTO UMOwnerRoles (entityType, entityId, roleId, permissionId, authorId)
					SELECT @entityType, @entityId, @roleIdForEntity, 0, @callerId
			END
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			SET @errorcode = ERROR_NUMBER()
			SET @errorString = ERROR_MESSAGE()
			GOTO END_PROCESSING
		END CATCH
		INSERT INTO @ownerPermissionsAdded
			SELECT permissionId
			FROM UMRolesWithPermissionsExpanded
			WHERE roleId = @roleIdForEntity
			EXCEPT
			SELECT permissionId
			FROM @oldPermissionsTable
		INSERT INTO @ownerPermissionsDeleted
			SELECT permissionId
			FROM @oldPermissionsTable
			EXCEPT
			SELECT permissionId
			FROM UMROlesWithPermissionsExpanded
			WHERE roleId = @roleIdForEntity
		IF NOT EXISTS (SELECT * FROM @ownerPermissionsAdded UNION SELECT * FROM @ownerPermissionsDeleted)
		BEGIN
			--Nothing has changed. May be the caller is changing some other property in GUI from entity properties
			--so let us not do any security check and throw errors
			GOTO END_PROCESSING
		END
		IF @skipSecurityCheck = 0
		BEGIN
		DECLARE @permissionListUserDontHaveRight TABLE (permissionId INT)
		DECLARE @inputNoAssocPermission TABLE(permissionId INT)
		 --Check if the user has Change security on the entity
IF NOT EXISTS (SELECT * FROM #sec_populatepermissionTablePermissionList WHERE permissionId = 107)
		 BEGIN
SET @errorCode = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2432 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
SET @errorString = REPLACE(@errorString, '^1%s', dbo.sec_getLocalizedPermission(107, @localeId))
					EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @localeId, @entityType, @entityId
					SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
					GOTO END_PROCESSING
		 END
		 IF(@skipAssocPermissionCheck=0)
		 BEGIN
			INSERT INTO @permissionListUserDontHaveRight
					 SELECT permissionId
					 FROM @ownerPermissionsAdded
					 UNION
					 SELECT permissionId
					 FROM @ownerPermissionsDeleted
					 EXCEPT
					( SELECT permissionId
					 FROM #sec_populatepermissionTablePermissionList
					 UNION
SELECT id from UMPermissions where flags&2<>0) -- skip third security check.( user should have this permission to assign others for hidden permissions.
			--Separate checks for no associations permissions.
			INSERT INTO @inputNoAssocPermission
SELECT permissionId FROM @permissionListUserDontHaveRight where permissionId in (SELECT id FROM UMPermissions WHERE flags& 1 <>0  )
			IF EXISTS ( SELECT * FROM @inputNoAssocPermission)
				BEGIN
					DECLARE @permissionString NVARCHAR(MAX)=''
					DECLARE	@hasAllNoAssociationsPermission INTEGER=0
					SELECT @permissionString =CASE WHEN @permissionString=''
															THEN CAST(permissionId as varchar(10))
															else @permissionString+','+CAST(permissionId as varchar(10))
															end
															FROM @inputNoAssocPermission
					EXEC sec_userHasCapability @callerId,0,@hasAllNoAssociationsPermission OUTPUT,0,0,@permissionString
					IF(@hasAllNoAssociationsPermission=1)
					BEGIN
						DELETE FROM @permissionListUserDontHaveRight WHERe permissionId in (select permissionId from @inputNoAssocPermission)
					END
				END
		 --Check if all the permissions that the user has given on the entity is present for him on the entity
		 IF EXISTS(SELECT * FROM @permissionListUserDontHaveRight)
         BEGIN
SET @errorCode = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2433 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
                SET @invalidChar = (SELECT ISNULL(SUBSTRING((SELECT ',' +  dbo.sec_getLocalizedPermission(permissionId, @localeId)
                                                            FROM @permissionListUserDontHaveRight
                                                            FOR XML PATH('')), 2, 2147483647), ''))
                SET @errorString = REPLACE(@errorString, '^1%s', @invalidChar)
                EXEC sec_getEntityTypeAndNameFromEntityTypeHierarchy @invalidChar OUTPUT, @LocaleId, @entityType, @entityId
                SET @errorString = REPLACE(@errorString, '^2%s', @invalidChar)
                GOTO END_PROCESSING
         END
		END
	END
		 UPDATE UMOwnerRoles
		 SET authorId = @callerId
		 WHERE entityTYpe = @entityType AND entityId = @entityId
END_PROCESSING:
	IF @tranStarted = 1
	BEGIN
		IF @errorCode <> 0 ROLLBACK TRAN
		ELSE COMMIT TRAN
	END
	IF OBJECT_ID ('tempdb.dbo.#sec_populatepermissionTablePermissionList') IS NOT NULL DROP TABLE #sec_populatepermissionTablePermissionList
	IF OBJECT_ID ('tempdb.dbo.#VisibleUsersAndUserGroups') IS NOT NULL DROP TABLE #VisibleUsersAndUserGroups
GO

IF EXISTS (select * from GxQscripts where name = 'sec_populateOwnersTable')
	delete from GxQscripts where name = 'sec_populateOwnersTable'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateOwnersTable')
	delete from GXDBVersions where aliasname = 'sec_populateOwnersTable'
GO

insert into GXDBVersions values(2, 'sec_populateOwnersTable',  '00000000000000000000', 'sec_populateOwnersTable', '00000000000000000000')
GO

