

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_populateCache_OneEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+--------------------------------------------------------------------------------------------------+
--	| 	Procedure : "sec_populateCache_OneEntity"
--	|	Description: This Procedure is used to populate cache table for given user and given entity.
--	|	Inputs:
--	|		userId
--	|		entityType (as defined in CvEntities.x)
--	|		entityId1, entityId2, entityId3, entityId4, entityId5 (2-5 needed for iDA entities only)
--	|		update owner credentials flag. When set to 1, it will update UMOwnerCredentials also.
--	|	Author: jswaminathan
-- 	+--------------------------------------------------------------------------------------------------+
--
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_populateCache_OneEntity')
BEGIN
	print '>>> Drop Stored Procedure: sec_populateCache_OneEntity <<<'
	drop procedure sec_populateCache_OneEntity
END
IF EXISTS (select * from GxQscripts where name='sec_populateCache_OneEntity')
	delete from GxQscripts where name = 'sec_populateCache_OneEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateCache_OneEntity')
	delete from GXDBVersions where aliasname = 'sec_populateCache_OneEntity'
GO
print '... Creating Procedure: sec_populateCache_OneEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_populateCache_OneEntity
  @userID INT,
  @entityType INT,
  @entityId1 INT,
  @entityId2 INT = 0,
  @entityID3 INT = 0,
  @entityId4 INT = 0,
  @entityId5 INT = 0,
  @updateOwnerCredentials INT = 0
AS
SET NOCOUNT ON
DECLARE @isOldModelPopulateCache BIT = 0
SELECT @isOldModelPopulateCache = 1
FROM GxGlobalParam (NOLOCK)
WHERE
	name = 'nIsOldModelPopulateCache'
	AND value = '1'
	AND modified = 0
-- Amey wanted a method to fall back to old model based on a GxGlobalParam. It helps in case of issues.
IF @isOldModelPopulateCache = 1
BEGIN
	EXEC sec_updateUserCredentials @userID, 1
	RETURN
END
-- iDA entities special handling.
BEGIN
DECLARE @isIdaEntity INT = CASE WHEN @entityType IN (3, 4, 5, 6, 7) THEN 1 ELSE 0 END
	DECLARE @entityType1 INT = @entityType
			,@entityType2 INT = 0
			,@entityType3 INT = 0
			,@entityType4 INT = 0
			,@entityType5 INT = 0
	IF @isIdaEntity = 1
	BEGIN
SET @entityType1 = 3
IF @entityType > 3
SET @entityType2 = 4
IF @entityType > 4
SET @entityType3 = 5
IF @entityType > 5
SET @entityType4 = 6
IF @entityType > 6
SET @entityType5 = 7
	END
END
-- Populate cache table.
BEGIN
	IF OBJECT_ID('tempdb.dbo.#populateCache_OneEntity_UMUserCredentialsTable') IS NOT NULL
		DROP TABLE #populateCache_OneEntity_UMUserCredentialsTable
	CREATE TABLE #populateCache_OneEntity_UMUserCredentialsTable
	(
		permissionId INT
	)
	EXEC sec_getPermissionsOnEntity '#populateCache_OneEntity_UMUserCredentialsTable', @userId,
									@entityType1, @entityID1,
									@entityType2, @entityId2,
									@entityType3, @entityId3,
									@entityType4, @entityId4,
									@entityType5, @entityId5
	DECLARE @capabilitiesBigInt BIGINT = 0
	-- The following special handling are done in sec_populateCache stored procedure. Please refer to that for any comments.
IF (@isIdaEntity = 0 AND NOT(@entityType = 1 AND @entityId1 = 2))
	BEGIN
IF @entityType = 83				-- For workflow honor only permissionId <= 64.
		BEGIN
			SELECT @capabilitiesBigInt = SUM(POWER(2.0,permissionId-1))
			FROM #populateCache_OneEntity_UMUserCredentialsTable
			WHERE
				permissionId <= 64
		END
		ELSE								-- For other entities, honor permissionId <= 64 and fill View for permissionId > 64
		BEGIN
			SELECT @capabilitiesBigInt = SUM(DISTINCT
											CASE
												WHEN permissionId <= 64 THEN POWER(2.0,permissionId-1)
ELSE POWER(2.0,31-1)
											END)
			FROM #populateCache_OneEntity_UMUserCredentialsTable
		END
	END
	ELSE			-- For iDA entities and commcell entity(2), fill only the generic permissions in cache table. We should not fill specific permissions.
	BEGIN
		SELECT @capabilitiesBigInt = SUM(DISTINCT
											CASE
												WHEN Temp.permissionId <= 64 THEN POWER(2.0,Temp.permissionId-1)
ELSE POWER(2.0,31-1)
											END)
		FROM #populateCache_OneEntity_UMUserCredentialsTable Temp
			INNER JOIN UMPermissionEntityTypeMap PE
				ON Temp.permissionId = PE.permissionId
		WHERE
			PE.entityType = 0
	END
	IF @capabilitiesBigInt <> 0 AND @capabilitiesBigInt IS NOT NULL
	BEGIN
		UPDATE UMUserCredentials
		SET capabilities = @capabilitiesBigInt
		WHERE
			userID = @userID
			AND
			(
(@entityType = 28 AND clientGroupId = @entityId1)
OR (@entityType = 3 AND clientId = @entityId1 AND appTypeId = 0)
OR (@entityType = 4 AND clientId = @entityId1 AND appTypeId = @entityId2 AND instanceID = 0)
OR (@entityType = 5 AND clientId = @entityId1 AND appTypeId = @entityId2 AND instanceID = @entityId3 AND backupsetID = 0)
OR (@entityType = 6 AND clientId = @entityId1 AND appTypeId = @entityId2 AND instanceID = @entityId3 AND backupsetId = @entityId4 AND subclientId = 0)
OR (@entityType = 7 AND clientId = @entityId1 AND appTypeId = @entityId2 AND instanceID = @entityId3 AND backupsetId = @entityId4 AND subclientId = @entityId5)
OR (@entityType = 11 AND mediaAgentId = @entityId1)
OR (@entityType = 9 AND libraryId = @entityId1)
OR (@entityType = 17 AND archGroupId = @entityId1)
OR (@entityType = 130 AND vtContainerId = @entityId1)
OR (@entityType = 21 AND vtPolicyId = @entityId1)
OR (@entityType = 57 AND vtShelfId = @entityId1)
OR (@entityType = 9501 AND reviewSetId = @entityId1)
OR (@entityType = 9502 AND querySetId = @entityId1)
OR (@entityType = 9503 AND downloadSetId = @entityId1)
OR (@entityType = 9504 AND tagId = @entityId1)
OR (@entityType = 9505 AND legalHoldId = @entityId1)
OR (@entityType = 9506 AND ermId = @entityId1)
OR (@entityType = 9507 AND cdPolicyId = @entityId1)
OR (@entityType = 35 AND taskId = @entityId1)
OR (@entityType = 83 AND workflowId = @entityId1)
OR (@entityType = 90 AND logMonitoringPolicyId = @entityId1)
OR (@entityType = 153 AND arrayId = @entityId1)
OR (@entityType = 15 AND userGroupId = @entityId1)
OR (@entityType = 61 AND providerId = @entityId1)
OR (@entityType = 53 AND entityId1 = @entityId1)
OR (@entityType = 124 AND entityId3 = @entityId1)
OR (@entityType = 1 AND @entityId1 <> 2 AND entityId6 = @entityId1)
OR (@entityType = 1 AND @entityId1 = 2 AND commcellId = 2 AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0 AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0 AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0 AND vtContainerId = 0 AND vtPolicyId = 0 AND vtShelfId = 0 AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0 AND ermId = 0 AND legalHoldId = 0 AND tagId = 0 AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0 AND workflowId = 0 AND logMonitoringPolicyId = 0 AND arrayId = 0 AND cloudId = 0 AND userGroupId = 0 AND providerId = 0 AND entityId1 = 0 AND entityId2 = 0 AND entityId3 = 0 AND entityId4 = 0 AND entityId5 = 0 AND entityId6 = 0 AND entityId7 = 0 AND entityId8 = 0 AND entityId9 = 0)
			)
		IF @@ROWCOUNT = 0			-- Cache table does not have this entry. Insert new one.
			INSERT INTO UMUserCredentials
				VALUES (
							@userId,
							@capabilitiesBigInt,
							0,
							2,
CASE WHEN (@entityType = 28) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType1 = 3) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType2 = 4) THEN @entityId2 ELSE 0 END,
CASE WHEN (@entityType3 = 5) THEN @entityId3 ELSE 0 END,
CASE WHEN (@entityType4 = 6) THEN @entityId4 ELSE 0 END,
CASE WHEN (@entityType5 = 7) THEN @entityId5 ELSE 0 END,
CASE WHEN (@entityType = 11) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 17) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 130) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 21) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 57) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9501) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9502) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9503) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9504) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9505) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9506) THEN @entityId1 ELSE 0 END,
CASE WHEN (@entityType = 9507) THEN @entityId1 ELSE 0 END,
							0, --complianceReportId
CASE WHEN (@entityType = 35) THEN @entityId1 ELSE 0 END, --taskId
CASE WHEN (@entityType = 83) THEN @entityId1 ELSE 0 END, --workflowId
CASE WHEN (@entityType = 90) THEN @entityId1 ELSE 0 END, --logMonitoringPolicyId
CASE WHEN (@entityType = 153)THEN @entityId1 ELSE 0 END, --arrayId
							0,	--cloudId
CASE WHEN (@entityType = 15 OR @entityType = 62) THEN @entityId1 ELSE 0 END, --userGroupId,externalGroupId
CASE WHEN (@entityType = 61 ) THEN @entityId1 ELSE 0 END, --umdsporvider
CASE WHEN (@entityType = 53 ) THEN @entityId1 ELSE 0 END, --entityId1: location entity
							0,	--entityId2
CASE WHEN (@entityType= 124  ) THEN @entityId1 ELSE 0 END, --entityId3
							0,	--entityId4
							0,	--entityId5
							CASE --entityId6
WHEN (@entityType = 1 AND @entityId1 <> 2)  THEN @entityId1
								ELSE 0
							END,
							0, --entityId7
							0, --entityId8
							0, --entityId9
							0,	--permissionBitArray
							0	--extendedPermissionBitArray
						)
		-- This SP is called mainly when a new client is added. If this client is a company client, then all logged in tenant admins can see this new added client.
		-- All of them should be associated with this new client in the cache table, not just the one who is physically adding this client Id.
		-- Else it creates issues, (like when auth-code is used for install, etc.).
IF @entityType = 3			-- other entities have already moved away from cache table. So lets add only for client entity. And this SP is currently called only for Client entity.
		BEGIN
			DECLARE @_tenantAdminGroupId INT = 0
			DECLARE @_companyID INT = 0
			SET @_companyId = dbo.AppGetCompanyForUserOrUserGroup(@userID, 1)
			IF @_companyId <> 0
			BEGIN
				SELECT
					@_tenantAdminGroupId = id
				FROM UMGroups (NOLOCK)
				WHERE
					(umdsProviderID = @_companyId)
AND ((groupFlags & CAST(0x10000 AS INT)) <> 0)
				IF @_tenantAdminGroupId <> 0
				BEGIN
					IF OBJECT_ID('tempdb.dbo.#peerTenantAdminGroupTbl')  IS NOT NULL
						DROP TABLE #peerTenantAdminGroupTbl
					CREATE TABLE #peerTenantAdminGroupTbl
					(
						userId INT PRIMARY KEY
					)
					INSERT INTO #peerTenantAdminGroupTbl
						SELECT
							userID
						FROM UMUserGroup (NOLOCK)
						WHERE
							(groupId = @_tenantAdminGroupId) AND (userId <> @userId)
						UNION
						SELECT
							UG.userId
						FROM UMUserGroup UG (NOLOCK)
							INNER JOIN UMDSGroupMaps UDGM (NOLOCK)
								ON (UG.groupId = UDGM.umDSGroupId)
						WHERE
							(UDGM.umGroupId = @_tenantAdminGroupId) AND (UG.userId <> @userId)
					IF @@ROWCOUNT <> 0
					BEGIN
						UPDATE UC
						SET capabilities = capabilities | @capabilitiesBigInt
						FROM UMUserCredentials UC
							INNER JOIN #peerTenantAdminGroupTbl Temp
								ON (UC.userId = Temp.userId) AND (UC.clientId = @entityId1) AND (UC.appTypeId = 0)
						INSERT INTO UMUserCredentials (userId, capabilities, commcellid, clientId)
							SELECT DISTINCT
								Temp.userId,
								@capabilitiesBigInt,
								2,
								@entityId1
							FROM #peerTenantAdminGroupTbl Temp
								LEFT OUTER JOIN UMUserCredentials UC
									ON (UC.userId = Temp.userId) AND (UC.clientId = @entityId1) AND (UC.appTypeId = 0)
							WHERE
								UC.userID IS NULL
					END		-- @ROWCOUNT <> 0
				END		-- @_tenantAdminGroupId <> 0
			END		--	@_companyId <> 0
		END	-- @entityType = 3
	END	-- @capabilitiesBigInt <> 0 AND @capabilitiesBigInt IS NOT NULL
END	-- Populate cache table.
-- Populate owner cache table.
IF (@updateOwnerCredentials = 1 AND @entityType = 3)
BEGIN
	IF OBJECT_ID('tempdb.dbo.#populateCache_OneEntity_UMOwnerCredentialsTable') IS NOT NULL
		DROP TABLE #populateCache_OneEntity_UMOwnerCredentialsTable
	CREATE TABLE #populateCache_OneEntity_UMOwnerCredentialsTable
	(
		permissionId INT
	)
	EXEC sec_getPermissionsOnEntity '#populateCache_OneEntity_UMOwnerCredentialsTable', @userId,
									@entityType1, @entityID1,
									@entityType2, @entityId2,
									@entityType3, @entityId3,
									@entityType4, @entityId4,
									@entityType5, @entityId5,
									@skipClassicPermissions = 1
	DECLARE @ownerCapabilitiesBigInt BIGINT = 0
	SELECT @ownerCapabilitiesBigInt = SUM(DISTINCT
											CASE
												WHEN Temp.permissionId <= 64 THEN POWER(2.0,Temp.permissionId-1)
ELSE POWER(2.0,31-1)
											END)
	FROM #populateCache_OneEntity_UMOwnerCredentialsTable Temp
	IF @ownerCapabilitiesBigInt <> 0 AND @ownerCapabilitiesBigInt IS NOT NULL
	BEGIN
		UPDATE UMOwnerCredentials
		SET capabilities = @ownerCapabilitiesBigInt
		WHERE
			userID = @userID
			AND clientId = @entityId1
		IF @@ROWCOUNT = 0
			INSERT INTO UMOwnerCredentials
				VALUES (@userId, @entityId1, @ownerCapabilitiesBigInt)
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_populateCache_OneEntity')
	delete from GxQscripts where name = 'sec_populateCache_OneEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateCache_OneEntity')
	delete from GXDBVersions where aliasname = 'sec_populateCache_OneEntity'
GO

insert into GXDBVersions values(2, 'sec_populateCache_OneEntity',  '00000000000000000000', 'sec_populateCache_OneEntity', '00000000000000000000')
GO

