

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_populateCache.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_populateCache.sp,v $ $Id: sec_populateCache.sp,v 1.11.2.37.12.2 2021/05/13 02:05:05 jswaminathan Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_populateCache()
--  |
--  | Description:  To populate temp table (UMUsercredentials) from new v11 config tables
--  |
--  |        Note:  Add support for specific entityTypes if needed.
--	|
--  |       Input:
--	|
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  Seema & Jagadeesh  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_populateCache')
BEGIN
	print '>>> Drop Stored Procedure: sec_populateCache <<<'
	drop procedure sec_populateCache
END
IF EXISTS (select * from GxQscripts where name='sec_populateCache')
	delete from GxQscripts where name = 'sec_populateCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateCache')
	delete from GXDBVersions where aliasname = 'sec_populateCache'
GO
print '... Creating Procedure: sec_populateCache'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_populateCache
  @i_userId integer,
  @outputTablearg varchar(128),
  @entityType integer
AS
SET QUOTED_IDENTIFIER ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @sqlStmt varchar(max)
IF OBJECT_ID ('tempdb.dbo.#tempFilterUSA') is not null DROP TABLE #tempFilterUSA
CREATE TABLE #tempFilterUSA (entityType int, entityId int,roleId int default 0,permissionId integer default 0)
CREATE CLUSTERED INDEX tempFilterUSA_EntityType_EntityId_Idx ON #tempFilterUSA (entityType, entityId)
-- These 2 indexes are causing a huge delay and performance impact, when we are doing Insert / Delete
-- operations on this table. (~4 seconds for Insert and ~3 seconds for Delete).
-- Without these indexes, the Insert and Delete operations finish within 1 second, and not having these indexes
-- is not creating major impact on the Read statements. So removing them from code.
--CREATE NONCLUSTERED INDEX tempFilterUSA_roleID_Idx ON #tempFilterUSA(roleId)
--CREATE NONCLUSTERED INDEX tempFilterUSA_permissionId_Idx ON #tempFilterUSA(permissionId)
IF OBJECT_ID('tempdb.dbo.#tempUMUserCredentials') is not null DROP TABLE #tempUMUserCredentials
create table  #tempUMUserCredentials ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [tagId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [ermId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0, [permissionBitArray] varbinary(2000) default 0x0, [extendedPermissionBitArray] varbinary(2000) default 0x0  )
IF OBJECT_ID('tempdb.dbo.#userOrGroup') is not null drop table #userOrGroupId
CREATE TABLE #userOrGroup( userOrGroupId integer ,isUser integer)
CREATE CLUSTERED INDEX U ON #userOrGroup(isUser,userOrGroupId )
BEGIN TRY
	INSERT INTO #userOrGroup
	SELECT id,0
	FROM UMGroups JOIN(SELECT umgroupId  as groupId
						FROM UMDSGroupMaps UGMAP
							JOIN UMUserGroup UG
							ON UG.groupId=UGMAP.umDSgroupId and userId=@i_userId
						UNION ALL
						SELECT groupId
						FROM UMUserGroup
						where userId=@i_userId
					)AS Map on Map.groupId=id
				WHERE groupFlags &1=1
	INSERT INTO #userOrGroup
	SELECT @i_userId,1
	DECLARE @columnName NVARCHAR(1024)
	DECLARE @entityTblIdColumnName NVARCHAR(1024)
	DECLARE @whereClause NVARCHAR(1024)
	DECLARE @entityTypeCur INTEGER
	DECLARE @roleIdCurVal BIGINT
	DECLARE @permissionIdCur BIGINT
	DECLARE @tableName NVARCHAR(128)
	IF( @entityType=0)
	BEGIN
		--get  all client owners.
		  if object_id('tempdb.dbo.#NewOwnerCapabilites_new') is not null
                    DROP TABLE #NewOwnerCapabilites_new
            SELECT clientId, [userId], capabilities
                INTO #OwnerCapabilites_new
                FROM UMOwnerCredentials (NOLOCK)
                WHERE [UserId]=@i_userId
		DECLARE @tempFilterOwnerTable TABLE ( clientId int,roleId int, permissionId int)
		 DECLARE  @ownerEntities TABLE (entityId INT)
		INSERT INTO @ownerEntities
			SELECT entityId
			FROM UMOwners Owner
			JOIN #userOrGroup input ON Owner.isUser=input.isUser and  input.userOrGroupId=Owner.userOrGroupId
WHERE Owner.entityType =3
			UNION
			SELECT clientId
			FROM UMOwners Owner
			JOIN #userOrGroup input ON Owner.isUser=input.isUser and  input.userOrGroupId=Owner.userOrGroupId
JOIN APP_ClientGroupAssoc ON Owner.entityType= 28  AND  APP_ClientGroupAssoc.clientGroupId=Owner.entityId
	    INSERT INTO @tempFilterOwnerTable (clientId,roleId,permissionId)
			SELECT OwnerEntities.entityId, ISNULL(OwnerROles.roleId,0), ISNULL(OwnerRoles.permissionId,0)
            FROM UMOwnerRoles OwnerRoles RIGHT OUTER JOIN @ownerEntities OwnerEntities
ON OwnerRoles.entityType = 3 AND OwnerRoles.entityId = OwnerEntities.entityId
            UNION
            SELECT OwnerEntities.entityId, OwnerROles.roleId, OwnerRoles.permissionId
            FROM UMOwnerRoles OwnerRoles INNER JOIN APP_ClientGroupAssoc Parent
ON OwnerRoles.entityType = 28 AND OwnerRoles.entityId = Parent.clientGroupId
            INNER JOIN @ownerEntities OwnerEntities
            ON Parent.clientId = OwnerEntities.entityId
            UNION
            SELECT OwnerEntities.entityId, OwnerROles.roleId, OwnerRoles.permissionId
            FROM UMOwnerROles OwnerROles INNER JOIN @ownerEntities OwnerEntities
ON OwnerRoles.entityType = 1 AND OwnerRoles.entityId = 2
			SELECT Tbl1.clientId as clientId,@i_userId as UserId, SUM(DISTINCT CASE WHEN (ISNULL(permissionId,0)<=64) THEN POWER(2.0,(ISNULL(permissionId,0)-1)) ELSE POWER(2.0,31-1) END )AS capabilities
			INTO #NewOwnerCapabilites_new
			FROM (SELECT clientId,RPE.permissionId
					FROM  @tempFilterOwnerTable Tbl
					 LEFT OUTER JOIN UMRolesWithPermissionsExpanded RPE ON RPE.roleId=Tbl.roleId and Tbl.permissionId=0
				  UNION
				  SELECt clientId,permissionId
				  FROM @tempFilterOwnerTable  where permissionId<>0
				  ) as TBL1
					 GROUP BY Tbl1.clientId
		--CHECK IF THERE ANY CHANGE TO OWNER CAPABILTIES BEFORE TRYING TO UPDATE TABLE
			IF EXISTS(
				SELECT * FROM #OwnerCapabilites_new OC
				RIGHT OUTER JOIN #NewOwnerCapabilites_new NC ON NC.clientId = OC.clientId AND NC.userId = OC.userId
				WHERE NC.capabilities <> OC.capabilities OR OC.capabilities IS NULL
			)
			BEGIN
				UPDATE Sec
				SET capabilities = SecNew.capabilities
				FROM UMOwnerCredentials Sec
						INNER JOIN #NewOwnerCapabilites_new SecNew
							ON (Sec.userId = @i_userId) AND (Sec.clientId = SecNew.clientId) AND (Sec.capabilities <> SecNew.capabilities)
				INSERT INTO UMOwnerCredentials (userId, clientId, capabilities)
					SELECT DISTINCT
						@i_userId,
						SecNew.clientId,
						SecNew.capabilities
					FROM #NewOwnerCapabilites_new SecNew
						LEFT OUTER JOIN UMOwnerCredentials Sec
							ON (Sec.userId = @i_userId) AND (Sec.clientId = SecNew.clientId)
				WHERE (Sec.userId IS NULL)
			END
			--REMOVE ENTRIES FROM UMOwnerCredentials NOT IN #NewOwnerCapabilites. USER HAS LOST RIGHTS TO THESE CLIENTS
			IF EXISTS(
				SELECT * FROM #OwnerCapabilites_new OC
				LEFT OUTER JOIN #NewOwnerCapabilites_new NC ON NC.clientId = OC.clientId AND NC.userId = OC.userId
				WHERE NC.capabilities IS NULL
			)
			BEGIN
				DELETE UMOwnerCredentials
				FROM UMOwnerCredentials UMO
				LEFT OUTER JOIN #NewOwnerCapabilites_new NC ON UMO.userId = NC.userId AND UMO.clientId = NC.clientId
				WHERE NC.clientId IS NULL AND UMO.userId = @i_userId
			END
		-- If user has all association on commcell (or except Compliance Search permission), then just populate Commcell row.
		IF EXISTS (
					SELECT TOP 1 1
					FROM UMSecurityAssociations Sec
						INNER JOIN #userOrGroup UG
							ON Sec.isUser = UG.isUser AND Sec.userOrgroupId = UG.userOrGroupID
					WHERE
						Sec.entityType1 = 1 AND Sec.entityId1 = 2
						AND Sec.permissionid < 65
					)
		BEGIN
			-- Compute run time since devs remove permission Id < 64 and implement new permissions.
			DECLARE @allCapsBitMask BIGINT = (SELECT SUM(CAST(POWER(2.0,id-1)AS BIGINT)) FROM UMPermissions WHERE id < 65)
,@complianceSeachBitMask BIGINT = POWER(2,25-1)														-- 16777216
					,@allCapsBitMaskMinusCompliance BIGINT
					,@capsOnCommcellThisUserHas BIGINT = 0
			SET @allCapsBitMaskMinusCompliance = @allCapsBitMask &~(@complianceSeachBitMask)
			IF OBJECT_ID('tempdb.dbo.#CommcellPermissions') IS NOT NULL
				DROP TABLE #CommcellPermissions
			CREATE TABLE #CommcellPermissions
			(
				roleId INT,
				permissionId INT,
				UNIQUE CLUSTERED (roleId, permissionId)
			)
			-- Do not call any existing SP since they compute user group relations again. Load commcell permissions directly.
			-- Query only once and get all roles and permission on commcell. Then we can operate on this subset.
			-- This is better than querying the security table twice - once for role and once for permission.
			INSERT INTO #CommcellPermissions
				SELECT DISTINCT roleId, permissionId
				FROM UMSecurityAssociations Sec
					INNER JOIN #userOrGroup UG
						ON Sec.isUser = UG.isUser AND Sec.userOrgroupId = UG.userOrGroupID
				WHERE
					Sec.entityType1 = 1 AND Sec.entityId1 = 2
					AND Sec.permissionId < 65
			-- Compute bit mask capability
			SELECT @capsOnCommcellThisUserHas = @capsOnCommcellThisUserHas | CAST(POWER(2.0,RPE.permissionId-1) AS BIGINT)
			FROM #CommcellPermissions CP
				INNER JOIN UMRolesWithPermissionsExpanded RPE
					ON CP.roleId = RPE.roleID
				INNER JOIN UMRoles R
					ON CP.roleID = R.id
			WHERE
				R.disabled = 0
				AND RPE.permissionId < 65
			SELECT @capsOnCommcellThisUserHas = @capsOnCommcellThisUserHas | CAST(POWER(2.0,permissionId-1) AS BIGINT)
			FROM #CommcellPermissions
			WHERE
				permissionID > 0 AND permissionId < 65
			-- If he has all permissions on commcell, then insert only one row into cache table.
			-- with commcell entry and all capabilities and exit.
			IF (@capsOnCommcellThisUserHas = @allCapsBitMask)
			BEGIN
				INSERT INTO #tempUMUserCredentials (capabilities, flag, commCellId)
					VALUES (@capsOnCommcellThisUserHas, 0, 2)
				GOTO PROC_EXIT
			END
			-- If he has all permissions minus compliance search on commcell, then check if he has compliance search on any other entity.
			-- If yes, then go to old logic of populating everything.
			-- If no, then populate only commcell row with all capabilities minus compliance search and exit.
			ELSE IF (@capsOnCommcellThisUserHas = @allCapsBitMaskMinusCompliance)
			BEGIN
				DECLARE @complianceSearchOnAnyEntity INT
				-- Need to call existing SP since it already handles owners too.
				EXEC sec_userHasCapability @i_userId,
											@complianceSeachBitMask,				-- bit mask for compliance search
											@complianceSearchOnAnyEntity OUTPUT
				IF @complianceSearchOnAnyEntity = 0
				BEGIN
					INSERT INTO #tempUMUserCredentials (capabilities, flag, commCellId)
						VALUES (@capsOnCommcellThisUserHas, 0, 2)
					GOTO PROC_EXIT
				END
			END
			DROP TABLE #CommcellPermissions
		END
		--have to take care of include ALL
		INSERT INTO #tempFilterUSA
SELECT  entityType1,-10,roleId,permissionId
		 FROM
				(SELECT entityType1,roleId ,0  as permissionId FROM
				UMSecurityAssociations	 SA
				JOIN #userOrGroup temp ON SA.isUser=temp.isUser and   SA.userOrGroupId=temp.userOrGroupId JOIN UMRoles on SA.roleId=UMRoles.id and UMRoles.disabled=0 and SA.roleId<>0
				WHERE   includeAll=1
				UNION
				SELECT entityType1,0 as roleId, permissionId FROM
				UMSecurityAssociations	 SA
				JOIN #userOrGroup temp ON SA.isUser=temp.isUser and   SA.userOrGroupId=temp.userOrGroupId  WHERE   includeAll=1  and permissionId<>0)  as tbl
		INSERT INTO #tempFilterUSA
		SELECT DISTINCT entityType1,entityId1,roleId,0 FROM UMSecurityAssociations SA JOIN UMRoles ON roleId=id and disabled=0 JOIN #userOrGroup  t on SA.isUser=t.isUser and SA.userOrGroupId=t.userOrGroupId WHERE   includeAll=0and    ([entityType2]=(0) AND [entityType3]=(0) AND [entityType4]=(0) AND [entityType5]=(0) )
		UNION
		SELECT DISTINCT entityType1,entityId1,0,permissionId FROM UMSecurityAssociations SA   JOIN #userOrGroup  t on SA.isUser=t.isUser and SA.userOrGroupId=t.userOrGroupId WHERE   permissionId<>0 and includeAll=0 and    ([entityType2]=(0) AND [entityType3]=(0) AND [entityType4]=(0) AND [entityType5]=(0) )
		UNION
		SELECT Owner.entityType,Owner.entityId,roleId,permissionId
		FROM UMOwners Owner
		JOIN #userOrGroup input ON Owner.isUser=input.isUser and  input.userOrGroupId=Owner.userOrGroupId
		JOIN UMOwnerRoles OwnerRoles
		ON (Owner.entityType=OwnerRoles.entityType and Owner.entityId=OwnerRoles.entityId)
WHERE Owner.entityType<>3
		UNION
		SELECT Owner.entityType,Owner.entityId,roleId,permissionId
		FROM UMOwners Owner
		JOIN #userOrGroup input ON Owner.isUser=input.isUser and  input.userOrGroupId=Owner.userOrGroupId
		JOIN UMOwnerRoles OwnerRoles
ON (OwnerRoles.entityType=1 and OwnerRoles.entityId=2)
WHERE Owner.entityType<>3
		UNION
SELECT 3,clientId,roleId,permissionId
		FROM @tempFilterOwnerTable
		-- Put these expanded list (~6000 rows) in a separate table (parentChildEntities). Not to mix with original table (tempFilterUSA) (~27 rows). Original table can be joined with roles expanded and delete op
		-- be preformed on it. More rows cause delay there. Moreover, whatever filtering done on original table, can be done on the expanded list before merging it to the original table.
		BEGIN
			IF OBJECT_ID ('tempdb.dbo.#parentChildEntities') IS NOT NULL
				DROP TABLE #parentChildEntities
			CREATE TABLE #parentChildEntities
			(
				entityTYpe INT,
				entityId INT,
				roleId INT,
				permissionId INT
			)
			CREATE CLUSTERED INDEX parentChildEntities_Idx1 ON #parentChildEntities(roleId);;
			CREATE NONCLUSTERED INDEX parentChildEntities_Idx2 ON #parentChildEntities (permissionId);;
			-- Expand direct associations -> child entities in one call with a UNION. This avoids redundant data that may come up from company->clients, client group->clients,etc.
			-- If user has rights on company, get those entities with roleId as USA's role Id (whatever this user has on the company).
			INSERT INTO #parentChildEntities (entityTYpe, entityId, roleId, permissionID)
				SELECT Sec.entityType1, Sec.entityId1, USA.roleId, USA.permissionId
				FROM UMSecurityAssociations Sec (NOLOCK)
					INNER JOIN #tempFilterUSA USA
						ON Sec.companyId = USA.entityId
						AND Sec.isCreator = 1
				WHERE
USA.entityType = 61
					AND Sec.entityType2 = 0			-- We are just interested till clients. Company will be a parent of clients only. Subclient policies are not in cache table anyways.
													-- Bug fix: User with rights on company's subclient policies is seeing CS client as well.
AND Sec.entityType1 IN (1,28,3,11,9,17,130,21,
57,9501,9502,9503,9504,9505,9506,9507,
35,83,90,
15,62,61,53,124,153)
											-- only these entities are part of UserCredentials table. Instead of Delete at last, filter them here itself.
				UNION
				SELECT Sec.entityType, Sec.entityId, USA.roleId, USA.permissionId
				FROM UMOwners Sec (NOLOCK)
					INNER JOIN #tempFilterUSA USA
						ON Sec.companyId = USA.entityId
				WHERE
USA.entityType = 61
				UNION			-- special handling for company SCG and client
SELECT 28, CP.attrValInt, USA.roleId, USA.permissionID
				FROM APP_CompanyProp CP (NOLOCK)
					INNER JOIN #tempFilterUSA USA
						ON CP.componentNameId = USA.entityId
				WHERE
USA.entityTYpe = 61
AND CP.attrName = 'Associated Smart Client Group' AND CP.cs_attrName = checksum('Associated Smart Client Group')
				UNION
SELECT 3, CP.componentNameId, USA.roleId, USA.permissionID
				FROM APP_ClientProp CP (NOLOCK)
					INNER JOIN #tempFilterUSA USA
						ON CP.attrVal = USA.entityId
				WHERE
USA.entityTYpe = 61
AND CP.attrName = 'Installation Company ID'
				UNION
SELECT 3, clientId, roleId, permissionId
				FROM #tempFilterUSA SA
					INNER JOIN APP_ClientGroupAssoc (NOLOCK)
ON entityType = 28 AND clientGroupId = entityId
				UNION
				SELECT 11, MAList.clientId, roleId, permissionId						-- MEDIAAGENT_ENTITY
				FROM #tempFilterUSA SA
						INNER JOIN APP_ClientGroupAssoc CGA (NOLOCK)
							ON entityType = 28 AND clientGroupId = entityId 			-- CLIENT_GROUP_ENTITY
						INNER JOIN MMHost MAList (NOLOCK)
							ON CGA.clientID = MAList.clientID
				WHERE
					MAList.clientId NOT IN (SELECT PMClientID FROM App_VMToPMMap (NOLOCK) WHERE VMclientId = 2)
				UNION
SELECT CASE WHEN P.attrName = 'Storage policy' OR P.attrName = 'Log storage policy' THEN 17
WHEN P.attrName = 'Schedule policy' OR P.attrName = 'Log schedule policy' OR P.attrName = 'Replication schedule policy' THEN 35
						END,
						P.attrVal,
						roleId,
						permissionId
				FROM #tempFilterUSA T
					INNER JOIN APP_PlanProp P (NOLOCK)
						ON T.entityId = P.componentNameId
				WHERE
T.entityType = 158
					AND (P.attrName = 'Storage policy' OR P.attrName = 'Log storage policy'
						OR P.attrName = 'Schedule policy' OR P.attrName = 'Log schedule policy' OR P.attrName = 'Replication schedule policy'
						)
				UNION
SELECT 35, taskId, roleId, permissionId
            	FROM #tempFilterUSA T
                	INNER JOIN App_PlanProp P (NOLOCK)
                    	ON T.entityId = P.componentNameId
                    	AND P.attrName = 'Storage policy'
                	INNER JOIN TM_AssocEntity TMAE (NOLOCK)
	                    ON CAST(P.attrVal AS INT) = TMAE.policyId AND TMAE.taskId <> 0
    	        WHERE
T.entityType = 158
		END
	-- VSA subclient expansion
	-- Now we have till client level. Expand the "hypervisor VSA clients" to the VM clients as well.
	INSERT #tempFilterUSA (entityType, entityId, roleId, permissionId)
SELECT 3, CP.componentNameId, OT.roleId, OT.permissionId
		FROM #tempFilterUSA OT			-- this will take care if user got rights on VSA client from client group, company or directly on client.
			INNER JOIN APP_Application A (NOLOCK)
				ON OT.entityId = A.clientID
			INNER JOIN APP_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
				AND CAST(CP.attrVal AS INT) = A.id
				AND CP.modified = 0
		WHERE
OT.entityType = 3
AND A.appTypeId = 106
		UNION				-- if user has rights on VSA subclient (or backupset, instace directly) it is not present in temp table yet. So explicitly honoring that.
SELECT 3, CP.componentNameId, OT.roleId, OT.permissionId
		FROM UMSecurityAssociations OT  (NOLOCK)
			INNER JOIN #userOrGroup UG
				ON OT.isUser = UG.isUser AND OT.userOrGroupId = UG.userOrGroupId
			INNER JOIN APP_Application A (NOLOCK)
				ON OT.entityId1 = A.clientID
					AND (OT.entityId2 = 0 OR OT.entityID2 = A.appTypeId)
					AND (OT.entityId3 = 0 OR OT.entityId3 = A.instance)
					AND (OT.entityId4 = 0 OR OT.entityId4 = A.backupSet)
					AND (OT.entityId5 = 0 OR OT.entityId5 = A.id)
			INNER JOIN APP_ClientProp CP (NOLOCK)
ON CP.attrName = 'Last Backup Subclient'
				AND CAST(CP.attrVal AS INT) = A.id
				AND CP.modified = 0
		WHERE
OT.entityType1 = 3
AND A.appTypeId = 106
		UNION
SELECT 3, CP.componentNameId, OT.roleId, OT.permissionId
		FROM #parentChildEntities OT			-- if user had rights on parent VSA client's client group, then it's expanded clients are in this parent child table only. so join on this is also needed.
			INNER JOIN APP_Application A (NOLOCK)
				ON OT.entityId = A.clientID
			INNER JOIN APP_ClientProp CP (NOLOCK)
				ON CP.attrName = 'Last Backup Subclient'
				AND CAST(CP.attrVal AS INT) = A.id
				AND CP.modified = 0
		WHERE
OT.entityType = 3
AND A.appTypeId = 106
	INSERT #tempFilterUSA ( entityType,entityId,permissionId)
	SELECT entityType,entityId,RPE.permissionId FROM  #tempFilterUSA TempTbl
			 JOIN UMRolesWithPermissionsExpanded RPE ON RPE.roleId=TempTbl.roleId and TempTbl.permissionId=0
JOIN UMPermissions  P ON RPE.permissionId=P.id and P.flags&1=0
	DELETE FROM #tempFilterUSA where roleId<>0
	--Check if there is any new mapped permission at commcell level than set it at particular entity type.
	DECLARE @mappedPermissionOnComcell TABLE ( entityType INTEGER,permissionId INTEGER)
	INSERT INTO @mappedPermissionOnComcell
	SELECT Map.entityType,filter.permissionId
	FROM #tempFilterUSA filter JOIN UMPermissionEntityTypeMap Map
	on filter.permissionId=Map.permissionId and filter.entityType=1 and entityId=2 AND Map.entityTYpe <> 0			--we dont need to get entity type 0 permissions that are mapped to all entities
	IF EXISTS(select * from @mappedPermissionOnComcell)
	BEGIN
		INSERT INTO #tempFilterUSA
SELECT entityType,-10,0,permissionId
		FROM @mappedPermissionOnComcell
		where entityType<>1 --Commcell
		--This delete cannot be combined with the delete written in #260. Because we should not map commcell mapped permissions to commcell entity.
		--Permissions like Install Client (mapped to Commcell entity) should be set on entityId6 = -10 and not on commcellId = 2. This delete will take care of that.
		DELETE tbl
		FROM #tempFilterUSA tbl
		where entityType=1 and entityID=2 and permissionId in (SELECT permissionId from @mappedPermissionOnComcell)
		and permissionId not in (SELECT permissionId FROM UMPermissionEntityTypeMap WHERE entityTYpe = 0)	--there are some permissions like "Job Management" that is mapped to 0 and WF entity types. So if they are present on commcell, they should be applicable on both commcell and WF(-10).
	END
	--do not set permission mapped to other entities
	--fix for MR: 157053
	delete temp
	from UMPermissionEntityTypeMap PE right outer join #tempFilterUSA temp
	on temp.permissionId = PE.permissionID and (PE.entityType = 0 or temp.entityType = Pe.entityType)
	where PE.permissionId is null
or PE.entityType = 3	-- We need not put mapped permission in Cache table for iDA entities.
													-- Because if there is a permission mapped only to app type, and if we assign it on app type, then it will show subclient also.
													-- It is not correct according to Amey. We should show only app type not subclient. So better way is to not assign this permission at all.
	DELETE FROM #tempFilterUSA WHERE entityId=0
	--either have table to look up entityType(UMObjectTypeToEntityTypeMap), or keep updating list, as we know rest of them
	DELETE #tempFilterUSA
where entityType not in (1,28,3,11,9,17,130, 21,
57,9501,9502,9503,9504,9505,9506,9507,
35,83,90,
15,62,61,53,124,153	)
	BEGIN
		-- Now merge from parent child entities into this original table.
		-- We need to do some filtering before inserting --> 1. Convert roles to permissions. 2. Filter out non mapped permissions. 3. Entity type filtering already done. 4. Entity Id filtering not needed as they will all > 0.
		-- These are the 4 filters done on original table. We just need to do the applicable ones on the parent child table as well.
		INSERT INTO #tempFilterUSA
			SELECT PC.entityTYpe, PC.entityId, 0, RPE.permissionId
			FROM #parentChildEntities PC
				INNER JOIN UMRolesWithPermissionsExpanded RPE (NOLOCK)
					ON PC.roleId = RPE.roleID
				INNER JOIN UMPermissionEntityTypeMap UPE(NOLOCK)
					ON RPE.permissionId = UPE.permissionID AND UPE.entityType IN (0, PC.entityTYpe) AND UPE.entityType <> 3
			WHERE
				PC.permissionId = 0
			UNION
			SELECT PC.entityTYpe, PC.entityId, 0, PC.permissionID
			FROM #parentChildEntities PC
				INNER JOIN UMPermissionEntityTYpeMap UPE (NOLOCK)
					ON PC.permissionId = UPE.permissionID AND UPE.entityType IN (0, PC.entityTYpe) AND UPE.entityType <> 3
			WHERE
				PC.roleID = 0
	END
    INSERT INTO #tempUMUserCredentials
    SELECT Tbl.capabilities,0 ,2,
CASE WHEN (entityType=28 ) THEN entityId ELSE 0 END,
CASE WHEN (entityType=3) THEN entityId ELSE 0 END,
        0,0,0,0,
CASE WHEN (entityType=11 ) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9 ) THEN entityId ELSE 0 END,
CASE WHEN (entityType=17) THEN entityId ELSE 0 END,
CASE WHEN (entityType=130) THEN entityId ELSE 0 END,
CASE WHEN (entityType=21  ) THEN entityId ELSE 0 END,
CASE WHEN (entityType=57) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9501) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9502) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9503) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9504) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9505) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9506) THEN entityId ELSE 0 END,
CASE WHEN (entityType=9507) THEN entityId ELSE 0 END,
        0, --complianceReportId                                                      Not supported in 11.0 as per Arun
CASE WHEN (entityType=35  ) THEN entityId ELSE 0 END, --taskId
CASE WHEN (entityType=83 ) THEN entityId ELSE 0 END, --workflowId
CASE WHEN (entityType=90  ) THEN entityId ELSE 0 END, --logMonitoringPolicyId
CASE WHEN (entityType=153 )THEN entityId ELSE 0 END, --arrayId
        0,--CASE WHEN (entityType=28) THEN entityId ELSE 0 END, cloudId
CASE WHEN (entityType=15 OR entityType=62  ) THEN entityId ELSE 0 END, --userGroupId,externalGroupId
CASE WHEN (entityType=61 ) THEN entityId ELSE 0 END, --umdsporvider
CASE WHEN (entityType=53 ) THEN entityId ELSE 0 END, --entityId1  --location entity
        0,-- CASE WHEN (entityType=28) THEN entityId ELSE 0 END, entityId2
CASE WHEN (entityType= 124  ) THEN entityId ELSE 0 END, --entityId3
        0,--CASE WHEN (entityType=28) THEN entityId ELSE 0 END,
        0,--CASE WHEN (entityType=28) THEN entityId ELSE 0 END,
CASE WHEN (entityType=1 AND  entityId =-10) THEN 2
WHEN (entityType=1 AND  entityId <>2)  THEN entityId
			ELSE 0
		END,
        0,--CASE WHEN (entityType=28) THEN entityId ELSE 0 END,
        0,--CASE WHEN (entityType=28) THEN entityId ELSE 0 END,
        0,--CASE WHEN (entityType=28) THEN entityId ELSE 0
		permissionBitArray ,
		extendedPermissionBitArray
		FROM
		(
			SELECT entityType,
					 entityId,
					 SUM(DISTINCT CASE
										WHEN (permissionId<=64) THEN POWER(2.0,permissionId-1)
										ELSE
CASE WHEN entityType = 83 THEN 0
												 ELSE POWER(2.0,31-1)
											END
								  END) AS capabilities,
					 0 as permissionBitArray,			-- this column is not yet used. So set to 0 for now. the CLR is taking so much time.
					 --dbo.sec_setBitMask(DISTINCT CASE WHEN permissionId>100000 THEN 0 ELSE permissionId END) as permissionBitArray,
					 --dbo.sec_setBitMask(DISTINCT CASE WHEN permissionId>100000 THEN permissionId-100000 ELSE 0 END)
					 0 as extendedPermissionBitArray
			 FROM #tempFilterUSA			-- JOIN with permissions is already done. No need to repeat again.
			 GROUP BY entityType, entityId
		 )
		 AS TBL
	--Now  IDA entityType
		INSERT INTO #tempUMUserCredentials ( capabilities,clientId,appTypeId,instanceId,backupsetId,subClientId,permissionBitArray ,extendedPermissionBitArray)
SELECT  SUM(DISTINCT CASE WHEN (permissionId<=64) THEN POWER(2.0,permissionId-1) ELSE POWER(2.0,31-1) END) ,entityId1,entityId2,entityId3,entityId4,entityId5,
					dbo.sec_setBitMask(DISTINCT CASE WHEN permissionId>100000 THEN 0 ELSE permissionId END) as permissionBitArray,
					--dbo.sec_setBitMask(DISTINCT CASE WHEN permissionId>100000 THEN permissionId-100000 ELSE 0 END)
					0 as extendedPermissionBitArray
		FROM
		(
		SELECT R.permissionId,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5
		FROM UMSecurityAssociations SA
			JOIN #userOrGroup t on SA.isUser=t.isUser and SA.userOrGroupId=t.userOrGroupId  and entityType2<>0 and entityId2<>1030 /* CV_APPTYPE_SUBCLIENT_POLICY */
			JOIN UMRolesWithPermissionsExpanded R on R.roleId=SA.roleId JOIN UMRoles ON R.roleId=id and disabled=0 and SA.roleId<>0
JOIN UMPermissions  P ON R.permissionId=P.id and P.flags&1=0
			 INNER JOIN UMPermissionEntityTypeMap UPE
				ON UPE.entityType = 0 AND R.permissionId = UPE.permissionId				-- We need not put mapped permission in Cache table for iDA entities.
																							-- Because if there is a permission mapped only to app type, and if we assign it on app type, then it will show subclient also.
																							-- It is not correct according to Amey. We should show only app type not subclient. So better way is to not assign this permission at all.
		UNION
		SELECT SA.permissionId,entityType1,entityId1,entityType2,entityId2,entityType3,entityId3,entityType4,entityId4,entityType5,entityId5
FROM UMSecurityAssociations SA JOIN UMPermissions  P ON SA.permissionId=P.id and P.flags&1=0
			JOIN #userOrGroup t on SA.isUser=t.isUser and SA.userOrGroupId=t.userOrGroupId  and entityType2<>0 and entityId2<>1030 /* CV_APPTYPE_SUBCLIENT_POLICY */ and SA.permissionId<>0
			INNER JOIN UMPermissionEntityTypeMap UPE
				ON UPE.entityType = 0 AND SA.permissionId = UPE.permissionId
		) as TBL
		group by entityId1,entityId2,entityId3,entityId4,entityId5
	END
	-- Now all include all and client group expansion has been taken care of. expand roles for other rows.
	--Special handling as per sec_updateUserCredentials.spb
		UPDATE #tempUMUserCredentials
		SET commCellId=0
		where workflowId<>0
PROC_EXIT:
    DECLARE @companyIdOfUser INT = 0
    SET @companyIdOfUser = dbo.AppGetCompanyForUserOrUserGroup(@i_userId, 1)
IF OBJECT_ID('tempdb.dbo.#validCompaniesOfCompanyUser') IS NOT NULL
    DROP TABLE #validCompaniesOfCompanyUser
CREATE TABLE #validCompaniesOfCompanyUser
    (
        companyId INT NOT NULL
        primary key (companyId)
    )
DECLARE @doNotUseCompanyEntitiesTableForFiltering INTEGER  = 0
SET @doNotUseCompanyEntitiesTableForFiltering =  ISNULL((SELECT value FROM GXGlobalParam WHERE name = N'DoNotUseCompanyEntitiesTableForFiltering' AND modified = 0), 0)
IF @doNotUseCompanyEntitiesTableForFiltering = 1
BEGIN
	SET @companyIdOfUser = 0
END
IF @companyIdOfUser <> 0
BEGIN
    declare @parentCompanyId int = @companyIdOfUser
        ;with parentCompany as
        (
            select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            union all
            select P.id as childCompanyId from UMDSProviders P inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select childCompanyId
        from parentCompany
    declare @childCompanyId int = @companyIdOfUser
        ;with childCompany as
        (
            select ownerCompany as parentCompanyId from UMDSproviders WITH(NOLOCK) where id = @childCompanyId and serviceType = 5 and ownerCompany != 0
            union all
            select P.ownerCompany as parentCompanyId from UMDSProviders P inner join childCompany P1 on P.id = P1.parentCompanyId and P.serviceType = 5 and  P.ownerCompany != 0
        )
        INSERT INTO #validCompaniesOfCompanyUser(companyId)
        select parentCompanyId
        from childCompany
    INSERT INTO #validCompaniesOfCompanyUser values (@companyIdOfUser) , (0)   -- Company Id 0 For MSP entities
END
	DECLARE @outputStmt nvarchar(MAX) = 'INSERT INTO '+@outputTableArg
	IF @companyIdOfUser <> 0
	BEGIN
		DECLARE @defaultVMInstanceId INT=0
 		SET @defaultVMInstanceId = ISNULL((SELECT top 1 componentNameId
				  FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 and attrVal = '1'), 0)
		SET @outputStmt += ' SELECT UM.* FROM #tempUMUserCredentials UM' +
							' LEFT JOIN App_CompanyEntities App ' +
' On (App.entityId = UM.clientGroupId AND App.entityType = 28) ' +
' OR (App.entityId = UM.clientId AND App.entityType = 3) ' +
' OR (App.entityId = UM.instanceId AND App.entityType = 5 AND UM.instanceId <> 1 AND UM.instanceId <> ' +CAST (@defaultVMInstanceId AS VARCHAR(10)) +' ) '+
' OR (App.entityId = UM.backupsetId AND App.entityType = 6) ' +
' OR (App.entityId = UM.subClientId AND App.entityType = 7) ' +
' OR (App.entityId = UM.mediaAgentId AND App.entityType = 11) ' +
' OR (App.entityId = UM.libraryId AND App.entityType = 9) ' +
' OR (App.entityId = UM.archGroupId AND App.entityType = 17) ' +
' OR (App.entityId = UM.taskId AND App.entityType = 35) ' +
' OR (App.entityId = UM.workflowId AND App.entityType = 83) ' +
' OR (App.entityId = UM.arrayId  AND App.entityType = 153) ' +
' OR (App.entityId = UM.userGroupId  AND App.entityType = 15) ' +
' OR (App.entityId = UM.providerId  AND App.entityType = 61) ' +
							' LEFT JOIN #validCompaniesOfCompanyUser C ' +
								' ON C.companyId = App.companyId ' +
							' WHERE App.entityId is NULL OR C.companyId = App.companyId '
	END
	ELSE
	BEGIN
		SET @outputStmt += ' SELECT * FROM #tempUMUserCredentials'
	END
	EXEC (@outputStmt)
	IF OBJECT_ID('tempdb.dbo.#tempUMUserCredentials') is not null DROP TABLE #tempUMUserCredentials
	IF OBJECT_ID('tempdb.dbo.#userOrGroup') is not null drop table #userOrGroup
	IF OBJECT_ID ('tempdb.dbo.#tempFilterUSA') is not null DROP TABLE #tempFilterUSA
END  TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF OBJECT_ID('tempdb.dbo.#tempUMUserCredentials') is not null DROP TABLE #tempUMUserCredentials
	IF OBJECT_ID('tempdb.dbo.#userOrGroup') is not null drop table #userOrGroup
	IF OBJECT_ID ('tempdb.dbo.#tempFilterUSA') is not null DROP TABLE #tempFilterUSA
	-- re-throw the error so that caller does not try to commit a transaction now
	DECLARE @sev INT = ERROR_SEVERITY()
	DECLARE @state INT = ERROR_STATE()
	RAISERROR ('Exception Trapped in sec_populateCache SP', @sev, @state)
END CATCH
GO

IF EXISTS (select * from GxQscripts where name = 'sec_populateCache')
	delete from GxQscripts where name = 'sec_populateCache'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_populateCache')
	delete from GXDBVersions where aliasname = 'sec_populateCache'
GO

insert into GXDBVersions values(2, 'sec_populateCache',  'v1.11.2.37.12.2', 'sec_populateCache', 'v1.11.2.37.12.2')
GO

