

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_performUserOperation.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "sec_performUserOperation"
--	|	This Procedure is used to modify/add/delete users
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_performUserOperation')
BEGIN
	print '>>> Drop Stored Procedure: sec_performUserOperation <<<'
	drop procedure sec_performUserOperation
END
IF EXISTS (select * from GxQscripts where name='sec_performUserOperation')
	delete from GxQscripts where name = 'sec_performUserOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_performUserOperation')
	delete from GXDBVersions where aliasname = 'sec_performUserOperation'
GO
print '... Creating Procedure: sec_performUserOperation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_performUserOperation
  @autherUserId INT=0,
  @origCCId INT=0,
  @xmlText XML OUTPUT,
  @operationType INT=1,
  @createdefaultUserGroup INT=0,
  @createdefaultClientGroup INT=0,
  @isCmdLine INT=0,
  @hashPassword nvarchar(MAX)=N'',
  @userSalt nvarchar(MAX)=N'',
  @isRequestForReplication INT=0,
  @isReturnCursor INT = 1
AS
  DECLARE @outputXML XML
DECLARE @responseTable Table(errorCode int,
								errorMessage nvarchar(max),
								userId int,
								userName nvarchar(255),
								userGuid nvarchar(256),
								warningMessage nvarchar(MAX))
--DECLARE @autherUserId INT
DECLARE @name nvarchar(255)
DECLARE @description nvarchar(max)
DECLARE  @login nvarchar(255)
DECLARE  @password nvarchar(400)
DECLARE  @email nvarchar(255)
DECLARE  @datePasswordSet int
DECLARE  @dateExpires int
DECLARE  @policy int
DECLARE  @enabled int
DECLARE  @flags int
DECLARE  @modified int
DECLARE  @pVer int
DECLARE  @Pager varchar(255)
DECLARE  @lastLogInTime int
DECLARE  @credSetTime int
DECLARE  @umDSproviderId int=0
DECLARE  @serviceType int = 1
DECLARE  @userGuid nvarchar(256)
DECLARE  @origUserGuid nvarchar(256)
DECLARE  @companyName nvarchar(max)
DECLARE  @inheritGroupQuotaSettings int
DECLARE @enforceFSQuota int
DECLARE @quotaLimitInGB int
DECLARE @inheritGroupEdgeDriveQuotaSettings int
DECLARE @enforceEdgeDriveQuota int
DECLARE @edgeDriveQuotaLimitInGB int
DECLARE @nowTime integer
SET @nowTime =  dbo.GetUnixTime (GetUTCdate())
--DECLARE  @origCCId int
DECLARE @o_errorCode INT
DECLARE @o_errorString nvarchar(max)
DECLARE @o_warningCode INT
DECLARE @o_warningMessage nvarchar(max)
SET @o_errorCode = 0
SET @o_errorString = ''
SET @o_warningCode = 0
SET @o_warningMessage = ''
DECLARE @userId int
DECLARE @newOwnerName nvarchar(255)
SET @userId = '-1'
DECLARE @validateLogin int = 0
DECLARE @sec_assOptype INTEGER
DECLARE @errorTable TABLE (errorCode INT, errorString NVARCHAR(MAX))
DECLARE @xml1 XML
DECLARE @localeId INT
DECLARE @masterGroupId INT
DECLARE @existingUserId int
DECLARE @planId int
DECLARE @planOpType int
DECLARE @removeOtherActiveSessions INT=1
DECLARE @currentSessionId nvarchar(max)
DECLARE  @passwordOperationType int =2 --CHANGE_PWD
DECLARE @UMSessionFlag int =5
DECLARE @enforceQuotaChanged INT = 0
DECLARE @newEnforceFSQuotaValue INT = 0
DECLARE @enforcePasswordChangeOnFirstLogin INT = 0
DECLARE @noOfPasswordsToRemember int = 0
DECLARE @recomputeQuota INT = 0
DECLARE @createUser bit = 1
DECLARE  @newName nvarchar(255)
DECLARE @OrganizationDomainName NVARCHAR(255)
DECLARE @apiQuotaLimit INT
DECLARE @apiQuotaTimeFrame INT
DECLARE @forCompany int = 0
DECLARE @isServiceCommcell INT = ISNULL((SELECT 1 FROM APP_commcellPRop where commcellId=2 and commcellType & 8<>0),0)
DECLARE @tenantgroupFlags INT = 0x10000
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @inputUserGroupsTbl TABLE (userGroupId INT, userGroupName NVARCHAR(MAX))
	DECLARE @addedUserGroupsTbl TABLE (userGroupId INT)
	DECLARE @deletedUserGroupsTbl TABLE (userGroupId INT)
	DECLARE @associatedExternalUserGroupsTable TABLE (externalUserGroupId INT, externalUserGroupName NVARCHAR(255), providerDomainName NVARCHAR(255), providerDomainId INT)
	--------------------Get baisc input options---------------------------------------
	--Set any default values later, when needed as per operation.
	SET  @userId = @xmlText.value('(//App_UserInfo/userEntity/@userId)[1]', 'INT')
	SET  @name = RTRIM(LTRIM(@xmlText.value('(//App_UserInfo/@fullName)[1]', 'nvarchar(255)')))
	SET  @description = @xmlText.value('(//App_UserInfo/@description)[1]', 'nvarchar(max)')
	SET  @login = RTRIM(LTRIM(@xmlText.value('(//App_UserInfo/userEntity/@userName)[1]', 'nvarchar(255)')))--MODIFIED
	SET @newName = RTRIM(LTRIM(@xmlText.value('(//App_UserInfo/userEntity/@newName)[1]', 'nvarchar(255)')))
	SET  @email = @xmlText.value('(//App_UserInfo/@email)[1]', 'nvarchar(255)')
	SET  @datePasswordSet = @nowTime
	SET  @dateExpires = 0
	SET  @policy = @xmlText.value('(//App_UserInfo/@agePasswordDays)[1]', 'int') --check this - age password
	SET  @enabled = @xmlText.value('(//App_UserInfo/@enableUser)[1]', 'int')
	SET  @flags = 1
	SET  @modified = 0
	SET  @pVer = 50
	SET  @Pager = @xmlText.value('(//App_UserInfo/@pagerAddress)[1]','varchar(255)')
	SET  @credSetTime = 0
	SET  @origUserGuid = ''
	IF 1=  @xmlText.exist('//App_UserInfo/validationParameters/@email')
		set @validateLogin = 1
	SET @companyName = @xmlText.value('(//App_UserInfo/@companyName)[1]', 'nvarchar(max)')
	SET @inheritGroupQuotaSettings=@xmlText.value('(//App_UserInfo/@inheritGroupQuotaSettings)[1]', 'int')
	SET @enforceFSQuota=@xmlText.value('(//App_UserInfo/@enforceFSQuota)[1]', 'int')
	SET @quotaLimitInGB=@xmlText.value('(//App_UserInfo/@quotaLimitInGB)[1]', 'int')
	SET @inheritGroupEdgeDriveQuotaSettings=@xmlText.value('(//App_UserInfo/@inheritGroupEdgeDriveQuotaSettings)[1]', 'int')
	SET @enforceEdgeDriveQuota=@xmlText.value('(//App_UserInfo/@enforceEdgeDriveQuota)[1]', 'int')
	SET @edgeDriveQuotaLimitInGB=@xmlText.value('(//App_UserInfo/@edgeDriveQuotaLimitInGB)[1]', 'int')
	SET @enforcePasswordChangeOnFirstLogin = ISNULL(@xmlText.value('(//App_UserInfo/@enforcePasswordChange)[1]', 'int'), 0)
	SET @localeId = isnull(@xmlText.value('(//App_UserInfo/processinginstructioninfo/locale/@localeId)[1]', 'int') , 0)
SET @masterGroupId = (SELECT id FROM umgroups WHERE groupFlags&0x0008=0x0008)
	SET @planId = @xmlText.value('(//App_UserInfo/plan/@planId)[1]', 'int')
    SET @planOpType = @xmlText.value('(//App_UserInfo/@planOperationType)[1]', 'INT')
	SET @removeOtherActiveSessions =ISNULL( @xmlText.value('(//App_UserInfo/@removeOtherActiveSessions)[1]', 'int'),1)
	SET @currentSessionId =  @xmlText.value('(//App_UserInfo/@currentSessionId)[1]', 'nvarchar(max)')
	SET @passwordOperationType = ISNULL( @xmlText.value('(//App_UserInfo/validationParameters/@passwordOperationType)[1]', 'int'),2)--CHANGE_PWD
	DECLARE @isOrganizationUser INT
	SET @isOrganizationUser = 0
	DECLARE @isRadiusUser INT
	SET @isRadiusUser = 0
	SET @forCompany =@xmlText.value('(//App_UserInfo/company/@providerId)[1]', 'int')
	DECLARE @isSystemGeneratedPassword int = ISNULL( @xmlText.value('(//App_UserInfo/@systemGeneratePassword)[1]', 'int'),0)
	SET @apiQuotaLimit = @xmlText.value('(//App_UserInfo/apiQuota/@APILimit)[1]', 'int')
	SET @apiQuotaTimeFrame = @xmlText.value('(//App_UserInfo/apiQuota/@APItimeFrame)[1]', 'int')
	DECLARE @externalAndLocalGroupsSingleList INT
	SET @externalAndLocalGroupsSingleList = 0
	DECLARE @systemGeneratedLoginName INT = 0;
	--DELETE AND MODIFY
	IF @operationType = 2 or @operationType = 3
	BEGIN
	IF @userId <= 0 OR @userId is NULL AND @login != '' AND @login is not NULL
		SET @userId = ISNULL((SELECT ID FROM UMUSERS WHERE LOGIN = @LOGIN),0)
	ELSE -- Check if userId exists
		BEGIN
			IF NOT EXISTS (SELECT id FROM UMUsers where id = @userId)
				BEGIN
SET @o_errorCode = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3290 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					GOTO EXIT_ERROR
				END
		END
	--check if login is not set. This can happen when password from webconsole or admin where only userid is given
	IF( @userId IS NOT NULL AND @userId > 0 AND @login is NULL)
		SET @login= (SELECT login FROM UMUSERS WHERE id = @userId)
	END
	IF @operationType = 3
	BEGIN
		IF(@newName is not null)--For backward compatibility set the new name to login. Admin Console and Command line will use newName to give new name of the user.
		BEGIN
		DECLARE @tempCompanyDomainName nvarchar(255)
SELECT @tempCompanyDomainName=domainName FROM UMDSProviders umds INNER JOIN  umusers u ON u.umDSproviderId= umds.id WHERE u.id = @userId AND  umds.serviceType in (5,12)
			IF(CHARINDEX('\',@newName, 1) = 0)
			BEGIN
				--Verify that new login name is missing a domain name then add one
				IF(@tempCompanyDomainName IS NOT NULL)
				BEGIN
					SET @newName = @tempCompanyDomainName + '\' + @newName
				END
			END
			ELSE IF(CHARINDEX('\',@newName, 1) > 0)
			BEGIN
				IF( SUBSTRING(@newName, 0, CHARINDEX('\', @newName, 1)) <> @tempCompanyDomainName)
				BEGIN
SET @o_errorCode = (1779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s', @newName)
					GOTO EXIT_ERROR
				END
			END
			SET @login=@newName
		END
		--If there is another user with same name  then fail.
			IF(EXISTS(SELECT Id FROM UMUsers WHERE login = @login AND id <> @userId))
			BEGIN
SET @o_errorCode = (1061 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1061 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@login)
				GOTO EXIT_ERROR
			END
	END
	--In admin console when creating a user userName is optional field. So create user request might not have the login name and have email. In that case get the login name from email username
	--For organization user the login name will be orgDomain\emailUserName
	--if it turns out to be local user, login name will be emailUserName.local
	IF @operationType = 1 and (@login is NULL OR @login = '')
	BEGIN
		SET @systemGeneratedLoginName=1
		SET @login = REPLACE(SUBSTRING(@email,1,CHARINDEX('@',@email)),'@','')
	END
	--creating a user for a company
	IF (@operationType = 1 AND @forCompany > 0)
	BEGIN
		SET @OrganizationDomainName = (SELECT top 1 domainName from UMDSProviders	WHERE ID = @forCompany and serviceType in (5,12))
		IF(@OrganizationDomainName IS NOT NULL OR @OrganizationDomainName<> '')
		BEGIN
			IF(CHARINDEX('\',@login, 1) = 0)
			BEGIN
				SET @login = @OrganizationDomainName + '\' + @login
			END
			ELSE IF( SUBSTRING(@login, 0, CHARINDEX('\', @login, 1)) <> @OrganizationDomainName)
			BEGIN --Verify the domain name is correct
SET @o_errorCode =  (1779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
            	SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
            	SET @o_errorString = REPLACE(@o_errorString, '^1%s', @login)
            	GOTO EXIT_ERROR
			END
        END
	END
	--For add user operation, if tenant admin is creating a user, the should be it's organization user. So make it org user here by prepending the domain name to login
	IF @operationType = 1 AND (CHARINDEX('\',@login, 1))  = 0
	BEGIN
		--check if caller user is a tenant admin
		DECLARE @tempUmDSproviderId INT = 0
		SELECT  @tempUmDSproviderId = dbo.AppGetOrganizationDomainForUser(@autherUserId)
		--if the caller user is tenant admin, we will have umdsproviderId here
		IF(@tempUmDSproviderId > 0)
		BEGIN
SET @OrganizationDomainName = (SELECT top 1 domainName from UMDSProviders	WHERE ID = @tempUmDSproviderId and serviceType in (5,12))
			IF(@OrganizationDomainName IS NOT NULL OR @OrganizationDomainName<> '')
                		SET @login = @OrganizationDomainName + '\' + @login
		END
	END
	IF @operationType = 1 OR @operationType=3
	BEGIN
		--local group
		INSERT INTO @inputUserGroupsTbl (userGroupId, userGroupName)
		SELECT T.c.value('(@userGroupId)[1]','INT'), T.c.value('(@userGroupName)[1]','NVARCHAR(MAX)')
		FROM @xmlText.nodes('//App_UserInfo/associatedUserGroups') T(c)
		DELETE FROM @inputUserGroupsTbl WHERE (userGroupId IS NULL) AND (userGroupname IS NULL)
		/*Sanity check*/
		IF EXISTS (SELECT 1
			FROM @inputUserGroupsTbl
			WHERE (userGroupId <= 0) OR (userGroupId IS NULL))
		BEGIN
		-- Set warning if user groups are not present in CS. MR:247041
		SET @o_warningCode = (2428 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_warningMessage = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_warningCode AND localeId = @localeId)
		SET @o_warningMessage = REPLACE(@o_warningMessage, '^1%s', STUFF((SELECT ', ' + userGroupName
															FROM @inputUserGroupsTbl
															WHERE (userGroupId <= 0) OR (userGroupId IS NULL) FOR XML PATH('')), 1, 2, ''))
		-- delete invalid userGroups from @inputUserGroupsTbl and proceed.
		DELETE FROM @inputUserGroupsTbl WHERE (userGroupId <= 0) OR (userGroupId IS NULL)
		END
		--cannot manually associate to a external AD group
		--for organization users, external groups can come either in userGroupName blob or externalGroupName blob - they can be handled separately
		--this table is only for local user groups
		IF EXISTS (SELECT 1
			FROM @inputUserGroupsTbl
			WHERE userGroupId IN (SELECT id FROM UMGroups WHERE umdsProviderID <> 0))
		BEGIN
			SET @externalAndLocalGroupsSingleList = 1
			DELETE FROM @inputUserGroupsTbl WHERE userGroupId IN (SELECT id FROM UMGroups WHERE umdsProviderId <> 0)
		END
		--external group
		INSERT INTO @associatedExternalUserGroupsTable (externalUserGroupId, externalUserGroupName, providerDomainName, providerDomainId)
		SELECT T.c.value('(@groupId)[1]', 'INT'), T.c.value('(@externalGroupName)[1]', 'NVARCHAR(255)'), T.c.value('(@providerDomainName)[1]', 'NVARCHAR(255)'), T.c.value('(@providerId)[1]', 'INT')
		FROM @xmlText.nodes('//App_UserInfo/associatedExternalUserGroups') T(c)
		IF @externalAndLocalGroupsSingleList = 1
		BEGIN
			INSERT INTO @associatedExternalUserGroupsTable (externalUserGroupId, externalUserGroupName, providerDomainName, providerDomainId)
			SELECT T.c.value('(@userGroupId)[1]', 'INT'), T.c.value('(@userGroupName)[1]', 'NVARCHAR(255)'), N'', 0
			FROM @xmlText.nodes('//App_UserInfo/associatedUserGroups') T(c)
				INNER JOIN UMGroups G
					ON T.c.value('(@userGroupId)[1]', 'INT') = G.id
			WHERE 			-- Depend on the id not name. Because many code send only user group id.
				G.umdsProviderId > 0
		END
		UPDATE @associatedExternalUserGroupsTable
		SET externalUserGroupName = SUBSTRING(externalUserGroupName, CHARINDEX('\', externalUserGroupName, 1)+1, LEN(externalUserGroupName))
		WHERE CHARINDEX('\', externalUserGroupName, 1) > 0
		--we need umdsProviderId information to check that we are adding users to the groups of this organization only
		UPDATE Tbl
		SET Tbl.externalUserGroupName = G.name, Tbl.providerDomainId = G.umdsProviderId
		FROM @associatedExternalUserGroupsTable Tbl INNER JOIN UMGroups G WITH (NOLOCK)
		ON Tbl.externalUserGroupId = G.id
		UPDATE Tbl
		SET Tbl.providerDomainName = P.domainName
		FROM @associatedExternalUserGroupsTable Tbl INNER JOIN UMDSProviders P
		ON Tbl.providerDomainId = P.id
		WHERE providerDomainName IS NULL OR  providerDomainName = ''
		/*Sanity checks*/
		IF EXISTS (SELECT 1 FROM @associatedExternalUserGroupsTable WHERE ((externalUserGroupId IS NULL) OR (externalUserGroupId <= 0)))
		BEGIN
			SET @o_errorCode = (2429 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
			SET @o_errorString = REPLACE (@o_errorString, '^1%s', ISNULL((SELECT TOP 1 providerDomainName + '\' + externalUserGroupName
																			FROM @associatedExternalUserGroupsTable
																			WHERE ((externalUserGroupId IS NULL) OR (externalUserGroupId <= 0))), N''))
			GOTO EXIT_ERROR
		END
		--If MSP admin is creating a user by selecting a user group that is organization user group then create organization user of that organization
		IF @operationType=1 AND CHARINDEX('\',@login, 1)  = 0
		BEGIN
			SELECT @OrganizationDomainName= domainName FROM @associatedExternalUserGroupsTable g
INNER JOIN UMDSProviders p WITH(NOLOCK) ON p.id =g.providerDomainId WHERE serviceType in (12 , 5)
			IF(@OrganizationDomainName IS NOT NULL OR @OrganizationDomainName<> '')
			BEGIN
				SET @login = @OrganizationDomainName + '\' + @login
			END
		END
	END
	IF(@systemGeneratedLoginName = 1 AND CHARINDEX('\',@login, 1)  = 0) --if it turns out to be local user, login name will be emailUserName.local
			SET @login = @login + '.local'
	--At this point login name is constructed from email, if login name was not given in the request.
	IF (@operationType=1 AND @login is NULL)
	BEGIN
SET @o_errorCode = (2543 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
			GOTO EXIT_ERROR
		END
	IF((CHARINDEX('\',@login, 1)) >0 )
	BEGIN
		DECLARE  @domain nvarchar(255)
		SET  @umdsProviderID = 	ISNULL((SELECT  umdsproviderId from UMUSers  WITH(NOLOCK)  where login = @login),0)
		IF(@umdsProviderID=0)
		BEGIN
			SET @umdsProviderID= ISNULL(@xmlText.value('(//App_UserInfo/provider/@providerId)[1]', 'INT'),0)
		END
		IF(@umdsProviderID=0)
		BEGIN
			SET  @domain = SUBSTRING(@login, 1, CHARINDEX('\', @login) - 1)
			SET  @umDSproviderId = 	(SELECT TOP 1 id from UMDSProviders  WITH(NOLOCK)  where domainName = @domain)
		END
		IF @umdsProviderID IS NULL OR @umdsProviderId <= 0
		BEGIN
SET @o_errorCode = (1779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s', @login)
			GOTO EXIT_ERROR
		END
IF (SELECT serviceType FROM UMDSProviders WHERE id = @umdsProviderId) = 5
			SET @isOrganizationUser = 1
IF (SELECT serviceType FROM UMDSProviders WHERE id = @umdsProviderId) = 7
			SET @isRadiusUser = 1
		SET @serviceType = (SELECT serviceType FROM UMDSProviders WHERE id = @umdsProviderId)
		-- If operationType is 1 (create): Do not allow creation if company is deactivated
		-- If operationType is 3 (modify): Do not allow user enable flag to be changed if company is deactivated
		-- If operationType is 2 (delete): Proceed as usual irrespective of whether the company is activated or not
		IF(@operationType <> 2)
		BEGIN
			DECLARE @companyId INT
			SET @companyId = (SELECT (CASE @serviceType
WHEN 5 THEN @umDSproviderId -- given umdsProviderId is the companyId
                                        ELSE -- fetch parent companyId from given umdsProviderId
                                            (SELECT distinct ownerCompany FROM UMDSProviders WITH (NOLOCK) WHERE id = @umDSproviderId)
                                        END))
IF EXISTS(SELECT 1 FROM UMDSProviders WITH (NOLOCK) WHERE ((flags & 0x0010) = 0x0010) AND
						id = @companyId)
			BEGIN
				IF (@operationType = 1)
				BEGIN
SET @o_errorCode = (3898 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
					GOTO EXIT_ERROR
				END
				ELSE IF (@operationType = 3 AND (@enabled = 1 AND EXISTS(SELECT 1 FROM App_CompanyProp WITH(NOLOCK) WHERE componentNameId = @companyId
AND attrName = 'Disable Login' AND attrVal = '1' AND cs_attrName=checksum('Disable Login') )))
				BEGIN
SET @o_errorCode = (3899 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
					GOTO EXIT_ERROR
				END
			END
		END
	END
	IF(@operationType=1)
	BEGIN
		IF(((CHARINDEX('\',@login, 1)) >0 ) AND (@isRadiusUser = 1))
		BEGIN
			SET  @password = N'2AZdUUxUUyUUz'
			SET  @lastLogInTime = 0
			SET  @userGuid = ISNULL(@xmlText.value('(//App_UserInfo/userEntity/@userGUID)[1]', 'nvarchar(255)'),cast(cast(hashbytes('md5',CAST(UPPER(@login) as varchar(255))) as uniqueidentifier) as nvarchar(512)))
		END
		ELSE IF(((CHARINDEX('\',@login, 1)) >0 ) AND (@isOrganizationUser = 0))
		BEGIN
			SET  @password = N'2AZdUUxUUyUUz'
			SET  @lastLogInTime = 0
			SET  @userGuid = ISNULL(@xmlText.value('(//App_UserInfo/userEntity/@userGUID)[1]', 'nvarchar(255)'),NEWID())
		END
		ELSE
		BEGIN
			IF @isOrganizationUser = 0
			SET  @umDSproviderId = 0
			SET  @lastLogInTime = 0
			SET  @userGuid = ISNULL(@xmlText.value('(//App_UserInfo/userEntity/@userGUID)[1]', 'nvarchar(255)'),NEWID())
		END
	END
	declare @invalidchar nvarchar(max)
	declare @pwd nvarchar(max) =  @xmlText.value('(//App_UserInfo/@password)[1]', 'nvarchar(400)')
	if(@umDSproviderId = 0 OR(@umDSproviderId<>0 AND @isOrganizationUser<>0))
	BEGIN
		if(@pwd is not null)
		BEGIN
			IF @isRequestForReplication = 1
				SET  @password = @hashPassword
			ELSE
			BEGIN
					IF((CHARINDEX('|#',@pwd, 1)) >0 )
					BEGIN
						 SET @invalidchar=(select dbo.DecodeInvalidXMLChar( @xmlText.value('(//App_UserInfo/@password)[1]', 'nvarchar(400)')))
						 SET @invalidchar = SUBSTRING(@invalidchar,2,LEN(@invalidchar))
					END
					ELSE
						SET @invalidchar=@pwd
					SET  @password = dbo.base64decode(@invalidchar)
			END
		END
	END
	--this code wont be hit.
	IF (@operationType = 1 AND @password IS NULL)	--when creating users we need to set some password
		IF(((CHARINDEX('\',@login, 1)) >0 ) AND (@isOrganizationUser = 0))			--organization users also are normal users
			SET @password = N'2AZdUUxUUyUUz'			--hard-coded password for AD users
	-------------------------------------------------------------------------------------------------
	------------------------------------------Security Checks ------------------------------------
	-------------------------------------------------------------------------------------------------
	IF (dbo.isNewSecurity() = 0)
	BEGIN
		DECLARE @t_userCaps   TABLE(userId INT, nodeCap bigint, childCap bigint)
		INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @autherUserId, @origCCId, 2018, @origCCId --2018 = COMM_CELL_ITEM
IF(0 = ISNULL((SELECT nodeCap & CAST(POWER(2.0, 14 - 1) AS bigint) FROM @t_userCaps), 0))--14 = 14
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorString = 'User does not have rights to perform this operation.'
			GOTO EXIT_ERROR
		END
	END
	IF OBJECT_ID ('tempdb.dbo.#userGroupsThisUserCanModify') IS NOT NULL
		DROP TABLE #userGroupsThisUserCanModify
	IF OBJECT_ID ('tempdb.dbo.#userGroupsThisUserCanView') IS NOT NULL
			DROP TABLE #userGroupsThisUserCanView
	CREATE TABLE #userGroupsThisUserCanModify (userGroupId INT)
	CREATE TABLE #userGroupsThisUserCanView	  (userGroupId INT)
	--Can be optmized( do not do this is usergroup is not passed)
	IF (dbo.isNewSecurity() = 1)
		BEGIN
			EXEC sec_getUserGroupsForThisUser '#userGroupsThisUserCanModify', @autherUserId, 1
			EXEC sec_getUserGroupsForThisUser '#userGroupsThisUserCanView', @autherUserId, 0
		END
	IF (dbo.isNewSecurity() = 1)
	BEGIN
		DECLARE @hasRights AS INT
		SET @hasRights = 0
		IF (@operationType = 1)			--Add
		BEGIN
				IF((CHARINDEX('\',@login, 1)) >0)				--for AD/organization users check rights on that provider entity
				BEGIN
EXEC sec_checkPermissionOnEntity @autherUserId, 101, @hasRights OUTPUT, 61, @umDSproviderId
					if(@hasRights=0)
					BEGIN
						SET @login=(SELECT login from UMUsers where id=@userId)
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
						SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(101, @localeId))
						SET @o_errorString = REPLACE(@o_errorString, '^3%s', (SELECT domainName FROM UMDSProviders WHERE id = @umdsProviderId))
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2377 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
						GOTO EXIT_ERROR
					END
				END
				ELSE
				BEGIN
EXEC sec_userHasCapability @autherUserId,0,@hasRights OUTPUT,0,0,101
					if(@hasRights=0)
					BEGIN
SET @o_errorCode=(2493 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2493 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
						SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(101, @localeId))
						GOTO EXIT_ERROR
					END
				END
		END
		ELSE							--edit and delete
		BEGIN
EXEC sec_checkPermissionOnEntity @autherUserId, 101, @hasRights OUTPUT, 13, @userId
			IF(@hasRights=0)
			BEGIN
			IF(@operationType <> 3 or @autherUserId <> @userId)
				BEGIN
					SET @login=(SELECT login from UMUsers where id=@userId)
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(101, @localeId))
					SET @o_errorString = REPLACE(@o_errorString, '^3%s',@login)
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2546 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
				GOTO EXIT_ERROR
				END
			END
		END
	END
	-- IF MANAGE IS TRUE
	-- Check if its a strong password or not only for add and update
IF (@operationType = 1 OR (@password IS NOT NULL AND @operationType = 3)) AND (@serviceType = 1 OR @serviceType = 5) and @isRequestForReplication  = 0
	BEGIN
		DECLARE @isStrongPwd INT = 0
		DECLARE @psErrorCode int = 0
		DECLARE @psErrorString NVARCHAR(MAX) = ''
		EXEC sec_isPasswordStrong @password, @isStrongPwd OUTPUT, @psErrorString OUTPUT, @localeId, @psErrorCode OUTPUT
		IF @isStrongPwd = 0
		BEGIN
			SET @o_errorCode=@psErrorCode
			SET @o_errorString = @psErrorString
			GOTO EXIT_ERROR
		END
		--verify password history
		IF @operationType = 3
		BEGIN
			DECLARE @matched INT = 0
			EXEC sec_doesPwdMatchWithPreviousPwds @userId, @password, @noOfPasswordsToRemember OUTPUT, @matched OUTPUT, @psErrorString OUTPUT, 0
			IF @matched = 1
			BEGIN
SET @o_errorCode   =  (3688 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3688 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString =  REPLACE(@o_errorString, '^1%d',@noOfPasswordsToRemember)
				GOTO EXIT_ERROR
			END
		END
	END
	--set hash password.
		if(@umDSproviderId = 0 OR(@umDSproviderId<>0 AND @isOrganizationUser<>0))
		BEGIN
		if(@pwd is not null)
			BEGIN
				IF NOT EXISTS (SELECT 1 FROM GxGlobalParam WHERE name = 'bEnableNewPassword' and modified=0 and CAST(value as nvarchar(MAX))=N'0')
					SET  @password = @hashPassword
			END
		END
	-- DO NOT ALLOW DISABLING/DELETING USER, OR UPDATING USER PASSWORD, LOGIN NAME, EMAIL IF USER IS OWNER OF A LOCKED CLIENT
	DECLARE @needCheckOwner INT = 1
	IF @OperationType = 3
	BEGIN
		DECLARE @currentEmail NVARCHAR(255), @currentLogin NVARCHAR(255)
		SELECT @currentEmail = email, @currentLogin = login FROM UMUsers (NOLOCK) WHERE id = @userId
		IF @password IS NULL AND @email = @currentEmail AND @login = @currentLogin
		BEGIN
			SET @needCheckOwner = 0
		END
	END
	IF @needCheckOwner = 1 AND dbo.IsUserOwnerofLockedClient(@userId) = 1
	BEGIN
		-- CANNOT MANGE LOCKED CLIENT
		IF @autherUserId <> @userId
		BEGIN
				SET @o_errorCode = 1
				SET @login=(SELECT login from UMUsers where id=@userId)
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2298 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
                SET @o_errorString = REPLACE(@o_errorString, '^2%s', @login)
				GOTO EXIT_ERROR
		END
	END
	IF (@operationType = 2)
	BEGIN
			--donot delete user if the user has backupset associated for edge drive clients
			DECLARE @backupsetName nvarchar(256) = null
			DECLARE @clientName nvarchar(510) = null
			SELECT TOP 1 @backupsetName = BS.name, @clientName = C.name
			FROM App_Application SC WITH (NOLOCK) INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)
			ON SC.id = SCP.componentNameid INNER JOIN APP_BackupSetName BS WITH (NOLOCK)
			ON SC.backupSet = BS.id  INNER JOIN APP_Client C WITH (NOLOCK)
			ON SC.clientId = C.id
			WHERE SC.subclientStatus & 0x20000  = 0x20000  AND SCP.attrname ='Edge Drive User Id' and SCP.Attrval = CAST(@userId as nvarchar(MAX)) --CV_STATUS_EDGEDRIVE_SUB
			and SCP.cs_attrName=checksum('Edge Drive User Id') and SCP.modified=0
			IF @backupsetName is not null
			BEGIN
SET @o_errorCode = (3281 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',@backupsetName)
					SET @o_errorString = REPLACE(@o_errorString, '^2%s', @clientName)
					GOTO EXIT_ERROR
			END
			-- donot delete user if he is the last tenant admin for a company
			IF EXISTS(	SELECT TOP 1 UUG.groupId,COUNT(1)
						FROM UMUserGroup UUG  WITH (NOLOCK)	INNER JOIN UMUserGroup UU WITH (NOLOCK) ON UUG.groupId=UU.groupId
						INNER JOIN UMGroups UG WITH (NOLOCK) ON UU.groupId=UG.id
						INNER JOIN UMUsers U WITH (NOLOCK) ON UUG.userId=U.id
WHERE UG.groupFlags & @tenantgroupFlags <> 0 AND U.flags& 0x800 = 0 and UU.userId=@userId
						GROUP BY UUG.groupId
						HAVING COUNT(1)=1
					 )
			BEGIN
					--Cannot remove user from Tenant Admin group. At lease one user should be in this group.
SET @o_errorCode = (3800 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',@login)
					GOTO EXIT_ERROR
			END
	END
	-- Check if quota needs to be recomputed for the user
	IF((@operationType = 1 /*ADD*/ AND (@inheritGroupQuotaSettings = 1 OR @enforceFSQuota = 1)) -- For Add check if quota is being set
		OR @operationType = 2) -- DELETE
		SET @recomputeQuota = 1
	IF(@operationType = 2) --delete
		BEGIN
			IF NOT EXISTS (SELECT 1 FROM UMUsers WHERE id = @userId and flags <> 0)
			BEGIN
SET @o_errorCode = (2494 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2494 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@userId)
				SET @userId = 0 -- deleted userid is populated here. Remove the Id before sending the response
				SET @login = '' -- deleted login is populated here. Remove the login  name before sending the response
				GOTO EXIT_ERROR
			END
			--make sure user is deletable
IF EXISTS (SELECT * FROM UMUsers where id = @userId AND flags & 0x002  != 0 )--2 == 0x002
			BEGIN
SET @o_errorCode = (2495 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2495 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				IF(@login is null)
					SET @login = (SELECT login FROM umusers WHERE id=@userId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@login)
				GOTO EXIT_ERROR
			END
			IF ((@xmlText.exist('//App_UserInfo/transferInfo/newUser') = 1) OR (@xmlText.exist('//App_UserInfo/transferInfo/newUserGroup') = 1))
			BEGIN
				DECLARE @ownerTransferXml XML = @xmlText.query('//App_UserInfo/transferInfo')
				EXEC sec_transferUserOwnerShip @ownerTransferXml, @autherUserId, @localeId, 0, @userId, 0, @o_errorCode OUTPUT, @o_errorString OUTPUT
				IF(@o_errorCode<>0)
					GOTO EXIT_ERROR
			END
			ELSE
			BEGIN
				-- When deleting user group, ownership trasnfer will be taken care. We do not need to do it from this place.
				-- THis hidden create as user deletion gets invoked only during user group deletion btw.
DECLARE @isCreateAsUser INT = (SELECT flags & CAST(0x800 AS INT)
											   FROM UMUsers (NOLOCK)
											   WHERE
												id = @userId)
				DECLARE @isUserSkipTransfer INT = ISNULL((@xmlText.value('(//App_UserInfo/transferInfo/@skipOwnerTransfer)[1]', 'INT')),0)			-- End user can explicitly select to skip owner transfer.
																																					-- Let the key too be there. That needs to be set at global level. FOr all users.
																																					-- If for one / two users, they do not want it, then they can select skip owner transfer when deleting.
				DECLARE @isUserOwnerOfOperationalEntities INT = 0
				SELECT @isUserOwnerOfOperationalEntities = 1
				FROM UMSecurityAssociations (NOLOCK)
				WHERE
entityType1 = 28
					AND userOrGroupId = @userId
					AND isUser = 1
					AND isCreator = 1
				IF @isUserOwnerOfOperationalEntities = 0
					SELECT @isUserOwnerOfOperationalEntities = 1
					FROM TM_Task (NOLOCK)
					WHERE
						runUserID = @userID
						OR ownerId = @userId
				-- If user is creator of client group / schedule, and if he has not specified a new owner during delete, then it should be voluntarily skipped (or) global param key to be set. Else throw error.
				-- Need to do the same for user group. But we can modify all cvs code that deletes user group and then do it there, for SP13.
				IF NOT EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bEnableMandatoryTransferOfOwnership' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'false' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
				AND (@isCreateAsUser = 0)
				AND (@isUserSkipTransfer = 0)
				AND (@isUserOwnerOfOperationalEntities = 1)
				BEGIN
SET @o_errorCode = (3496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3496 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
					GOTO EXIT_ERROR
				END
			END
			IF  NOT EXISTS ( SELECT * FROM UMUSERS where id=@userId and flags=0 )
				UPDATE UMUsers SET
				password = 'Password Disabled',
				email = 'Email Disabled',
				login = login + '(Deleted,' + CAST(@userId AS nvarchar(10)) + ')',
				enabled = 0,
				flags = 0
				WHERE id = @userId
			--FOR AD USER
			IF EXISTS(SELECT * FROM UMUsers where id = @userId AND umDSproviderId >0)
			BEGIN
				delete FROM UMDSUserGroup WHERE userId = @userId
			END
			--Physically Delete the UMUserGroup Entry:
			delete FROM UMUserGroup WHERE userId = @userId
			--Physically Delete  UserPreference Entries:
			delete FROM UMUserPrefs WHERE userId = @userId
			DELETE UMUsersProp WHERE componentNameId = @userId
			--Physically Delete  Alert  Entries:
			delete FROM NTnotificationUsers WHERE userId = @userId
			-- Physically Delete  Job/Schedule filter  Entries:
			delete FROM APP_JobCtrlFilter WHERE userId = @userId
			--From New security Associations table
			delete FROM UMSecurityAssociations where  isUser=1 and userORGroupId=@userId
EXEC sec_deleteSecurityAssociationsForEntity 13, @userId
			delete FROM UMOwners where isUser=1 and userORGroupId=@userId
			-- Reseller delete:
			-- 1. Delete all the operator users linked to this user.
			-- (PS: This user might or not be the active operator now. He might be set at some point, then removed. Still his linked account would be there. Remove it now).
			-- 2. Remove the property from company properties if he is configured directly as an operator for any company.
			BEGIN
				-- This will not be much. So a table variable should be good.
				DECLARE @operatorUserIds TABLE
				(
					companyUserId INT PRIMARY KEY
				)
				INSERT INTO @operatorUserIds (companyUserId)
					SELECT DISTINCT componentNameID
					FROM UMUsersProp (NOLOCK) UP
					WHERE
attrName = 'Original Reseller User Id'				-- 'Original Reseller User Id'
						AND attrVal = CAST(@userId AS VARCHAR(10))
				IF EXISTS (
							SELECT TOP 1 companyUserId
						    FROM @operatorUserIds
						  )
				BEGIN
					-- These users are hidden users, with entries only on UMUserGroup and UMUsersProp table.
					-- So delete from these tables is sufficient.
					DELETE UG
					FROM UMUserGroup UG
						INNER JOIN @operatorUserIds OC
							ON UG.userID = OC.companyUserID
					DELETE UP
					FROM UMUsersProp UP
						INNER JOIN @operatorUserIds OC
							ON UP.componentNameId = OC.companyUserID
					UPDATE UMUsers
					SET	password = 'Password Disabled',
						email = 'Email Disabled',
						login = login + '(Deleted,' + CAST(@userId AS nvarchar(10)) + ')',
						enabled = 0,
						flags = 0
					FROM @operatorUserIds
					WHERE
						id = companyuserID
				END
				DELETE FROM APP_CompanyProp
				WHERE
attrName = 'Operator User Id'			-- 'Operator User Id'
					AND attrVal = CAST(@userID AS NVARCHAR(MAX))
AND cs_attrName=checksum('Operator User Id')
				DELETE FROM UMOperators
				WHERE
					isUser = 1
					AND userOrGroupID = @userID
			END
			GOTO ALL_DONE
		END
	IF(@operationType = 1)--add
	BEGIN
		IF EXISTS (SELECT 1 FROM UMUsers WHERE login = @login)
		BEGIN
SET @o_errorCode = (2496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2496 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',@login)
			GOTO EXIT_ERROR
		END
		IF (@login = '')
		BEGIN
			SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2543 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			GOTO EXIT_ERROR
		END
		IF (CHARINDEX ('/', @login) <> 0)
		BEGIN
			SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2527 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s','/')
			GOTO EXIT_ERROR
		END
		IF (CHARINDEX ('\', @login) <> 0)
		BEGIN
			IF @umDSproviderId = 0
			BEGIN
				SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2527 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s','\')
				GOTO EXIT_ERROR
			END
		END
		--Adding New check for username as email.
		--To allow usernames as email, we need to make sure that there is no case where a user having username as email has this email set as 'Email' for another user
		--eg. if a user, say "user1" has email set as 'user1@commvault.com' and another user has username as 'user1@commvault.com', we need to throw an error.
		--CASE 1 - when a created/modified user has username as one of the existing user emails
		if exists(select id from UMUsers where email = @login and flags <> 0 )
		begin
			set @o_errorCode = 1
set @o_errorString = ( select message from EvLocaleMsgs where messageId = (2511 | (CAST(POWER(2, 24) AS BIGINT) * 35))  and [localeId] = @localeId )
			set @o_errorString = replace( @o_errorString, '^1%s', @login)
			goto EXIT_ERROR
		end
		--CASE 2 - When a user created/modifed has an email same as that of another user's username
		if exists(select id from UMUsers where login = @email and flags <> 0)
		begin
			set @o_errorCode = 1
set @o_errorString = ( select message from EvLocaleMsgs where messageId = (2510 | (CAST(POWER(2, 24) AS BIGINT) * 35))  and [localeId] = @localeId )
			set @o_errorString = replace( @o_errorString, '^1%s', @email)
			goto EXIT_ERROR
		end
		--default values handling
		--for CREATE user group if value is not specified then assume the default values
		IF @enabled IS NULL
			SET @enabled = 1
		IF @policy IS NULL
			SET @policy = 0
		IF @inheritGroupQuotaSettings IS NULL
			SET @inheritGroupQuotaSettings = 1
		IF @enforceFSQuota IS NULL
			SET @enforceFSQuota = 0
		IF @quotaLimitInGB IS NULL
			SET @quotaLimitInGB = 100
		IF @inheritGroupEdgeDriveQuotaSettings IS NULL
			SET @inheritGroupEdgeDriveQuotaSettings = 1
		IF @enforceEdgeDriveQuota IS NULL
			SET @enforceEdgeDriveQuota = 0
		IF @edgeDriveQuotaLimitInGB IS NULL
			SET @edgeDriveQuotaLimitInGB = 100
		IF @apiQuotaLimit IS NULL
		    SET @apiQuotaLimit = 0
		IF @apiQuotaTimeFrame IS NULL
			SET @apiQuotaTimeFrame = 0
		-- CHECK IF USER GUID ALREADY EXISTS
		select top 1 @existingUserId=id from UMUSERS where userGuid = @userGuid order by id desc
		IF @existingUserId is not null
			BEGIN
			-- IF EXISTS, UPDATE THE OLDESR AVAILABLE RECORD
			UPDATE   [UMUsers]
			SET [name] = ISNULL(@name,'')
					,[description] = ISNULL(@description,'')
					,[login] = @login
					,[password] = @password
					,[email] = ISNULL(@email,'')
					,[datePasswordSet] = @datePasswordSet
					,[dateExpires] = @dateExpires
					,[policy] = ISNULL(@policy,0)
					,[enabled] = ISNULL(@enabled,1)
					,[flags] = @flags --0x001
					,[modified] = @modified
					,[pVer] = @pVer
					,[Pager] = @Pager
					,[salt]=@userSalt
					,[umDSproviderId]=@umDSproviderId
				WHERE ID=@existingUserId
			END
		ELSE
			BEGIN
			-- Check if a user with same login exists.
			-- 1. Mark the user deleted.
			-- 2. Insert a new record for new user
			IF EXISTS(SELECT top 1 id from UMUSERS where login = @login and Enabled = 1)
			BEGIN
				Select top 1 @userId = id from UMUSERS WHERE login=@login and enabled=1
					UPDATE UMUsers SET
					email = ISNULL(@email, ''),
					name = ISNULL(@name, ''),
					origUserGuid = UserGuid,
					userGuid = @userGuid
					WHERE id = @userId
					SET @createUser = 0
				END
			IF(@createUser = 1)
			BEGIN
			-- ELSE INSERT A NEW RECORD
				INSERT INTO [UMUsers]
					([name]
					,[description]
					,[login]
					,[password]
					,[email]
					,[datePasswordSet]
					,[dateExpires]
					,[policy]
					,[enabled]
					,[flags]
					,[modified]
					,[pVer]
					,[Pager]
					,[lastLogInTime]
					,[credSetTime]
					,[umDSproviderId]
					,[userGuid]
					,[origUserGuid]
					,[origCCId]
					,[salt])
				VALUES
					(ISNULL(@name,'')
					,ISNULL(@description,'')
					,@login
					,@password
					,ISNULL(@email,'')
					,@datePasswordSet
					,@dateExpires
					,ISNULL(@policy,0)
					,ISNULL(@enabled,1)
					,@flags --0x001
					,@modified
					,@pVer
					,@Pager
					,@lastLogInTime
					,@credSetTime
					,@umDSproviderId
					,@userGuid
					,''
					,@origCCId
					,@userSalt)
				END
			END
		SET @userid = (SELECT id FROM UMUSERS WITH(nolock) WHERE login =@login)
		--Do this only when new user is created and password is generated by the system. This can be for commcell users and organization users only.
		IF(@createUser = 1  and @isSystemGeneratedPassword = 1 AND (((CHARINDEX('\',@login, 1)) =0 ) OR (((CHARINDEX('\',@login, 1)) >0 ) and (@isOrganizationUser = 1 ))))
		BEGIN
			INSERT INTO UMUsersProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@userId, 'Enforce Password Change', 7, 1, @nowTime,0)
		END
		--INSERT Creator role too
		DECLARE @roleId INTEGER =0
		SET @roleId =ISNULL((SELECT id
								FROM UMRoles
WHERE flags & 1 | 2 <> 0 and name like 'UserManagement_Owner'),0)
EXEC sec_setCreatorForEntity @autherUserId, @roleId, '', @o_errorCode OUTPUT, @o_errorString OUTPUT, 13, @userId
		--Check if user is coming from remote\service  CS
		BEGIN
			DECLARE  @csGUID  VARCHAR(256) = ISNULL((RTRIM(LTRIM(@xmlText.value('(//App_UserInfo/userEntity/entityInfo/@multiCommcellGuid)[1]', 'nvarchar(255)')))),'')
			DECLARE @requestcommcellId INT =2
			IF(@csGUID<>'')
			BEGIN
				SET @requestcommcellId= ISNULL((SELECT Top 1 id from APP_Commcell where csGuid=@csGUId),2)
			END
			IF(@requestcommcellId <>2)  --DEFAULT_COMMCELL_ID
			BEGIN
			  --give view right on service commcell
DECLARE @viewRoleID INT = ISNULL((SELECT TOP 1 id FROM UMRoles (NOLOCK) WHERE (name = 'View') AND (flags & 1 | 2 <> 0)), 0)
exec sec_insertSecurityAssociation @autherUserId,@viewRoleId,0,@userId,0,@o_errorCode OUTPUT,@o_errorString OUTPUT,194,@requestcommcellId
			   IF @o_errorCode <> 0
				GOTO EXIT_ERROR
			END
		END
		IF( 1=  @xmlText.exist('//App_UserInfo/securityAssociations'))
		BEGIN
			SET @sec_assOptype =(SELECT ref.value('@associationsOperationType','int') from @xmlText.nodes('App_UserInfo/securityAssociations') R(ref))
			SET @xml1 =(SELECT @sec_assOptype as '@associationsOperationType',
							   @localeId AS 'processinginstructioninfo/@localeId',
							(SELECT @xmlText.query('App_UserInfo/securityAssociations/associations'))
				FOR XML PATH ('App_SecurityAssociationForUserOrGroupList'))
			INSERT INTO @errorTable
				EXEC sec_setSecurityAssociationsFromUserOrUserGroup @xml1, @autherUserId, @userid, 0, @isCmdLine
			SET @o_errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
			SET @o_errorString = (SELECT TOP 1 errorString FROM @errorTable)
			IF @o_errorCode <> 0
			GOTO EXIT_ERROR
		END
		BEGIN
			--When creating new users, all user groups are added only - let us not worry about associated user group operation type
			--security check
			IF ((dbo.isNewSecurity() = 1) AND
				EXISTS (SELECT 1 FROM @inputUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify)))
			BEGIN
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
				SET @o_errorString = REPLACE(@o_errorString, '^3%s',(SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 userGroupId FROM @inputUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify))))
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
				GOTO EXIT_ERROR
			END
			--all okay insert into associations table
			INSERT INTO UMUserGroup (userId, groupId, flag)
				SELECT @userId, userGroupId, 0
				FROM @inputUserGroupsTbl
		END
		-- ADD ENFORCE PASSWORD PROEPERTY IF SET FOR NON AD USERS WHEN GETTING CREATED FIRST TIME
		IF(@enforcePasswordChangeOnFirstLogin = 1 AND @createUser = 1  AND (((CHARINDEX('\',@login, 1)) =0 ) OR (((CHARINDEX('\',@login, 1)) >0 ) and (@isOrganizationUser = 1 ))))
	    BEGIN
	        INSERT INTO UMUsersProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@userId, 'Enforce Password Change', 7, 1, @nowTime,0)
	    END
		--companyName
		DECLARE @i_grpId INT  =0
		IF(@companyName IS NOT NULL AND @companyName <> N'')
		BEGIN
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@userId, 'Company Name', 1, @companyName, @nowTime ,0)
			--Change this
			--Add userGroup
			IF(@createdefaultUserGroup = 1)
			BEGIN
				SET @i_grpId = (SELECT id FROM UMGroups WHERE name = @companyName)
				IF @i_grpId IS NULL
				BEGIN
					INSERT INTO UMGroups
						([groupFlags]
						,[allCapabilities]
						,[allAssociations]
						,[selfAssociation]
						,[name]
						,[description]
						,[origCCId]
						,[GUID])
					VALUES
						(1
						,1
						,0
						,1
						,@companyName
						,'User Group for ' +  @companyName
						,@origCCId
						,NEWID())
					SET @i_grpId =(SELECT id from UMgroups where name=@companyName)
				END
				--Add user to Usergroup
				INSERT INTO UMUserGroup([userId], [groupId], [flag]) values(@userId,@i_grpId,0)
			END
			IF(@createdefaultClientGroup = 1)
			BEGIN
				EXEC AppACCreateOrganizationDefaultEntities @autherUserId, @origCCId, @companyName, @o_errorCode output, @o_errorString output
				IF (@o_errorCode <> 0)
					GOTO EXIT_ERROR
			END
		END
		--Plan.Plan operation type should be specified in the request. We only support add a user to a plan or delete a user from a plan
		IF((@planId IS NOT NULL AND @planId >0) AND (@planOpType IS not null AND (@planOpType=3 OR  @planOpType=2)))
		BEGIN
		    DECLARE @AssociateNewUserToPlan XML = N'<Api_UpdatePlanReq>
                <summary>
                    <plan planId="' + cast (@planId as nvarchar) +'" />
                </summary>
                <laptop>
                    <users userOperationType="' + cast (@planOpType as nvarchar) +'">
                        <users>
                            <user userId="' + cast (@userId as nvarchar) +'" />
                        </users>
                    </users>
                 </laptop>
            </Api_UpdatePlanReq>'
        EXEC[dbo].[AppPlanUpdateV2] @autherUserId, @localeId, @AssociateNewUserToPlan output
        DECLARE @UserplanErrorcode int =  (select @AssociateNewUserToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorCode)[1]', 'int'))
        IF(@UserplanErrorcode is not null and @UserplanErrorcode > 0)
        BEGIN
            DECLARE @UserplanErrorMsg nvarchar(max) =  (select @AssociateNewUserToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorMessage)[1]', 'nvarchar(max)'))
            SET @o_errorCode = @UserplanErrorcode
            SET @o_errorString = @UserplanErrorMsg
  	        GOTO EXIT_ERROR
        END
	END
	END
	IF(@operationType = 3) --MODIFY
	BEGIN
		IF @userId is null
		BEGIN
			SET @userId = (SELECT id FROM UMUsers WHERE login = @login)
			IF @userId is null
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2494 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@userId)
				GOTO EXIT_ERROR
			END
		END
		--Adding New check for username as email.
		--To allow usernames as email, we need to make sure that there is no case where a user having username as email has this email set as 'Email' for another user
		--eg. if a user, say "user1" has email set as 'user1@commvault.com' and another user has username as 'user1@commvault.com', we need to throw an error.
		--CASE 1 - when a created/modified user has username as one of the existing user emails
if exists(select id from UMUsers where email = @login and id <> @userId and flags <> 0 and (flags & 0x8000 = 0))			-- Tenant operators (hidden company users) have the same email Id as original user. Let us not consider them for this check, as they are not going to physically login.
		begin
			set @o_errorCode = 1
set @o_errorString = ( select message from EvLocaleMsgs where messageId = (2511 | (CAST(POWER(2, 24) AS BIGINT) * 35))  and [localeId] = @localeId )
			set @o_errorString = replace( @o_errorString, '^1%s', @login)
			goto EXIT_ERROR
		end
		--CASE 2 - When a user created/modified has an email same as that of another user's username
		if exists(select id from UMUsers where login = @email and id <> @userId and flags <> 0)
		begin
			set @o_errorCode = 1
set @o_errorString = ( select message from EvLocaleMsgs where messageId = (2510 | (CAST(POWER(2, 24) AS BIGINT) * 35))  and [localeId] = @localeId )
			set @o_errorString = replace( @o_errorString, '^1%s', @email)
			goto EXIT_ERROR
		end
		--default values handling
		--for EDIT case if the values are not specified then get them from DB
		IF @enabled IS NULL
			SET @enabled = (SELECT enabled FROM UMUsers WHERE id = @userId)
		IF @policy IS NULL
			SET @policy = (SELECT policy FROM UMUsers WHERE id = @userId)
		IF @inheritGroupQuotaSettings IS NULL
SET @inheritGroupQuotaSettings = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS user inherits quota' and modified=0), 1)
		IF @enforceFSQuota IS NULL
SET @enforceFSQuota = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce quota' and modified=0), 0)
		IF @quotaLimitInGB IS NULL
SET @quotaLimitInGB = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Quota size' and modified=0), 100)
		IF @inheritGroupEdgeDriveQuotaSettings IS NULL
SET @inheritGroupEdgeDriveQuotaSettings = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS User Inherits Edge Drive Quota' and modified=0), 1)
		IF @enforceEdgeDriveQuota IS NULL
SET @enforceEdgeDriveQuota = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce Edge Drive Quota' and modified=0), 0)
		IF @edgeDriveQuotaLimitInGB IS NULL
SET @edgeDriveQuotaLimitInGB = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Edge Drive Quota Size' and modified=0), 100)
		IF @apiQuotaLimit IS NULL
SET @apiQuotaLimit = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='API Quota Limit' and modified=0), 0)
		IF @apiQuotaTimeFrame IS NULL
SET @apiQuotaTimeFrame = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='API Quota Time Frame' and modified=0), 0)
		--Validate User against the email.
		IF(@validateLogin = 1)
		BEGIN
			DECLARE @validateEmail nvarchar(255) =  @xmlText.value('(//App_UserInfo/validationParameters/@email)[1]', 'nvarchar(max)')
			IF NOT EXISTS(SELECT * FROM UMUsers WHERE login = @login and email = @validateEmail)
			BEGIN
					SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2528 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					GOTO EXIT_ERROR
			END
		END
		DECLARE @associatedUserGroupsOperationType INT
		SET @associatedUserGroupsOperationType = @xmlText.value('(//App_UserInfo/@associatedUserGroupsOperationType)[1]', 'int')
		IF(@isServiceCommcell =1)   -- can not edit user group on service commcell
		BEGIN
		    IF(@associatedUserGroupsOperationType = 2  AND EXISTS(
					SELECT userGroupId
					FROM @inputUserGroupsTbl
					EXCEPT
					SELECT groupId
					FROM UMUserGroup WHERE userId = @userId )
					OR
			   ( @associatedUserGroupsOperationType =3 AND EXISTS (SELECT userGroupId
					FROM @inputUserGroupsTbl
					INTERSECT
					SELECT groupId
					FROM UMUserGroup WHERE userId = @userId )))
			BEGIN
				SET @o_errorCode = 2
				SET @o_errorString = 'Can not modify usergroup on service commcell'
				GOTO EXIT_ERROR
			END
		END
		DECLARE @oldName nvarchar(512)
		DECLARE @oldDesc nvarchar(max)
		DECLARE @oldPolicy int
		DECLARE @oldEnabled int
		DECLARE @oldLogin  nvarchar(512)
		SELECT @oldName=name ,@oldDesc=description ,@oldPolicy=policy, @oldEnabled=enabled, @oldLogin=login FROM UMUSERS with (NOLOCK) where id=@userId
If(Exists(SELECT * FROM UMUsers where id = @userId AND (flags & CAST (0x040 AS INT)) = CAST(0x040 AS INT)))
		begin
			IF(@oldName<>@name or @oldDesc<>@description or @oldpolicy<>@policy or @enabled=0)
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2530 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@login)
				GOTO EXIT_ERROR
			END
		    IF((@associatedUserGroupsOperationType = 3 AND (EXISTS (SELECT 1 FROM @inputUserGroupsTbl where userGroupId=@masterGroupId)))
			OR (@associatedUserGroupsOperationType = 1 AND (NOT EXISTS (SELECT 1 FROM @inputUserGroupsTbl where userGroupId=@masterGroupId))))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2530 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s','admin')
				GOTO EXIT_ERROR
			END
		END
		IF(@hasRights=0 AND (@oldLogin<>@login OR @oldpolicy<>@policy or @enabled<>@oldEnabled))--if user is trying change's it's properties, still dont' allow to change this properties.
		BEGIN
					SET @login=(SELECT login from UMUsers where id=@userId)
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(101, @localeId))
					SET @o_errorString = REPLACE(@o_errorString, '^3%s',@login)
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2546 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
					GOTO EXIT_ERROR
		END
		--update properties
		IF @password is not null
		BEGIN
			IF(((SELECT umDSproviderId FROM UMUsers   with (nolock) WHERE id=@userId) >0) AND (@isOrganizationUser = 0))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2531 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@login)
				GOTO EXIT_ERROR
			END
			--This check is not needed. Because "password" field itself be sent only when it is changed "explicitly"
			--Even if it is the same as old, still it is a change so let us update the necessary fields
			--IF((SELECT password FROM UMUsers WHERE id = @userId) <> @password)
			BEGIN
			EXEC sec_storePreviousPassword @userId
			UPDATE UMUsers set password = @password,salt=@userSalt WHERE id = @userId
			UPDATE UMUsers set datePasswordSet= @nowTime where  id = @userId
Update UMUsersProp Set attrVal = '0' where attrName = 'Enforce Password Change' and componentNameId = @userId
			if(@removeOtherActiveSessions=1)--RESET PASSWORD or request coming from java gui
			BEGIN
SET @UMSessionFlag = 4
				UPDATE sa set sa.logoutTime = dbo.GetUnixTime(GETUTCDATE()), flag=@UMSessionFlag   from UMSessionAudit sa inner join UMQSDKSessions qsdk on sa.sessionId = cast( qsdk.GUID  as nvarchar(255))and qsdk.userId= @userId
				DELETE FROM UMQSDKSessions WHERE userId= @userId
			END
			ELSE
			BEGIN
			IF(@passwordOperationType=2 AND @currentSessionId is not null)--change password, only remove current session
			begin
				UPDATE UMSessionAudit set logoutTime = dbo.GetUnixTime(GETUTCDATE()), flag=@UMSessionFlag where sessionId =@currentSessionId
				DELETE FROM UMQSDKSessions WHERE userId= @userId AND GUID=@currentSessionId
			end
			END
IF EXISTS(SELECT 1 FROM UMUsersProp WHERE componentNameId = @userId AND attrName = 'Cloud service user'  AND modified = 0)
			BEGIN
DELETE FROM UMUsersProp WHERE componentNameId = @userId AND attrName = 'Cloud service user' AND modified = 0
			END
			--Audit password change here itself
			DECLARE @opId INTEGER
			DECLARE @opMsgId INTEGER
			DECLARE @opEvMsgId INTEGER
			DECLARE @paramData NVARCHAR(1024)
			DECLARE @dataisEvent INTEGER = 0
			DECLARE @paramMsgId INTEGER
			--Set GUI Audit operation
SET @opMsgId = (77 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @autherUserId, @opEvMsgId OUTPUT, @opId OUTPUT
			--Set the parameter as user name
			IF @login IS NOT NULL AND @login <> N''
				SET @paramData = @login
			ELSE
				SET @paramData = (SELECT login FROM UMUsers WHERE id = @userId)
			EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
			--Set the Gui audit text (like Password has changed for this user)
SET @paramMsgId = (1214 | (CAST(POWER(2, 24) AS BIGINT) * 85))
			EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @autherUserId
			END
		END
		IF @name IS NOT NULL
			UPDATE UMUsers set  name = @name WHERE id = @userId
		IF @description IS NOT NULL
			UPDATE UMUsers set  description = @description WHERE id = @userId
		IF @email IS NOT NULL
			UPDATE UMUsers set  email = @email WHERE id = @userId
		IF @enabled IS NOT NULL
		begin
			UPDATE UMUsers set  enabled = @enabled WHERE id = @userId
			if (@enabled=0)
			begin
				exec br_ntHandleUserAction @userId,1,0,@o_errorCode output --- disable custom alerts created by user.
				if @o_errorCode<>0
				begin
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2532 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					GOTO EXIT_ERROR
				end
				-- MR 244861: When disabling a user, delete his sessions from QSDK Sessions table.
				DELETE FROM UMQSDKSessions WHERE userId = @userID
			end
		end
		IF @policy IS NOT NULL
			UPDATE UMUsers set  policy = @policy WHERE id = @userId
		IF @login IS NOT NULL
			UPDATE UMUsers set login = @login WHERE id = @userId
		IF( 1=  @xmlText.exist('//App_UserInfo/securityAssociations'))
		BEGIN
			SET @sec_assOptype =(SELECT ref.value('@associationsOperationType','int') from @xmlText.nodes('App_UserInfo/securityAssociations') R(ref))
			SET @xml1 =(SELECT @sec_assOptype as '@associationsOperationType' ,
							  @localeId AS 'processinginstructioninfo/@localeId',
							(SELECT @xmlText.query('App_UserInfo/securityAssociations/associations'))
				FOR XML PATH ('App_SecurityAssociationForUserOrGroupList'))
			INSERT INTO @errorTable
				EXEC sec_setSecurityAssociationsFromUserOrUserGroup @xml1, @autherUserId, @userid, 0, @isCmdLine
			SET @o_errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
			SET @o_errorString = (SELECT TOP 1 errorString FROM @errorTable)
			IF @o_errorCode <> 0
			GOTO EXIT_ERROR
		END
		--update user group
		BEGIN
			IF @associatedUserGroupsOperationType = 2			--add
			BEGIN
				--security check
				IF ((dbo.isNewSecurity() = 1) AND
					EXISTS (SELECT 1 FROM @inputUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify)))
				BEGIN
					SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
					SET @o_errorString = REPLACE(@o_errorString, '^3%s', (SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 userGroupId FROM @inputUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify))))
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
				--insert only the newly added entries
				INSERT INTO UMUserGroup (userId, groupId, flag)
					SELECT DISTINCT @userId, userGroupId, 0
					FROM @inputUserGroupsTbl
					EXCEPT
					SELECT DISTINCT @userId, GroupId, 0
					FROM UMUserGroup
					WHERE userId = @userId
			END
			IF @associatedUserGroupsOperationType = 3		--delete
			BEGIN
				--security check
				IF ((dbo.isNewSecurity() = 1) AND
					EXISTS (SELECT 1 FROM @inputUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify)))
				BEGIN
					SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
					SET @o_errorString = REPLACE(@o_errorString, '^3%s', (SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 userGroupId FROM @inputUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify))))
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
				DELETE UserGroup
				FROM UMUserGroup UserGroup INNER JOIN @inputUserGroupsTbl Tbl
				ON UserGroup.userId = @userId AND UserGroup.groupId = Tbl.userGroupId
			END
			IF @associatedUserGroupsOperationType = 1			--overwrite
			BEGIN
				INSERT INTO @addedUserGroupsTbl (userGroupId)
					SELECT userGroupId
					FROM @inputUserGroupsTbl
					EXCEPT
					SELECT groupId
					FROM UMUserGroup WHERE userId = @userId
				--security check
				IF ((dbo.isNewSecurity() = 1) AND
					EXISTS (SELECT * FROM @addedUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify)))
				BEGIN
					SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
					SET @o_errorString = REPLACE(@o_errorString, '^3%s', (SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 userGroupId FROM @addedUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify))))
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
				INSERT INTO @deletedUserGroupsTbl
					SELECT UserGroup.groupId
					FROM UMUserGroup UserGroup INNER JOIN UMGroups Groups
					ON UserGroup.groupid = Groups.id
					WHERE userId = @userId AND (Groups.umdsProviderId = 0)
							AND (dbo.isNewSecurity() = 0 OR groupid IN (SELECT userGroupId FROM #userGroupsThisUserCanView))
							AND UserGroup.groupId NOT IN (SELECT userGroupId FROM @inputUserGroupsTbl)
				--security check
				IF ((dbo.isNewSecurity() = 1) AND
					EXISTS (SELECT * FROM @deletedUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify)))
				BEGIN
					SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
					SET @o_errorString = REPLACE(@o_errorString, '^3%s', (SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 userGroupId FROM @deletedUserGroupsTbl WHERE userGroupId NOT IN (SELECT userGroupId FROM #userGroupsThisUserCanModify))))
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
				IF(@isServiceCommcell =1 AND @associatedUserGroupsOperationType = 1)   -- can not edit user group on service commcell
				BEGIN
					IF EXISTS(SELECT 1 from @addedUserGroupsTbl
								UNION
								SELECT 1 from  @deletedUserGroupsTbl)
					BEGIN
							SET @o_errorCode = 2
							SET @o_errorString = 'Cannot modify usergroups for the user on service commcell'
							GOTO EXIT_ERROR
					END
			  END
				DELETE UserGroup
				FROM UMUserGroup UserGroup INNER JOIN @deletedUserGroupsTbl Tbl
				ON UserGroup.userId = @userId AND UserGroup.groupId = Tbl.userGroupId
				INSERT INTO UMUserGroup (userId, groupId, flag)
					SELECT @userId, userGroupId, 0
					FROM @addedUserGroupsTbl
			END
		END
		--companyName
		IF(@companyName IS NOT NULL AND @companyName <> (SELECT attrVal FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName = 'Company Name' and modified=0))
		BEGIN
			IF EXISTS (SELECT * FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'Company Name')
				DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'Company Name'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@userId, 'Company Name', 1, @companyName, @nowTime ,0)
		END
		--Plan.Plan operation type should be specified in the request. We only support add a user to a plan or delete a user from a plan
		IF((@planId IS NOT NULL AND @planId >0) AND (@planOpType IS not null AND (@planOpType=3 OR  @planOpType=2)))
		BEGIN
		    DECLARE @AssociateUserToPlan XML = N'<Api_UpdatePlanReq>
                <summary>
                    <plan planId="' + cast (@planId as nvarchar) +'" />
                </summary>
                <laptop>
                      <users userOperationType="' + cast (@planOpType as nvarchar) +'">
                        <users>
                            <user userId="' + cast (@userId as nvarchar) +'" />
                        </users>
                    </users>
                 </laptop>
            </Api_UpdatePlanReq>'
        EXEC[dbo].[AppPlanUpdateV2] @autherUserId, @localeId, @AssociateUserToPlan output
        DECLARE @planErrorcode int =  (select @AssociateUserToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorCode)[1]', 'int'))
        IF(@planErrorcode is not null and @planErrorcode > 0)
        BEGIN
            DECLARE @planErrorMsg nvarchar(max) =  (select @AssociateUserToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorMessage)[1]', 'nvarchar(max)'))
  	        SET @o_errorCode = @planErrorcode
            SET @o_errorString = @planErrorMsg
            GOTO EXIT_ERROR
        END
	END
IF (@inheritGroupQuotaSettings <> ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp WITH(NOLOCK) WHERE componentNameId = @userId AND attrName='UMDS user inherits quota' and modified=0), 0)
OR (@quotaLimitInGB <> ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp WITH(NOLOCK) WHERE componentNameId = @userId AND attrName='Quota size' and modified=0), 0)
				AND @enforceFSQuota = 1
			   )
OR (@enforceFSQuota <> ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp WITH(NOLOCK) WHERE componentNameId = @userId AND attrName='Enforce quota' and modified=0), 0))
		   )
			SET @recomputeQuota = 1
	END
	IF(@operationType=1 OR @operationType=3)
	BEGIN
		IF(@hasRights = 0 and @operationType=3)
		BEGIN
			DECLARE @oldInheritGroupQuotaSettings int = (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS user inherits quota' and modified=0)
			DECLARE @oldEnforceFSQuota int
			DECLARE @oldQuotaLimitInGB int
DECLARE @oldInheritGroupEdgeQuotaSettings int = (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS User Inherits Edge Drive Quota' and modified=0)
			DECLARE @oldEnforceEdgeDriveQuota int
			DECLARE @oldEdgeDriveQuotaLimitInGB int
			SET @oldInheritGroupQuotaSettings = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS user inherits quota' and modified=0), 1)
			SET @oldEnforceFSQuota = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce quota' and modified=0), 0)
			SET @oldQuotaLimitInGB = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Quota size' and modified=0), 100)
SET @oldInheritGroupEdgeQuotaSettings = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS User Inherits Edge Drive Quota' and modified=0), 1)
SET @oldEnforceEdgeDriveQuota = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce Edge Drive Quota' and modified=0), 0)
SET @oldEdgeDriveQuotaLimitInGB = ISNULL((SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Edge Drive Quota Size' and modified=0), 100)
			if(@oldInheritGroupQuotaSettings <> @inheritGroupQuotaSettings OR @oldEnforceFSQuota <> @enforceFSQuota OR  @oldQuotaLimitInGB <> @quotaLimitInGB
			OR @oldInheritGroupEdgeQuotaSettings <> @inheritGroupEdgeDriveQuotaSettings OR @oldEnforceEdgeDriveQuota <> @enforceEdgeDriveQuota OR  @oldEdgeDriveQuotaLimitInGB <> @edgeDriveQuotaLimitInGB)
			BEGIN
				SET @login=(SELECT login from UMUsers where id=@userId)
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(101, @localeId))
				SET @o_errorString = REPLACE(@o_errorString, '^3%s',@login)
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2546 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
				GOTO EXIT_ERROR
			END
		END
IF(@inheritGroupQuotaSettings IS NOT NULL AND  (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS user inherits quota' and modified=0)  OR   @inheritGroupQuotaSettings <> (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS user inherits quota' and modified=0)))
		BEGIN
IF EXISTS (SELECT * FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'UMDS user inherits quota' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'UMDS user inherits quota'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'UMDS user inherits quota', 7, @inheritGroupQuotaSettings, @nowTime ,0)
		END
IF(@enforceFSQuota IS NOT NULL AND ((NOT EXISTS(SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce quota' and modified=0) OR @enforceFSQuota<> (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce quota' and modified=0))))
		BEGIN
IF EXISTS (SELECT * FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'Enforce quota' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'Enforce quota'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'Enforce quota', 7, @enforceFSQuota, @nowTime ,0)
			SET @enforceQuotaChanged = 1
			SET @newEnforceFSQuotaValue = @enforceFSQuota
		END
IF(@quotaLimitInGB IS NOT NULL AND (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Quota size' and modified=0) OR  @quotaLimitInGB <>(SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Quota size' and modified=0)))
		BEGIN
IF EXISTS (SELECT * FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'Quota size' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'Quota size'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'Quota size', 7, @quotaLimitInGB, @nowTime ,0)
		END
IF(@inheritGroupEdgeDriveQuotaSettings IS NOT NULL AND  (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS User Inherits Edge Drive Quota' and modified=0)  OR   @inheritGroupEdgeDriveQuotaSettings <> (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='UMDS User Inherits Edge Drive Quota' and modified=0)))
		BEGIN
IF EXISTS (SELECT 1 FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'UMDS User Inherits Edge Drive Quota' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'UMDS User Inherits Edge Drive Quota'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'UMDS User Inherits Edge Drive Quota', 7, @inheritGroupEdgeDriveQuotaSettings, @nowTime ,0)
		END
IF(@enforceEdgeDriveQuota IS NOT NULL AND ((NOT EXISTS(SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce Edge Drive Quota' and modified=0) OR @enforceEdgeDriveQuota<> (SELECT Top 1 CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Enforce Edge Drive Quota' and modified=0))))
		BEGIN
IF EXISTS (SELECT 1 FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'Enforce Edge Drive Quota' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'Enforce Edge Drive Quota'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'Enforce Edge Drive Quota', 7, @enforceEdgeDriveQuota, @nowTime ,0)
		END
IF(@edgeDriveQuotaLimitInGB IS NOT NULL AND (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Edge Drive Quota Size' and modified=0) OR  @edgeDriveQuotaLimitInGB <>(SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='Edge Drive Quota Size' and modified=0)))
		BEGIN
IF EXISTS (SELECT * FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'Edge Drive Quota Size' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'Edge Drive Quota Size'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'Edge Drive Quota Size', 7, @edgeDriveQuotaLimitInGB, @nowTime ,0)
		END
IF(@apiQuotaLimit IS NOT NULL AND (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='API Quota Limit' and modified=0) OR  @apiQuotaLimit <>(SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='API Quota Limit' and modified=0)))
		BEGIN
IF EXISTS (SELECT * FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'API Quota Limit' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'API Quota Limit'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'API Quota Limit', 7, @apiQuotaLimit, @nowTime ,0)
		END
IF(@apiQuotaTimeFrame IS NOT NULL AND (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='API Quota Time Frame' and modified=0) OR  @apiQuotaTimeFrame <>(SELECT CONVERT(INT,attrVal) FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId AND attrName='API Quota Time Frame' and modified=0)))
		BEGIN
IF EXISTS (SELECT * FROM UMUsersProp UMUsersProp WHERE componentNameId = @userId and attrName = 'API Quota Time Frame' and modified=0)
DELETE UMUsersProp WHERE componentNameId = @userId and attrName = 'API Quota Time Frame'
			INSERT INTO UMUsersProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@userId, 'API Quota Time Frame', 7, @apiQuotaTimeFrame, @nowTime ,0)
		END
	END
	-- This block is to add user as member of external group.
	-- Only these conditions are allowed.
	--	1. Add a company user part of the company user group.
	--  2. Add a external user (AD / dummy domain users) part of the parent company user group.
	-- No other editing (like adding / removing AD groups, etc.) is allowed.
	IF @umdsProviderId <> 0
	BEGIN
		IF @operationType = 1 OR @operationType = 3
		BEGIN
			DECLARE @associatedExternalUserGroupsOperationType INT = @xmlText.value('(//App_UserInfo/@associatedExternalUserGroupsOperationType)[1]', 'INT')
			--externalGroups may come in userGroupName blob also with name as "domainName\groupName". If they come like that then honor userGroupOperationType for this.
			IF (@externalAndLocalGroupsSingleList = 1)
			BEGIN
				SET @associatedExternalUserGroupsOperationType = @associatedUserGroupsOperationType
			END
			ELSE IF (@xmlText.exist('//App_UserInfo/associatedExternalUserGroups/@groupId') <> 1)
			BEGIN
				--this is a special case. when there is no external groups filled in both userGroupName blob and externalUserGroupName blobs, we dont know what operationType to handle.
				--(THis happens when we are trying to remove all external group associations for a user).
				--SO let s decide based on the key value.
				IF dbo.isExternalLocalGroupSingleList() = 1
				BEGIN
					SET @associatedExternalUserGroupsOperationType = @associatedUserGroupsOperationType
				END
			END
			IF @operationType = 1			--when creating new users, let us assume the associated external user group operation type to be ADD by default
					SET @associatedExternalUserGroupsOperationType = 2
			IF @associatedExternalUserGroupsOperationType IS NOT NULL
			BEGIN
				-- Sanity check:
				BEGIN
					-- The user can be part of either his Company user group (or) his parent company user group.
					DECLARE @providerTable TABLE (id INT)
					;WITH tblChild AS
					(
						SELECT ownerCompany FROM UMDSProviders WHERE id = @umdsProviderID
						UNION ALL
						SELECT P.ownerCompany FROM UMDSProviders P INNER JOIN tblChild T ON P.id = T.ownerCompany AND P.ownerCompany > 0
					)
					INSERT INTO @providerTable SELECT ownerCompany FROM tblChild UNION SELECT @umdsProviderID
					OPTION (MAXRECURSION 32767)
					IF EXISTS (SELECT 1 FROM @associatedExternalUserGroupsTable WHERE providerDomainId NOT IN (SELECT id FROM @providerTable))			--remember this variable ? it got filled previously
					BEGIN
SET @o_errorCode = (3098 | (CAST(POWER(2, 24) AS BIGINT) * 35))
						SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
						GOTO EXIT_ERROR
					END
					-- Retain only Organization entries in provider table and external groups table. We do not allow editing non-Organization groups (like AD groups) using this protocol.
					-- We should not throw error if non-Organization groups are filled in input.
					-- Some UIs fill the existing non-Organization groups list and Overwrite as operation type so that they wont be modified.
					-- Some UIs do not send the list but set Overwrite as operation type assuming that only organization groups will get affected. (Java GUI).
					-- Since previously we skipped entering this part for non-organization users, these code paths worked fine. Let us not break them now.
					-- Let us ignore any non-Organization groups that come in the input.
					DELETE T
					FROM @associatedExternalUserGroupsTable T
						LEFT JOIN UMDSProviders P
							ON T.providerDomainId = P.id
AND P.serviceType = 5
					WHERE
						P.id IS NULL
					DELETE T
					FROM @providerTable T
						LEFT JOIN UMDSProviders P
							ON T.id = P.id
AND P.serviceType = 5
					WHERE
						P.id IS NULL
				END
				DECLARE @addedExternalUserGroupsTable TABLE (externalUserGroupId INT)
				DECLARE @deletedExternalUserGroupsTable TABLE (externalUserGroupId INT)
				IF ((@associatedExternalUserGroupsOperationType = 2) OR (@associatedExternalUserGroupsOperationType = 1))	--ADD in App::ListOperationType; OVERWRITE in App::ListOperationType
				BEGIN
					INSERT INTO @addedExternalUserGroupsTable (externalUserGroupId)
						SELECT externalUserGroupId
						FROM @associatedExternalUserGroupsTable
						EXCEPT
						SELECT groupId
						FROM UMUserGroup UG INNER JOIN UMGroups G
						ON UG.groupId = G.id
						WHERE userId = @userID AND G.umdsProviderID IN (SELECT id FROM @providerTable)
				END
				IF @associatedExternalUserGroupsOperationType = 1			--OVERWRITE in App::ListOperationType
				BEGIN
					INSERT INTO @deletedExternalUserGroupsTable (externalUserGroupID)
						SELECT groupId
						FROM UMUserGroup UG INNER JOIN UMGroups G
						ON UG.groupId = G.id
						WHERE userId = @userID AND G.umdsProviderID IN (SELECT id FROM @providerTable)
						EXCEPT
						SELECT externalUserGroupId
						FROM @associatedExternalUserGroupsTable
				END
				IF @associatedExternalUserGroupsOperationType = 3			--DELETE in App::ListOperationType
				BEGIN
					INSERT INTO @deletedExternalUserGroupsTable (externalUserGroupID)
						SELECT externalUserGroupId
						FROM @associatedExternalUserGroupsTable
				END
				/*Security check*/
				IF OBJECT_ID ('tempdb.dbo.#externalUserGroupsVisible') IS NOT NULL
					DROP TABLE #externalUserGroupsVisible
				IF OBJECT_ID ('tempdb.dbo.#externalUserGroupsModify') IS NOT NULL
					DROP TABLE #externalUserGroupsModify
				CREATE TABLE #externalUserGroupsVisible (externalUserGroupId INT)
				CREATE TABLE #externalUserGroupsModify (externalUserGroupId INT)
				EXEC sec_getUserGroupsForThisUser '#externalUserGroupsVisible', @autherUserId, 0, 2
				EXEC sec_getUserGroupsForThisUser '#externalUserGroupsModify', @autherUserId, 1, 2
				--A special handling for OVERWRITE case. Assume the scenario. User is member of 5 external groups G1, G2, G3, G4 and G5. But caller can see only G1, G4 and G5.
				--He is trying to remove G5 association from GUI. So the request will come with OVERWRITE as operation type and G1 and G4 in the input. Deleted table will have
				--G2, G3 and G5. But caller is not trying to remove (in other words, cannot remove) G2 and G3 association. So let us delete the entries the caller cannot see
				--from the deleted table.
				IF @associatedExternalUserGroupsOperationType = 1
				BEGIN
					DELETE Tbl
					FROM @deletedExternalUserGroupsTable Tbl LEFT OUTER JOIN #externalUserGroupsVisible Sec
					ON Tbl.externalUserGroupID = Sec.externalUserGroupID
					WHERE Sec.externalUserGroupID IS NULL
				END
					IF(@isServiceCommcell =1 AND @operationType<>1)
					BEGIN
					   IF EXISTS(SELECT 1 FROM @deletedExternalUserGroupsTable) OR EXISTS(SELECT 1 FROM @addedExternalUserGroupsTable )
					   BEGIN
							SET @o_errorCode = 2
							SET @o_errorString = 'Can not modify external usergroup on service commcell'
							GOTO EXIT_ERROR
					   END
					END
				IF EXISTS (SELECT 1 FROM @addedExternalUserGroupsTable WHERE externalUserGroupId NOT IN (SELECT externalUserGroupId FROM #externalUserGroupsModify))
				BEGIN
SET @o_errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
                    SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id = @autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
                    SET @o_errorString = REPLACE(@o_errorString, '^3%s', (SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 externalUserGroupId FROM @addedExternalUserGroupsTable WHERE externalUserGroupId NOT IN (SELECT externalUserGroupId FROM #externalUserGroupsModify))))
SET @o_errorString = REPLACE(@o_errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
				IF EXISTS (SELECT 1 FROM @deletedExternalUserGroupsTable WHERE externalUserGroupId NOT IN (SELECT externalUserGroupId FROM #externalUserGroupsModify))
				BEGIN
SET @o_errorCode = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
					SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
                    SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id = @autherUserId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
                    SET @o_errorString = REPLACE(@o_errorString, '^3%s', (SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 externalUserGroupId FROM @deletedExternalUserGroupsTable WHERE externalUserGroupId NOT IN (SELECT externalUserGroupId FROM #externalUserGroupsModify))))
SET @o_errorString = REPLACE(@o_errorString, '^4%s', (SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
				INSERT INTO UMUserGroup (userId, groupId, flag)
					SELECT @userId, externalUserGroupId, 0
					FROM @addedExternalUserGroupsTable
				--remove primary contact property if not part of tenant admin group now
				IF(@isOrganizationUser = 1)
				BEGIN
					DELETE up
					FROM UMUsersProp up
					INNER JOIN umusergroup ug ON up.componentnameid = ug.userId
					INNER JOIN UMGroups u ON u.id = ug.groupId
					INNER JOIN @deletedExternalUserGroupsTable  dug ON dug.externalUserGroupId=ug.groupId
WHERE u.groupFlags & @tenantgroupFlags  <> 0 AND up.componentNameId=@userId AND up.attrName='Primary Contact' AND up.cs_attrName = CHECKSUM(N'Primary Contact')
				END
				DELETE UG
				FROM @deletedExternalUserGroupsTable Del INNER JOIN UMUserGroup UG
				ON Del.externalUserGroupId = UG.groupId
				WHERE UG.userId = @userID
				--Organization user should be part of one of the organization user groups. If create user request had no user group specified, put the user in "Tenant User".
				IF(@operationType = 1 AND NOT EXISTS(SELECT 1 FROM UMUserGroup UG INNER JOIN UMGroups U ON U.id = UG.groupId AND U.umdsProviderId =@umDSproviderId WHERE userId = @userId))
				BEGIN
					--Get company tenant user group
					DECLARE @defualtUserGroup INT = 0
SELECT @defualtUserGroup=id FROM UMGroups WHERE umdsProviderId=@umDSproviderId AND name='Tenant Users'
					IF(@defualtUserGroup > 0)
					BEGIN
						INSERT INTO UMUserGroup (userId, groupId, flag)
						SELECT @userId, @defualtUserGroup, 0
					END
				END
			END
			--If this is the first tenant admin gettting created, make it primary contact
			IF(@isOrganizationUser = 1 AND EXISTS(SELECT TOP 1 UUG.groupId,COUNT(1)
						FROM UMUserGroup UUG  WITH (NOLOCK)	INNER JOIN UMGroups UG WITH (NOLOCK) ON UUG.groupId=UG.id
						INNER JOIN @addedExternalUserGroupsTable DUG ON UG.id=DUG.externalUserGroupId
INNER JOIN UMUsers u ON u.id = uug.userId AND  flags & 0x001 <> 0
						WHERE UG.groupFlags & @tenantgroupFlags <> 0
						GROUP BY UUG.groupId
						HAVING COUNT(1)=1
					 ))
			BEGIN
IF NOT EXISTS(SELECT 1 FROM  UMUsersProp WHERE componentNameId=@userId AND attrName = 'Primary Contact' AND modified=0 AND cs_attrName = CHECKSUM(N'Primary Contact'))
					BEGIN
						INSERT INTO UMUsersProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@userId, 'Primary Contact', 7, 1, @nowTime,0)
					END
			END
		END
	END
	ALL_DONE:
	-- Compute global quota flag before returning
	IF @enforceQuotaChanged = 1 OR @operationType = 2 -- Common.x OperationType_DELETE
	BEGIN
-- Update global quota check flag
-- Based on this JM and other subsystems decide whether or not to do a quota check.
DECLARE @newDoQuotaCheck INT = CASE WHEN @newEnforceFSQuotaValue > 0 THEN 1
									ELSE ISNULL((
												SELECT TOP 1 1
												FROM UMUsersProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'
												UNION
												SELECT TOP 1 1
												FROM UMGroupsProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'), 0)
									END
DECLARE @oldDoQuotaCheck INT = (SELECT CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'DoFSQuotaCheck' AND modified = 0)
DECLARE @quotaSetTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
-- Insert only if it gets enabled
IF @oldDoQuotaCheck IS NULL AND @newDoQuotaCheck = 1
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES('DoFSQuotaCheck', @newDoQuotaCheck, @quotaSetTime, 0)
END
ELSE IF @oldDoQuotaCheck <> @newDoQuotaCheck
BEGIN
	UPDATE GXGlobalParam
	SET value = @newDoQuotaCheck
	WHERE name = 'DoFSQuotaCheck'
	AND modified = 0
END
--
	END
	--Need to recompute the quota information for the users/groups getting removed/added. Insert 'ReComputeQuota' property in UmUsersProp table for the modified users.
	IF @recomputeQuota = 1
	BEGIN
		DECLARE @inXml XML
		SET @inXml = (SELECT @userId as '@id'
						FOR XML PATH ('userID'), ROOT('UserList')
					 )
		exec UpdateUserPropForQuota @inXml
	END
	INSERT INTO @responseTable VALUES(0,@o_errorString,@userId,@login,@userGuid, @o_warningMessage)
	--	FETCH NEXT FROM @Cur INTO @xmlText
	---		END--END cursor fetch loop
	--		DEALLOCATE @Cur
EXIT_ERROR:
IF OBJECT_ID('tempdb.dbo.#userGroupsThisUserCanModify') IS NOT NULL
				DROP TABLE #userGroupsThisUserCanModify
IF OBJECT_ID('tempdb.dbo.#userGroupsThisUserCanView') IS NOT NULL
				DROP TABLE #userGroupsThisUserCanView
 IF @o_errorCode <> 0
 BEGIN
 INSERT INTO @responseTable VALUES(@o_errorCode,@o_errorString,@userId,@login,@userGuid, @o_warningMessage)
 END
 IF @isReturnCursor <> 0
 SELECT
errorCode AS '@errorCode',
errorMessage AS '@errorString',
warningMessage AS '@warningMessage',
userId AS 'entity/@userId',
userName AS  'entity/@userName',
userGuid AS 'entity/@userGUID'
FROM @responseTable
FOR xml path('App_GenericEntityResponse')--, root('App_GenericResponse')
ELSE
	SET @xmlText = (SELECT
errorCode AS '@errorCode',
errorMessage AS '@errorString',
warningMessage AS '@warningMessage',
userId AS 'entity/@userId',
userName AS  'entity/@userName',
userGuid AS 'entity/@userGUID'
FROM @responseTable
FOR xml path('App_GenericEntityResponse'))--, root('App_GenericResponse'))
GO

IF EXISTS (select * from GxQscripts where name = 'sec_performUserOperation')
	delete from GxQscripts where name = 'sec_performUserOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_performUserOperation')
	delete from GXDBVersions where aliasname = 'sec_performUserOperation'
GO

insert into GXDBVersions values(2, 'sec_performUserOperation',  '00000000000000000000', 'sec_performUserOperation', '00000000000000000000')
GO

