

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_performUserGroupOperation.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  sec_performUserGroupOperation()
--  | Description:  Performs galaxy user group operations (ADD,DISABLE,UPDATE, ...)
--	|  Do clean the other properties once, complety migrate to 11.0
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_performUserGroupOperation.sp,v $ $Id: sec_performUserGroupOperation.sp,v 1.43.2.67.4.2 2021/03/30 22:19:05 nramalingam Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_performUserGroupOperation')
BEGIN
	print '>>> Drop Stored Procedure: sec_performUserGroupOperation <<<'
	drop procedure sec_performUserGroupOperation
END
IF EXISTS (select * from GxQscripts where name='sec_performUserGroupOperation')
	delete from GxQscripts where name = 'sec_performUserGroupOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_performUserGroupOperation')
	delete from GXDBVersions where aliasname = 'sec_performUserGroupOperation'
GO
print '... Creating Procedure: sec_performUserGroupOperation'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_performUserGroupOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_userId INT=0,
  @i_ccId INT=0,
  @i_localeId INT=-1,
  @i_xmlText XML OUTPUT,
  @i_operation INT,
  @isCmdLine INT = 0,
  @isSelectXML INT = 1
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML 
	SET @o_xmlText = '<App_GenericEntityResponse/>'
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @o_errorCode		INT = 0
	DECLARE @o_errorString		NVARCHAR(MAX) = ''
	DECLARE @i_grpId			INT
	DECLARE @i_grpName			NVARCHAR(MAX) = ''
	DECLARE @i_desc				NVARCHAR(MAX) = ''
	DECLARE @i_enabled			INT
	DECLARE @i_allCaps			INT
	DECLARE @i_allAssoc			INT
	DECLARE	@i_compUsers		NVARCHAR(MAX) = ''
	DECLARE	@i_compGrps			NVARCHAR(MAX) = ''
	DECLARE @i_userOp			INT
	DECLARE @i_externalUserGroupsOp INT
	DECLARE @i_capOp			INT
	DECLARE @i_assocOp			INT
	DECLARE @i_secAssocOp		INT
	DECLARE @userGroupRoleId 	INTEGER = 0
	declare @enforcequota		NVARCHAR(255)
	declare @boolenforcequota	INT
	declare @quotasize			INT
	DECLARE @enforceEdgeDriveQuota int
	DECLARE @edgeDriveQuotaLimitInGB int
	DECLARE @t_users			TABLE(userId int)
	DECLARE @t_Caps 			TABLE(capId int)
	DECLARE @t_userCaps			TABLE(userId INT, nodeCap bigint, childCap bigint)
	DECLARE @planId				int
    DECLARE @planOpType int
	DECLARE @i_email			NVARCHAR(MAX) = N''
	DECLARE @i_email_db		NVARCHAR(MAX) = N''
	DECLARE @inheritGroupQuotaSettings INT = 0
	DECLARE @i_GUIDStr			NVARCHAR(MAX) = N''
	DECLARE @localUserGroupOp		INT
	DECLARE @umdsProviderID			INT = 0
	DECLARE @umdsProviderDomainName NVARCHAR(MAX) = N''
	DECLARE @isOrganizationGroup		INT = 0
	DECLARE @preferenceMachineCentricClient INT
	DECLARE @agePasswordDays	int
	DECLARE @pswdHistoryCount	int
	DECLARE @i_newGrpName			NVARCHAR(MAX)
create table  #t_assocs ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	DECLARE @CDUserAndGroupListOperation			TABLE(returnCode int, errorString varchar(255), userName NVARCHAR(255), userGroupName NVARCHAR(255))
		DECLARE @errorTable TABLE (errorCode INT, errorString NVARCHAR(MAX))
		DECLARE @responseTable Table(errorCode int,
								errorMessage nvarchar(max),
								groupId int,
								groupName nvarchar(255),
								groupGuid uniqueidentifier)
	DECLARE @blackListed INT = -1
	DECLARE @localeId INT
	DECLARE @enforceQuotaChanged INT = 0
	DECLARE @newEnforceFSQuotaValue INT = 0
	DECLARE @recomputeQuota			INT = 0
	DECLARE @enableTFA INT = -1 --Don't know
	DECLARE @apiQuotaLimit INT
	DECLARE @apiQuotaTimeFrame INT
DECLARE @tenantgroupFlags INT = 0x10000
DECLARE @viewRoleID INT = ISNULL((SELECT TOP 1 id FROM UMRoles (NOLOCK) WHERE (name = 'View') AND (flags & 1 | 2 <> 0)), 0)
	DECLARE @primaryContactId int = 0
BEGIN TRY
BEGIN TRAN
DECLARE @isServiceCommcell INT = ISNULL((SELECT 1 FROM APP_commcellPRop where commcellId=2 and commcellType & 8<>0),0)
	IF OBJECT_ID('tempdb.dbo.#usersThisUserCanModify') IS NOT NULL
		DROP TABLE #usersThisUserCanModify
	CREATE TABLE #usersThisUserCanModify (userId INT)
	IF OBJECT_ID('tempdb.dbo.#externalGroupsThisUserCanModify') IS NOT NULL
		DROP TABLE #externalGroupsThisUserCanModify
	CREATE TABLE #externalGroupsThisUserCanModify (externalGroupId INT)
	DECLARE @inputUsersTbl TABLE (userId INT, userName NVARCHAR(MAX))
	DECLARE @addedUsersTbl TABLE (userId INT)
	DECLARE @deletedUsersTbl TABLE (userId INT)
	DECLARE @inputExternalGroupsTbl TABLE (externalGroupId INT, externalGroupName NVARCHAR(MAX))
	DECLARE @addedExternalGroupsTbl TABLE (externalGroupId INT)
	DECLARE @deletedExternalGroupsTbl TABLE (externalGroupId INT)
	--GET PARAM INPUTS
DECLARE @i_desc_db			NVARCHAR(MAX) = ''
	DECLARE @i_enabled_db			INT = 1
	DECLARE @i_allCaps_db			INT = 0
	DECLARE @i_allAssoc_db			INT = 0
	SET	@i_grpName = RTRIM(LTRIM(ISNULL((SELECT ref.value('@userGroupName', 'NVARCHAR(1024)')
		FROM @i_xmlText.nodes ('//App_GroupInfo/userGroupEntity') R(ref)), '')))
	SET	@i_newGrpName = RTRIM(LTRIM((SELECT ref.value('@newName', 'NVARCHAR(1024)')
		FROM @i_xmlText.nodes ('//App_GroupInfo/userGroupEntity') R(ref))))
	SET	@i_grpId = ISNULL((SELECT ref.value('@userGroupId', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo/userGroupEntity') R(ref)), 0)
	SET @localeId = ISNULL((SELECT ref.value('@localeId', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo/processinginstructioninfo') R(ref)), 0)
	SET @blackListed = ISNULL(@i_xmlText.value('(//App_GroupInfo/@isBlackListed)[1]', 'int'),-1)
	SET @i_GUIDStr = (SELECT GUID FROM UMGroups where id = @i_grpId)
	DECLARE  @csGUID  VARCHAR(256) = ISNULL((RTRIM(LTRIM(@i_xmlText.value('(//App_GroupInfo/userGroupEntity/entityInfo/@multiCommcellGuid)[1]', 'nvarchar(255)')))),'')
	DECLARE @requestcommcellId INT =2
	if(@csGUID<>'')
		SET  @requestcommcellId  = ISNULL((SELECT Top 1 id from APP_Commcell where csGuid=@csGUId),2)
	IF CHARINDEX('\', @i_grpName, 1) > 0
	BEGIN
		SET @umdsProviderDomainName = (SELECT SUBSTRING(@i_grpName, 1, CHARINDEX('\', @i_grpName)-1))
		SET @umdsProviderID = (SELECT TOP 1 id FROM UMDSProviders  WITH(NOLOCK)  WHERE domainName = @umdsProviderDomainName)
		SET @umdsProviderID= ISNULL((SELECT ref.value('@providerId', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo/provider') R(ref)), @umdsProviderID)
		IF @umdsProviderID IS NULL OR @umdsProviderID = 0
		BEGIN
SET @o_errorCode = (1779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (1779 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorString = REPLACE(@o_errorString, '^1%s', @i_grpName)
			GOTO EXIT_ERROR
		END
		SET @i_grpName = (SELECT SUBSTRING(@i_grpName, CHARINDEX('\', @i_grpName)+1, LEN(@i_grpName)))		--we need @i_grpName to be stripped for further processing.
IF ((SELECT serviceType FROM UMDSProviders WHERE id = @umdsProviderId) = 5)
			SET @isOrganizationGroup = 1
	END
	--if logged in user is a company user, company user should be able create group of it's company only
	 IF(@i_operation = 1)
	 BEGIN
		IF(@umdsProviderID IS NULL  OR @umdsProviderID = 0)
		BEGIN
			DECLARE @userUmdsProviderID INT  = (SELECT dbo.AppGetOrganizationForUser(@i_userId))
IF(@userUmdsProviderID>0 AND EXISTS (SELECT 1 FROM UMDSProviders WHERE id = @userUmdsProviderID AND ServiceType = 5))
			BEGIN
					SET @umdsProviderID = @userUmdsProviderID
					SET @isOrganizationGroup = 1
			END
		END
	END
	--If i_grpId is sent without i_grpName then get it from the DB
	--let us not re-set the name in that case.
	IF @i_grpName = '' AND @i_grpId > 0
	BEGIN
		SELECT @i_grpName = name, @umdsProviderID = umdsProviderId FROM UMGroups WHERE id = @i_grpId
IF ((SELECT serviceType FROM UMDSProviders WHERE id = @umdsProviderId) = 5)
			SET @isOrganizationGroup = 1
	END
	IF(@i_operation = 3)
	BEGIN
		IF(@i_newGrpName is not null)--For backward compatibility set the new name to user group name. Admin Console and Command line will use newName to give new name of the user group.
			BEGIN
				SET @i_grpName = @i_newGrpName
				IF CHARINDEX('\', @i_grpName, 1) > 0
				BEGIN
					SET @i_grpName = (SELECT SUBSTRING(@i_grpName, CHARINDEX('\', @i_grpName)+1, LEN(@i_grpName)))		--we need @i_grpName to be stripped for further processing.
				END
			END
	END
		--verify properties for master group cannot be modified
		IF(@i_operation = 3 and @i_grpId = (dbo.GetMasterGroupID()) and
		 (1 <> @i_xmlText.value('(/App_GroupInfo/@enabled)[1]','INT')
or (select description from UMGroups where groupFlags&0x0008=0x0008) <> @i_xmlText.value('(/App_GroupInfo/@description)[1]','NVARCHAR(MAX)')
or (select name from UMGroups where groupFlags&0x0008=0x0008) <> @i_grpName
		 or 1 <> @i_xmlText.value('(/App_GroupInfo/@allCapabilities)[1]','INT')
		 or 1 <>  @i_xmlText.value('(/App_GroupInfo/@allAssociations)[1]', 'INT')
		 or @i_xmlText.exist('/App_GroupInfo/@capabilities') = 1
		 or @i_xmlText.exist('/App_GroupInfo/@associations') = 1))
		 BEGIN
			SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2534 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s','Master')
			GOTO EXIT_ERROR
		END
		--verify properties for view all group
	IF(@i_operation=3 and @i_grpId=(select id from UMgroups where name ='View All') and
	  ((1 <> @i_xmlText.value('(/App_GroupInfo/@enabled)[1]','INT')
	    or N'View All' <> @i_grpName
	    or 1 <>  @i_xmlText.value('(/App_GroupInfo/@allAssociations)[1]', 'INT')
		or @i_xmlText.exist('/App_GroupInfo/@associations') = 1)
	    or N'Members of this group can see all Commcell Objects, regardless of (other) group associations' <> @i_xmlText.value('(/App_GroupInfo/@description)[1]','NVARCHAR(MAX)')
	 ))
	 BEGIN
		SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2534 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
		SET @o_errorString = REPLACE(@o_errorString, '^1%s','View All')
		GOTO EXIT_ERROR
	 END
	IF(@i_grpId = dbo.GetMasterGroupID() AND @i_operation=2) --DO NOT ALLOW TO DELETE MASTER GROUP
	BEGIN
		SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2535 | (CAST(POWER(2, 24) AS BIGINT) * 35))    AND localeId = @localeId)
		SET @o_errorString = REPLACE(@o_errorString, '^1%s','Master')
		GOTO EXIT_ERROR
	END
	IF(@i_operation=2 ) --DO NOT ALLOW TO DELETE MASTER GROUP OR TENANT ADMIN GROUP OR GROUP ASSOCIATED TO PLAN
	BEGIN
		DECLARE @groupFlags INTEGER =(SELECT groupFlags FROM UMGroups WHERE id=@i_grpId )
IF(@groupFlags&0x8000 <>0)
		BEGIN
			SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2535 | (CAST(POWER(2, 24) AS BIGINT) * 35))    AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT name from UMgroups where id=@i_grpId))
			GOTO EXIT_ERROR
		END
IF (@groupFlags & 0x10000 <> 0)
OR (@groupFlags & 0x40000 <> 0)
		BEGIN
			DECLARE @CompanyName nvarchar(255) =''
			SELECT @CompanyName=hostName FROM UMGroups g WITH (NOLOCK)
			INNER JOIN UMDSProviders u WITH (NOLOCK) ON u.id = g.umdsProviderId
			WHERE g.id=@i_grpId
SET @o_errorCode = (3394 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3394 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT name from UMgroups where id=@i_grpId))
			SET @o_errorString = REPLACE(@o_errorString, '^2%s',@CompanyName)
			GOTO EXIT_ERROR
		END
IF(@groupFlags&536870912 <>0)
		BEGIN
			DECLARE @planName NVARCHAR(255) = (SELECT TOP 1 P.name
                                               FROM         App_Plan     P  WITH(nolock)
                                               INNER JOIN   App_PlanProp PP WITH(nolock) ON     P.id = PP.componentNameId
                                                                                           AND PP.attrVal  = CAST(@i_grpId AS VARCHAR(32))
AND PP.attrName = 'Assigned user group'
                                                                                           AND PP.modified = 0)
            IF NOT @planName IS NULL
            BEGIN
SET @o_errorCode = (3395 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3395 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			    SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT name from UMgroups where id=@i_grpId))
			    SET @o_errorString = REPLACE(@o_errorString, '^2%s',@planName)
			    GOTO EXIT_ERROR
            END
		END
	END
	IF ( @i_operation = 2  OR @i_operation = 3)
	BEGIN
		IF(NOT EXISTS(SELECT 1 FROM UMGroups WHERE id = @i_grpId))
		BEGIN
SET @o_errorCode = (2536 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2536 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',@i_grpName)
			GOTO EXIT_ERROR
		END
	END
	IF (@i_operation = 3)
		SELECT @i_desc_db=description, @i_enabled_db=groupFlags,@i_allCaps_db=allCapabilities,@i_allAssoc_db=allAssociations, @i_email_db=email FROM UMGroups WHERE id = @i_grpId
	SET	@i_desc = ISNULL((SELECT ref.value('@description', 'NVARCHAR(1024)')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), @i_desc_db)
	SET	@i_enabled = ISNULL((SELECT ref.value('@enabled', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), @i_enabled_db)
	SET	@i_allCaps = ISNULL((SELECT ref.value('@allCapabilities', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), @i_allCaps_db)
	SET	@i_allAssoc = ISNULL((SELECT ref.value('@allAssociations', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), @i_allAssoc_db)
	SET	@i_compUsers = ISNULL((SELECT ref.value('@complianceDelegationUsers', 'NVARCHAR(1024)')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), '')
	SET	@i_compGrps = ISNULL((SELECT ref.value('@complianceDelegationUserGroups', 'NVARCHAR(1024)')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), '')
	SET	@i_userOp = ISNULL((SELECT ref.value('@usersOperationType', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), 2)
	SET	@i_externalUserGroupsOp = ISNULL((SELECT ref.value('@externalUserGroupsOperationType', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), 2)
	SET	@i_capOp = ISNULL((SELECT ref.value('@capabilitiesOperationType', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), 2)
	SET	@i_assocOp = ISNULL((SELECT ref.value('@associationsOperationType', 'INT')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), 2)
	set @i_secAssocOp = ISNULL((SELECT ref.value('@associationsOperationType','INT')
									from @i_xmlText.nodes('//App_GroupInfo/securityAssociations') R(ref)),0)
	SET @i_email = ISNULL((SELECT ref.value('@email', 'NVARCHAR(1024)')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), @i_email_db)
	SET @i_GUIDStr = ISNULL((SELECT ref.value('@GUID', 'NVARCHAR(1024)')
									FROM @i_xmlText.nodes ('//App_GroupInfo') R(ref)), NEWID())				--this will be honored only during CREATE
	SET @inheritGroupQuotaSettings = (SELECT ref.value('@inheritGroupQuotaSettings','INT')
					   FROM @i_xmlText.nodes('//App_GroupInfo') R(ref))
	SET @enforcequota=(SELECT ref.value('@enforceFSQuota','varchar(256)')
					   FROM @i_xmlText.nodes('//App_GroupInfo') R(ref))
    SET @quotasize=(SELECT ref.value('@quotaLimitInGB','INT')
					   FROM @i_xmlText.nodes('//App_GroupInfo') R(ref))
	SET @enforceEdgeDriveQuota=@i_xmlText.value('(//App_GroupInfo/@enforceEdgeDriveQuota)[1]', 'int')
	SET @edgeDriveQuotaLimitInGB=@i_xmlText.value('(//App_GroupInfo/@edgeDriveQuotaLimitInGB)[1]', 'int')
	SET @planId=(SELECT ref.value('@planId','int')
					   FROM @i_xmlText.nodes('//App_GroupInfo/plan') R(ref))
    SET @planOpType = @i_xmlText.value('(//App_GroupInfo/@planOperationType)[1]', 'INT')
   	SET @preferenceMachineCentricClient=(SELECT ref.value('@preferenceMachineCentricClient','INT')
					   FROM @i_xmlText.nodes('//App_GroupInfo') R(ref))
   SET @agePasswordDays=(SELECT ref.value('@agePasswordDays','int')
					   FROM @i_xmlText.nodes('//App_GroupInfo') R(ref))
   SET @pswdHistoryCount=(SELECT ref.value('@pswdHistoryCount','int')
					   FROM @i_xmlText.nodes('//App_GroupInfo') R(ref))
	SET @enableTFA =ISNULL((SELECT ref.value('@enableTwoFactorAuthentication','int')
					   FROM @i_xmlText.nodes('//App_GroupInfo') R(ref)),-1)
  	SET @apiQuotaLimit = @i_xmlText.value('(//App_GroupInfo/apiQuota/@APILimit)[1]', 'int')
	SET @apiQuotaTimeFrame = @i_xmlText.value('(//App_GroupInfo/apiQuota/@APItimeFrame)[1]', 'int')
	IF(@i_secAssocOp<>0)
	BEGIN
		--new security XML blob is present, so we wont support old one anymore
		print 'New Security XML is present,so old one is not supported'
		SET @i_capOp=0
		SET @i_assocOp=0
	END
IF(@i_operation = 2) --for delete operation type set list operation type as overwrite to delete the associations
BEGIN
	--SET @i_userOp = 1
	SET @i_capOp = 1
	SET	@i_assocOp = 1
END
	-- Set recompute quota based on operationType
	IF (@i_operation = 1 /*add*/ AND (@inheritGroupQuotaSettings = 1 OR @enforcequota = 1)) -- For Add check if quota is being set
		OR @i_operation = 2 /*delete*/
		OR (@i_operation = 3 /*update*/AND
@enforcequota <> ISNULL((SELECT attrVal FROM UMGroupsProp WITH(NOLOCK) WHERE componentNameId = @i_grpId AND attrName = 'Enforce quota' AND modified = 0), 0)
		   )
OR (@quotasize <> ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp WITH(NOLOCK) WHERE componentNameId = @i_grpId AND attrName = 'Quota size' AND modified = 0), 0)
			AND @enforcequota = 1)
		SET @recomputeQuota = 1
	INSERT INTO @t_Caps
	SELECT ref.value('@capability', 'INT')
		FROM @i_xmlText.nodes ('//App_GroupInfo/capabilities') R(ref)
	-- Get associations from the input
	-- Possible entity types supported for groups are:
		-- CommCell
		-- Client groups
		-- Clients hierarchy (IDA, Instance, Backup Set, Sub Client)
		-- Libraries
		-- Media agents
		-- Storage policies
		-- Vault tracker policies
		--check for valid entities. Error out if the entity name is incorrect:
		IF @i_allCaps = 0 --do this when all capabilities is set to false
		BEGIN
		DECLARE @tempxmlText xml
		DECLARE @Cur CURSOR
		SET @Cur = CURSOR
		FOR	(SELECT T.c.query('.') FROM @i_xmlText.nodes('//App_GroupInfo/associations') T(c))
		OPEN @Cur
		FETCH NEXT FROM @Cur INTO @tempxmlText
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF( (1 <> @tempxmlText.exist('/associations/@clientId') AND 1 = @tempxmlText.exist('/associations/@clientName'))
			or (1 <> @tempxmlText.exist('/associations/@commCellId') AND 1 = @tempxmlText.exist('/associations/@commCellName'))
			or (1 <> @tempxmlText.exist('/associations/@clientGroupId') AND 1 = @tempxmlText.exist('/associations/@clientGroupName'))
			or (1 <> @tempxmlText.exist('/associations/@applicationId') AND 1 = @tempxmlText.exist('/associations/@appName'))
			or (1 <> @tempxmlText.exist('/associations/@instanceId') AND 1 = @tempxmlText.exist('/associations/@instanceName'))
			or (1 <> @tempxmlText.exist('/associations/@backupsetId') AND 1 = @tempxmlText.exist('/associations/@backupsetName'))
			or (1 <> @tempxmlText.exist('/associations/@subclientId') AND 1 = @tempxmlText.exist('/associations/@subclientName'))
			or (1 <> @tempxmlText.exist('/associations/@mediaAgentId') AND 1 = @tempxmlText.exist('/associations/@mediaAgentName'))
			or (1 <> @tempxmlText.exist('/associations/@libraryId') AND 1 = @tempxmlText.exist('/associations/@libraryName'))
			or (1 <> @tempxmlText.exist('/associations/@storagePolicyId') AND 1 = @tempxmlText.exist('/associations/@storagePolicyName'))
			or (1 <> @tempxmlText.exist('/associations/@trackingPolicyId') AND 1 = @tempxmlText.exist('/associations/@trackingPolicyName'))
			)
			BEGIN
				SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2538 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				GOTO EXIT_ERROR
			END
			FETCH NEXT FROM @Cur INTO @tempxmlText
		END--END cursor fetch loop
		DEALLOCATE @Cur
		END
	INSERT INTO #t_assocs
	SELECT 	0, -- Capabilities
			0, -- flag
			ISNULL(ref.value('@commCellId', 'INT'), 0), -- CommCellId
			ISNULL(ref.value('@clientGroupId', 'INT'), 0), -- ClientGroupId
			ISNULL(ref.value('@clientId', 'INT'), 0), -- ClientId
			ISNULL(ref.value('@applicationId', 'INT'), 0), -- AppTypeId
			ISNULL(ref.value('@instanceId', 'INT'), 0), -- instanceId
			ISNULL(ref.value('@backupsetId', 'INT'), 0), -- backupSetId
			ISNULL(ref.value('@subclientId', 'INT'), 0), -- subclientId
			ISNULL(ref.value('@mediaAgentId', 'INT'), 0), -- mediaAgentId
			ISNULL(ref.value('@libraryId', 'INT'), 0), -- libraryId
			ISNULL(ref.value('@storagePolicyId', 'INT'), 0), -- storagePolicyId
			0, -- vtContainerId
			ISNULL(ref.value('@trackingPolicyId', 'INT'), 0), -- vtPolicyId
			0, -- vtShelfId
			0, -- reviewSetId
			0, -- querySetId
			0, -- downloadSetId
			0, -- ermId
			0, -- legalHoldId
			0, -- tagId
			0, -- cdPolicyId
			0, -- complianceReportId
			0, --task id
                	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0,
                  	0
		FROM @i_xmlText.nodes ('//App_GroupInfo/associations') R(ref)
	--Perform user capability check
	IF (dbo.isNewSecurity() = 0)
	BEGIN
		INSERT INTO @t_userCaps
EXEC dbo.sec_NoNiDaNodeAccess @i_userId, @i_ccId, 2018, @i_ccId
IF(0 = ISNULL((SELECT nodeCap & CAST(POWER(2.0, 14-1) AS bigint) FROM @t_userCaps), 0))
		BEGIN
			SET @o_errorCode = 1
			SET @o_errorString = 'User does not have rights to perform this operation.'
			GOTO EXIT_ERROR
		END
	END
	ELSE
	BEGIN
		DECLARE @hasRights AS INT
		SET @hasRights = 0
		IF (@i_operation = 1)			--Add
		BEGIN
			IF @umdsProviderID = 0
			BEGIN
EXEC sec_userHasCapability @i_userId,0,@hasRights OUTPUT,0,0,102
				IF @hasRights = 0
				BEGIN
SET @o_errorCode=(2493 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2493 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@i_userId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
					GOTO EXIT_ERROR
				END
			END
			ELSE
			BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 102, @hasRights OUTPUT, 61, @umdsProviderID			--use macro.
				IF @hasRights = 0
				BEGIN
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@i_userId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
					IF(@umdsProviderID > 0 AND @umdsProviderDomainName  = '')
						SELECT @umdsProviderDomainName=domainName FROM UMDSProviders WHERE ID=@umdsProviderID
					SET @o_errorString = REPLACE(@o_errorString, '^3%s', @umdsProviderDomainName)
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2377 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
			END
			IF (@requestcommcellId > 2 AND @i_grpId > 0)
			BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 102, @hasRights OUTPUT, 15, @i_grpId
				IF(@hasRights=0)
				BEGIN
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
					SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@i_userId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
					SET @o_errorString = REPLACE(@o_errorString, '^3%s',@i_grpName)
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
					GOTO EXIT_ERROR
				END
			END
		END
		ELSE							--overwrite and delete
		BEGIN
EXEC sec_checkPermissionOnEntity @i_userId, 102, @hasRights OUTPUT, 15, @i_grpId
			IF(@hasRights=0)
			BEGIN
SET @o_errorCode=(2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2409 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT CASE WHEN name <> '' THEN name ELSE login END FROM UMUsers where id=@i_userId))
SET @o_errorString = REPLACE(@o_errorString, '^2%s', dbo.sec_getLocalizedPermission(102, @localeId))
				SET @o_errorString = REPLACE(@o_errorString, '^3%s',@i_grpName)
SET @o_errorString = REPLACE(@o_errorString, '^4%s',(SELECT message FROM EvLocaleMsgs WHERE messageId = (2547 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId))
				GOTO EXIT_ERROR
			END
		END
	END
	--Perform the operation
	-- Perform operation type check
	IF (@i_operation > 3)
	BEGIN
		SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (1884 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
		GOTO EXIT_ERROR
	END
	-- Delete user group information from all tables except UMGroups for delete AND MODIFY operation
	IF ( @i_operation = 2  OR @i_operation = 3)
	BEGIN
		IF(NOT EXISTS(SELECT 1 FROM UMGroups WHERE id = @i_grpId))
		BEGIN
SET @o_errorCode = (2536 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2536 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',@i_grpName)
			GOTO EXIT_ERROR
		END
		IF @i_assocOp = 1
		BEGIN
			-- Remove associted entities
			delete UMGroupAssociation WHERE groupId = @i_grpId
		END
		IF (@i_operation = 2)
		BEGIN
			-- Remove associted users
			delete UMUserGroup WHERE groupId = @i_grpId
				DELETE FROM UMDSGroupMaps WHERE umdsGroupId = @i_grpId
				DELETE FROM UMDSUSerGroup where groupId=@i_grpId
				DELETE FROM UMDSGroupMaps WHERE umgroupId = @i_grpId
		END
		IF @i_capOp = 1
		BEGIN
			-- Remove associted capabilities
			delete UMGroupCapability WHERE groupId = @i_grpId
		END
		IF @i_capOp = 3
		BEGIN
			-- Remove associted users
			delete UMGroupCapability WHERE groupId = @i_grpId AND capabilityId in (select capId From @t_Caps)
		END
	END
	-- Remove emtry from UMGroups only for delete operation
	IF ( @i_operation = 2 ) -- delete
	BEGIN
		delete NTnotificationGroups where groupId=@i_grpId
		-- Ownership transfer.
		IF ((@i_XMLText.exist('//App_GroupInfo/transferInfo/newUser') = 1) OR (@i_XMLText.exist('//App_GroupInfo/transferInfo/newUserGroup') = 1))
		BEGIN
			DECLARE @ownerTransferXml XML = @i_XMLText.query('//App_GroupInfo/transferInfo')
			EXEC sec_transferUserOwnerShip  @ownerTransferXml,			-- Transfer XML input
											@i_userId,					-- callerId
											@localeId,
											0,							-- doReturn
											0,							-- oldOwnerId (userId)
											@i_grpId,
											@o_errorCode OUTPUT,
											@o_errorString OUTPUT
			IF(@o_errorCode<>0)
				GOTO EXIT_ERROR
		END
		/*ELSE				-- Waiting on GUI changes. Once they are done will make this mandatory.
		BEGIN
			IF NOT EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bEnableMandatoryTransferOfOwnership' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'false' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
			BEGIN
SET @o_errorCode = (3496 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3496 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				GOTO EXIT_ERROR
			END
		END*/
		-- Remove CreateAs user ID
		-- We need to transfer ownership before removing from security associations table. So moving code above.
DECLARE @createAsUserID INT = (SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = N'Create As User' AND modified = 0)
		IF @createAsUserID IS NOT NULL AND @createAsUserID <> 0 AND EXISTS (SELECT 1 FROM UMUsers WHERE id = @createAsUserID)		--if accidentally that hidden user is already deleted then no need to call delete user request
		BEGIN
			DECLARE @deleteUserXML XML = (SELECT
												(SELECT @createAsUserId AS '@userId',
13 AS '@_type_'
												 FOR XML PATH ('userEntity'), TYPE)
											 FOR XML PATH ('App_UserInfo'))
EXEC sec_performUserOperation 1, 2, @deleteUserXML OUTPUT, 2, 0, 0, 0, '', '', 0, 0					--DEFAULT_COMMCELL_ID hardcoded, 2 stands for Common::Operation_Delete
		END
		DELETE UMSecurityAssociations WHERE isUser = 0 AND userOrGroupId = @i_grpId
		DELETE UMOwners WHERE isUser = 0 AND userOrGroupId = @i_grpId
EXEC sec_deleteSecurityAssociationsForEntity 15, @i_grpId
		SET @userGroupRoleId= ISNULL((SELECT CAST(attrVal as integer)
									 FROM UMgroupsProp
WHERE attrName='SystemCreatedRole_' and componentNameId=@i_grpId),0)
		if(@userGroupRoleId<>0)
		BEGIN
			DECLARE @roleXML XML= (SELECT @userGroupRoleId as '@roleId'
										FOR XML PATH('role'),
										ROOT ('Security_Role'))
exec sec_DeleteRole @roleXML ,1,0,1, 0
			DECLARE @errorXML XML= @roleXML
			IF(@errorXML.exist('App_GenericEntityResponse')=1)
				SET @o_errorCode = (ISNULL((SELECT @errorXML.value('(App_GenericEntityResponse/@errorcode)[1]' ,'int')),0))
			IF(@o_errorCode<>0)
			BEGIN
				SET @o_errorString =(SELECT @errorXML.value('(App_GenericEntityResponse/@errorString)[1]','varchar(1024)'))
				GOTO EXIT_ERROR
			END
		END
		-- Reseller delete: If this user group is set as operator of any company, remove that property.
DELETE FROM APP_CompanyProp WHERE attrName = 'Operator User Group Id' AND attrVal = CAST(@i_grpId AS NVARCHAR(MAX)) AND cs_attrName=checksum('Operator User Group Id')
		DELETE FROM UMOperators WHERE isUser = 0 AND userOrGroupId = @i_grpId
		-- Remove group
		DELETE UMGroupsProp where componentNameId=@i_grpId
		IF @umdsProviderID = 0
			delete UMGroups WHERE id = @i_grpId
		ELSE
		BEGIN
			-- ad or org groups will be stored in umgroups and UMDSGroups. umgroups will be used for reading while UMDSGroups is for legacy reasons.
			-- It is okay to prune rows on AD groups, tenant groups deletion as suggested with Jagadeesh and Nipa.
			delete NTnotificationExternalGroups where externalGroupId=@i_grpId
			delete UMDSGroups WHERE id = @i_grpID
			delete UMGroups WHERE id = @i_grpID -- good practice to delete UMGroups at last.
		END
		GOTO RETURN_PROC --All done. Lets return.
	END
		-- For MODIFY update entry in UMGroups
	IF ( @i_operation = 3 )	-- MODIFY
	BEGIN
		IF @umdsProviderID = 0 OR @isOrganizationGroup = 1
		BEGIN
			--If there is another user group with same name and within same domain then fail.
			IF(EXISTS(SELECT * FROM UMGroups WHERE name = @i_grpName AND id <> @i_grpId AND umdsProviderId = @umdsProviderID))
			BEGIN
SET @o_errorCode = (2540 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2540 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@i_grpName)
				GOTO EXIT_ERROR
			END
		END
		IF @umdsProviderID <> 0 AND @isOrganizationGroup = 0
		BEGIN
			--For AD groups we cannot change name once created.
			IF @i_grpName <> (SELECT name FROM UMGroups WHERE id = @i_grpID)
			BEGIN
SET @o_errorCode = (3099 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3099 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				GOTO EXIT_ERROR
			END
		END
		IF @blackListed >= 0
		BEGIN
			IF @blackListed = 1
			BEGIN
				IF ISNULL(NULLIF(@i_desc, ''), @i_desc) = ''
				BEGIN
SET @i_desc = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3711 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
				END
				UPDATE UMGroups SET
[groupFlags] = (groupFlags | CAST(0x20000 as integer))
				   ,[description] = @i_desc
				FROM UMGroups
					WHERE id = @i_grpId
SET	@i_enabled = (@i_enabled | CAST(0x20000 as integer))
			END
			ELSE
			BEGIN
				UPDATE UMGroups SET
[groupFlags] = (groupFlags& ~CAST(0x20000 as integer))
				FROM UMGroups
					WHERE id = @i_grpId
SET @i_enabled = (@i_enabled & ~CAST(0x20000 as integer))
			END
		END
		-- Update table row
		UPDATE UMGroups SET
[groupFlags] = (groupFlags& ~CAST(0x0001 as integer)|@i_enabled)
           ,[allCapabilities] = @i_allCaps
           ,[allAssociations] = @i_allAssoc
           ,[selfAssociation] = 1
           ,[name] = @i_grpName
           ,[description] = @i_desc
           ,[origCCId] = @i_ccId
		   ,[email] = CASE WHEN @umdsProviderId = 0 OR @isOrganizationGroup = 1 THEN @i_email ELSE email END			--for AD groups do not update email
		FROM UMGroups
			WHERE id = @i_grpId
		IF @umdsProviderID <> 0
		BEGIN
			UPDATE UMDSGroups
			SET [name] = CASE WHEN @isOrganizationGroup = 0 THEN name ELSE @i_grpName END			--Allow name change only for Organization groups
				,[description] = @i_desc
				,[email] = CASE WHEN @isOrganizationGroup = 1 THEN @i_email ELSE email END				--for AD groups do not update email
			FROM UMDSGroups
			WHERE id = @i_grpId
		END
		--Plan.Plan operation type should be specified in the request. We only support add a user to a plan or delete a user from a plan
		IF((@planId IS NOT NULL AND @planId >0) AND (@planOpType IS not null AND (@planOpType=3 OR  @planOpType=2)))
		BEGIN
		    DECLARE @AssociateGroupToPlan XML = N'<Api_UpdatePlanReq>
                <summary>
                    <plan planId="' + cast (@planId as nvarchar) +'" />
                </summary>
                <laptop>
                       <users userOperationType="' + cast (@planOpType as nvarchar) +'">
                        <users>
                            <userGroup userGroupId="' + cast (@i_grpId as nvarchar) +'" />
                        </users>
                    </users>
                 </laptop>
            </Api_UpdatePlanReq>'
        EXEC[dbo].[AppPlanUpdateV2] @i_userId, @localeId, @AssociateGroupToPlan output
        DECLARE @planErrorcode int =  (select @AssociateGroupToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorCode)[1]', 'int'))
        IF(@planErrorcode is not null and @planErrorcode > 0)
        BEGIN
            DECLARE @planErrorMsg nvarchar(max) =  (select @AssociateGroupToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorMessage)[1]', 'nvarchar(max)'))
  	        SET @o_errorCode = @planErrorcode
            SET @o_errorString = @planErrorMsg
            GOTO EXIT_ERROR
        END
	END
		--Age Password In Days
		IF(@agePasswordDays IS NOT NULL AND
@agePasswordDays <> isnull((SELECT attrVal FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Age Password in Days' and modified=0),0))
		BEGIN
IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId and attrName = 'Age Password in Days')
DELETE UMGroupsProp WHERE componentNameId = @i_grpId and attrName = 'Age Password in Days'
			INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_grpId, 'Age Password in Days', 7, @agePasswordDays, dbo.GetUnixTime(GETUTCDATE()) ,0)
		END
		--Password History
		IF(@pswdHistoryCount IS NOT NULL)
		BEGIN
IF EXISTS(SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Password History Count' AND modified=0)
				UPDATE UMGroupsProp SET attrVal = @pswdHistoryCount, created = dbo.GetUnixTime(GETUTCDATE())
WHERE componentNameId = @i_grpId AND attrName = 'Password History Count' AND modified = 0
			ELSE
				INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_grpId, 'Password History Count', 7, @pswdHistoryCount, dbo.GetUnixTime(GETUTCDATE()) ,0)
		END
	END
	-- For ADD create new entry in UMGroups
	IF ( @i_operation = 1 )	--ADD
	BEGIN
		--Duplicate check.
		IF @umdsProviderID = 0
		BEGIN
			IF(EXISTS(SELECT 1 FROM UMGroups WHERE name = @i_grpName and umdsProviderId = 0))
			BEGIN
				SET @i_GUIDStr = (SELECT GUID FROM UMGroups WHERE name = @i_grpName and umdsProviderId = 0)
SET @o_errorCode = (2540 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2540 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@i_grpName)
				GOTO EXIT_ERROR
			END
		END
		ELSE
		BEGIN
IF EXISTS (SELECT 1 FROM UMGroups WHERE name = @i_grpName AND umdsProviderID = @umdsProviderID AND ((groupFlags & 0x0001 <> 0) AND (groupFlags & 0x0020 = 0)))		--use macro for 0x001 and 0x0020
			BEGIN
SET @o_errorCode = (2540 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @i_GUIDStr = (SELECT GUID FROM UMGroups WHERE name = @i_grpName AND umdsProviderID = @umdsProviderID)
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2540 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',@i_grpName)
				GOTO EXIT_ERROR
			END
		END
		IF (@i_grpName = '')
        BEGIN
            SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2926 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
            GOTO EXIT_ERROR
        END
		-- Insert table row
		IF @umdsProviderID = 0
		BEGIN
		INSERT INTO UMGroups
           ([groupFlags]
           ,[allCapabilities]
           ,[allAssociations]
           ,[selfAssociation]
           ,[name]
           ,[description]
           ,[origCCId]
           ,[GUID])
	     VALUES
			(@i_enabled
			,@i_allCaps
			,@i_allAssoc
			,1
			,@i_grpName
			,@i_desc
			,@i_ccId
			,@i_GUIDStr)
		END
		ELSE
		BEGIN
			-- If external group resides already deleted/Hidden (happens in case of V10 groups that are not member of local groups) then update it
			IF EXISTS (SELECT 1 FROM UMGRoups WHERE name = @i_grpName AND umdsProviderId = @umdsProviderID)
			BEGIN
				UPDATE UMGroups
SET groupFlags = (groupFlags | 0x0001) & ~ CAST(0x0020 AS INT), email = @i_email, GUID = @i_GUIDStr			--might be GUID changed? Let's put what we got from input. In case if it is an organization user group getting recreated, it would have got new GUID.
				WHERE name = @i_grpName AND umdsProviderId = @umdsProviderID
			END
			ELSE
			BEGIN
				INSERT INTO UMGroups (groupFlags, allCapabilities, allAssociations, selfAssociation, name, description, email, GUID, umdsProviderId, origCCId)
					SELECT @i_enabled /*this is default*/, 0, 0, 1, /*these are not applicable for external groups*/ @i_grpName, @i_desc, @i_email, @i_GUIDStr, @umdsProviderID, @i_ccId
			END
			IF EXISTS (SELECT 1 FROM UMDSGroups WHERE name = @i_grpName AND umdsProviderId = @umdsProviderID)
			BEGIN
				UPDATE UMDSGroups
				SET enabled = 1, email = @i_email
				WHERE name = @i_grpName AND umdsProviderId = @umdsProviderID
			END
			ELSE
			BEGIN
				DECLARE @umdsGroupId INT = (SELECT id FROM UMGroups WHERE name = @i_grpName AND umdsProviderId = @umdsProviderID)
				INSERT INTO UMDSGroups (id, name, umdsProviderId, enabled, description, email, lastCredSetTime, oldId)
					SELECT @umdsGroupId, @i_grpName, @umdsProviderID, @i_enabled, @i_desc, @i_email, 0, 0
			END
		END
		SET @i_grpId = (SELECT id FROM UMGroups WHERE name = @i_grpName AND umdsProviderId = @umdsProviderID)
		DECLARE @roleId INTEGER =0
		SET @roleId =ISNULL((SELECT id
								FROM UMRoles
WHERE flags & 1 | 2 <> 0 and name = 'UserManagement_Owner'),0)
EXEC sec_setCreatorForEntity @i_userId, @roleId, '', @o_errorCode OUTPUT, @o_errorString OUTPUT, 15, @i_grpId
		--Plan.Plan operation type should be specified in the request. We only support add a user to a plan or delete a user from a plan
		IF((@planId IS NOT NULL AND @planId >0) AND (@planOpType IS not null AND (@planOpType=3 OR  @planOpType=2)))
		BEGIN
		    DECLARE @AssociateNewGroupToPlan XML = N'<Api_UpdatePlanReq>
                <summary>
                    <plan planId="' + cast (@planId as nvarchar) +'" />
                </summary>
                <laptop>
                      <users userOperationType="' + cast (@planOpType as nvarchar) +'">
                        <users>
                            <userGroup userGroupId="' + cast (@i_grpId as nvarchar) +'" />
                        </users>
                    </users>
                 </laptop>
            </Api_UpdatePlanReq>'
        EXEC[dbo].[AppPlanUpdateV2] @i_userId, @localeId, @AssociateNewGroupToPlan output
        DECLARE @planGroupErrorcode int =  (select @AssociateNewGroupToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorCode)[1]', 'int'))
        IF(@planGroupErrorcode is not null and @planGroupErrorcode > 0)
        BEGIN
            DECLARE @planGroupErrorMsg nvarchar(max) =  (select @AssociateNewGroupToPlan.value('(//Api_PlanComponentErrorList/error/status/@errorMessage)[1]', 'nvarchar(max)'))
  	        SET @o_errorCode = @planGroupErrorcode
            SET @o_errorString = @planGroupErrorMsg
            GOTO EXIT_ERROR
        END
	END
		if @agePasswordDays IS NOT NULL
		BEGIN
		 --Existing hidden AD groups also can be re discovered using CREATE protocol. We should not end up writing these properties twice in these cases.
IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId and attrName = 'Age Password in Days')
DELETE UMGroupsProp WHERE componentNameId = @i_grpId and attrName = 'Age Password in Days'
INSERT INTO UMGroupsProp VALUES (@i_grpId,'Age Password in Days',7,@agePasswordDays,dbo.GetUnixTime(GETUTCDATE()),0)
		END
		IF @pswdHistoryCount IS NOT NULL
		BEGIN
IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Password History Count' AND modified = 0)
				UPDATE UMGroupsProp  SET attrVal = @pswdHistoryCount, created = dbo.GetUnixTime(GETUTCDATE())
WHERE componentNameId = @i_grpId AND attrName = 'Password History Count' AND modified = 0
			ELSE
				INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_grpId, 'Password History Count', 7, @pswdHistoryCount, dbo.GetUnixTime(GETUTCDATE()), 0)
		END
	END
	IF ( @i_operation = 1 OR @i_operation = 3 )
	BEGIN
		--handling default values
		--for CREATE user group if value is not specified then assume the default values
		IF @i_operation = 1
		BEGIN
			IF @enforcequota IS NULL
				SET @enforcequota = '0'
			IF @quotasize IS NULL
				SET @quotasize = '100'
			IF (@inheritGroupQuotaSettings IS NULL AND @umdsProviderID <> 0)
				SET @inheritGroupQuotaSettings = '1'
			IF @edgeDriveQuotaLimitInGB IS NULL
				SET @edgeDriveQuotaLimitInGB = 100
		IF @enforceEdgeDriveQuota IS NULL
				SET @enforceEdgeDriveQuota = 0
			IF @apiQuotaLimit IS NULL
			   SET @apiQuotaLimit = 0
			IF @apiQuotaTimeFrame IS NULL
				SET @apiQuotaTimeFrame = 0
		END
		--for EDIT case if the values are not specified then get them from DB
		ELSE
		BEGIN
			IF @enforceQuota IS NULL
SET @enforcequota = ISNULL((SELECT attrVal FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Enforce quota' AND modified = 0), 0)
			IF @quotaSize IS NULL
SET @quotasize = ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Quota size' AND modified = 0), 100)
			IF (@inheritGroupQuotaSettings IS NULL AND @umdsProviderID <> 0)
				SET @inheritGroupQuotaSettings = ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Inherit Group Quota Settings' AND modified = 0), 100)
			IF @enforceEdgeDriveQuota IS NULL
SET @enforceEdgeDriveQuota = ISNULL((SELECT attrVal FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Enforce Edge Drive Quota' AND modified = 0), 0)
		IF @edgeDriveQuotaLimitInGB IS NULL
SET @edgeDriveQuotaLimitInGB = ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Edge Drive Quota Size' AND modified = 0), 100)
			IF @apiQuotaLimit IS NULL
SET @apiQuotaLimit = ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'API Quota Limit' AND modified = 0), 0)
			IF @apiQuotaTimeFrame IS NULL
SET @apiQuotaTimeFrame = ISNULL((SELECT CAST(attrVal AS INT) FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'API Quota Time Frame' AND modified = 0), 0)
		END
		if (@enforcequota = 'true' or @enforcequota = '1')
			set @boolenforcequota = 1
		else
			set @boolenforcequota = 0
	IF (@enforcequota is not null and @quotasize is not null )
     BEGIN
DELETE FROM UMGroupsProp WHERE componentNameId = @i_grpId AND (attrName = 'Enforce quota' OR attrName = 'Quota size')
INSERT INTO UMGroupsProp VALUES (@i_grpId,'Enforce quota',7,@boolenforcequota,dbo.GetUnixTime(GETUTCDATE()),0)
INSERT INTO UMGroupsProp VALUES (@i_grpId,'Quota size',7,@quotasize,dbo.GetUnixTime(GETUTCDATE()),0)
			 SET @enforceQuotaChanged = 1
			 SET @newEnforceFSQuotaValue = @boolenforcequota
    END
	DECLARE @nowTime integer = dbo.GetUnixTime (GetUTCdate())
IF(@enforceEdgeDriveQuota IS NOT NULL AND ((NOT EXISTS(SELECT CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName='Enforce Edge Drive Quota' and modified=0) OR @enforceEdgeDriveQuota<> (SELECT Top 1 CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId  AND attrName='Enforce Edge Drive Quota' and modified=0))))
	BEGIN
IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId  and attrName = 'Enforce Edge Drive Quota' and modified=0)
DELETE UMGroupsProp WHERE componentNameId = @i_grpId  and attrName = 'Enforce Edge Drive Quota'
			INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_grpId, 'Enforce Edge Drive Quota', 7, @enforceEdgeDriveQuota, @nowTime ,0)
	END
IF(@edgeDriveQuotaLimitInGB IS NOT NULL AND (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId  AND attrName='Edge Drive Quota Size' and modified=0) OR  @edgeDriveQuotaLimitInGB <>(SELECT Top 1 CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId  AND attrName='Edge Drive Quota Size' and modified=0)))
	BEGIN
IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId  and attrName = 'Edge Drive Quota Size' and modified=0)
DELETE UMGroupsProp WHERE componentNameId = @i_grpId and attrName = 'Edge Drive Quota Size'
			INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_grpId, 'Edge Drive Quota Size', 7, @edgeDriveQuotaLimitInGB, @nowTime ,0)
	END
IF(@apiQuotaLimit IS NOT NULL AND (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId  AND attrName='API Quota Limit' and modified=0) OR  @apiQuotaLimit <>(SELECT Top 1 CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId  AND attrName='API Quota Limit' and modified=0)))
	BEGIN
IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId  and attrName = 'API Quota Limit' and modified=0)
DELETE UMGroupsProp WHERE componentNameId = @i_grpId and attrName = 'API Quota Limit'
			INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_grpId, 'API Quota Limit', 7, @apiQuotaLimit, @nowTime ,0)
	END
IF(@apiQuotaTimeFrame IS NOT NULL AND (NOT EXISTS (SELECT CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId  AND attrName='API Quota Time Frame' and modified=0) OR  @apiQuotaTimeFrame <>(SELECT Top 1 CONVERT(INT,attrVal) FROM UMGroupsProp WHERE componentNameId = @i_grpId  AND attrName='API Quota Time Frame' and modified=0)))
	BEGIN
IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId  and attrName = 'API Quota Time Frame' and modified=0)
DELETE UMGroupsProp WHERE componentNameId = @i_grpId and attrName = 'API Quota Time Frame'
			INSERT INTO UMGroupsProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES (@i_grpId, 'API Quota Time Frame', 7, @apiQuotaTimeFrame, @nowTime ,0)
	END
	-- Begin TFA
	DECLARE @companyId INTEGER = ISNULL(dbo.AppGetCompanyForUserOrUserGroup(@i_grpId,0),0)
	DECLARE @enableTFACompany INT
	-- GET COMMCELL/COMPANY LEVEL TFA SETTING
	IF (@companyId <> 0)
		BEGIN
			SET @enableTFACompany = ISNULL((select Convert(int, attrval) from App_CompanyProp
													WITH (NOLOCK) where attrname = 'EnableTwoFactorAuthentication'
and componentNameId = @companyId AND cs_attrName=checksum('EnableTwoFactorAuthentication')), 0)
		END
	ELSE -- Commcell User
		BEGIN
			SET @enableTFACompany = ISNULL((select Convert(int, value) from GxGlobalParam WITH (NOLOCK)
													where Name = 'EnableTwoFactorAuthentication'
), 0)
		END
	-- IF PROPERTY OF 'DisableTwoFactorAuthentication' IS NOT SET FOR THIS USER GROUP AND TFA MODE IS NOT ENABLED WITH USER GROUP INCLUSION
	-- THEN GET THE TFA SETTING FROM USER GROUPS PROVIDER AS ITS TFA SETTING
IF (@enableTFA IS NULL OR @enableTFA = -1) AND (@enableTFACompany <> 2)
	BEGIN
		SET @enableTFA = @enableTFACompany
	END
	--Set TFA during Add and Modify
	IF @enableTFA IS NOT NULL AND @enableTFA <> -1
	BEGIN
		UPDATE UMGroupsProp
		SET attrval = @enableTFA ^ 1
WHERE attrname = 'DisableTwoFactorAuthentication' and componentNameId = @i_grpId
		IF @@ROWCOUNT = 0
		BEGIN
INSERT INTO UMGroupsProp VALUES (@i_grpId,'DisableTwoFactorAuthentication' ,7, (@enableTFA ^ 1), @nowTime, 0)
		END
	END
	-- End TFA
	MERGE   UMGroupsProp AS TGT
		USING   (VALUES (@i_grpId)) AS SRC (clientId)
ON      TGT.componentNameId = SRC.clientId and TGT.attrName = 'Prefer Machine Centric Client' AND TGT.attrType = 7
		WHEN    MATCHED AND @preferenceMachineCentricClient IS NOT NULL
			THEN UPDATE SET
				TGT.attrVal = @preferenceMachineCentricClient
		WHEN    NOT MATCHED AND @preferenceMachineCentricClient IS NOT NULL
			THEN INSERT (componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(SRC.clientId, 'Prefer Machine Centric Client', 7, @preferenceMachineCentricClient, dbo.GetUnixTime (GetUTCdate()), 0);
		IF ( @i_capOp =1 OR @i_capOp =2 )
		BEGIN
			-- Insert associated capabilities
				INSERT INTO UMGroupCapability ([groupId], [capabilityId], [flag])
				SELECT  @i_grpId as groupid,capId as capid, 0 as flag
				FROM @t_Caps  WHERE capId IS NOT null AND  capId not in(select [capabilityId] from UMGroupCapability WHERE groupId = @i_grpId)
		END
		--only if key is there
		--dont set any thing for master and view all in backward compatibility even if the input has some blobs
		--in V10, we cannot configure associations and capabilities for master and view all groups from user group properties panel
		IF(dbo.isNewSecurity()<>0 AND @i_grpId NOT IN (SELECT id FROM UMGroups WHERE name IN ('master', 'View All')))
		BEGIN
			IF(@i_secAssocOp=0)
			BEGIN
				--old xml UMgroupAssociation and UMGroupCapability is already populated. Populate UMSecurityAssociations now.
				IF (((@i_capOp = 2)	AND (@i_allCaps = @i_allCaps_db) AND NOT EXISTS (SELECT 1 FROM @t_Caps))
					 AND
					 ((@i_assocOp = 2) AND (@i_allAssoc = @i_allAssoc_db) AND NOT EXISTS (SELECT 1 FROM #t_assocs)))
				BEGIN
					--dont call this backward compatibility block in this case. we have just filled capoperationtype and associationoperationtype as ADD and no input is given.
					--this happens when we are creating / editing a user group from GUI - and if there is no change in security associations blob, then GUI does not fill in
					--capabilities and associations but fills only the operation type. But it does not fill securityassociationsoperationtype. so we will get securityassociationsoperationtype
					--as 0 and capabilityoperationtype and associationoperationtype as ADD respectively.
					GOTO END_OF_BACKWARD_COMPATIBILITY
				END
				IF(@i_capOp<>0 OR @i_assocop<>0)
				BEGIN
SET @userGroupRoleId = (SELECT attrVal from UMGroupsProp WHERE componentNameId=@i_grpId and attrName='SystemCreatedRole_' and modified=0 )
					IF @i_capOp<>0 OR @userGroupRoleId IS NULL OR @userGroupRoleId = 0 OR NOT EXISTS (SELECT 1 FROM UMRoles WHERE id = @userGroupRoleId)
					BEGIN
						EXEC sec_UpgradeUMGroupCapability @i_grpId,@userGroupRoleId OUTPUT,@o_errorCode  OUTPUT,@o_errorString OUTPUT,0
						IF(@o_errorCode<>0)
						BEGIN
							GOTO EXIT_ERROR
						END
					END
				END
				IF(@i_assocop<>0)
				BEGIN
SET @userGroupRoleId =(SELECT attrVal from UMGroupsProp WHERE componentNameId=@i_grpId and attrName='SystemCreatedRole_' and modified=0 )
					DECLARE @setOldSecurityAssociationXML XML
					IF (@i_operation = 1)				--if we are creating a new user group, then dont overwrite the already created associations, so hard-coding the operation type as "Add"
						SET @i_assocop = 2			--Add
					SET @setOldSecurityAssociationXML=(SELECT @i_assocop as '@associationsOperationType',
															  @localeId AS 'processinginstructioninfo/@localeId',
															(SELECT(SELECT ( SELECT 120 as '@type',@userGroupRoleId as '@roleId'
																				FOR XML PATH('role'),TYPE)
																	FOR XML PATH('properties'),TYPE ),
																 (select @i_xmlText.query('element entities {
																							for $n in App_GroupInfo/associations
																							 return element entity {$n/@*}}'))
																		FOR XML PATH ('associations'),TYPE)
														FOR XML PATH('App_SecurityAssociationForUserOrGroupList'))
					INSERT INTO @errorTable
						EXEC sec_setSecurityAssociationsFromUserOrUserGroup @setOldSecurityAssociationXML, @i_userId, 0, @i_grpId, 0
					SET @o_errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
					SET @o_errorString = (SELECT TOP 1 errorString FROM @errorTable)
					IF @o_errorCode <> 0
						GOTO EXIT_ERROR
				END
				IF(@i_allAssoc <> @i_allAssoc_db)
				BEGIN
					DECLARE @allAssociationsoperationTYpe INT = 0
					IF @i_allAssoc = 0 AND @i_allAssoc_db = 1
						SET @allAssociationsoperationTYpe = 3		--delete
					ELSE
						SET @allAssociationsoperationTYpe = 2		--add
					SET @setOldSecurityAssociationXML=(SELECT @allAssociationsoperationTYpe as '@associationsOperationType',  --ADD
															  @localeId AS 'processinginstructioninfo/@localeId',
															(SELECT(SELECT ( SELECT 120 as '@type',@userGroupRoleId as '@roleId'
																				FOR XML PATH('role'),TYPE)
																	FOR XML PATH('properties'),TYPE ),
																 (SELECT(	SELECT 2 as '@commCellId' ,
																					1 as '@_type_'
																			FOR XML PATH('entity') ,TYPE)
																	FOR XML PATH('entities') ,TYPE)
															FOR XML PATH ('associations'),TYPE)
														FOR XML PATH('App_SecurityAssociationForUserOrGroupList'))
					DELETE FROM @errorTable
					INSERT INTO @errorTable
							EXEC sec_setSecurityAssociationsFromUserOrUserGroup @setOldSecurityAssociationXML, @i_userId, 0, @i_grpId, 0
					SET @o_errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
					SET @o_errorString = (SELECT TOP 1 errorString FROM @errorTable)
					IF @o_errorCode <> 0
						GOTO EXIT_ERROR
				END
			END
		END
		END_OF_BACKWARD_COMPATIBILITY:
			--Check if user is coming from remote\service  CS
		BEGIN
			IF(@requestcommcellId <>2)  --DEFAULT_COMMCELL_ID
			BEGIN
			  --give view right on service commcell
exec sec_insertSecurityAssociation @i_userId,@viewRoleID,0,0,@i_grpId,@o_errorCode OUTPUT,@o_errorString OUTPUT,194,@requestcommcellId
			   IF @o_errorCode <> 0
				GOTO EXIT_ERROR
			END
		END
		IF(@i_secAssocOp<>0)
		BEGIN
			DECLARE @sec_assOptype INTEGER
			DECLARE @xml1 XML
			SET @sec_assOptype =(SELECT ref.value('@associationsOperationType','int') from @i_xmlText.nodes('App_GroupInfo/securityAssociations') R(ref))
			IF (@i_operation = 1)				--if we are creating a new user group, then dont overwrite the already created associations, so hard-coding the operation type as "Add"
						SET @sec_assOptype = 2			--Add
			SET @xml1 =(SELECT @sec_assOptype as '@associationsOperationType',
							   @localeId AS 'processinginstructioninfo/@localeId',
							(SELECT @i_xmlText.query('App_GroupInfo/securityAssociations/associations'))
				FOR XML PATH ('App_SecurityAssociationForUserOrGroupList'))
			INSERT INTO @errorTable
				EXEC sec_setSecurityAssociationsFromUserOrUserGroup @xml1, @i_userId, 0, @i_grpId, 0
			SET @o_errorCode = (SELECT TOP 1 errorCode FROM @errorTable)
			SET @o_errorString = (SELECT TOP 1 errorString FROM @errorTable)
			IF @o_errorCode <> 0
				GOTO EXIT_ERROR
		END
		IF ( @i_operation = 1 OR @i_assocOp =1 OR @i_assocOp =2 OR @i_assocOp =3)
		BEGIN
		-- delete the entities when list operation type delete AND Insert associated entities when list operation type is add/overwrite
----------------------------------------------------
			IF(@i_assocOp <> 1)
			BEGIN
				delete grpassociation FROM  UMGroupAssociation grpassociation
				JOIN #t_assocs temp on grpassociation.id1 = temp.clientId AND grpassociation.id2 = temp.appTypeId
				AND grpassociation.id3 = temp.backupsetId AND grpassociation.id4 = temp.subClientId
				WHERE  subClientId <> 0 AND backupsetId <> 0 AND appTypeId <> 0 AND clientId <> 0 AND groupId = @i_grpId
AND type1 = 2009 AND type2 = 2230 AND type3 = 2012 AND type4 = 2013
			END
			-- Insert sub client associations first
			IF(@i_assocOp <> 3)
				INSERT INTO UMGroupAssociation
					(groupId,
						type1,
						id1,
						type2,
						id2,
						type3,
						id3,
						type4,
						id4,
						flag)
					SELECT @i_grpId,
2009,
						clientId,
2230,
						appTypeId,
2012,
						backupsetId,
2013,
						subClientId,
						0
					FROM #t_assocs
						WHERE subClientId <> 0
							AND backupsetId <> 0
							AND appTypeId <> 0
							AND clientId <> 0
			delete #t_assocs
				WHERE subClientId <> 0
				AND backupsetId <> 0
				AND appTypeId <> 0
				AND clientId <> 0
	-- delete sub client associations first
			IF(@i_assocOp <> 1)
			BEGIN
				delete grpassociation FROM  UMGroupAssociation grpassociation
				JOIN #t_assocs temp on grpassociation.id1 = temp.clientId AND grpassociation.id2 = temp.appTypeId
				AND grpassociation.id3 = temp.backupsetId AND temp.subClientId =0
				WHERE  backupsetId <> 0 AND appTypeId <> 0 AND clientId <> 0 AND groupId = @i_grpId
AND type1 = 2009 AND type2 = 2230 AND type3 = 2012 AND type4 = 0
			END
		-- Insert backup set associations next
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
2009,
			clientId,
2230,
			appTypeId,
2012,
			backupsetId,
			0,
			0,
			0
		FROM #t_assocs
			WHERE backupsetId <> 0
				AND appTypeId <> 0
				AND clientId <> 0
		delete #t_assocs
			WHERE backupsetId <> 0
				AND appTypeId <> 0
				AND clientId <> 0
		-- As of now association at instance level is not allowed from GUI
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.clientId AND grpassociation.id2 = temp.appTypeId
			AND grpassociation.id3 = temp.backupsetId AND temp.subClientId =0
			WHERE appTypeId <> 0 AND clientId <> 0 AND groupId = @i_grpId
AND type1 = 2009 AND type2 = 2230 AND type3 = 0 AND type4 = 0
		END
		-- Insert app type associations next
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
2009,
			clientId,
2230,
			appTypeId,
			0,
			0,
			0,
			0,
			0
		FROM #t_assocs
			WHERE appTypeId <> 0
				AND clientId <> 0
		delete #t_assocs
			WHERE appTypeId <> 0
				AND clientId <> 0
			-- Insert client associations next
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.clientId AND grpassociation.id2 = 0
			AND grpassociation.id3 = 0 AND temp.subClientId =0
			WHERE clientId <> 0 AND groupId = @i_grpId
AND type1 = 2009 AND type2 = 0 AND type3 = 0 AND type4 = 0
		END
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
2009,
			clientId,
			0,
			0,
			0,
			0,
			0,
			0,
			0
		FROM #t_assocs
WHERE clientId <> 0 AND clientId not in(select clientId from UMGroupAssociation WHERE groupId = @i_grpId AND type1 = 2009
			AND id1 = #t_assocs.clientId AND type2 = 0 AND id2 = 0 AND type3 = 0 AND id3 = 0 AND type4 = 0 AND id4 = 0)
		delete #t_assocs
			WHERE clientId <> 0
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.libraryId
WHERE libraryId <> 0 AND groupId = @i_grpId AND type1 = 2049
		END
		-- Insert library associations next
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
2049,
			libraryId,
			0,
			0,
			0,
			0,
			0,
			0,
			0
		FROM #t_assocs
			WHERE libraryId <> 0
		delete #t_assocs
				WHERE libraryId <> 0
			-- Insert media agent associations next
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.mediaAgentId
WHERE mediaAgentId <> 0 AND groupId = @i_grpId AND type1 = 2048
		END
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
2048,
			mediaAgentId,
			0,
			0,
			0,
			0,
			0,
			0,
			0
		FROM #t_assocs
			WHERE mediaAgentId <> 0
		delete #t_assocs
				WHERE mediaAgentId <> 0
		--client group
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.clientGroupId
WHERE clientGroupId <> 0 AND groupId = @i_grpId AND type1 = 2572
		END
		IF(@i_assocOp <> 3)
				INSERT INTO UMGroupAssociation
				(groupId,
				type1,
				id1,
				type2,
				id2,
				type3,
				id3,
				type4,
				id4,
				flag)
			SELECT @i_grpId,
2572,
				clientGroupId,
				0,
				0,
				0,
				0,
				0,
				0,
				0
			FROM #t_assocs
				WHERE clientGroupId <> 0
		delete #t_assocs
				WHERE clientGroupId <> 0
			-- Insert storage policy associations next
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.archGroupId
WHERE archGroupId <> 0 AND groupId = @i_grpId AND type1 = 2231
		END
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
2231,
			archGroupId,
			0,
			0,
			0,
			0,
			0,
			0,
			0
		FROM #t_assocs
			WHERE archGroupId <> 0
		delete #t_assocs
			WHERE archGroupId <> 0
			-- Insert vault tracker policy associations next
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.vtPolicyId
WHERE vtPolicyId <> 0 AND groupId = @i_grpId AND type1 = 8462
		END
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
8462,
			vtPolicyId,
			0,
			0,
			0,
			0,
			0,
			0,
			0
		FROM #t_assocs
			WHERE vtPolicyId <> 0
		delete #t_assocs
				WHERE vtPolicyId <> 0
		-- Insert commCell associations next
		IF(@i_assocOp <> 1)
		BEGIN
			delete grpassociation FROM  UMGroupAssociation grpassociation
			JOIN #t_assocs temp on grpassociation.id1 = temp.commCellId
			WHERE commCellId <> 0
				AND clientId = 0
				AND instanceId = 0
				AND backupsetId = 0
AND subClientId = 0 AND groupId = @i_grpId AND type1 = 2018
		END
		IF(@i_assocOp <> 3)
		INSERT INTO UMGroupAssociation
			(groupId,
			type1,
			id1,
			type2,
			id2,
			type3,
			id3,
			type4,
			id4,
			flag)
		SELECT @i_grpId,
2018,
			commCellId,
			0,
			0,
			0,
			0,
			0,
			0,
			0
		FROM #t_assocs
			WHERE commCellId <> 0
				AND clientId = 0
				AND instanceId = 0
				AND backupsetId = 0
				AND subClientId = 0
	END
--		delete #t_assocs
--			WHERE commCellId <> 0
--				AND clientId = 0
--				AND instanceId = 0
--				AND backupsetId = 0
--				AND subClientId = 0
--------------------------------------------------
END
--Moved user-user group associations after setting security tab for user group
--Why to handle case where
-- caller user adding himself to group, Group has view capability on some entities but caller user didn't.
-- In 11.0 security, caller cant see those entites, so GUI wont send them back. We will check  caller user has  rights on entity as he is member of group, but GUI didn't send us, so they will be treated as deleted by caller user
-- Add user group information in all other tables.
--We cannot add users manually any other AD groups other than organization
DECLARE @shouldProcessMemberUsers INT = 1
IF @umdsProviderID <> 0 AND @isOrganizationGroup = 0
BEGIN
	--We need to error out ideally. Will make that change later.
	SET @shouldProcessMemberUsers = 0
END
IF @shouldProcessMemberUsers = 1
BEGIN
	INSERT INTO @inputUsersTbl (userId, userName)
			SELECT T.c.value('(@userId)[1]','INT'), T.c.value('(@userName)[1]', 'NVARCHAR(MAX)')
			FROM @i_xmlText.nodes('//App_GroupInfo/users') T(c)
	DELETE FROM @inputUsersTbl WHERE (userId IS NULL) AND (userName IS NULL)			--when the input XML contains only <users/>, an empty blob, userID and userName will be filled as NULL
																						--We can neither consider this as an error scenario, nor try to insert the value into DB
	/*Sanity checks*/
	IF EXISTS (SELECT 1 FROM @inputUsersTbl WHERE (userId <= 0) OR (userId IS NULL))
	BEGIN
SET @o_errorCode = (2427 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
		SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT TOP 1 userName
														 	 FROM @inputUsersTbl
															 WHERE (userId <= 0) OR (userId IS NULL)))
		GOTO EXIT_ERROR
	END
	--We cannot add users of another organization to this organization user group.
	IF @umdsProviderID <> 0
	BEGIN
		DECLARE @providerTable TABLE (id INT)
		;WITH tblChild AS
		(
			SELECT id FROM UMDSProviders WHERE ownerCompany = @umdsProviderID
			UNION ALL
			SELECT UMDSProviders.id FROM UMDSProviders INNER JOIN tblChild ON UMDSProviders.ownerCompany = tblChild.id
		)
		INSERT INTO @providerTable SELECT id FROM tblChild UNION SELECT @umdsProviderID
		OPTION (MAXRECURSION 32767)
		IF EXISTS (SELECT 1 FROM UMUsers WHERE umdsProviderID NOT IN (SELECT id FROM @providerTable) AND id IN (SELECT userId FROM @inputUsersTbl))
		BEGIN
SET @o_errorCode = (3098 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3098 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
			GOTO EXIT_ERROR
		END
	END
	EXEC sec_getUsersForThisUser '#usersThisUserCanModify', @i_userId, 1
	IF (@i_operation = 1)			--Add new user group, so all users will be added to it
	BEGIN
		IF ((dbo.isNewSecurity() = 1) AND
			EXISTS (SELECT 1 FROM @inputUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)))
		BEGIN
			SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @inputUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)) ))
			GOTO EXIT_ERROR
		END
		INSERT INTO UMUserGroup (userId, groupId, flag)
			SELECT userId, @i_grpId, 0
			FROM @inputUsersTbl
	END
	ELSE IF (@i_operation = 3)			--modify user group, check for users associated to this user group
	BEGIN
		IF (@i_userop = 2)			--add the new user associations
		BEGIN
			IF(@isServiceCommcell =1 and EXISTS (SELECT 1 FROM @inputUsersTbl))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @inputUsersTbl) ))
				GOTO EXIT_ERROR
			END
			IF ((dbo.isNewSecurity() = 1) AND
				EXISTS (SELECT 1 FROM @inputUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @inputUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)) ))
				GOTO EXIT_ERROR
			END
			--add primary contact property for first user added
			IF EXISTS(SELECT id FROM umgroups WHERE id = @i_grpId and groupFlags & @tenantgroupFlags  <> 0 ) AND
NOT EXISTS(	SELECT TOP 1 UG.groupId FROM UMUserGroup UG INNER JOIN UMUsers u ON u.id = UG.userId AND  flags & 0x001 <> 0  wHERE UG.groupId=@i_grpId
					 )
			BEGIN
				SET @primaryContactId  = (SELECT TOP 1 userId FROM @inputUsersTbl)
IF NOT EXISTS(SELECT 1 FROM  UMUsersProp WHERE componentNameId=@primaryContactId AND attrName = 'Primary Contact' AND modified=0 AND cs_attrName = CHECKSUM(N'Primary Contact'))
					BEGIN
						INSERT INTO UMUsersProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@primaryContactId, 'Primary Contact', 7, 1, @nowTime,0)
					END
			END
			INSERT INTO UMUserGroup (userId, groupId, flag)
				SELECT userId, @i_grpId, 0
				FROM @inputUsersTbl
				EXCEPT
				SELECT userId, @i_grpId, 0
				FROM UMUserGroup
				WHERE groupId = @i_grpId
		END
		ELSE IF (@i_userOp = 3)		--delete the given user-group assocaitions
		BEGIN
			IF(@isServiceCommcell =1 and EXISTS (SELECT 1 FROM @inputUsersTbl))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @inputUsersTbl) ))
				GOTO EXIT_ERROR
			END
			IF ((dbo.isNewSecurity() = 1) AND
				EXISTS (SELECT * FROM @inputUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @inputUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify))))
				GOTO EXIT_ERROR
			END
			--verify first that protected user is not removed.
if(@i_grpId = dbo.GetMasterGroupID() and Exists (select * from @inputUsersTbl where userId in (SELECT id FROM UMUsers where (flags & CAST (0x040 AS INT)) = CAST(0x040 AS INT))))	BEGIN
				SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2539 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT TOP 1 login FROM UMUsers WHERE id in (SELECT  userId from @deletedUsersTbl) and (flags & CAST (0x040 AS INT)) = CAST(0x040 AS INT)))
				GOTO EXIT_ERROR
			END
			IF EXISTS(SELECT id  FROM umgroups WHERE id = @i_grpId and groupFlags & @tenantgroupFlags <> 0 ) AND
				NOT EXISTS(SELECT TOP 1 uug.groupId  FROM UMUserGroup uug
INNER JOIN umusers u ON u.id=uug.userId AND u.flags & 0x800 = 0
						LEFT JOIN @inputUsersTbl Tbl ON Tbl.userId=uug.userId
						WHERE groupId=@i_grpId  AND tbl.userId is null
					 )
			BEGIN
					--Cannot remove user from Tenant Admin group. At lease one user should be in this group.
SET @o_errorCode = (3630 | (CAST(POWER(2, 24) AS BIGINT) * 35))
                    SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
                    GOTO EXIT_ERROR
			END
			--remove primary contact property  the user removed from tenant admin group
			DELETE up
					FROM UMUsersProp up
					INNER JOIN @inputUsersTbl  tbl ON Tbl.userId=up.componentnameid
					INNER JOIN umusergroup ug ON Tbl.userId = ug.userId
					INNER JOIN UMGroups u ON u.id = ug.groupId
WHERE u.id = @i_grpId and u.groupFlags & @tenantgroupFlags  <> 0 AND up.componentNameId=Tbl.userId AND up.attrName='Primary Contact' AND up.cs_attrName = CHECKSUM(N'Primary Contact')
			DELETE UserGroup
			FROM UMUserGroup UserGroup INNER JOIN @inputUsersTbl Tbl
			ON UserGroup.groupId = @i_grpId AND UserGroup.userId = Tbl.userId
		END
		ELSE IF (@i_userOp = 1)		--overwrite
		BEGIN
			INSERT INTO @addedUsersTbl (userId)
				SELECT userId
				FROM @inputUsersTbl
				EXCEPT
				SELECT UserGroup.userid
				FROM UMUserGroup UserGroup
				WHERE UserGroup.groupId = @i_grpId
			IF ((dbo.isNewSecurity() = 1) AND
				EXISTS (SELECT * FROM @addedUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @addedUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)) ))
				GOTO EXIT_ERROR
			END
			INSERT INTO @deletedUsersTbl(userId)
				SELECT Groups.userId
				FROM UMUserGroup Groups
				WHERE Groups.groupId = @i_grpId
						AND (Groups.userId NOT IN (SELECT userId
													FROM @inputUsersTbl))
if(@i_grpId = dbo.GetMasterGroupID() and Exists (select * from @deletedUsersTbl where userId in (SELECT id FROM UMUsers where (flags & CAST (0x040 AS INT)) = CAST(0x040 AS INT))))	BEGIN
				SET @o_errorCode = 1
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2539 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT TOP 1 login FROM UMUsers WHERE id in (SELECT  userId from @deletedUsersTbl) and (flags & CAST (0x040 AS INT)) = CAST(0x040 AS INT)))
				GOTO EXIT_ERROR
			END
			IF EXISTS (SELECT 1 FROM @deletedUsersTbl)
			BEGIN
				--there is a chance that @deletedUsersTbl contains hidden users. We cannot do security checks on hidden users. We need to ignore them
				IF OBJECT_ID ('tempdb.dbo.#usersThisUserCanView') IS NOT NULL
					DROP TABLE #usersThisUserCanView
				CREATE TABLE #usersThisUserCanView (userID INT)
				EXEC sec_getUsersForThisUser '#usersThisUserCanView', @i_userId
				--@deletedUsersTbl is DB - Input. If there is an entry in @deletedUsersTbl that is not present in #usersThisUserCanView, logged in user is not trying to
				--remove them explicitly. So dont touch them.
				DELETE Del
				FROM @deletedUsersTbl Del
				WHERE NOT EXISTS (SELECT 1 FROM #usersThisUserCanView WHERE userID = Del.userID)
				IF OBJECT_ID ('tempdb.dbo.#usersThisUserCanView') IS NOT NULL
					DROP TABLE #usersThisUserCanView
			END
			IF ((dbo.isNewSecurity() = 1) AND
				EXISTS (SELECT * FROM @deletedUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)))
			BEGIN
				SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2541 | (CAST(POWER(2, 24) AS BIGINT) * 35))   AND localeId = @localeId)
				SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT login FROM UMUsers WHERE id = (SELECT TOP 1 userId FROM @deletedUsersTbl WHERE userId NOT IN (SELECT userId FROM #usersThisUserCanModify)) ))
				GOTO EXIT_ERROR
			END
			IF(@isServiceCommcell =1 AND EXISTS (SELECT userId FROM @addedusersTbl UNION SELECT userID FROM @deletedUsersTbl ))
			BEGIN
				SET @o_errorCode = 2
				SET @o_errorString = 'Can not add users to user group on service commcell'
				GOTO EXIT_ERROR
			END
			--add primary contact property for first user added
			IF EXISTS(SELECT id FROM umgroups WHERE id = @i_grpId and groupFlags & @tenantgroupFlags  <> 0 ) AND
NOT EXISTS(	SELECT TOP 1 UG.groupId FROM UMUserGroup UG INNER JOIN UMUsers u ON u.id = UG.userId AND  flags & 0x001 <> 0 wHERE UG.groupId=@i_grpId
					 )
			BEGIN
				SET @primaryContactId  = (SELECT TOP 1 userId FROM @addedUsersTbl)
IF NOT EXISTS(SELECT 1 FROM  UMUsersProp WHERE componentNameId=@primaryContactId AND attrName = 'Primary Contact' AND modified=0 AND cs_attrName = CHECKSUM(N'Primary Contact'))
					BEGIN
						INSERT INTO UMUsersProp(componentNameId,attrName,attrType,attrVal,created,modified)
VALUES(@primaryContactId, 'Primary Contact', 7, 1, @nowTime,0)
					END
			END
			INSERT INTO UMUserGroup (userId, groupId, flag)
				SELECT userId, @i_grpId, 0
				FROM @addedUsersTbl
			--remove primary contact property  the user removed from tenant admin group
			DELETE up
					FROM UMUsersProp up
					INNER JOIN @deletedUsersTbl  tbl ON Tbl.userId=up.componentnameid
					INNER JOIN umusergroup ug ON Tbl.userId = ug.userId
					INNER JOIN UMGroups u ON u.id = ug.groupId
WHERE u.id = @i_grpId and u.groupFlags & @tenantgroupFlags  <> 0 AND up.componentNameId=Tbl.userId AND up.attrName='Primary Contact' AND up.cs_attrName = CHECKSUM(N'Primary Contact')
			DELETE UserGroup
			FROM UMUserGroup UserGroup INNER JOIN @deletedUsersTbl Tbl
			ON UserGroup.groupId = @i_grpId AND UserGroup.userId = Tbl.userId
				IF EXISTS(SELECT id  FROM umgroups WHERE id = @i_grpId and groupFlags & @tenantgroupFlags  <> 0 ) AND
					NOT EXISTS(	SELECT TOP 1 UUG.groupId
						FROM UMUserGroup UUG
						LEFT JOIN @deletedUsersTbl Tbl ON Tbl.userId=uug.userId
						WHERE UUG.groupId=@i_grpId AND tbl.userId is null
					 )
			BEGIN
					--Cannot remove user from Tenant Admin group. At lease one user should be in this group.
SET @o_errorCode = (3630 | (CAST(POWER(2, 24) AS BIGINT) * 35))
                    SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
                    GOTO EXIT_ERROR
			END
		END
	END
END
--Handling of external groups
--From v11, we dont allow mapping of external groups to local groups. Unless a console setting is enabled
IF @umdsProviderID = 0
BEGIN
	INSERT INTO @inputExternalGroupsTbl (externalGroupId, externalGroupName)
		SELECT T.c.value('(@groupId)[1]','INT'), T.c.value('(@externalGroupName)[1]', 'NVARCHAR(MAX)')
		FROM @i_xmlText.nodes('//App_GroupInfo/externalUserGroups') T(c)
		UNION
		SELECT T.c.value('(@userGroupId)[1]','INT'), T.c.value('(@userGroupName)[1]', 'NVARCHAR(MAX)')
		FROM @i_xmlText.nodes('//App_GroupInfo/associatedExternalUserGroups') T(c)
	UPDATE @inputExternalGroupsTbl
	SET externalGroupName = SUBSTRING(externalGroupName, CHARINDEX('\', externalGroupName, 1)+1, LEN(externalGroupName))
	WHERE CHARINDEX('\', externalGroupName, 1) > 0
	DELETE FROM @inputExternalGroupsTbl WHERE (externalGroupId IS NULL) AND (externalGroupName IS NULL)
	/*Sanity check*/
	IF EXISTS (SELECT 1
			   FROM @inputExternalGroupsTbl
			   WHERE (externalGroupId <= 0) OR (externalGroupId IS NULL))
	BEGIN
SET @o_errorCode = (2429 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
		SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT TOP 1 externalGroupName
														 	 FROM @inputExternalGroupsTbl
															 WHERE (externalGroupId <= 0) OR (externalGroupId IS NULL)))
		GOTO EXIT_ERROR
	END
	--Frame added and deleted tables
	IF (@i_operation = 1)			--Add new user group, so all external groups will be added to it irrespective of external group operation type
	BEGIN
		INSERT INTO @addedExternalGroupsTbl (externalGroupId)
			SELECT externalGroupId
			FROM @inputExternalGroupsTbl
	END
	ELSE 	 IF(@i_operation=3) --Modify
	BEGIN
		--overwrite
		--added = input - DB, deleted = DB - input
		IF @i_externalUserGroupsOp = 1
		BEGIN
			INSERT INTO @addedExternalGroupsTbl (externalGroupId)
				SELECT externalGroupId
				FROM @inputExternalGroupsTbl
				EXCEPT
				SELECT umdsGroupId
				FROM UMDSGroupMaps
				WHERE umGroupID = @i_grpId
			INSERT INTO @deletedExternalGroupsTbl (externalGroupId)
				SELECT umdsGroupId
				FROM UMDSGroupMaps
				WHERE umGroupId = @i_grpID
				EXCEPT
				SELECT externalGroupId
				FROM @inputExternalGroupsTbl
		END
		--add
		--added = input, deleted = none
		IF @i_externalUserGroupsOp = 2
		BEGIN
			INSERT INTO @addedExternalGroupsTbl (externalGroupId)
				SELECT externalGroupId
				FROM @inputExternalGroupsTbl
				EXCEPT
				SELECT umdsGroupId
				FROM UMDSGroupMaps
				WHERE umGroupID = @i_grpId
		END
		--delete
		--deleted = input, added = none
		IF @i_externalUserGroupsOp = 3
		BEGIN
			INSERT INTO @deletedExternalGroupsTbl (externalGroupId)
				SELECT externalGroupId
				FROM @inputExternalGroupsTbl
		END
	END
	--security check (only for new security)
	IF EXISTS (SELECT 1 FROM @addedExternalGroupsTbl) OR EXISTS (SELECT 1 FROM @deletedExternalGroupsTbl)
		EXEC sec_getUserGroupsForThisUser '#externalGroupsThisUserCanModify', @i_userId, 1, 2			--we need only external groups
	--caller should have "edit user group" permission on all the added and deleted AD user groups
	IF ((dbo.isNewSecurity() = 1) AND
		EXISTS (SELECT * FROM @addedExternalGroupsTbl WHERE externalgroupId NOT IN (SELECT externalGroupId FROM #externalGroupsThisUserCanModify)))
	BEGIN
			SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2542 | (CAST(POWER(2, 24) AS BIGINT) * 35))    AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 externalGroupId FROM @addedExternalGroupsTbl WHERE externalGroupId NOT IN (SELECT externalGroupId FROM #externalGroupsThisUserCanModify)) ))
			GOTO EXIT_ERROR
	END
	IF ((dbo.isNewSecurity() = 1) AND
		EXISTS (SELECT * FROM @deletedExternalGroupsTbl WHERE externalgroupId NOT IN (SELECT externalGroupId FROM #externalGroupsThisUserCanModify)))
	BEGIN
			SET @o_errorCode = 2
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2542 | (CAST(POWER(2, 24) AS BIGINT) * 35))    AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT name FROM UMGroups WHERE id = (SELECT TOP 1 externalGroupId FROM @deletedExternalGroupsTbl WHERE externalGroupId NOT IN (SELECT externalGroupId FROM #externalGroupsThisUserCanModify)) ))
			GOTO EXIT_ERROR
	END
	INSERT INTO UMDSGroupMaps (umdsGroupId, umGroupId, flag)
		SELECT externalGroupId, @i_grpId, 0
		FROM @addedExternalGroupsTbl
	DELETE Tbl
	FROM UMDSGroupMaps Tbl INNER JOIN @deletedExternalGroupsTbl del
	ON Tbl.umdsGroupId = del.externalGroupID
	WHERE Tbl.umGroupId = @i_grpId
END
IF @umdsProviderID <> 0			--local group -> external group mapping
BEGIN
	DECLARE @localUserGroupsOperationType INT = ISNULL((SELECT ref.value('@localUserGroupsOperationType', 'INT')
														FROM @i_xmlText.nodes('//App_GroupInfo') R (ref)), 2)
	DECLARE @inputLocalUserGroups TABLE (localGroupId INT, localGroupname NVARCHAR(MAX))
	INSERT INTO @inputLocalUserGroups
		SELECT T.c.value('(@userGroupId)[1]', 'INT'), T.c.value('(@userGroupName)[1]','NVARCHAR(MAX)')
		FROM @i_xmlText.nodes('//App_GroupInfo/localUserGroups') T(c)
	DELETE FROM @inputLocalUserGroups WHERE localGroupId IS NULL AND localGroupname IS NULL
	--Sanity checks
	IF EXISTS (SELECT 1 FROM @inputLocalUserGRoups WHERE (localGroupId <= 0) OR (localGroupId IS NULL))
	BEGIN
SET @o_errorCode = (2428 | (CAST(POWER(2, 24) AS BIGINT) * 35))
         SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
         SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ localGroupname
																						 FROM @inputLocalUserGRoups
																						 WHERE localGroupId <= 0 AND localGroupname <> N''
																						FOR XML PATH ('')),
																			 2, 2147483647), '')))
		GOTO EXIT_ERROR
	END
	--the user groups here can be local commcell user groups or company user groups
IF EXISTS (SELECT 1 FROM @inputLocalUserGroups I INNER JOIN UMGroups G ON I.localGroupId = G.id inner join umdsproviders u on u.id=g.umdsProviderId and u.serviceType not in (1,5))
	BEGIN
SET @o_errorCode = (2428 | (CAST(POWER(2, 24) AS BIGINT) * 35))
         SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
         SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT ISNULL(SUBSTRING((SELECT DISTINCT ','+ localGroupname
																						 FROM @inputLocalUserGRoups I INNER JOIN UMGroups G
																						 ON I.localGroupId = G.id
																						 WHERE G.umdsProviderId <> 0
																						FOR XML PATH ('')),
																			 2, 2147483647), '')))
		GOTO EXIT_ERROR
	END
	--Frame added and deleted tables
	DECLARE @addedUserGroupsTable TABLE (userGroupId INT)
	DECLARE @deletedUserGroupsTable TABLE (userGroupId INT)
	IF @i_operation = 1				--Create new user group
		SET @localUserGroupsOperationType = 2			--Add local user groups
	IF @localUserGroupsOperationType IN (2, 1)			--Add, Overwrite
	BEGIN
		INSERT INTO @addedUserGroupsTable
			SELECT localGroupId
			FROM @inputLocalUserGroups
			EXCEPT
			SELECT umGroupID
			FROM UMDSGroupMaps
			WHERE umDSgroupId = @i_grpId
	END
	IF @localUserGroupsOperationType = 3			--Delete
	BEGIN
		INSERT INTO @deletedUserGroupsTable
			SELECT localGroupID
			FROM @inputLocalUserGroups
	END
	IF @localUserGroupsOperationType = 1			--Overwrite
	BEGIN
		INSERT INTO @deletedUserGroupsTable
			SELECT umGroupid
			FROM UMDSGroupMaps
			WHERE umdsGroupID = @i_grpId
			AND umGroupID NOT IN (SELECT localGroupID FROM @inputLocalUserGroups)
		--Special handling for Overwrite. If there are any user groups that this user cannot see, then they should not be deleted.
		IF EXISTS (SELECT 1 FROM @deletedUserGroupsTable)
		BEGIN
			IF OBJECT_ID ('tempdb.dbo.#localUserGroupsThisUserCanSee') IS NOT NULL
				DROP TABLE #localUserGroupsThisUserCanSee
			CREATE TABLE #localUserGroupsThisUserCanSee (localGroupId INT)
			EXEC sec_getUserGroupsForThisUser '#localUserGroupsThisUserCanSee', @i_userId, 0, 5
			DELETE FROM @deletedUserGroupsTable
			WHERE userGroupId NOT IN (SELECT localGroupId FROM #localUserGroupsThisUserCanSee)
		END
	END
	--Security checks.
	IF OBJECT_ID('tempdb.dbo.#localUserGroupsThisUserCanModify') IS NOT NULL
		DROP TABLE #localUserGroupsThisUserCanModify
	CREATE TABLE #localUserGroupsThisUserCanModify (localGroupId INT)
	--Get local user groups and company user groups
	EXEC sec_getUserGroupsForThisUser '#localUserGroupsThisUserCanModify', @i_userId, 1, 5
	IF EXISTS (SELECT 1 FROM @addedUserGroupsTable WHERE userGroupId NOT IN (SELECT localGroupId FROM #localUserGroupsThisUserCanModify))
	BEGIN
SET @o_errorCode = (3100 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
		SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT ISNULL(SUBSTRING(( SELECT DISTINCT ',' + G.name
																						FROM @addedUserGroupsTable Tbl INNER JOIN UMGroups G
																						ON Tbl.userGroupID = G.id
																						WHERE userGroupId NOT IN (SELECT localGroupId FROM #localUserGroupsThisUserCanModify)
																						FOR XML PATH ('')),
																			 2, 2147483647), '')))
		GOTO EXIT_ERROR
	END
	--To prevent user group of one provider get added to another provider.
	IF(@umdsProviderID <> 0)
	BEGIN
		DECLARE @userGroupcompanyId INTEGER = ISNULL(dbo.AppGetCompanyForUserOrUserGroup(@i_grpId,0),0)
		IF EXISTS (SELECT TOP 1 1 from @addedUserGroupsTable a inner join UMGroups ug on ug.id=a.userGroupId inner join UMDSProviders u on u.id = ug.umdsProviderId where (u.id<>@userGroupcompanyId and u.id <>0))
		BEGIN
SET @o_errorCode = (3100 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
			SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT ISNULL(SUBSTRING(( SELECT DISTINCT ',' + uG.name
																						from @addedUserGroupsTable a inner join UMGroups ug on ug.id=a.userGroupId inner join UMDSProviders u on u.id = ug.umdsProviderId where (u.id<>@userGroupcompanyId and u.id <>0)
																						FOR XML PATH ('')),
																			 2, 2147483647), '')))
			GOTO EXIT_ERROR
		END
	END
	IF EXISTS (SELECT 1 FROM @deletedUserGroupsTable WHERE userGroupId NOT IN (SELECT localGroupId FROM #localUserGroupsThisUserCanModify))
	BEGIN
SET @o_errorCode = (3100 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = @o_errorCode AND localeId = @localeId)
		SET @o_errorString = REPLACE(@o_errorString, '^1%s', (SELECT ISNULL(SUBSTRING(( SELECT DISTINCT ',' + G.name
																						FROM @deletedUserGroupsTable Tbl INNER JOIN UMGroups G
																						ON Tbl.userGroupID = G.id
																						WHERE userGroupId NOT IN (SELECT localGroupId FROM #localUserGroupsThisUserCanModify)
																						FOR XML PATH ('')),
																			 2, 2147483647), '')))
		GOTO EXIT_ERROR
	END
	INSERT INTO UMDSGroupMaps (umgroupId, umDSgroupId, flag)
		SELECT userGroupId, @i_grpId, 0
		FROM @addedUserGroupsTable
	DELETE UMDSGroupMaps
	WHERE umDSgroupId = @i_grpId AND umGroupId IN (SELECT userGroupID FROM @deletedUserGroupsTable)
END
		-- Insert compliance users AND groups
		insert into @CDUserAndGroupListOperation
		EXEC sec_performCDUserAndGroupListOperation 2, @i_grpId, @i_compUsers, @i_compGrps,@i_userId
		Select @o_errorCode=returnCode,@o_errorString=errorString from @CDUserAndGroupListOperation where returnCode <> 0
		 if @o_errorCode <> 0
		 GOTO EXIT_ERROR
	-- Update UserGroup's 'Vcloud' Properties
	IF (@i_operation = 1 OR @i_operation = 3)
	BEGIN
		DECLARE @isVcloud NVARCHAR(256)
		DECLARE @vcloud INT = 0
		DECLARE @authenticationURL NVARCHAR(MAX)
		DECLARE @validationURL NVARCHAR(MAX)
   		SET @isVcloud=(SELECT ref.value('@isVcloud','NVARCHAR(256)')
					   FROM @i_xmlText.nodes('//App_GroupInfo/vcloudGroupProp') R(ref))
   		SET @authenticationURL=(SELECT ref.value('@authenticationURL','NVARCHAR(MAX)')
					   FROM @i_xmlText.nodes('//App_GroupInfo/vcloudGroupProp') R(ref))
   		SET @validationURL=(SELECT ref.value('@validationURL','NVARCHAR(MAX)')
					   FROM @i_xmlText.nodes('//App_GroupInfo/vcloudGroupProp') R(ref))
		-- if vcloud properties are set in xml, delete and insert the values in DB
		IF (@isVcloud IS NOT NULL)
		BEGIN
			IF (@isVcloud = 'true' or @isVcloud = '1')
				SET @vcloud = 1
			IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Vcloud')
				DELETE FROM UMGroupsProp WHERE componentNameId = @i_grpId AND attrName = 'Vcloud'
			INSERT INTO UMGroupsProp VALUES (@i_grpId, 'Vcloud', 7, @vcloud, dbo.GetUnixTime(GETUTCDATE()), 0)
			IF @vcloud = 1
			BEGIN
				IF EXISTS (SELECT 1 FROM UMGroupsProp WHERE componentNameId = @i_grpId AND (attrName = 'External Authentication URL' OR attrName = 'External Token Validation URL'))
					DELETE FROM UMGroupsProp WHERE componentNameId = @i_grpId AND (attrName = 'External Authentication URL' OR attrName = 'External Token Validation URL')
				INSERT INTO UMGroupsProp VALUES (@i_grpId, 'External Authentication URL', 1, @authenticationURL, dbo.GetUnixTime(GETUTCDATE()), 0)
				INSERT INTO UMGroupsProp VALUES (@i_grpId, 'External Token Validation URL', 1, @validationURL, dbo.GetUnixTime(GETUTCDATE()), 0)
			END
		END
	END
RETURN_PROC:
	-- Compute global quota flag before returning
	IF @enforceQuotaChanged = 1 OR @i_operation = 2 -- Common.x OperationType_DELETE
	BEGIN
-- Update global quota check flag
-- Based on this JM and other subsystems decide whether or not to do a quota check.
DECLARE @newDoQuotaCheck INT = CASE WHEN @newEnforceFSQuotaValue > 0 THEN 1
									ELSE ISNULL((
												SELECT TOP 1 1
												FROM UMUsersProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'
												UNION
												SELECT TOP 1 1
												FROM UMGroupsProp WITH(NOLOCK)
												WHERE attrName = N'Enforce quota' AND cs_attrName = CHECKSUM(N'Enforce quota')
												AND modified = 0
												AND attrVal = '1'), 0)
									END
DECLARE @oldDoQuotaCheck INT = (SELECT CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'DoFSQuotaCheck' AND modified = 0)
DECLARE @quotaSetTime INT = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE()))
-- Insert only if it gets enabled
IF @oldDoQuotaCheck IS NULL AND @newDoQuotaCheck = 1
BEGIN
	INSERT INTO GXGlobalParam(name, value, created, modified)
	VALUES('DoFSQuotaCheck', @newDoQuotaCheck, @quotaSetTime, 0)
END
ELSE IF @oldDoQuotaCheck <> @newDoQuotaCheck
BEGIN
	UPDATE GXGlobalParam
	SET value = @newDoQuotaCheck
	WHERE name = 'DoFSQuotaCheck'
	AND modified = 0
END
--
	END
	--Need to recompute the quota information for the users/groups getting removed/added. Insert 'ReComputeQuota' property in UmUsersProp table for the modified users.
	IF @recomputeQuota = 1
	BEGIN
		DECLARE @inXml XML
		SET @inXml = (SELECT userId as '@id'
						FROM UMUserGroup WITH(NOLOCK) WHERE groupId = @i_grpId
						FOR XML PATH ('userID'), ROOT('UserList')
					 )
		exec UpdateUserPropForQuota @inXml
	END
	COMMIT TRAN
	INSERT INTO @responseTable VALUES(0,@o_errorString,@i_grpId,@i_grpName,@i_GUIDStr)
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	EXECUTE dbo.GetError @o_errorString OUTPUT , @o_errorCode OUTPUT
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0 AND @o_errorCode  = 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
DECLARE @warningCode INT =0
DECLARE @warningMessage VARCHAR(MAX)=''
EXIT_ERROR:
IF(@o_errorCode=(2540 | (CAST(POWER(2, 24) AS BIGINT) * 35)))
BEGIN
		    SET @i_GUIDStr = (SELECT GUID FROM UMGroups WHERE name = @i_grpName and umdsProviderId = @umdsProviderID)
			IF(@requestcommcellId <>2)  --DEFAULT_COMMCELL_ID
			BEGIN
			  --give view right on service commcell
exec sec_insertSecurityAssociation @i_userId,@viewRoleID,0,0,@i_grpId,@o_errorCode OUTPUT,@o_errorString OUTPUT,194,@requestcommcellId
			   SET @warningCode = @o_errorCode
			   SET @warningMessage= @o_errorString
				SET @o_errorCode=0
				COMMIT TRANSACTION;
				INSERT INTO @responseTable VALUES(0,@o_errorString,@i_grpId,@i_grpName,@i_GUIDStr)
			  END
END
IF @o_errorCode <> 0
 BEGIN
 INSERT INTO @responseTable VALUES(@o_errorCode,@o_errorString,@i_grpId,@i_grpName,@i_GUIDStr)
  IF( @@TRANCOUNT  > 0)
	ROLLBACK TRANSACTION;
 END
 SET @i_xmlText = (
					 SELECT
					errorCode AS '@errorCode',
					errorMessage AS '@errorString',
					groupId AS 'entity/@userGroupId',
					groupName AS  'entity/@userGroupName',
					groupGuid AS 'entity/@GUID'
					FROM @responseTable
					FOR xml path('App_GenericEntityResponse')--, root('App_GenericResponse')
)
IF @isSelectXML = 1
	SELECT @i_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_performUserGroupOperation')
	delete from GxQscripts where name = 'sec_performUserGroupOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_performUserGroupOperation')
	delete from GXDBVersions where aliasname = 'sec_performUserGroupOperation'
GO

insert into GXDBVersions values(2, 'sec_performUserGroupOperation',  'v1.43.2.67.4.2', 'sec_performUserGroupOperation', 'v1.43.2.67.4.2')
GO

