

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_performCDUserAndGroupListOperation.sp] ---------- 

   --  +========================================================================+
   --  | Name:  sec_performCDUserAndGroupListOperation
   --  | Description: Takes clientId and list of owners and populates the UMUserandGroupEntityAssociation table.
   --  | In case any owner does not have login already, new user is added to UMUsers table.
   --  +========================================================================+
   SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sec_performCDUserAndGroupListOperation <<<'

IF EXISTS (select * from sysobjects where name='sec_performCDUserAndGroupListOperation')
	drop procedure sec_performCDUserAndGroupListOperation
IF EXISTS (select * from GxQscripts where name='sec_performCDUserAndGroupListOperation')
	delete from GxQscripts where name = 'sec_performCDUserAndGroupListOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_performCDUserAndGroupListOperation')
	delete from GXDBVersions where aliasname = 'sec_performCDUserAndGroupListOperation'
GO
print '... Creating Procedure: sec_performCDUserAndGroupListOperation'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_performCDUserAndGroupListOperation
  @operationType INT,
  @groupId INT,
  @userList NVARCHAR(MAX),
  @groupList NVARCHAR(MAX),
  @callerID INT
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorStr varchar(255)
  DECLARE @userName NVARCHAR(255)
  DECLARE @groupName NVARCHAR(255)
	DECLARE @tmpUserListTbl 	TABLE ([name] NVARCHAR(MAX), [domainName] NVARCHAR(MAX))
	DECLARE @tmpGroupListTbl 	TABLE ([name] NVARCHAR(MAX), [domainName] NVARCHAR(MAX))
	DECLARE @delimPos			integer
	DECLARE	@delim				char
	DECLARE @fullName 			NVARCHAR(MAX)
	DECLARE @domainName 		NVARCHAR(MAX)
	DECLARE @name 				NVARCHAR(MAX)
	DECLARE @pos				integer
	DECLARE @entityType 		integer = 9509 -- Entity type
	DECLARE @tmpUserGroupTbl	TABLE([userName] NVARCHAR(MAX), [groupName] NVARCHAR(MAX))
	SET @delim = ','
	SET @o_errorCode = 0
	SET @o_errorStr = 'Success'
	WHILE len(@groupList) > 0
	BEGIN
		SET @delimPos = CHARINDEX(@delim, @groupList)
		IF @delimPos > 0
		BEGIN
			SET @fullName = substring(@groupList, 1, @delimPos - 1)
			SET @groupList = substring(@groupList, @delimPos + 1, len(@groupList) - @delimPos)
		END
		ELSE
		BEGIN
			SET @fullName = @groupList
			SET @groupList = ''
		END
		SET @pos = CHARINDEX('\', @fullName, 1)
		IF @pos <> 0
		BEGIN
			SET @domainName = LTRIM(RTRIM(LEFT(@fullName,@pos-1)))
			SET @name = RIGHT(@fullName,LEN(@fullName)-@pos)
			INSERT INTO @tmpGroupListTbl VALUES (@name, @domainName)
		END
	END
	WHILE len(@userList) > 0
	BEGIN
		SET @delimPos = CHARINDEX(@delim, @userList)
		IF @delimPos > 0
		BEGIN
			SET @fullName = substring(@userList, 1, @delimPos - 1)
			SET @userList = substring(@userList, @delimPos + 1, len(@userList) - @delimPos)
		END
		ELSE
		BEGIN
			SET @fullName = @userList
			SET @userList = ''
		END
		SET @pos = CHARINDEX('\', @fullName, 1)
		IF @pos <> 0
		BEGIN
			SET @domainName = LTRIM(RTRIM(LEFT(@fullName,@pos-1)))
			SET @name = RIGHT(@fullName,LEN(@fullName)-@pos)
			INSERT INTO @tmpUserListTbl VALUES (@name, @domainName)
		END
	END
	--Security check to add/remove only user/usergroups which the user can see
	  IF OBJECT_ID ('tempdb.dbo.#usersThisUserCanView') IS NOT NULL
                    DROP TABLE #usersThisUserCanView
	  IF OBJECT_ID ('tempdb.dbo.#getUserGroupsForThisUserTbl') IS NOT NULL
                    DROP TABLE #getUserGroupsForThisUserTbl
	CREATE TABLE #usersThisUserCanView (userID INT)
		EXEC sec_getUsersForThisUser '#usersThisUserCanView',@callerId
	CREATE TABLE #getUserGroupsForThisUserTbl (groupId INT)
		EXEC sec_getUserGroupsForThisUser '#getUserGroupsForThisUserTbl',@callerId
	If EXISTS (Select  U.login from @tmpUserListTbl users
				Inner Join UMUsers U
				on U.login=users.domainName+'\'+users.name
				where U.id Not in (Select userId from #usersThisUserCanView))
				BEGIN
					SET @o_errorStr = 'User does not have permission on some users'
					SET @o_errorCode = 1
					GOTO EXIT_END
				END
	IF EXISTS (select 1 from  @tmpGroupListTbl userGroups
				INNER JOIN UMDSProviders UP
				on UP.domainName=userGroups.domainName
				INNER JOIN UMGroups UG
				on UG.umdsProviderId=UP.id
				where userGroups.name=UG.name and  UG.id Not in (Select groupId from #getUserGroupsForThisUserTbl))
				BEGIN
					SET @o_errorStr = 'User does not have permission on some userGroups'
					SET @o_errorCode = 2
				GOTO EXIT_END
				END
	IF @operationType = 2 	-- UPDATE ALL
	BEGIN
		--Removing only the users that the user can see.
		DELETE UMUserAndGroupEntityAssociation
		WHERE entityType = @entityType AND objectId = @groupId and userId<>0 and userId IN (Select userID from #usersThisUserCanView )
		--Removing only the usersGroups that the user can see.
		DELETE UMUserAndGroupEntityAssociation
		WHERE entityType = @entityType AND objectId = @groupId and groupId<>0 and groupId IN (Select groupId from #getUserGroupsForThisUserTbl )
	END
	IF @operationType = 1 OR @operationType = 2 -- ADD ALL OR UPDATE ALL
	BEGIN
		-- Inserting into UMUserAndGroupEntityAssociation relations for Users.
		INSERT INTO UMUserAndGroupEntityAssociation (userId, groupID, providerId, capabilities, entityType, objectId, ownerUserId)
		SELECT U.id, 0, 0, 0, @entityType, @groupId, 1
		FROM UMUsers U INNER JOIN UMDSProviders UP ON U.umDSproviderId = UP.id
			INNER JOIN @tmpUserListTbl T ON UP.domainName = T.domainName
			WHERE (T.domainName + '\' + T.name) = U.login
		-- Inserting into UMUserAndGroupEntityAssociation relations for groups.
		INSERT INTO UMUserAndGroupEntityAssociation (userId, groupID, providerId, capabilities, entityType, objectId, ownerUserId)
		SELECT 0, UG.id, 0, 0, @entityType, @groupId, 1
		FROM UMDSGroups UG INNER JOIN UMDSProviders UP ON UG.umDSproviderId = UP.id
			INNER JOIN @tmpGroupListTbl T ON UP.domainName = T.domainName
			WHERE UG.name = T.name
	END
	ELSE IF @operationType = 3 -- DELETE ALL
	BEGIN
		DELETE UMUserAndGroupEntityAssociation
		WHERE entityType = @entityType AND objectId = @groupId
	END
	ELSE IF @operationType = 4 -- GET ALL
	BEGIN
		INSERT @tmpUserGroupTbl
		SELECT U.login, NULL
		FROM UMUserAndGroupEntityAssociation UA INNER JOIN UMUsers U ON UA.userId = U.id
		WHERE UA.entityType = @entityType AND UA.objectId = @groupId   and U.id in (Select userId from #usersThisUserCanView)
		INSERT @tmpUserGroupTbl
		SELECT NULL, (P.domainName + '\' + G.name)
		FROM UMUserAndGroupEntityAssociation UA INNER JOIN UMDSGroups G ON UA.groupId = G.id
			INNER JOIN UMDSProviders AS P ON G.umdsProviderId = P.id
		WHERE UA.entityType = @entityType AND UA.objectId = @groupId 	and G.id in (Select groupId from #getUserGroupsForThisUserTbl)
		SELECT @o_errorCode, @o_errorStr, T.userName, T.groupName FROM @tmpUserGroupTbl AS T
		GOTO EXIT_END
	END
	ELSE
	BEGIN
		SET @o_errorCode = -1
		SET @o_errorStr = 'Invalid operation type.'
	END
EXIT_END:
SELECT "ReturnCode"=@o_errorCode,"ErrorString"=@o_errorStr,'',''
GO

IF EXISTS (select * from GxQscripts where name = 'sec_performCDUserAndGroupListOperation')
	delete from GxQscripts where name = 'sec_performCDUserAndGroupListOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_performCDUserAndGroupListOperation')
	delete from GXDBVersions where aliasname = 'sec_performCDUserAndGroupListOperation'
GO

insert into GXDBVersions values(2, 'sec_performCDUserAndGroupListOperation',  '00000000000000000000', 'sec_performCDUserAndGroupListOperation', '00000000000000000000')
GO

