

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_ownershipCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : sec_ownershipCheck.sp
--
--  Description : Check if given user/user groups are creators of any of the following entities :
--                Smart Client Group, Schedules, Schedule Policy, Workflow, Custom Reports, DM2 entity, Alarm, Alert
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_ownershipCheck.sp,v $ $Id: sec_ownershipCheck.sp,v 1.1.2.5 2020/04/29 13:15:05 kvinayak Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_ownershipCheck')
BEGIN
	print '>>> Drop Stored Procedure: sec_ownershipCheck <<<'
	drop procedure sec_ownershipCheck
END
IF EXISTS (select * from GxQscripts where name='sec_ownershipCheck')
	delete from GxQscripts where name = 'sec_ownershipCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ownershipCheck')
	delete from GXDBVersions where aliasname = 'sec_ownershipCheck'
GO
print '... Creating Procedure: sec_ownershipCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_ownershipCheck
  @i_xmlText XML OUTPUT
AS
SET NOCOUNT ON
BEGIN TRY
	IF OBJECT_ID('tempdb.dbo.#OwnershipCheckTbl') IS NOT null DROP TABLE #OwnershipCheckTbl
	CREATE TABLE #OwnershipCheckTbl
	(
		userOrGroupId INT,
		isUser INT,
		isOwner INT DEFAULT 0
	)
	IF object_id('tempdb.dbo.#CreatorsTbl') IS NOT null DROP TABLE #CreatorsTbl
	CREATE TABLE #CreatorsTbl
	(
		userOrGroupId INT,
		isUser INT
	)
	IF OBJECT_ID('tempdb.dbo.#EntityTypeTbl') IS NOT null DROP TABLE #EntityTypeTbl
	CREATE TABLE #EntityTypeTbl
	(
		entityType INT
	)
	CREATE INDEX #EntityTypeTbl_entityType_idx ON #EntityTypeTbl(entityType)
	--insert input values : users
	INSERT  INTO #OwnershipCheckTbl (userOrGroupId, isUser)
	SELECT DISTINCT ref.value('@userId', 'int') AS userOrGroupId, 1 As isUser
	FROM    @i_xmlText.nodes('App_OwnershipCheckReq/user') R ( ref )
	--insert input values : user groups
	INSERT  INTO #OwnershipCheckTbl (userOrGroupId, isUser)
	SELECT DISTINCT ref.value('@userGroupId', 'int') AS userOrGroupId, 0 As isUser
	FROM    @i_xmlText.nodes('App_OwnershipCheckReq/userGroup') R ( ref )
	-- insert entities	: client group, workflow, schedules, schedule policy, custom reports, DM2 entities, alerts, alarms, credential account owner
INSERT INTO #EntityTypeTbl (entityType) values (28), (68), (35),(2900), (131),
(64),(83), (9501), (9502),(9503),(9504), (9505),
(132), (133), (157), (174)
	-- find owners
	INSERT INTO #CreatorsTbl
	SELECT DISTINCT UMS.userOrGroupId , UMS.isUser FROM UMSecurityAssociations UMS WITH(NOLOCK)
		INNER JOIN #OwnershipCheckTbl OC ON (OC.userOrGroupId = UMS.userOrGroupId and OC.isUser = UMS.isUser)
		INNER JOIN #EntityTypeTbl ET ON (UMS.entityType1 = ET.entityType)
		WHERE  UMS.isCreator = 1
	-- insert creators of alarm entities
	INSERT INTO #CreatorsTbl
	SELECT DISTINCT CAP.userId , 1 FROM CustomAlarmProps CAP WITH(NOLOCK)
	INNER JOIN #OwnershipCheckTbl OC ON CAP.userId = OC.userOrGroupId and OC.isUser = 1
	-- insert users & user groups from client group scope
	INSERT INTO #CreatorsTbl
	SELECT DISTINCT scg.entityId,
CASE WHEN scg.entityType = (13) THEN '1'                -- If user then isUser = 1
WHEN scg.entityType = (15) THEN '0'           -- If user group, isUser = 0
	END
	FROM App_SCGScope scg
INNER JOIN #OwnershipCheckTbl OC ON (OC.userOrGroupId = scg.entityId and OC.isUser = 1 and scg.entityType = (13))
OR (OC.userOrGroupId = scg.entityId and OC.isUser = 0 and scg.entityType = (15))
	-- set isOwner = 1 for users who are creators of above entities.
	UPDATE #OwnershipCheckTbl SET isOwner = 1 FROM #OwnershipCheckTbl OC
	INNER JOIN #CreatorsTbl Creators ON OC.userOrGroupId = Creators.userOrGroupId and OC.isUser = Creators.isUser
	--form output xml
	SET @i_xmlText = ISNULL(
							(SELECT OC.isOwner AS '@isOwner',
								CASE OC.isUser WHEN 1
								THEN(
									(SELECT OC.userOrGroupId AS '@userId'
									FOR XML PATH('user'), TYPE))
								ELSE
									(SELECT OC.userOrGroupId AS '@userGroupId'
									FOR XML PATH('userGroup'), TYPE)
								END
							FROM #OwnershipCheckTbl AS OC
							FOR XML PATH('ownershipCheck'), ROOT('App_OwnershipCheckResp'), TYPE),
							'<App_OwnershipCheckResp/>')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @i_xmlText = '<App_OwnershipCheckResp/>'
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_ownershipCheck')
	delete from GxQscripts where name = 'sec_ownershipCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_ownershipCheck')
	delete from GXDBVersions where aliasname = 'sec_ownershipCheck'
GO

insert into GXDBVersions values(2, 'sec_ownershipCheck',  '00010001000200050000', 'sec_ownershipCheck', '00010001000200050000')
GO

