

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_isUserOrGroupAdmin.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_isUserOrGroupAdmin.sp,v $ $Id: sec_isUserOrGroupAdmin.sp,v 1.1.2.1 2019/10/09 07:16:18 jge Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_isUserOrGroupAdmin()
--  |
--  | Description:  Check if a user or group has admin permission
--  |
--  |       Input:  i_userOrGroupId
--  |       Input:  i_isUser
--	|
--  |      Output:  o_isAdmin
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_isUserOrGroupAdmin')
BEGIN
	print '>>> Drop Stored Procedure: sec_isUserOrGroupAdmin <<<'
	drop procedure sec_isUserOrGroupAdmin
END
IF EXISTS (select * from GxQscripts where name='sec_isUserOrGroupAdmin')
	delete from GxQscripts where name = 'sec_isUserOrGroupAdmin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isUserOrGroupAdmin')
	delete from GXDBVersions where aliasname = 'sec_isUserOrGroupAdmin'
GO
print '... Creating Procedure: sec_isUserOrGroupAdmin'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_isUserOrGroupAdmin
  @i_userOrGroupId integer,
  @o_isAdmin integer OUTPUT,
  @i_isUser integer = 1
AS
SET NOCOUNT ON
if @i_isUser = 1
begin
	exec sec_isUserAdmin @i_userOrGroupId, @o_isAdmin
	return
end
SET @o_isAdmin = 0
if @i_userOrGroupId = dbo.GetMasterGroupID()
begin
	SET @o_isAdmin = 1
end
else if EXISTS ( SELECT GM.umgroupId
			FROM UMDSGroupMaps GM
			WHERE GM.umDSgroupId = @i_userOrGroupId AND GM.umgroupId = dbo.GetMasterGroupID() )
begin
	SET @o_isAdmin = 1
end
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_isUserOrGroupAdmin')
	delete from GxQscripts where name = 'sec_isUserOrGroupAdmin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isUserOrGroupAdmin')
	delete from GXDBVersions where aliasname = 'sec_isUserOrGroupAdmin'
GO

insert into GXDBVersions values(2, 'sec_isUserOrGroupAdmin',  '00010001000200010000', 'sec_isUserOrGroupAdmin', '00010001000200010000')
GO

