

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_isRestoreAuthorized.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_isRestoreAuthorized')
BEGIN
	print '>>> Drop Stored Procedure: sec_isRestoreAuthorized <<<'
	drop procedure sec_isRestoreAuthorized
END
IF EXISTS (select * from GxQscripts where name='sec_isRestoreAuthorized')
	delete from GxQscripts where name = 'sec_isRestoreAuthorized'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isRestoreAuthorized')
	delete from GXDBVersions where aliasname = 'sec_isRestoreAuthorized'
GO
print '... Creating Procedure: sec_isRestoreAuthorized'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure sec_isRestoreAuthorized
  @i_userId int,
  @i_entityId int,
  @i_type int,
  @i_localeId int
AS
  DECLARE @o_clientId int
  DECLARE @o_companyId int
  DECLARE @o_passkeyToCheck int
  DECLARE @o_errorCode int
  DECLARE @o_errorString nvarchar(max)
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @o_passkeyToCheck = 0
	SET @o_companyId = -1
	SET @o_errorCode = 0
	DECLARE @o_isRestoreAuthorized int = 0
	SET @o_clientId = (SELECT CASE
WHEN @i_type = 7 THEN (SELECT distinct clientId from App_Application where id = @i_entityId)
WHEN @i_type = 5 THEN (SELECT distinct clientId from App_Application where instance = @i_entityId)
WHEN @i_type = 6 THEN (SELECT distinct clientId from App_Application where backupset = @i_entityId)
WHEN @i_type = 3 THEN @i_entityId
							 ELSE 0
							END)
	IF @o_clientId IS NULL OR @o_clientId = 0 OR @i_userId = 0
	BEGIN
		SET @o_clientId = 0
SET @o_errorCode = (451 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		GOTO ENDSP
	END
	DECLARE @authorizedUsers xml
	DECLARE @currentTime bigint	= DATEDIFF(s, '1970-01-01', GETUTCDATE())
	DECLARE @expirationTime bigint = @currentTime
	DECLARE @clientAuthorizationType int = ISNULL((SELECT CAST(attrVal AS int) FROM APP_ClientProp
WHERE componentNameId=@o_clientId AND attrName='AuthorizationType' and modified=0), 1)
	IF @clientAuthorizationType = 1	-- If passkey is NOT set at the client level
	BEGIN
		SET @o_companyId = ISNULL((SELECT CONVERT(INTEGER,attrval) FROM APP_ClientProp
WHERE attrname='Installation Company ID' AND componentNameId=@i_entityId AND modified=0) , -1)
		-- Some clients could have 0 as their "Installation company ID" for reasons like MSP admin creds were used during installation, so we need to check smart client group info to get true company Id
		IF @o_companyId = -1 OR @o_companyId = 0
		BEGIN
			SET @o_companyId = ISNULL((SELECT TOP 1 ACP.componentNameId FROM APP_Client AC
										INNER JOIN APP_ClientGroupAssoc ACGA ON AC.id = ACGA.clientId
										INNER JOIN App_CompanyProp ACP ON ACP.attrValInt=ACGA.clientGroupId
AND ACP.attrName='Associated Smart Client Group' AND cs_attrName = checksum('Associated Smart Client Group') AND ACP.modified = 0
										WHERE AC.id = @i_entityId), 0)
		END
		DECLARE @companyAuthorizationType int = ISNULL((SELECT CAST(attrVal AS int) FROM APP_CompanyProp WHERE componentNameId=@o_companyId
AND attrName='AuthorizationType' AND cs_attrName = checksum('AuthorizationType') AND modified=0), 1)
		IF @companyAuthorizationType = 2	-- If passkey is set at the company/tenant level
		BEGIN
			SET @o_passkeyToCheck = 2
			SET @authorizedUsers = (SELECT attrVal FROM App_ClientProp
WHERE componentNameId = @o_clientId AND attrName = 'AuthorizedUsersForRestore' AND modified=0)
			IF @authorizedUsers IS NOT NULL AND @authorizedUsers.exist('*') != 0
			BEGIN
				SET @expirationTime = ISNULL((SELECT TOP 1 T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]', 'bigint') FROM @authorizedUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
											  WHERE T.c.value('@userId','int') = @i_userId), 0)
			END
			ELSE
			BEGIN
				SET @expirationTime = 0
			END
			IF @expirationTime < @currentTime
			BEGIN
				SET @authorizedUsers = (SELECT attrVal FROM App_CompanyProp WHERE componentNameId = @o_companyId
AND attrName = 'AuthorizedUsersForRestore' AND cs_attrName = checksum('AuthorizedUsersForRestore') AND modified=0)
				IF @authorizedUsers IS NOT NULL AND @authorizedUsers.exist('*') != 0
				BEGIN
					SET @expirationTime = ISNULL((SELECT TOP 1 T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]', 'bigint') FROM @authorizedUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
												  WHERE T.c.value('@userId','int') = @i_userId), 0)
				END
			END
		END
	END
	ELSE	-- If passkey is set at the client level
	BEGIN
		SET @o_passkeyToCheck = 1
		SET @authorizedUsers = (SELECT attrVal FROM App_ClientProp
WHERE componentNameId = @o_clientId AND attrName = 'AuthorizedUsersForRestore' AND modified=0)
		IF @authorizedUsers IS NOT NULL AND @authorizedUsers.exist('*') != 0
		BEGIN
			SET @expirationTime = ISNULL((SELECT TOP 1 T.c.query('..').value('(/authorizedUsers/@expirationTime)[1]', 'bigint') FROM @authorizedUsers.nodes('/App_AuthorizedUsersForRestore/authorizedUsers/user') AS T(c)
										  WHERE T.c.value('@userId','int') = @i_userId), 0)
		END
		ELSE
		BEGIN
			SET @expirationTime = 0
		END
	END
	IF @expirationTime >= @currentTime
	BEGIN
		SET @o_isRestoreAuthorized = 1
	END
	ENDSP:
	IF @o_isRestoreAuthorized = 0
SET @o_errorCode = (3967 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	IF @o_errorCode != 0
		SET @o_errorString = (SELECT Message FROM EvLocaleMsgs
							  WHERE EvLocaleMsgs.MessageId = @o_errorCode AND [localeId] = @i_localeId)
	SELECT @o_clientId AS o_clientId, @o_companyId AS o_companyId, @o_passkeyToCheck AS o_passkeyToCheck, @o_errorCode AS o_errorCode, @o_errorString AS o_errorString
END
GO

IF EXISTS (select * from GxQscripts where name = 'sec_isRestoreAuthorized')
	delete from GxQscripts where name = 'sec_isRestoreAuthorized'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isRestoreAuthorized')
	delete from GXDBVersions where aliasname = 'sec_isRestoreAuthorized'
GO

insert into GXDBVersions values(2, 'sec_isRestoreAuthorized',  '00000000000000000000', 'sec_isRestoreAuthorized', '00000000000000000000')
GO

