

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_isPasswordStrong.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/sec_isPasswordStrong.sp,v $ $Id: sec_isPasswordStrong.sp,v 1.1.2.8 2020/12/07 14:43:05 saggarwal Exp $";
--
--  +========================================================================+
--  |   Procedure:  sec_isPasswordStrong()
--  |
--  | Description:
--  |
--  |       Input:
--  |      Output:
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='sec_isPasswordStrong')
BEGIN
	print '>>> Drop Stored Procedure: sec_isPasswordStrong <<<'
	drop procedure sec_isPasswordStrong
END
IF EXISTS (select * from GxQscripts where name='sec_isPasswordStrong')
	delete from GxQscripts where name = 'sec_isPasswordStrong'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isPasswordStrong')
	delete from GXDBVersions where aliasname = 'sec_isPasswordStrong'
GO
print '... Creating Procedure: sec_isPasswordStrong'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure sec_isPasswordStrong
  @i_password NVARCHAR(MAX),
  @o_isPwdStrong INT OUTPUT,
  @o_errorMessage NVARCHAR(MAX) OUTPUT,
  @i_localeId int=0,
  @o_errorCode INT OUTPUT,
  @returnCursor INT = 0
AS
  DECLARE @isPwdStrongR INT
  DECLARE @errorMessageOutput NVARCHAR(MAX)
  DECLARE @errorCodeOutput INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @nowTime  INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @COMPLEXITY_LEVEL_NO INT = 1
DECLARE @COMPLEXITY_LEVEL_MEDIUM INT = 2
DECLARE @COMPLEXITY_LEVEL_STRONG INT = 3
DECLARE @INSERT_PROP_RESULTS table (
    errorCode           integer,
    hasChanged          integer,
    propId              integer,
    errorString         varchar(1024)
)
DECLARE @passwordComplexityLevel INT = (SELECT value FROM GXGlobalParam WHERE name = 'passwordComplexityLevel')
IF @passwordComplexityLevel IS NULL
BEGIN
	SET @passwordComplexityLevel = @COMPLEXITY_LEVEL_NO
END
	--Enforce strong password check ONLY for non-Admin Simpana users
	--At least 2 lowercase characters ( abcdefg ... )
	--At least 2 uppercase characters ( ABCDEFG ... )
	--At least 2 numbers ( 123456 ... )
	--At least 2 special characters ( ~!@#$%^& ... )
	--Minimum length must be 8 characters
	--COLLATE for case sensitive check
	--decrypt password
	DECLARE @decryptedPassword NVARCHAR(MAX) = ''
	EXEC miscProc2 @i_password, @decryptedPassword OUTPUT
	SET @o_errorMessage = ''
	IF @passwordComplexityLevel = @COMPLEXITY_LEVEL_NO
	BEGIN
		SET @o_isPwdStrong = 1
	END
	ELSE IF @passwordComplexityLevel = @COMPLEXITY_LEVEL_MEDIUM
	BEGIN
		SET @o_isPwdStrong = ( SELECT CASE WHEN
				 					@decryptedPassword COLLATE Latin1_General_BIN LIKE '%[a-z]%'
									AND @decryptedPassword COLLATE Latin1_General_BIN LIKE '%[A-Z]%'
									AND @decryptedPassword LIKE '%[0-9]%'
									AND @decryptedPassword LIKE '%[-!@#$%^&*()_+=.,;:''"`~<>?/\{|}]%'
									AND LEN(@decryptedPassword) >= 8
								THEN
									1
								ELSE
									0
								END   )
		IF @o_isPwdStrong = 0
		BEGIN
SET @o_errorCode = (3507 | (CAST(POWER(2, 24) AS BIGINT) * 35))
             SET @o_errorMessage =dbo.fn_EvFormatEventMsgText(0, @i_localeId, @o_errorCode, 0, 2)
		END
	END
	ELSE IF @passwordComplexityLevel = @COMPLEXITY_LEVEL_STRONG
	BEGIN
		SET @o_isPwdStrong = ( SELECT CASE WHEN
				 					@decryptedPassword COLLATE Latin1_General_BIN LIKE '%[a-z]%[a-z]%'
									AND @decryptedPassword COLLATE Latin1_General_BIN LIKE '%[A-Z]%[A-Z]%'
									AND @decryptedPassword LIKE '%[0-9]%[0-9]%'
									AND @decryptedPassword LIKE '%[-!@#$%^&*()_+=.,;:''"`~<>?/\{|}]%[-!@#$%^&*()_+=.,;:''"`~<>?/\{|}]%'
									AND LEN(@decryptedPassword) >= 8
								THEN
									1
								ELSE
									0
								END   )
		IF @o_isPwdStrong = 0
		BEGIN
SET @o_errorCode = (3508 | (CAST(POWER(2, 24) AS BIGINT) * 35))
             SET @o_errorMessage = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @o_errorCode, 0, 2)
		END
	END
	ELSE
	 BEGIN
		SET @o_isPwdStrong = 1
	END
	IF @returnCursor <> 0
		SELECT @o_isPwdStrong, @o_errorMessage, @o_errorCode
GO

IF EXISTS (select * from GxQscripts where name = 'sec_isPasswordStrong')
	delete from GxQscripts where name = 'sec_isPasswordStrong'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isPasswordStrong')
	delete from GXDBVersions where aliasname = 'sec_isPasswordStrong'
GO

insert into GXDBVersions values(2, 'sec_isPasswordStrong',  '00010001000200080000', 'sec_isPasswordStrong', '00010001000200080000')
GO

