

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sec_isPasswordExpired.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Name:  sec_isPasswordExpired()
--  | Description: determines if the password of a particular user is expired
--	|          based on the agePassworddays property of the user and user group
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='sec_isPasswordExpired')
BEGIN
	print '>>> Drop Stored Procedure: sec_isPasswordExpired <<<'
	drop procedure sec_isPasswordExpired
END
IF EXISTS (select * from GxQscripts where name='sec_isPasswordExpired')
	delete from GxQscripts where name = 'sec_isPasswordExpired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isPasswordExpired')
	delete from GXDBVersions where aliasname = 'sec_isPasswordExpired'
GO
print '... Creating Procedure: sec_isPasswordExpired'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sec_isPasswordExpired
  @i_userId integer,
  @o_isExpired integer OUTPUT
AS
SET NOCOUNT ON
declare @isAdmin int = 0
declare @isExternalUser int = 0
declare @agePasswordDays int = 0
declare @agePasswordDaysUserLevel int = 0
declare @passwordSetDate datetime = 0
declare @secondsPerDay int = 24*60*60
declare @today datetime = convert(date, GETDATE())
declare @UserGroupsForUser table(userGroupId int)
--check if the user is organizational user
declare @umdsProviderId int = 0
declare @umdsServiceType int = 0
select @umdsProviderId = umdsProviderId from UMUsers with(nolock) where id = @i_userId
IF @umdsProviderId > 0
	BEGIN
		select @umdsServiceType = serviceType from UMDSProviders with(nolock) where id = @umdsProviderId
		--serviceType = 5 is for organizational user
IF @umdsServiceType = 5
			set @isExternalUser = 0
		ELSE
			set @isExternalUser = 1
	END
select @agePasswordDaysUserLevel = policy,
	   @passwordSetDate = convert(date,dbo.UTCToCellLocalTime(dbo.GetDateTime(datePasswordSet),2)),
@isAdmin = flags & 0x040
	   from UMUsers with(nolock) where id = @i_userId
--password donot age for external users and admin
IF @isExternalUser = 0  and @isAdmin = 0
	BEGIN
		insert into @UserGroupsForUser
		select groupId from UMUserGroup where userId = @i_userId
		delete UG
		from @UserGroupsForUser UG
		inner join UMGroups on UG.userGroupId = UMGroups.id
where UMGroups.groupFlags & 0x0001 = 0
		select @agePasswordDays = isnull (min(cast (attrval as integer)),0) from UMGroupsProp UGProp with (nolock)
		inner join @UserGroupsForUser UGroup on UGroup.userGroupId=UGProp.componentNameId
and UGProp.attrname='Age Password in Days'
		where attrVal <> 0 and modified=0
		IF @agePasswordDays = 0 or (@agePasswordDaysUserLevel <> 0 and @agePasswordDaysUserLevel < @agePasswordDays)
		 SET @agePasswordDays = @agePasswordDaysUserLevel
		IF @agePasswordDays <> 0
			BEGIN
				IF (datediff(dd,@passwordSetDate,@today) >= @agePasswordDays)
					SET @o_isExpired = 1 --passwordExpired
				ELSE
					SET @o_isExpired = 0
			END
		ELSE
				SET @o_isExpired = 0
	END
ELSE
	BEGIN
		SET @o_isExpired=0
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'sec_isPasswordExpired')
	delete from GxQscripts where name = 'sec_isPasswordExpired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sec_isPasswordExpired')
	delete from GXDBVersions where aliasname = 'sec_isPasswordExpired'
GO

insert into GXDBVersions values(2, 'sec_isPasswordExpired',  '00000000000000000000', 'sec_isPasswordExpired', '00000000000000000000')
GO

